/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.crypto.pkcs11.provider.RSAPKCS11PrivateKey;
import com.ibm.crypto.pkcs11.provider.RSAPKCS11PublicKey;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;

public final class DatawithRSA
extends Signature {
    private PKCS11Session session;
    private PKCS11Object keyObject;
    private boolean isSign;
    private byte[] returnSignature;
    private static final int ARRAY_SIZE_INC = 256;
    private int dataSize = 0;
    private byte[] data = new byte[256];

    public DatawithRSA() {
        super("Data/RSA");
    }

    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        int n = 6;
        if (!(privateKey instanceof RSAPKCS11PrivateKey)) {
            throw new InvalidKeyException("not a RSA private key: " + privateKey);
        }
        RSAPKCS11PrivateKey rSAPKCS11PrivateKey = (RSAPKCS11PrivateKey)privateKey;
        this.isSign = true;
        this.session = rSAPKCS11PrivateKey.getSession();
        this.keyObject = rSAPKCS11PrivateKey.getObject();
        int[] nArray = this.session.getSlot().getMechanismList();
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == 1) {
                bl = true;
                n = 1;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw new UnsupportedOperationException("The token does not support RSA signature");
        }
        this.session.signInit(n, null, this.keyObject);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        int n = 6;
        if (!(publicKey instanceof RSAPublicKey) && !(publicKey instanceof RSAPKCS11PublicKey)) {
            throw new InvalidKeyException("not a RSA public key: " + publicKey);
        }
        RSAPKCS11PublicKey rSAPKCS11PublicKey = (RSAPKCS11PublicKey)publicKey;
        this.isSign = false;
        this.session = rSAPKCS11PublicKey.getSession();
        this.keyObject = rSAPKCS11PublicKey.getObject();
        int[] nArray = this.session.getSlot().getMechanismList();
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == 1) {
                bl = true;
                n = 1;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw new UnsupportedOperationException("The token does not support RSA verification");
        }
        this.session.verifyInit(n, null, this.keyObject);
    }

    protected void engineSetParameter(String string, Object object) {
    }

    protected byte[] engineSign() throws SignatureException {
        int n = 36;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[256];
        if (this.dataSize >= n) {
            byArray = new byte[n];
            System.arraycopy(this.data, 0, byArray, 0, n);
        } else {
            byArray = new byte[this.dataSize];
            System.arraycopy(this.data, 0, byArray, 0, this.dataSize);
            n = this.dataSize;
        }
        this.dataSize = 0;
        n = this.session.sign(byArray, 0, n, byArray3, 0);
        byArray2 = new byte[n];
        System.arraycopy(byArray3, 0, byArray2, 0, n);
        return byArray2;
    }

    protected void engineUpdate(byte by) {
        if (this.data.length <= this.dataSize + 1) {
            int n = this.dataSize + 256;
            byte[] byArray = new byte[n];
            System.arraycopy(this.data, 0, byArray, 0, this.dataSize);
            this.data = byArray;
        }
        this.data[this.dataSize] = by;
        ++this.dataSize;
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.data.length <= this.dataSize + n2) {
            int n3 = this.dataSize + n2 + 256;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(this.data, 0, byArray2, 0, this.dataSize);
            this.data = byArray2;
        }
        System.arraycopy(byArray, n, this.data, this.dataSize, n2);
        this.dataSize += n2;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        int n = 36;
        byte[] byArray2 = null;
        if (this.dataSize >= n) {
            byArray2 = new byte[n];
            System.arraycopy(this.data, 0, byArray2, 0, n);
        } else {
            if (this.dataSize == 0) {
                return false;
            }
            byArray2 = new byte[this.dataSize];
            System.arraycopy(this.data, 0, byArray2, 0, this.dataSize);
            n = this.dataSize;
        }
        this.dataSize = 0;
        return this.session.verify(byArray2, 0, n, byArray, 0, byArray.length);
    }
}

