/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.AIXCore;
import com.ibm.jvm.dump.extract.ExThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.SDFFJavaStack;
import com.ibm.jvm.dump.sdff.SDFFNativeStack;
import com.ibm.jvm.dump.sdff.Sdff;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

class AIXThread
extends ExThread {
    long ti_tid;
    long ti_pid;
    long ti_pri;
    long ti_policy;
    long ti_state;
    long ti_flag;
    long ti_scount;
    long ti_wtype;
    long ti_wchan;
    long ti_cpu;
    long ti_cpuid;
    long ti_affinity;
    long ti_sigmask_loset;
    long ti_sigmask_hiset;
    long[] ti_sigmask64 = new long[4];
    long ti_sig_loset;
    long ti_sig_hiset;
    long[] ti_sig64 = new long[4];
    long ti_code;
    long ti_scp;
    long ti_cursig;
    byte[] ti_pad = new byte[7];
    long ti_oldmask_loset;
    long ti_oldmask_hiset;
    long[] ti_oldmask64 = new long[4];
    long ti_stkb;
    long ti_ucontext;
    long ti_sigsp;
    long ti_sigssz;
    long ti_userdata;
    long ti_errnopp;
    long ti_ustk;
    long ti_ticks;
    long ti_dispct;
    long ti_fpuct;
    long ti_watch;
    long[] ti_resvd = new long[7];
    long[] ti_64bit_resvd = new long[8];
    long prev;
    long kjmpbuf;
    long stackfix;
    long intpri;
    long backt;
    byte[] rsvd = new byte[2];
    long curid;
    long excp_type;
    long mq;
    long tid;
    long fpscr;
    long fpeu;
    long fpinfo;
    byte[] pad = new byte[2];
    long[] except = new long[5];
    byte[] pad1 = new byte[4];
    long o_iar;
    long o_toc;
    long o_arg1;
    long excbranch;
    long fpscrx;
    long o_vaddr;
    long[] cachealign = new long[7];
    long alloc;
    long[] srval = new long[16];
    long ti_ru_utime_sec;
    long ti_ru_utime_usec;
    long ti_ru_stime_sec;
    long ti_ru_stime_usec;
    long ti_ru_maxrss;
    long ti_ru_ixrss;
    long ti_ru_idrss;
    long ti_ru_isrss;
    long ti_ru_minflt;
    long ti_ru_majflt;
    long ti_ru_nswap;
    long ti_ru_inblock;
    long ti_ru_oublock;
    long ti_ru_msgsnd;
    long ti_ru_msgrcv;
    long ti_ru_nsignals;
    long ti_ru_nvcsw;
    long ti_ru_nivcsw;
    Vector gpr = new Vector(32);
    Vector fpr = new Vector(32);
    HashMap specials = new HashMap();

    AIXThread() {
    }

    AIXThread(AIXCore aIXCore) throws IOException {
        DvFileReader dvFileReader = aIXCore.getReader();
        if (dvFileReader.wordLength.size == 4) {
            this.populate32BitThread(dvFileReader);
        } else {
            this.populate64BitThread(dvFileReader);
        }
        this.register.setBank("gpr", this.gpr, this.gpr.size());
        this.register.setBank("fpr", this.fpr, this.fpr.size());
        this.register.setSpecial(this.specials, this.specials.size());
        this.context.setPc((Long)this.specials.get("iar"));
        this.context.setLr((Long)this.specials.get("lr"));
        this.context.setSp((Long)this.gpr.elementAt(1));
        this.context.setBp((Long)this.gpr.elementAt(15));
        DvUtils.trace("Set up thread context for 0x" + Long.toHexString(this.tid), 2, false);
        this.context.dump();
    }

    private void populate64BitThread(DvFileReader dvFileReader) throws IOException {
        int n;
        this.ti_tid = dvFileReader.readLong();
        this.ti_pid = dvFileReader.readWord();
        this.ti_pri = dvFileReader.readWord();
        this.ti_policy = dvFileReader.readWord();
        this.ti_state = dvFileReader.readWord();
        this.ti_flag = dvFileReader.readWord();
        this.ti_scount = dvFileReader.readWord();
        this.ti_wtype = dvFileReader.readWord();
        this.ti_cpu = dvFileReader.readWord();
        this.ti_cpuid = dvFileReader.readHalf();
        this.ti_affinity = dvFileReader.readHalf();
        dvFileReader.readWord();
        this.ti_wchan = dvFileReader.readLong();
        for (n = 0; n < this.ti_sigmask64.length; ++n) {
            this.ti_sigmask64[n] = dvFileReader.readLong();
        }
        for (n = 0; n < this.ti_sig64.length; ++n) {
            this.ti_sig64[n] = dvFileReader.readLong();
        }
        this.ti_code = dvFileReader.readLong();
        this.ti_scp = dvFileReader.readLong();
        this.ti_cursig = dvFileReader.readByte();
        dvFileReader.read(this.ti_pad);
        for (n = 0; n < this.ti_oldmask64.length; ++n) {
            this.ti_oldmask64[n] = dvFileReader.readLong();
        }
        this.ti_stkb = dvFileReader.readLong();
        this.ti_ucontext = dvFileReader.readLong();
        this.ti_sigsp = dvFileReader.readLong();
        this.ti_sigssz = dvFileReader.readLong();
        this.ti_userdata = dvFileReader.readLong();
        this.ti_errnopp = dvFileReader.readLong();
        this.ti_ustk = dvFileReader.readLong();
        this.ti_ticks = dvFileReader.readWord();
        this.ti_dispct = dvFileReader.readWord();
        this.ti_fpuct = dvFileReader.readWord();
        this.ti_watch = dvFileReader.readWord();
        this.ti_ru_utime_sec = dvFileReader.readLong();
        this.ti_ru_utime_usec = dvFileReader.readWord();
        dvFileReader.readWord();
        this.ti_ru_stime_sec = dvFileReader.readLong();
        this.ti_ru_stime_usec = dvFileReader.readWord();
        dvFileReader.readWord();
        this.ti_ru_maxrss = dvFileReader.readLong();
        this.ti_ru_ixrss = dvFileReader.readLong();
        this.ti_ru_idrss = dvFileReader.readLong();
        this.ti_ru_isrss = dvFileReader.readLong();
        this.ti_ru_minflt = dvFileReader.readLong();
        this.ti_ru_majflt = dvFileReader.readLong();
        this.ti_ru_nswap = dvFileReader.readLong();
        this.ti_ru_inblock = dvFileReader.readLong();
        this.ti_ru_oublock = dvFileReader.readLong();
        this.ti_ru_msgsnd = dvFileReader.readLong();
        this.ti_ru_msgrcv = dvFileReader.readLong();
        this.ti_ru_nsignals = dvFileReader.readLong();
        this.ti_ru_nvcsw = dvFileReader.readLong();
        this.ti_ru_nivcsw = dvFileReader.readLong();
        for (n = 0; n < this.ti_64bit_resvd.length; ++n) {
            this.ti_64bit_resvd[n] = dvFileReader.readWord();
        }
        DvUtils.trace("__context64 register dump", 2, false);
        for (n = 0; n < 32; ++n) {
            this.gpr.add(new Long(dvFileReader.readLong()));
        }
        this.specials.put("msr", new Long(dvFileReader.readLong()));
        this.specials.put("iar", new Long(dvFileReader.readLong()));
        this.specials.put("lr", new Long(dvFileReader.readLong()));
        this.specials.put("ctr", new Long(dvFileReader.readLong()));
        this.specials.put("cr", new Long(dvFileReader.readWord()));
        this.specials.put("xer", new Long(dvFileReader.readWord()));
        this.fpscr = dvFileReader.readWord();
        this.fpscrx = dvFileReader.readWord();
        this.except[1] = dvFileReader.readLong();
        for (n = 0; n < 32; ++n) {
            this.fpr.add(new Long(dvFileReader.readLong()));
        }
        this.fpeu = dvFileReader.readByte();
        this.fpinfo = dvFileReader.readByte();
        dvFileReader.readBytes(2);
        this.excp_type = dvFileReader.readWord();
    }

    private void populate32BitThread(DvFileReader dvFileReader) throws IOException {
        int n;
        this.tid = this.ti_tid = dvFileReader.readWord();
        this.ti_pid = dvFileReader.readWord();
        this.ti_pri = dvFileReader.readWord();
        this.ti_policy = dvFileReader.readWord();
        this.ti_state = dvFileReader.readWord();
        this.ti_flag = dvFileReader.readWord();
        this.ti_scount = dvFileReader.readWord();
        this.ti_wtype = dvFileReader.readWord();
        this.ti_wchan = dvFileReader.readLong();
        this.ti_cpu = dvFileReader.readWord();
        this.ti_cpuid = dvFileReader.readHalf();
        this.ti_affinity = dvFileReader.readHalf();
        this.ti_sigmask_loset = dvFileReader.readWord();
        this.ti_sigmask_hiset = dvFileReader.readWord();
        this.ti_sig_loset = dvFileReader.readWord();
        this.ti_sig_hiset = dvFileReader.readWord();
        this.ti_code = dvFileReader.readLong();
        this.ti_scp = dvFileReader.readLong();
        this.ti_cursig = dvFileReader.readByte();
        dvFileReader.read(this.ti_pad);
        this.ti_oldmask_loset = dvFileReader.readWord();
        this.ti_oldmask_hiset = dvFileReader.readWord();
        this.ti_stkb = dvFileReader.readLong();
        this.ti_ucontext = dvFileReader.readLong();
        this.ti_sigsp = dvFileReader.readLong();
        this.ti_sigssz = dvFileReader.readLong();
        this.ti_userdata = dvFileReader.readLong();
        this.ti_errnopp = dvFileReader.readLong();
        this.ti_ustk = dvFileReader.readLong();
        this.ti_ticks = dvFileReader.readWord();
        this.ti_dispct = dvFileReader.readWord();
        this.ti_fpuct = dvFileReader.readWord();
        this.ti_watch = dvFileReader.readWord();
        for (n = 0; n < this.ti_resvd.length; ++n) {
            this.ti_resvd[n] = dvFileReader.readWord();
        }
        dvFileReader.readWord();
        DvUtils.trace("mstsave register dump", 2, false);
        this.prev = dvFileReader.readAddress();
        this.kjmpbuf = dvFileReader.readAddress();
        this.stackfix = dvFileReader.readAddress();
        this.intpri = dvFileReader.readByte();
        this.backt = dvFileReader.readByte();
        dvFileReader.read(this.rsvd);
        this.curid = dvFileReader.readWord();
        this.excp_type = dvFileReader.readWord();
        this.specials.put("iar", new Long(dvFileReader.readWord()));
        this.specials.put("msr", new Long(dvFileReader.readWord()));
        this.specials.put("cr", new Long(dvFileReader.readWord()));
        this.specials.put("lr", new Long(dvFileReader.readWord()));
        this.specials.put("ctr", new Long(dvFileReader.readWord()));
        this.specials.put("xer", new Long(dvFileReader.readWord()));
        this.mq = dvFileReader.readWord();
        this.tid = dvFileReader.readWord();
        this.fpscr = dvFileReader.readWord();
        this.fpeu = dvFileReader.readByte();
        this.fpinfo = dvFileReader.readByte();
        dvFileReader.read(this.pad);
        for (n = 0; n < this.except.length; ++n) {
            this.except[n] = dvFileReader.readWord();
        }
        dvFileReader.read(this.pad1);
        this.o_iar = dvFileReader.readWord();
        this.o_toc = dvFileReader.readWord();
        this.o_arg1 = dvFileReader.readWord();
        this.excbranch = dvFileReader.readWord();
        this.fpscrx = dvFileReader.readWord();
        this.o_vaddr = dvFileReader.readWord();
        for (n = 0; n < this.cachealign.length; ++n) {
            this.cachealign[n] = dvFileReader.readWord();
        }
        this.alloc = dvFileReader.readWord();
        for (n = 0; n < 16; ++n) {
            this.srval[n] = dvFileReader.readWord();
        }
        for (n = 0; n < 32; ++n) {
            this.gpr.add(new Long(dvFileReader.readWord()));
        }
        for (n = 0; n < 32; ++n) {
            this.fpr.add(new Long(dvFileReader.readLong()));
        }
    }

    void attach(long l) {
        DvUtils.trace("ExThread pid=" + this.ti_pid + " tid=" + this.ti_tid, 2, false);
        this.pid = new Long(this.ti_pid);
        this.tid = this.ti_tid;
        this.execEnv = l;
        this.context.setEE(l);
    }

    void dump() {
        int n;
        DvUtils.trace("ti_tid = 0x" + Long.toHexString(this.ti_tid), 2, false);
        DvUtils.trace("ti_pid = 0x" + Long.toHexString(this.ti_pid), 2, false);
        DvUtils.trace("ti_pri = 0x" + Long.toHexString(this.ti_pri), 2, false);
        DvUtils.trace("ti_policy = 0x" + Long.toHexString(this.ti_policy), 2, false);
        DvUtils.trace("ti_state = 0x" + Long.toHexString(this.ti_state), 2, false);
        DvUtils.trace("ti_flag = 0x" + Long.toHexString(this.ti_flag), 2, false);
        DvUtils.trace("ti_scount = 0x" + Long.toHexString(this.ti_scount), 2, false);
        DvUtils.trace("ti_wtype = 0x" + Long.toHexString(this.ti_wtype), 2, false);
        DvUtils.trace("ti_wchan = 0x" + Long.toHexString(this.ti_wchan), 2, false);
        DvUtils.trace("ti_cpu = 0x" + Long.toHexString(this.ti_cpu), 2, false);
        DvUtils.trace("ti_cpuid = 0x" + Long.toHexString(this.ti_cpuid), 2, false);
        DvUtils.trace("ti_affinity = 0x" + Long.toHexString(this.ti_affinity), 2, false);
        DvUtils.trace("ti_sigmask_hiset = 0x" + Long.toHexString(this.ti_sigmask_hiset), 2, false);
        DvUtils.trace("ti_sigmask_loset = 0x" + Long.toHexString(this.ti_sigmask_loset), 2, false);
        DvUtils.trace("ti_sig_hiset = 0x" + Long.toHexString(this.ti_sig_hiset), 2, false);
        DvUtils.trace("ti_sig_loset = 0x" + Long.toHexString(this.ti_sig_loset), 2, false);
        DvUtils.trace("ti_code = 0x" + Long.toHexString(this.ti_code), 2, false);
        DvUtils.trace("ti_scp = 0x" + Long.toHexString(this.ti_scp), 2, false);
        DvUtils.trace("ti_cursig = 0x" + Long.toHexString(this.ti_cursig), 2, false);
        DvUtils.trace("ti_oldmask_hiset = 0x" + Long.toHexString(this.ti_oldmask_hiset), 2, false);
        DvUtils.trace("ti_oldmask_loset = 0x" + Long.toHexString(this.ti_oldmask_loset), 2, false);
        DvUtils.trace("ti_stkb = 0x" + Long.toHexString(this.ti_stkb), 2, false);
        DvUtils.trace("ti_ucontext = 0x" + Long.toHexString(this.ti_ucontext), 2, false);
        DvUtils.trace("ti_sigsp = 0x" + Long.toHexString(this.ti_sigsp), 2, false);
        DvUtils.trace("ti_sigssz = 0x" + Long.toHexString(this.ti_sigssz), 2, false);
        DvUtils.trace("ti_userdata = 0x" + Long.toHexString(this.ti_userdata), 2, false);
        DvUtils.trace("ti_errnopp = 0x" + Long.toHexString(this.ti_errnopp), 2, false);
        DvUtils.trace("ti_ustk = 0x" + Long.toHexString(this.ti_ustk), 2, false);
        DvUtils.trace("ti_ticks = 0x" + Long.toHexString(this.ti_ticks), 2, false);
        DvUtils.trace("ti_dispct = 0x" + Long.toHexString(this.ti_dispct), 2, false);
        DvUtils.trace("ti_fpuct = 0x" + Long.toHexString(this.ti_fpuct), 2, false);
        DvUtils.trace("ti_watch = 0x" + Long.toHexString(this.ti_watch), 2, false);
        DvUtils.trace("prev = 0x" + Long.toHexString(this.prev), 2, false);
        DvUtils.trace("kjmpbuf = 0x" + Long.toHexString(this.kjmpbuf), 2, false);
        DvUtils.trace("stackfix = 0x" + Long.toHexString(this.stackfix), 2, false);
        DvUtils.trace("intpri = 0x" + Long.toHexString(this.intpri), 2, false);
        DvUtils.trace("backt = 0x" + Long.toHexString(this.backt), 2, false);
        DvUtils.trace("curid = 0x" + Long.toHexString(this.curid), 2, false);
        DvUtils.trace("excp_type = 0x" + Long.toHexString(this.excp_type), 2, false);
        DvUtils.trace("iar = 0x" + Long.toHexString((Long)this.specials.get("iar")), 2, false);
        DvUtils.trace("msr = 0x" + Long.toHexString((Long)this.specials.get("msr")), 2, false);
        DvUtils.trace("cr = 0x" + Long.toHexString((Long)this.specials.get("cr")), 2, false);
        DvUtils.trace("lr = 0x" + Long.toHexString((Long)this.specials.get("lr")), 2, false);
        DvUtils.trace("ctr = 0x" + Long.toHexString((Long)this.specials.get("ctr")), 2, false);
        DvUtils.trace("xer = 0x" + Long.toHexString((Long)this.specials.get("xer")), 2, false);
        DvUtils.trace("mq = 0x" + Long.toHexString(this.mq), 2, false);
        DvUtils.trace("tid = 0x" + Long.toHexString(this.tid), 2, false);
        DvUtils.trace("fpscr = 0x" + Long.toHexString(this.fpscr), 2, false);
        DvUtils.trace("fpeu = 0x" + Long.toHexString(this.fpeu), 2, false);
        DvUtils.trace("fpinfo = 0x" + Long.toHexString(this.fpinfo), 2, false);
        for (n = 0; n < 5; ++n) {
            DvUtils.trace("except[" + n + "] = 0x" + Long.toHexString(this.except[n]), 2, false);
        }
        DvUtils.trace("o_iar = 0x" + Long.toHexString(this.o_iar), 2, false);
        DvUtils.trace("o_toc = 0x" + Long.toHexString(this.o_toc), 2, false);
        DvUtils.trace("o_arg1 = 0x" + Long.toHexString(this.o_arg1), 2, false);
        DvUtils.trace("excbranch = 0x" + Long.toHexString(this.excbranch), 2, false);
        DvUtils.trace("fpscrx = 0x" + Long.toHexString(this.fpscrx), 2, false);
        DvUtils.trace("o_vaddr = 0x" + Long.toHexString(this.o_vaddr), 2, false);
        DvUtils.trace("alloc = 0x" + Long.toHexString(this.alloc), 2, false);
        for (n = 0; n < 16; ++n) {
            DvUtils.trace("srval[" + n + "] = 0x" + Long.toHexString(this.srval[n]), 2, false);
        }
        for (n = 0; n < 32; ++n) {
            DvUtils.trace("gpr[" + n + "] = 0x" + Long.toHexString((Long)this.gpr.elementAt(n)), 2, false);
        }
        for (n = 0; n < 32; ++n) {
            DvUtils.trace("fpr[" + n + "] = " + Double.longBitsToDouble((Long)this.fpr.elementAt(n)), 2, false);
        }
    }

    void printSdff(Sdff sdff) throws IOException {
        DvUtils.trace("Printing AIXThread", 0, false);
        DvUtils.trace("tid     0x" + Long.toHexString(this.tid), 0, false);
        DvUtils.trace("ExecEnv 0x" + Long.toHexString(this.execEnv), 0, false);
        DvUtils.trace("sp      0x" + Long.toHexString(this.context.getSp()), 0, false);
        DvUtils.trace("pc      0x" + Long.toHexString(this.context.getPc()), 0, false);
        sdff.align(8);
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.writeBytes("THREAD  ");
        sdff.writeLong(this.tid);
        sdff.writeInt(-1);
        sdff.writeInt((int)this.ti_state);
        sdff.writeLong(this.context.getSp());
        sdff.writeLong(this.context.getPc());
        sdff.writeLong(this.execEnv);
        sdff.writeInt(-1);
        sdff.writeInt(-1);
        SDFFJavaStack sDFFJavaStack = new SDFFJavaStack(this.javaFrames);
        SDFFNativeStack sDFFNativeStack = new SDFFNativeStack(this.nativeFrames);
        sDFFJavaStack.printSdff(sdff);
        sDFFNativeStack.printSdff(sdff);
        this.register.printSdff(sdff);
        for (int i = 0; i < 8; ++i) {
            sdff.writeBytes("PAD ");
        }
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }
}

