/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.Elf;
import com.ibm.jvm.dump.extract.ElfHeader;
import com.ibm.jvm.dump.extract.ElfLinux;
import com.ibm.jvm.dump.extract.ElfLkp;
import com.ibm.jvm.dump.extract.ElfSolaris;
import com.ibm.jvm.dump.extract.ExProcess;
import com.ibm.jvm.dump.sdff.DvFileReader;
import java.io.IOException;
import java.util.HashMap;

public abstract class ElfType {
    Elf elf;
    ExProcess process;
    HashMap thread = new HashMap();
    DvFileReader reader;

    ElfType(Elf elf) {
        this.elf = elf;
        this.reader = elf.reader;
    }

    protected static ElfType makeElfType(Elf elf) throws IOException {
        DvFileReader dvFileReader = elf.getReader();
        ElfHeader elfHeader = (ElfHeader)elf.getHeader();
        if (elfHeader.machine == 2L) {
            ElfSolaris elfSolaris = new ElfSolaris(elf);
            return elfSolaris;
        }
        dvFileReader.setPos(elfHeader.programHeaderOffset + elfHeader.programHeaderEntrySize);
        long l = dvFileReader.readWord();
        if (l == 4L) {
            return new ElfLkp(elf);
        }
        ElfLinux elfLinux = new ElfLinux(elf, (int)elfHeader.machine);
        return elfLinux;
    }

    abstract void readNote(int var1, long var2) throws IOException;
}

