/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.AbstractLayout;
import com.ibm.jvm.dump.extract.Elf;
import com.ibm.jvm.dump.extract.ElfHeader;
import com.ibm.jvm.dump.extract.ExProcess;
import com.ibm.jvm.dump.extract.Layout;
import com.ibm.jvm.dump.extract.Xcoff;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.SDFFDump;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Vector;

class Executable {
    SDFFDump header;
    DvFileReader reader;
    String execFileName;

    Executable(ExProcess exProcess, String string) throws IOException {
        Vector<String> vector = new Vector<String>();
        RandomAccessFile randomAccessFile = null;
        String string2 = exProcess.command;
        if (string != null) {
            vector.add(string);
        }
        if (exProcess.jvmData.executable.startsWith("/")) {
            vector.add(exProcess.jvmData.executable);
        }
        vector.add(exProcess.jvmData.dll + "/exe/" + string2);
        vector.add(exProcess.jvmData.dll + "/" + string2);
        vector.add(exProcess.jvmData.dll + "/../../bin/" + string2);
        if (exProcess.executable.startsWith("/")) {
            vector.add(exProcess.executable);
        }
        boolean bl = false;
        Iterator iterator = vector.iterator();
        while (!bl && iterator.hasNext()) {
            this.execFileName = ((String)iterator.next()).trim();
            DvUtils.trace("trying " + this.execFileName, 2, false);
            try {
                randomAccessFile = new RandomAccessFile(this.execFileName, "r");
                bl = true;
                break;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        if (randomAccessFile != null) {
            DvUtils.trace("set up executable reader", 2, false);
            AbstractLayout abstractLayout = Layout.getLayout(randomAccessFile);
            if (!(abstractLayout instanceof Xcoff)) {
                this.reader = abstractLayout.getFileReader(randomAccessFile);
                ((Elf)abstractLayout).readHeader();
                this.header = ((Elf)abstractLayout).getHeader();
                ((ElfHeader)this.header).dump();
            } else {
                DvUtils.trace("XCOFF executable - skipping", 2, false);
            }
        } else {
            throw new IOException("JVMRAS021: A stack trace cannot be generated because the executable '" + (string != null ? string : string2) + "' which created the core file cannot be found.  " + "To create an SDFF file with the stack trace, rerun " + "jextract using the -f flag to specify the " + "location of the executable.");
        }
    }

    String getExecFileName() {
        return this.execFileName;
    }
}

