/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.DvBaseFmtCmds;
import java.util.Vector;

public class DvBaseFmtCmdsSov
extends DvBaseFmtCmds {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvBaseFmtCmdsSov";
    private static DvBaseFmtCmdsSov selfRef;
    protected static String[] commandsSupported;

    public DvBaseFmtCmdsSov() {
        selfRef = this;
    }

    public String pluginName() {
        return "Base format commands (DvBaseFmtCmdsSov)";
    }

    public String[] getSyntax() {
        int n;
        String[] stringArray = new String[DvBaseFmtCmds.commandsSupported.length + commandsSupported.length];
        for (n = 0; n < DvBaseFmtCmds.commandsSupported.length; ++n) {
            stringArray[n] = DvBaseFmtCmds.commandsSupported[n];
        }
        for (n = DvBaseFmtCmds.commandsSupported.length; n < DvBaseFmtCmds.commandsSupported.length + commandsSupported.length; ++n) {
            stringArray[n] = commandsSupported[n - DvBaseFmtCmds.commandsSupported.length];
        }
        return stringArray;
    }

    public void formatEE() {
        Vector<Object> vector = new Vector<Object>();
        DvDump dvDump = DvConsole.theDump;
        if (null != dvDump) {
            String string;
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            DvProcess dvProcess = (DvProcess)DvUtils.getAPT(dvDump, "P");
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            if (null == this.paramString) {
                string = DvUtils.getValue("THREAD");
            } else {
                string = this.paramString;
                if (dvAddressSpace != null && dvProcess != null) {
                    dvThread = DvUtils.findThread(dvDump, string, dvAddressSpace, dvProcess);
                }
            }
            vector.add("\n execenv for thread " + string + "\n ==========================\n");
            if (null != dvAddressSpace && null != dvProcess && null != dvThread) {
                DvAddress dvAddress = dvAddressSpace.createAddress(dvThread.eeAddress().getAddressAsLong());
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "execenv");
                    if (null != cTypeObject) {
                        vector.add(cTypeObject);
                        vector.add("\n Format of execenv finished");
                    } else {
                        vector.add(" Format of execenv failed!!!!");
                    }
                } else {
                    vector.add(" Address " + dvThread.eeAddress().convertToHex() + " is not available in the dump");
                }
            } else {
                vector.add(" ASID/Process/Thread invalid");
            }
        } else {
            vector.add(" Unable to comply as no dump accessed yet");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void formatJVM() {
        DvUtils.writetoTrace(" Entry to DvBaseFmtCmds:formatJVM");
        Vector<Object> vector = new Vector<Object>();
        DvDump dvDump = DvConsole.theDump;
        if (null != dvDump) {
            String string;
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
            DvProcess dvProcess = (DvProcess)DvUtils.getAPT(dvDump, "P");
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            if (null == this.paramString) {
                string = DvUtils.getValue("THREAD");
            } else {
                string = this.paramString;
                if (dvAddressSpace != null && dvProcess != null) {
                    dvThread = DvUtils.findThread(dvDump, string, dvAddressSpace, dvProcess);
                }
            }
            vector.add("\n Jvm via thread " + string + "\n ==========================\n");
            if (null != dvAddressSpace && null != dvProcess && null != dvThread) {
                DvAddress dvAddress = dvAddressSpace.createAddress(dvThread.eeAddress().getAddressAsLong());
                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "execenv");
                    if (null != cTypeObject) {
                        CTypeObject cTypeObject2 = cTypeObject.getField("jvmP");
                        if (null != cTypeObject2) {
                            String string2 = cTypeObject2.toString();
                            if (string2.startsWith("null ")) {
                                string2 = string2.substring(5);
                            }
                            if (string2.startsWith("(null) ")) {
                                string2 = string2.substring(7);
                            }
                            string2 = DvUtils.removeAtSign(string2);
                            string2 = DvUtils.remove0x(string2);
                            DvAddress dvAddress2 = null;
                            DvAddress dvAddress3 = dvAddressSpace.createAddress(DvUtils.hexToLong(string2));
                            try {
                                dvAddress2 = dvAddressSpace.readPointer(dvAddress3);
                            }
                            catch (DvAddressException dvAddressException) {
                                vector.add("\n jvmP addressing failure");
                            }
                            CTypeObject cTypeObject3 = null;
                            if (null != dvAddress2) {
                                cTypeObject3 = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress2, "Jvm");
                            }
                            if (null != cTypeObject3) {
                                DvUtils.setupJVMHints(cTypeObject3, dvAddress2.getAddressAsLong(), dvAddressSpace);
                                vector.add(cTypeObject3);
                                vector.add("\n Format of Jvm finished");
                            } else {
                                vector.add(" Unable to format Jvm!");
                            }
                        } else {
                            vector.add(" Unable to get jvmP!");
                        }
                    } else {
                        vector.add(" obtaining execenv failure!!!!");
                    }
                } else {
                    vector.add(" Address " + dvThread.eeAddress().convertToHex() + " is not available in the dump");
                }
            } else {
                vector.add(" ASID/Process/Thread invalid");
            }
        } else {
            vector.add(" Unable to comply as no dump accessed yet");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
        DvUtils.writetoTrace(" Exit from DvBaseFmtCmds:formatJVM");
    }

    public void formatSTGlobal() {
        Vector<String> vector = new Vector<String>();
        DvDump dvDump = DvConsole.theDump;
        if (null != dvDump) {
            DvThread dvThread = (DvThread)DvUtils.getAPT(dvDump, "T");
            if (null != dvThread) {
                long l = DvUtils.jvmFromThreadId(dvThread.id());
                String string = DvUtils.getJVMHint(l, "STGLOBALPTR");
                if (null != string) {
                    this.verbModifier = string;
                    this.paramString = "as STGlobal";
                    this.doFormat();
                    return;
                }
                vector.add(" Unable to comply - no hint found for STGLOBALPTR");
            } else {
                vector.add(" Unable to comply as no valid address space found");
            }
        } else {
            vector.add(" Unable to comply as no dump accessed");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    static {
        commandsSupported = new String[]{"FORMAT,FOR,execenv,ee,formatEE,Y,N", "FORMAT,FOR,jvm,jvm,formatJVM,Y,N", "FORMAT,FOR,stglobal,stg,formatSTGlobal,Y,N", "FORM,FO,execenv,ee,formatEE,Y,N", "FORM,FO,jvm,jvm,formatJVM,Y,N", "FORM,FO,stglobal,stg,formatSTGlobal,Y,N"};
    }
}

