/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pkcs11;

public class PKCS11Exception
extends RuntimeException {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int HOST_MEMORY = 2;
    public static final int SLOT_ID_INVALID = 3;
    public static final int GENERAL_ERROR = 5;
    public static final int FUNCTION_FAILED = 6;
    public static final int ARGUMENTS_BAD = 7;
    public static final int NO_EVENT = 8;
    public static final int NEED_TO_CREATE_THREADS = 9;
    public static final int CANT_LOCK = 10;
    public static final int ATTRIBUTE_READ_ONLY = 16;
    public static final int ATTRIBUTE_SENSITIVE = 17;
    public static final int ATTRIBUTE_TYPE_INVALID = 18;
    public static final int ATTRIBUTE_VALUE_INVALID = 19;
    public static final int DATA_INVALID = 32;
    public static final int DATA_LEN_RANGE = 33;
    public static final int DEVICE_ERROR = 48;
    public static final int DEVICE_MEMORY = 49;
    public static final int DEVICE_REMOVED = 50;
    public static final int ENCRYPTED_DATA_INVALID = 64;
    public static final int ENCRYPTED_DATA_LEN_RANGE = 65;
    public static final int FUNCTION_CANCELED = 80;
    public static final int FUNCTION_NOT_PARALLEL = 81;
    public static final int FUNCTION_NOT_SUPPORTED = 84;
    public static final int KEY_HANDLE_INVALID = 96;
    public static final int KEY_SIZE_RANGE = 98;
    public static final int KEY_TYPE_INCONSISTENT = 99;
    public static final int KEY_NOT_NEEDED = 100;
    public static final int KEY_CHANGED = 101;
    public static final int KEY_NEEDED = 102;
    public static final int KEY_INDIGESTIBLE = 103;
    public static final int KEY_FUNCTION_NOT_PERMITTED = 104;
    public static final int KEY_NOT_WRAPPABLE = 105;
    public static final int KEY_UNEXTRACTABLE = 106;
    public static final int MECHANISM_INVALID = 112;
    public static final int MECHANISM_PARAM_INVALID = 113;
    public static final int OBJECT_HANDLE_INVALID = 130;
    public static final int OPERATION_ACTIVE = 144;
    public static final int OPERATION_NOT_INITIALIZED = 145;
    public static final int PIN_INCORRECT = 160;
    public static final int PIN_INVALID = 161;
    public static final int PIN_LEN_RANGE = 162;
    public static final int PIN_EXPIRED = 163;
    public static final int PIN_LOCKED = 164;
    public static final int SESSION_CLOSED = 176;
    public static final int SESSION_COUNT = 177;
    public static final int SESSION_HANDLE_INVALID = 179;
    public static final int SESSION_PARALLEL_NOT_SUPPORTED = 180;
    public static final int SESSION_READ_ONLY = 181;
    public static final int SESSION_EXISTS = 182;
    public static final int SESSION_READ_ONLY_EXISTS = 183;
    public static final int SESSION_READ_WRITE_SO_EXISTS = 184;
    public static final int SIGNATURE_INVALID = 192;
    public static final int SIGNATURE_LEN_RANGE = 193;
    public static final int TEMPLATE_INCOMPLETE = 208;
    public static final int TEMPLATE_INCONSISTENT = 209;
    public static final int TOKEN_NOT_PRESENT = 224;
    public static final int TOKEN_NOT_RECOGNIZED = 225;
    public static final int TOKEN_WRITE_PROTECTED = 226;
    public static final int UNWRAPPING_KEY_HANDLE_INVALID = 240;
    public static final int UNWRAPPING_KEY_SIZE_RANGE = 241;
    public static final int UNWRAPPING_KEY_TYPE_INCONSISTENT = 242;
    public static final int USER_ALREADY_LOGGED_IN = 256;
    public static final int USER_NOT_LOGGED_IN = 257;
    public static final int USER_PIN_NOT_INITIALIZED = 258;
    public static final int USER_TYPE_INVALID = 259;
    public static final int USER_ANOTHER_ALREADY_LOGGED_IN = 260;
    public static final int USER_TOO_MANY_TYPES = 261;
    public static final int WRAPPED_KEY_INVALID = 272;
    public static final int WRAPPED_KEY_LEN_RANGE = 274;
    public static final int WRAPPING_KEY_HANDLE_INVALID = 275;
    public static final int WRAPPING_KEY_SIZE_RANGE = 276;
    public static final int WRAPPING_KEY_TYPE_INCONSISTENT = 277;
    public static final int RANDOM_SEED_NOT_SUPPORTED = 288;
    public static final int RANDOM_NO_RNG = 289;
    public static final int DOMAIN_PARAMS_INVALID = 304;
    public static final int BUFFER_TOO_SMALL = 336;
    public static final int SAVED_STATE_INVALID = 352;
    public static final int INFORMATION_SENSITIVE = 368;
    public static final int STATE_UNSAVEABLE = 384;
    public static final int CRYPTOKI_NOT_INITIALIZED = 400;
    public static final int CRYPTOKI_ALREADY_INITIALIZED = 401;
    public static final int MUTEX_BAD = 416;
    public static final int MUTEX_NOT_LOCKED = 417;
    public static final int VENDOR_DEFINED = Integer.MIN_VALUE;
    private static final int[] CKR_types = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 16, 17, 18, 19, 32, 33, 48, 49, 50, 64, 65, 80, 81, 84, 96, 98, 99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 130, 144, 145, 160, 161, 162, 163, 164, 176, 177, 179, 180, 181, 182, 183, 184, 192, 193, 208, 209, 224, 225, 226, 240, 241, 242, 256, 257, 258, 259, 260, 261, 272, 274, 275, 276, 277, 288, 289, 304, 336, 352, 368, 384, 400, 401, 416, 417};
    static final String[] CKR_names = new String[]{PKCS11Exception.a("Axm8>nbm{\"f~#8%j}o>>bi#(?dnf(9axo73"), PKCS11Exception.a("Axm8>nbm{9obv7.'of{)fc`>&bi"), PKCS11Exception.a("Ibw{/ibv<\"'`f6%ut#4$'el(>"), PKCS11Exception.a("Tal/jNI#29'dm-+kdg"), PKCS11Exception.a("Rcq>)h{f)+eaf{/u\u007fl)"), PKCS11Exception.a("Sef{8b|v>9shg{,rc`/#hc#8%rag{$hy#9/'}f),h\u007fn>."), PKCS11Exception.a("Txs+&nhg{+ujv6/iyp{$hy#::w\u007fl+8nlw>"), PKCS11Exception.a("Ib#5/p-f-/iyp{+qlj7+eaf"), PKCS11Exception.a("Ilw2<b-w38blg{9r}s48s-q>;rdq>."), PKCS11Exception.a("Kb`0#ij#5%s-b-+nab9&b"), PKCS11Exception.a("Fyw)#exw>jn~#)/fi.4$kt"), PKCS11Exception.a("Fyw)#exw>jn~#(/i~j/#qh#:$c-`:$ibw{(b-q><blo>."), PKCS11Exception.a("Fyw)#exw>jsts>jn~#2$qlo2."), PKCS11Exception.a("Fyw)#exw>jqlo./'dp{#i{b7#c"), PKCS11Exception.a("Clw:jn~#2$qlo2."), PKCS11Exception.a("Ncu:&ni#?+sl#7/ijw3"), PKCS11Exception.a("Chu2)b-f)8h\u007f"), PKCS11Exception.a("Ibw{/ibv<\"'`f6%ut#4$'if-#dh"), PKCS11Exception.a("Chu2)b-k:9'of>$'\u007ff6%qhg"), PKCS11Exception.a("Bc`)3wyf?jclw:jn~#2$qlo2."), PKCS11Exception.a("Bc`)3wyf?jclw:jkhm<>o-j(jhxw{%a-q:$`h"), PKCS11Exception.a("Axm8>nbm{\"f~#9/bc#8+inf7/c"), PKCS11Exception.a("Ib#=?inw2%i-j(jbuf8?sdm<jnc#++ulo7/k"), PKCS11Exception.a("Sef{8b|v>9shg{,rc`/#hc#29'cl/jtxs+%uyf?"), PKCS11Exception.a("Lhz{\"fcg7/'dp{#i{b7#c"), PKCS11Exception.a("Lhz{9nwf{#t-l.>'be{8fcd>"), PKCS11Exception.a("Lhz{>~}f{#t-j5)hcp29shm/jpdw3jjh`3+idp6"), PKCS11Exception.a("Lhz{$hy#5/bif?f'h{/8fcf4?t-h>3'~v+:kdf?"), PKCS11Exception.a("Lhz{\"f~#9/bc#8\"fcd>."), PKCS11Exception.a("Lhz{$bhg>.+-m4jlhz{9r}s7#bi"), PKCS11Exception.a("Sef{<fav>jhk#/\"b-p+/dde2/c-h>3'nb5$hy#9/'ij</tyf?"), PKCS11Exception.a("Axm8>nbm{$hy#+/u`j/>bi#=%u-w3#t-h>3"), PKCS11Exception.a("Lhz{)fcm4>'of{=uls+/c"), PKCS11Exception.a("Lhz{#t-v5/\u007fyq:)sla7/"), PKCS11Exception.a("Jh`3+idp6jncu:&ni"), PKCS11Exception.a("Jh`3+idp6jwlq:'byf)jn~#2$qlo2."), PKCS11Exception.a("Hoi>)s-k:$caf{#t-j5<faj?"), PKCS11Exception.a("Fcl/\"b\u007f#4:b\u007fb/#hc#29'lo)/fiz{+dyj-/"), PKCS11Exception.a("H}f)+sdl5jolp{$hy#9/bc#2$nyj:&nwf?"), PKCS11Exception.a("Wdm{#t-j5)h\u007fq>)s"), PKCS11Exception.a("Iht{\u001aNC#8%slj59'dm-+kdg{)olq:)shq("), PKCS11Exception.a("Iht{\u001aNC#7/ijw3jn~#4?s-l=julm</"), PKCS11Exception.a("Wdm{\"f~#>2wdq>."), PKCS11Exception.a("Wdm{#t-o4)lhg"), PKCS11Exception.a("Thp(#hc#3+t-a>/i-`7%thg"), PKCS11Exception.a("Thp(#hc#7#jdw(jolu>jehf5juhb8\"bi"), PKCS11Exception.a("Thp(#hc#3+iio>jn~#2$qlo2."), PKCS11Exception.a("Wlq:&kho{/\u007fh`.>nbm{#t-m4>'~v+:h\u007fw>."), PKCS11Exception.a("Thp(#hc#29'\u007ff:.*bm73"), PKCS11Exception.a("F-p>9tdl5jpdw3jsef{>hff5jn~#:&uhb?3'bs>$"), PKCS11Exception.a("F-q>+c l5&~-p>9tdl5jfaq>+ct#>2n~w(jfcg{>oh#\b\u0005'nb5$hy#9/'al<-bi#2$"), PKCS11Exception.a("F-q>+c\"t)#sh#\b\u0005'~f(9nbm{+k\u007ff:.~-f##typ{+ii#/\"b-P\u0014jdlm5%s-a>jkbd</c-j5"), PKCS11Exception.a("Tdd5+sxq>jn~#2$qlo2."), PKCS11Exception.a("Tdd5+sxq>jkhm<>o-j(jhxw{%a-q:$`h"), PKCS11Exception.a("Shn+&fyf{#t-j5)h`s7/sh"), PKCS11Exception.a("Shn+&fyf{#t-j5)hcp29shm/"), PKCS11Exception.a("Tal/jcbf(jibw{)hcw:#i-b{>hff5"), PKCS11Exception.a("Sef{>hff5jplp{$hy#)/dbd5#}hg"), PKCS11Exception.a("Sbh>$'dp{=udw>gw\u007fl//dyf?"), PKCS11Exception.a("Rct)+w}j5-'ff\"jolm?&b-j(jncu:&ni"), PKCS11Exception.a("Rct)+w}j5-'ff\"jtdy>jn~#4?s-l=julm</"), PKCS11Exception.a("Rct)+w}j5-'ff\"jn~#2$dbm(#tyf5>'zj/\"'`f8\"fcj('"), PKCS11Exception.a("F-v(/u-j(jfaq>+ct#7%`jf?jnc"), PKCS11Exception.a("F-v(/u-j(jibw{&hjd>.'dm"), PKCS11Exception.a("Sef{?thq|9']J\u0015jolp{$hy#9/bc#2$nyj:&nwf?"), PKCS11Exception.a("R~f)jsts>jn~#2$qlo2."), PKCS11Exception.a("Fcl/\"b\u007f#.9b\u007f#29'lo)/fiz{&hjd>.'dm"), PKCS11Exception.a("Sbl{'fcz{?thq(jkbd</c-j5"), PKCS11Exception.a("P\u007fb+:bi#0/~-j(jncu:&ni"), PKCS11Exception.a("P\u007fb+:bi#0/~-o>$`yk{#t-l.>'be{8fcd>"), PKCS11Exception.a("P\u007fb+:ncd{!bt#3+iio>jn~#2$qlo2."), PKCS11Exception.a("P\u007fb+:ncd{!bt#(#}h#29'dm-+kdg"), PKCS11Exception.a("P\u007fb+:ncd{!bt#/3wh#29'dm8%i~j(>bcw{=nyk{'bnk:$n~n"), PKCS11Exception.a("Ulm?%j-m.'ehq{-bcf)+sbq{.hhp{$hy#:)dhs/jthf?#ij"), PKCS11Exception.a("Sef{>hff5jcbf(jibw{\"f{f{+'\u007fb5.h`#5?jof)j`hm>8fyl)"), PKCS11Exception.a("Ncu:&ni#48'xm(?w}l)>bi#?%jlj5jwlq:'byf)9"), PKCS11Exception.a("Exe=/u-w4%'~n:&k"), PKCS11Exception.a("Sef{9f{f?jh}f)+sdl59'~w:>b-j(jncu:&ni#:$c-`:$ibw{(b-q>9sbq>."), PKCS11Exception.a("Sef{8b|v>9shg{#ikl)'fyj4$'dp{9bcp2>n{f{+ii#8+icl/jeh#)/qhb7/c"), PKCS11Exception.a("Sef{%whq:>nbm(jtyb//'nb5$hy#9/'~b-/c"), PKCS11Exception.a("D\u007fz+>hfj{#t-m4>'tf/jncj/#faj!/c"), PKCS11Exception.a("D\u007fz+>hfj{#t-b78blg\"jncj/#faj!/c"), PKCS11Exception.a("Jxw>2'ba1/dy#29'ob?"), PKCS11Exception.a("Jxw>2'dp{$hy#7%dff?")};
    int code;

    public PKCS11Exception(int n2) {
        super(PKCS11Exception.errorMessage(n2));
        this.code = n2;
    }

    public PKCS11Exception(String string) {
        super(string);
        this.code = Integer.MIN_VALUE;
    }

    public int getCode() {
        return this.code;
    }

    static String errorMessage(int n2) {
        if ((n2 & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return PKCS11Exception.a("Qhm?%u-g>,ncf?jb\u007fq48");
        }
        int n3 = 0;
        while (n3 < CKR_names.length) {
            if (CKR_types[n3] == n2) {
                return CKR_names[n3];
            }
            ++n3;
        }
        return PKCS11Exception.a("Rch5%pc#>8ubq{b7u") + Integer.toHexString(n2) + ")";
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 7;
                        break;
                    }
                    case 1: {
                        n5 = 13;
                        break;
                    }
                    case 2: {
                        n5 = 3;
                        break;
                    }
                    case 3: {
                        n5 = 91;
                        break;
                    }
                    default: {
                        n5 = 74;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

