/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMAWTUtil;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFilenameFilter;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class KMInputFileDialog
extends JDialog
implements IkeymanConstants,
ActionListener {
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton helpButton;
    private KMButton browseButton;
    private JLabel fileNameLabel;
    private JTextField fileNameField;
    private JLabel dirNameLabel;
    private JTextField dirNameField;
    private KeyStoreManager keyDb;
    private String currWorkingDirName;
    private int mode;
    private String browserFileName;
    private String browserDirName;
    FilenameFilter fileNameFilter = null;
    JPanel mainPanel = new JPanel();
    JPanel fileNamePanel = new JPanel();
    private String fileName;
    private String dirName;
    private JDialog diagInstance;

    public KMInputFileDialog(JFrame jFrame, String string) {
        this(jFrame, string, (KeyStoreManager)null, 0);
    }

    public KMInputFileDialog(JFrame jFrame, String string, KeyStoreManager keyStoreManager, int n) {
        this(jFrame, string, keyStoreManager, Ikeyman.getNLSResString("GUI_LABEL_FILENAME"), n);
    }

    public KMInputFileDialog(JFrame jFrame, String string, KeyStoreManager keyStoreManager, String string2, int n) {
        super(jFrame, string, true);
        this.keyDb = keyStoreManager;
        this.mode = n;
        this.diagInstance = this;
        this.populateFields();
        this.fileNameLabel.setText(string2);
        this.mainPanel.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.fileNamePanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.fileNameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.fileNameField, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 5, 5);
        gridBagLayout.setConstraints(this.browseButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.dirNameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.dirNameField, gridBagConstraints);
        this.fileNamePanel.add(this.fileNameLabel);
        this.fileNamePanel.add(this.fileNameField);
        this.fileNamePanel.add(this.browseButton);
        this.fileNamePanel.add(this.dirNameLabel);
        this.fileNamePanel.add(this.dirNameField);
        KMHorizontalButtonPanel kMHorizontalButtonPanel = new KMHorizontalButtonPanel();
        kMHorizontalButtonPanel.add(this.okButton);
        kMHorizontalButtonPanel.add(this.cancelButton);
        kMHorizontalButtonPanel.equalizeButtons();
        this.mainPanel.add((Component)this.fileNamePanel, "Center");
        this.mainPanel.add((Component)kMHorizontalButtonPanel, "South");
        BevelBorder bevelBorder = new BevelBorder(0);
        this.mainPanel.setBorder(bevelBorder);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.mainPanel, "Center");
        this.addWindowListener(new DiagAdapter());
        this.pack();
        this.setResizable(false);
        this.fileNameField.requestFocus();
    }

    protected void populateFields() {
        this.populateInputFields();
        this.populateButtons();
        this.setToolTips();
    }

    protected void populateInputFields() {
        int n = 45;
        if (Ikeyman.screenSize.width < 800) {
            n = 25;
        } else if (Ikeyman.screenSize.width < 1024) {
            n = 35;
        }
        String string = Locale.getDefault().getLanguage();
        if (string.equals("ja")) {
            n *= 2;
        }
        this.fileNameLabel = new JLabel();
        this.fileNameField = new JTextField(n);
        File file = new File(".");
        int n2 = 0;
        if (this.keyDb != null) {
            n2 = this.keyDb.getType();
        }
        this.currWorkingDirName = KeyStoreManager.getDefaultKeyDbFileLocation(n2);
        this.dirNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_LOCATION"));
        this.dirNameField = new JTextField(this.currWorkingDirName, n);
        if (string.equals("ko") || string.equals("ja")) {
            this.fileNameField.setFont(Ikeyman.defaultMonospacedFont);
            this.dirNameField.setFont(Ikeyman.defaultMonospacedFont);
        }
    }

    protected void populateButtons() {
        this.browseButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_BROWSE"));
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.helpButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_HELP"));
        this.browseButton.setActionCommand("Browse");
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("Cancel");
        this.helpButton.setActionCommand("Help");
        this.browseButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        if (!Ikeyman.isHelpAvailable()) {
            this.helpButton.setEnabled(false);
        }
    }

    protected void setToolTips() {
        this.fileNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_FILE_NAME"));
        this.dirNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_FILE_LOCATION"));
    }

    public String getFileName() {
        return KMUtil.trimBlankSpace(this.fileName);
    }

    public String getDirName() {
        return KMUtil.trimBlankSpace(this.dirName);
    }

    public void setFileName(String string) {
        this.fileNameField.setText(string);
    }

    public void setDirName(String string) {
        this.dirNameField.setText(string);
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.fileNameFilter = filenameFilter;
    }

    public void setFileNameLabelText(String string) {
        this.setResizable(true);
        this.fileNameLabel.setText(string);
        this.fileNameLabel.invalidate();
        this.fileNamePanel.validate();
        this.mainPanel.validate();
        this.pack();
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.fileName = this.fileNameField.getText();
            this.dirName = this.dirNameField.getText();
            if (KMUtil.trimBlankSpace(this.fileName) != null) {
                int n;
                File file;
                if (this.dirName == null) {
                    this.dirName = this.currWorkingDirName;
                }
                if (!this.dirName.endsWith(File.separator)) {
                    this.dirName = this.dirName + File.separator;
                }
                if (!(Ikeyman.isOverwriteConfirmedFileDialog() && this.fileName.equals(this.browserFileName) && this.dirName.equals(this.browserDirName) || this.mode != 1 || !(file = new File(this.dirName, this.fileName)).exists() || (n = KMFrame.showConfirmDialog(KMAWTUtil.getFrame(this), Ikeyman.getNLSResString("GUI_DIALOG_QST_OVERWRITE_KDB_FILE"), 1)) == 0)) {
                    this.fileNameField.requestFocus();
                    return;
                }
                ((Component)this).setVisible(false);
            } else {
                KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_INVALID_FILE_PATH_NAME"));
                this.fileNameField.requestFocus();
            }
        } else if (string.equals("Cancel")) {
            KMUtil.debugMsg("Cancel button is hit\n");
            this.fileName = null;
            this.dirName = null;
            ((Component)this).setVisible(false);
        } else if (string.equals("Browse")) {
            KMUtil.debugMsg("Browse button is hit\n");
            JFileChooser jFileChooser = new JFileChooser(KMSystem.getWorkingDirName());
            jFileChooser.setFileHidingEnabled(KMFrame.hideHiddenFiles);
            if (KMFrame.isWindowLookAndFeel()) {
                jFileChooser.setPreferredSize(new Dimension(((JComponent)object).getWidth() * 6, ((JComponent)object).getHeight() * 10));
            }
            KMFilenameFilter kMFilenameFilter = new KMFilenameFilter(".arm", Ikeyman.getNLSResString("GUI_LABEL_KEY_FILE_TYPE"));
            jFileChooser.addChoosableFileFilter(kMFilenameFilter);
            jFileChooser.setDialogTitle(Ikeyman.getNLSResString("GUI_DIALOG_TITLE_EXTRACT_CERTREQ"));
            jFileChooser.setCurrentDirectory(new File(this.dirNameField.getText()));
            Dimension dimension = jFileChooser.getSize();
            jFileChooser.setLocation((Ikeyman.screenSize.width - dimension.width) / 2, (Ikeyman.screenSize.height - dimension.height) / 2);
            int n = jFileChooser.showSaveDialog(null);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.fileName = file.getName();
                this.fileNameField.setText(this.fileName);
                this.dirName = jFileChooser.getCurrentDirectory().toString();
                if (!this.dirName.endsWith(File.separator)) {
                    this.dirName = this.dirName + File.separator;
                }
                this.dirNameField.setText(this.dirName);
                KMSystem.setCurrentWorkingDirName(this.dirName);
            } else if (n != 1) {
                if (n == -1) {
                    KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_NOT_OPENED"));
                } else {
                    KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
                }
            }
        } else if (string.equals("Help")) {
            String string2 = "packages.html";
            Ikeyman.showHelpWindow(this, string2);
        }
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.okButton.requestFocus();
    }

    class DiagAdapter
    extends WindowAdapter {
        DiagAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            KMInputFileDialog.this.fileName = null;
            KMInputFileDialog.this.dirName = null;
            ((Component)KMInputFileDialog.this).setVisible(false);
        }
    }
}

