/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;

class GB18030Decoder
extends IBMCharsetDecoder {
    protected static final int LINEAR_BASE = 74418;
    protected static final int LINEAR_FOUR_BASE = 24067;
    protected static final int LINEAR_BIG = GB18030Decoder.toLinear(144, 48, 129, 48);
    protected static final int LINEAR_BIGEND = GB18030Decoder.toLinear(227, 50, 154, 53);
    private static final int NO_CHAR = 0xFFFFFF;
    private static final int REPLACE_CHAR = 0xFFFFFE;
    private final char[] index;
    private final char[] ranges;
    private final char[] values;
    private final int convType;

    protected static int toLinear(int n, int n2) {
        return (n - 129) * 191 + (n2 - 63);
    }

    protected static int toLinear(int n, int n2, int n3, int n4) {
        return (((n & 0x7F) * 10 + (n2 & 0xFF)) * 126 + (n3 & 0xFF)) * 10 + (n4 & 0xFF) - 74418 + 24067;
    }

    protected GB18030Decoder(Charset charset, char[] cArray, char[] cArray2, char[] cArray3, String string) {
        super(charset, 1.0f, 1.0f);
        this.index = cArray;
        this.ranges = cArray2;
        this.values = cArray3;
        this.convType = string != null && string.length() > 0 ? string.charAt(0) - 48 : 0;
    }

    protected int getUnicode(int n) {
        if (n < 65535) {
            int n2 = this.index[n >> 9] << 2;
            while (n >= this.ranges[n2]) {
                if (n <= this.ranges[n2 + 1]) {
                    switch (this.ranges[n2 + 2]) {
                        case '\u0001': {
                            return this.values[this.ranges[n2 + 3] + (n - this.ranges[n2])];
                        }
                        case '\u0002': {
                            return this.ranges[n2 + 3] + (n - this.ranges[n2]);
                        }
                    }
                }
                n2 += 4;
            }
        } else if (n >= LINEAR_BIG && n <= LINEAR_BIGEND) {
            return 65536 + n - LINEAR_BIG;
        }
        return 0xFFFFFE;
    }

    protected boolean isLeadByte(int n) {
        if (this.convType == 2) {
            return true;
        }
        return n >= 129 && n <= 254;
    }

    protected boolean isExtendedByte(int n) {
        if (this.convType != 0) {
            return false;
        }
        return n <= 57 && n >= 48;
    }

    protected boolean isValidSecondByte(int n) {
        return n >= 64 && n != 127 && n != 255;
    }

    protected int convSingleByte(int n) {
        if (n < 128) {
            return (char)n;
        }
        return 0xFFFFFE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        int n2;
        block26: {
            CoderResult coderResult2;
            block25: {
                CoderResult coderResult3;
                block24: {
                    CoderResult coderResult4;
                    block23: {
                        CoderResult coderResult5;
                        block22: {
                            CoderResult coderResult6;
                            block21: {
                                CoderResult coderResult7;
                                block20: {
                                    byte[] byArray = byteBuffer.array();
                                    int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
                                    int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
                                    char[] cArray = charBuffer.array();
                                    n2 = charBuffer.arrayOffset() + charBuffer.position();
                                    int n5 = charBuffer.arrayOffset() + charBuffer.limit();
                                    n = n3;
                                    int n6 = 0;
                                    int n7 = 0;
                                    int n8 = 0;
                                    int n9 = 0;
                                    int n10 = 0xFFFFFF;
                                    try {
                                        while (n3 < n4) {
                                            int n11 = byArray[n3++] & 0xFF;
                                            switch (n9) {
                                                case 0: {
                                                    if (this.isLeadByte(n11)) {
                                                        n9 = 1;
                                                        n6 = n11;
                                                        n10 = 0xFFFFFF;
                                                        break;
                                                    }
                                                    n10 = this.convSingleByte(n11);
                                                    break;
                                                }
                                                case 1: {
                                                    if (this.isExtendedByte(n11)) {
                                                        n9 = 2;
                                                        n7 = n11;
                                                        break;
                                                    }
                                                    if (!this.isValidSecondByte(n11)) {
                                                        coderResult7 = CoderResult.malformedForLength(2);
                                                        Object var18_23 = null;
                                                        break block20;
                                                    } else {
                                                        n10 = this.getUnicode(GB18030Decoder.toLinear(n6, n11));
                                                        break;
                                                    }
                                                }
                                                case 2: {
                                                    if (this.isLeadByte(n11)) {
                                                        n9 = 3;
                                                        n8 = n11;
                                                        break;
                                                    }
                                                    coderResult6 = CoderResult.malformedForLength(3);
                                                    break block21;
                                                }
                                                case 3: {
                                                    if (this.isExtendedByte(n11)) {
                                                        n10 = this.getUnicode(GB18030Decoder.toLinear(n6, n7, n8, n11));
                                                        break;
                                                    }
                                                    coderResult5 = CoderResult.malformedForLength(4);
                                                    break block22;
                                                }
                                            }
                                            if (n10 == 0xFFFFFF) continue;
                                            if (n10 == 0xFFFFFE) {
                                                coderResult4 = CoderResult.unmappableForLength(n9 + 1);
                                                break block23;
                                            }
                                            if (n10 > 65535) {
                                                if (n5 - n2 < 2) {
                                                    coderResult3 = CoderResult.OVERFLOW;
                                                    break block24;
                                                }
                                                cArray[n2++] = (char)((n10 -= 65536) >> 10 | 0xD800);
                                                cArray[n2++] = (char)(n10 & 0x3FF | 0xDC00);
                                            } else {
                                                if (n5 - n2 < 1) {
                                                    coderResult2 = CoderResult.OVERFLOW;
                                                    break block25;
                                                }
                                                cArray[n2++] = (char)n10;
                                            }
                                            n += n9 + 1;
                                            n9 = 0;
                                        }
                                        coderResult = CoderResult.UNDERFLOW;
                                        break block26;
                                    }
                                    catch (Throwable throwable) {
                                        Object var18_30 = null;
                                        byteBuffer.position(n - byteBuffer.arrayOffset());
                                        charBuffer.position(n2 - charBuffer.arrayOffset());
                                        throw throwable;
                                    }
                                }
                                byteBuffer.position(n - byteBuffer.arrayOffset());
                                charBuffer.position(n2 - charBuffer.arrayOffset());
                                return coderResult7;
                            }
                            Object var18_24 = null;
                            byteBuffer.position(n - byteBuffer.arrayOffset());
                            charBuffer.position(n2 - charBuffer.arrayOffset());
                            return coderResult6;
                        }
                        Object var18_25 = null;
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        charBuffer.position(n2 - charBuffer.arrayOffset());
                        return coderResult5;
                    }
                    Object var18_26 = null;
                    byteBuffer.position(n - byteBuffer.arrayOffset());
                    charBuffer.position(n2 - charBuffer.arrayOffset());
                    return coderResult4;
                }
                Object var18_27 = null;
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n2 - charBuffer.arrayOffset());
                return coderResult3;
            }
            Object var18_28 = null;
            byteBuffer.position(n - byteBuffer.arrayOffset());
            charBuffer.position(n2 - charBuffer.arrayOffset());
            return coderResult2;
        }
        Object var18_29 = null;
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n2 - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0xFFFFFF;
        try {
            while (byteBuffer.hasRemaining()) {
                int n7 = byteBuffer.get() & 0xFF;
                switch (n5) {
                    case 0: {
                        if (this.isLeadByte(n7)) {
                            n5 = 1;
                            n2 = n7;
                            n6 = 0xFFFFFF;
                            break;
                        }
                        n6 = this.convSingleByte(n7);
                        break;
                    }
                    case 1: {
                        if (this.isExtendedByte(n7)) {
                            n5 = 2;
                            n3 = n7;
                            break;
                        }
                        if (!this.isValidSecondByte(n7)) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        n6 = this.getUnicode(GB18030Decoder.toLinear(n2, n7));
                        break;
                    }
                    case 2: {
                        if (this.isLeadByte(n7)) {
                            n5 = 3;
                            n4 = n7;
                            break;
                        }
                        CoderResult coderResult = CoderResult.malformedForLength(3);
                        return coderResult;
                    }
                    case 3: {
                        if (this.isExtendedByte(n7)) {
                            n6 = this.getUnicode(GB18030Decoder.toLinear(n2, n3, n4, n7));
                            break;
                        }
                        CoderResult coderResult = CoderResult.malformedForLength(4);
                        return coderResult;
                    }
                }
                if (n6 == 0xFFFFFF) continue;
                if (n6 == 0xFFFFFE) {
                    CoderResult coderResult = CoderResult.unmappableForLength(n5 + 1);
                    return coderResult;
                }
                if (n6 > 65535) {
                    if (charBuffer.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put((char)((n6 -= 65536) >> 10 | 0xD800));
                    charBuffer.put((char)(n6 & 0x3FF | 0xDC00));
                } else {
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put((char)n6);
                }
                n += n5 + 1;
                n5 = 0;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !UseBuffer) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

