/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Iterator;
import java.util.List;

public abstract class CertPath
implements Serializable {
    static final long serialVersionUID = 6068470306649138683L;
    private String type;

    protected CertPath(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public abstract Iterator getEncodings();

    public boolean equals(Object object) {
        boolean bl = false;
        if (!(object instanceof CertPath)) {
            return false;
        }
        if (this == (CertPath)object) {
            return true;
        }
        if (!this.getType().equals(((CertPath)object).getType())) {
            return false;
        }
        List list = this.getCertificates();
        List list2 = ((CertPath)object).getCertificates();
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        if (list.size() != list2.size()) {
            return false;
        }
        while (iterator.hasNext()) {
            Certificate certificate;
            Certificate certificate2 = (Certificate)iterator.next();
            if (!certificate2.equals(certificate = (Certificate)iterator2.next())) {
                return false;
            }
            bl = true;
        }
        return bl || list.size() == 0 && list2.size() == 0;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        n = 31 * n + ((Object)this.getCertificates()).hashCode();
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.getCertificates();
        stringBuffer.append("\n" + this.type + " Cert Path: length = " + list.size() + ".\n[\n");
        Iterator iterator = list.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            stringBuffer.append("=========================================================Certificate " + n + " start.\n" + certificate.toString() + "\n=========================================================Certificate " + n + " end.\n\n\n");
            ++n;
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    public abstract List getCertificates();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertPathRep(this.type, this.getEncoded());
        }
        catch (CertificateException certificateException) {
            NotSerializableException notSerializableException = new NotSerializableException("java.security.cert.CertPath: " + this.type);
            notSerializableException.initCause(certificateException);
            throw notSerializableException;
        }
    }

    protected static class CertPathRep
    implements Serializable {
        static final long serialVersionUID = 3015633072427920915L;
        private String type;
        private byte[] data;

        protected CertPathRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(this.type);
                return certificateFactory.generateCertPath(new ByteArrayInputStream(this.data));
            }
            catch (CertificateException certificateException) {
                NotSerializableException notSerializableException = new NotSerializableException("java.security.cert.CertPath: " + this.type);
                notSerializableException.initCause(certificateException);
                throw notSerializableException;
            }
        }
    }
}

