VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form TestClient 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Video Online Test Client"
   ClientHeight    =   6915
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   9000
   BeginProperty Font 
      Name            =   "Arial"
      Size            =   9
      Charset         =   178
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6915
   ScaleWidth      =   9000
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdQueryWishList 
      Caption         =   "Query Wish List"
      Default         =   -1  'True
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   3360
      TabIndex        =   5
      Top             =   6480
      Width           =   2835
   End
   Begin VB.CommandButton cmdAddWishList 
      Caption         =   "Add To Wish List"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   240
      TabIndex        =   4
      Top             =   6480
      Width           =   2355
   End
   Begin VB.TextBox txtOutput 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3915
      Left            =   3240
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   3
      Top             =   2400
      Width           =   5655
   End
   Begin VB.CommandButton cmdSave 
      Caption         =   "Save"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   6480
      TabIndex        =   1
      Top             =   6480
      Width           =   1155
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   9
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   7800
      TabIndex        =   0
      Top             =   6480
      Width           =   1155
   End
   Begin MSComctlLib.ListView lstTitles 
      Height          =   3975
      Left            =   120
      TabIndex        =   2
      Top             =   2400
      Width           =   2955
      _ExtentX        =   5212
      _ExtentY        =   7011
      View            =   3
      LabelEdit       =   1
      MultiSelect     =   -1  'True
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      FullRowSelect   =   -1  'True
      GridLines       =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin VB.Image Image1 
      BorderStyle     =   1  'Fixed Single
      Height          =   1095
      Left            =   120
      Picture         =   "TestClient.frx":0000
      Top             =   0
      Width           =   8820
   End
   Begin VB.Label lblTitle 
      Alignment       =   2  'Center
      Caption         =   "Wish List - Test Client"
      BeginProperty Font 
         Name            =   "Comic Sans MS"
         Size            =   20.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   -1  'True
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   840
      TabIndex        =   8
      Top             =   1200
      Width           =   8775
   End
   Begin VB.Line Line1 
      X1              =   120
      X2              =   10320
      Y1              =   1920
      Y2              =   1920
   End
   Begin VB.Line Line2 
      X1              =   3120
      X2              =   3120
      Y1              =   2040
      Y2              =   7200
   End
   Begin VB.Label lblOutput 
      AutoSize        =   -1  'True
      Caption         =   "Current wish list titles (XML document) :"
      Height          =   225
      Index           =   0
      Left            =   3660
      TabIndex        =   7
      Top             =   2040
      Width           =   3240
   End
   Begin VB.Label lblOutput 
      AutoSize        =   -1  'True
      Caption         =   "Available titles list :"
      Height          =   225
      Index           =   1
      Left            =   120
      TabIndex        =   6
      Top             =   2040
      Width           =   1545
   End
End
Attribute VB_Name = "TestClient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' IVOEBDL stands for IBM Video Online for e-businss Data Layer

' Adds titles to customer wish list
' Generates XML-formatted string, passes this to XTitleIDShredder UDF
' Calls AddWished method in IVOEBDL
' Returns nothing
Private Sub cmdAddWishList_Click()

    Dim AddTitles As String         ' XML-formatted string
    Dim NumSelected As Integer      ' Number of TitlsIDs selected
    Dim MovieNumbers As String      ' TitleIDs
    Dim Count As Integer            ' Title counter
    Dim dl As Object                ' Data Layer object
    Dim rc As Long                  ' Record
    Dim MID As Integer              ' MemberID

    ' Generate XML-formatted string
    NumSelected = 0
    
    AddTitles = _
        "<AddWishedTitles>" & vbNewLine & _
        "<Titles>" & vbNewLine

    For Count = 1 To lstTitles.ListItems.Count
        If lstTitles.ListItems.Item(Count).Selected Then
            NumSelected = NumSelected + 1
            AddTitles = AddTitles & _
            "<Title>" & vbNewLine & _
            "<TitleID>" & _
            lstTitles.ListItems(Count).Text & _
            "</TitleID>" & vbNewLine & _
            "</Title>" & vbNewLine
        End If
    Next

    If NumSelected = 0 Then
        Exit Sub
    End If
    
    AddTitles = AddTitles & _
    "</Titles>" & vbNewLine & _
    "</AddWishedTitles>"

    MsgBox AddTitles, vbInformation, "AddTitles XML"
    
    MID = 1
    
    ' Create Data Layer object
    Set dl = CreateObject("IVOEBDL.WishList")
    rc = dl.AddWished(MID, AddTitles)
    Set dl = Nothing
    
    txtOutput.Text = ""
    Call RefreshList

End Sub

' Initialize form
Private Sub Initialize()
    
    Dim Count As Integer
    
    For Count = 1 To lstTitles.ListItems.Count
        lstTitles.ListItems.Item(Count).Selected = False
    Next
    
    txtOutput.Text = ""
End Sub

' Exit test client application
Private Sub cmdExit_Click()
    Unload Me
End Sub

' Query customer wish list
' Calls GetMyWishedFull method in IVOEBDL
' Returns customer wish list in XML format to txtOutput
Private Sub cmdQueryWishList_Click()
    
    Dim List As String      ' XML-formatted output string
    Dim dl As Object        ' Data Layer object
    Dim rc As Long          ' Record
    Dim MID As Integer      ' MemberID

    MID = 1
    
    Set dl = CreateObject("IVOEBDL.WishList")
    
    rc = dl.GetMyWishedFull(MID, List)
    
    Set dl = Nothing

    txtOutput.Text = List

End Sub

' Sets up look/format of title list
Private Sub SetupList()
    
    lstTitles.ColumnHeaders.Add , , "ID", lstTitles.Width / 7
    lstTitles.ColumnHeaders.Add , , "Name", lstTitles.Width * (3 / 4)

End Sub

' Builds title list from database
' Only titles not currently in customer wish list displayed
' Calls GetNonWishedTitlesList method in Data Layer
' Returns recordset of TitleID, Name for each movie
Private Sub RefreshList()
    
    Dim lstItem As ListItem
    Dim rsTitles As New ADODB.Recordset
    Dim dl As Object
    Dim MID As Integer

    MID = 1
    
    Set dl = CreateObject("IVOEBDL.WishList")
    
    Call dl.GetNonWishedTitlesList(MID, rsTitles)
    
    Set dl = Nothing
    
    lstTitles.ListItems.Clear

    While Not rsTitles.EOF
        Set lstItem = lstTitles.ListItems.Add(Text:=rsTitles!TitleID)
        Call lstItem.ListSubItems.Add(Text:=rsTitles!Name)
        rsTitles.MoveNext
    Wend
    
    rsTitles.Close
    
    Call Initialize

End Sub

Private Sub cmdSave_Click()
    Dim fs As Object
    Dim fl As Object
    Set fs = CreateObject("Scripting.FileSystemObject")
    Set fl = fs.CreateTextFile("WishList.xml", True)
    Call fl.WriteLine(txtOutput.Text)
    Call fl.Close
    Set fl = Nothing
    Set fs = Nothing
End Sub

' Form load commands
Private Sub Form_Load()
    Call Initialize
    Call SetupList
    Call RefreshList
End Sub



