/******************************************************************/
/* Program -FhbCPP- ported from PLI language to C by KM - 8/27/97 */
/* File has been reorganized to be readable in C                  */
/******************************************************************/
/* 5696-737 (C) COPYRIGHT IBM CORP. 1988-94                       */
/* LICENSED MATERIAL - PROGRAM PROPERTY OF IBM                    */
/*   iwsv3r1 work station modifications  12/01/94 psw             */
/******************************************************************/


#ifdef __WIN32__
#include <io.h>
#else
#ifdef __MSDOS__
#include <io.h>
#endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fhbcpp.h"


/**************************************/
/* Global variables                   */
/**************************************/
char Infilename[80], Outfilename[80];
FILE *Infile, *Outfile;
/**************************************/


/* Retrieves parameter */
void getparam(int argc, char **argv, char *infilename, char *outfilename)
{
   /* Get parameter */
   if (argc-1 == 0)
   {
      printf("\nInvalid number of parameters\n");
      printf("Syntax: FHBCPP  <input file>  [output file]\n\n");
      exit(1);
   }
   else
   {
      strcpy(infilename, argv[1]);
      if (argc-1 >= 2)
         strcpy(outfilename, argv[2]);
      else
         strcpy(outfilename, OUTFILE);
   }
}

/* Opens input and output files */
FILE *openfile(char *filename, char *mode)
{
   FILE *file;

   if (!(file = fopen(filename, mode)))
   {
      printf("\nError opening %s file\n", mode[0]=='r' ? "COBOL source input" : "output");
      exit(1);
   }
   else
      return file;
}



/**************************************/
/* Main Program                       */
/**************************************/
int main(int argc, char **argv)
{
   /* Get parameter */
   getparam(argc, argv, Infilename, Outfilename);

   /* Open files */
   if ((Infile = openfile(Infilename, "r")))
      Outfile = openfile(Outfilename, "w");

   /* Follow structure of PLI code */
   do_mri();

   /* Close files */
   fclose(Infile);
   fclose(Outfile);

   return 0;
}
