/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.reuse.awt.GridTools;
import com.ibm.vatc.reuse.awt.RollOverButton;
import com.ibm.vatc.reuse.awt.Toolbar;
import com.ibm.vatc.tcmerge.CollisionsCanvas;
import com.ibm.vatc.tcmerge.CollisionsListener;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

class CollisionsDialog
extends Dialog {
    CollisionsCanvas collisionsCanvas;
    Frame parentFrame;
    int currentSelection;
    int numOfFiles;
    Vector mergeInfo;
    ScrollPane scrollPane;
    CollisionsListener collisionsListener;
    RollOverButton nextColButton;
    RollOverButton prevColButton;
    static /* synthetic */ Class class$com$ibm$vatc$tcmerge$CollisionsDialog;

    public CollisionsDialog(Frame frame, Vector vector, int n) {
        super(frame, tcmerge.locResource.getString("ITEM_COLLISION"));
        this.parentFrame = frame;
        this.currentSelection = n;
        this.mergeInfo = vector;
        this.numOfFiles = vector.size();
        ((Component)this).setSize(460, 160);
        this.setResizable(false);
        ((Component)this).setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.setLayout(new GridBagLayout());
        DialogListener dialogListener = new DialogListener();
        this.addWindowListener(dialogListener);
        KeyboardListener keyboardListener = new KeyboardListener();
        this.addKeyListener(keyboardListener);
        this.collisionsCanvas = new CollisionsCanvas(vector, n);
        this.collisionsCanvas.addKeyListener(keyboardListener);
        this.collisionsCanvas.addCanvasListener(new CanvasListener());
        this.scrollPane = new ScrollPane(0);
        this.scrollPane.add(this.collisionsCanvas, null, 0);
        this.scrollPane.setSize(420, 100);
        this.scrollPane.getHAdjustable().setUnitIncrement(8);
        this.scrollPane.getVAdjustable().setUnitIncrement(12);
        GridTools.constrain(this, this.scrollPane, 2, 2, 1, 1);
        Canvas canvas = new Canvas();
        canvas.setSize(5, 5);
        canvas.setBackground(Color.lightGray);
        canvas.addKeyListener(keyboardListener);
        GridTools.constrain(this, canvas, 1, 3, 1, 1);
        Canvas canvas2 = new Canvas();
        canvas2.setSize(5, 5);
        canvas2.setBackground(Color.lightGray);
        canvas2.addKeyListener(keyboardListener);
        GridTools.constrain(this, canvas2, 3, 3, 1, 1);
        Class clazz = class$com$ibm$vatc$tcmerge$CollisionsDialog != null ? class$com$ibm$vatc$tcmerge$CollisionsDialog : (class$com$ibm$vatc$tcmerge$CollisionsDialog = CollisionsDialog.class$("com.ibm.vatc.tcmerge.CollisionsDialog"));
        Toolbar toolbar = new Toolbar(clazz);
        toolbar.addSeparator(4);
        this.nextColButton = toolbar.addTool("ndnoroll.gif", "ndgrey.gif", "ndroll.gif", "nddown.gif", new ToolbarListener("nextCol"));
        this.nextColButton.addKeyListener(keyboardListener);
        this.prevColButton = toolbar.addTool("pdnoroll.gif", "pdgrey.gif", "pdroll.gif", "pddown.gif", new ToolbarListener("prevCol"));
        this.prevColButton.addKeyListener(keyboardListener);
        GridTools.constrain(this, toolbar, 2, 1, 1, 1, 0, 0, 10, 0);
        toolbar.addSeparator(4);
        toolbar.addKeyListener(keyboardListener);
        this.setButtons();
        Dimension dimension = this.parentFrame.getSize();
        Dimension dimension2 = this.getSize();
        Point point = this.parentFrame.getLocationOnScreen();
        Dimension dimension3 = this.getToolkit().getScreenSize();
        Point point2 = new Point();
        point2.x = point.x + (dimension.width - dimension2.width) / 2;
        point2.y = point.y + dimension.height + 40;
        if (point2.y + dimension2.height > dimension3.height) {
            point2.y = dimension3.height - dimension2.height;
        }
        if (point2.x < 0) {
            point2.x = 0;
        }
        if (point2.x > dimension3.width - dimension2.width) {
            point2.x = dimension3.width - dimension2.width;
        }
        ((Component)this).setLocation(point2);
    }

    public void updateCollisions(Vector vector, int n) {
        this.mergeInfo = vector;
        this.currentSelection = n;
        this.numOfFiles = vector.size();
        this.collisionsCanvas.updateCollisionsCanvas(vector, n);
        this.setButtons();
        this.repaint();
        this.pack();
    }

    public void updateCollisions(int n) {
        this.currentSelection = n;
        this.collisionsCanvas.setCurrentSelection(n);
        this.setButtons();
        this.repaint();
    }

    public void addCollisionsListener(CollisionsListener collisionsListener) {
        this.collisionsListener = collisionsListener;
    }

    private void setButtons() {
        if (this.currentSelection == 0) {
            if (this.prevColButton.isEnabled()) {
                this.prevColButton.setEnabled(false);
            }
        } else if (!this.prevColButton.isEnabled()) {
            this.prevColButton.setEnabled(true);
        }
        if (this.currentSelection == this.numOfFiles - 1) {
            if (this.nextColButton.isEnabled()) {
                this.nextColButton.setEnabled(false);
                return;
            }
        } else if (!this.nextColButton.isEnabled()) {
            this.nextColButton.setEnabled(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final /* synthetic */ void access$0() {
        this.setButtons();
    }

    class DialogListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)CollisionsDialog.this).setVisible(false);
            if (CollisionsDialog.this.collisionsListener != null) {
                CollisionsDialog.this.collisionsListener.collisionsWindowClosing();
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            CollisionsDialog.this.collisionsCanvas.requestFocus();
        }

        DialogListener() {
            CollisionsDialog.this = CollisionsDialog.this;
        }
    }

    class KeyboardListener
    extends KeyAdapter {
        KeyboardListener() {
            CollisionsDialog.this = CollisionsDialog.this;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                ((Component)CollisionsDialog.this).setVisible(false);
                if (CollisionsDialog.this.collisionsListener != null) {
                    CollisionsDialog.this.collisionsListener.collisionsWindowClosing();
                    return;
                }
            } else if (keyEvent.getKeyCode() == 78 && CollisionsDialog.this.nextColButton.isEnabled()) {
                ++CollisionsDialog.this.currentSelection;
                CollisionsDialog.this.collisionsCanvas.setCurrentSelection(CollisionsDialog.this.currentSelection);
                CollisionsDialog.this.access$0();
                if (CollisionsDialog.this.collisionsListener != null) {
                    CollisionsDialog.this.collisionsListener.newCollisionChoosen(CollisionsDialog.this.currentSelection);
                    return;
                }
            } else if (keyEvent.getKeyCode() == 80 && CollisionsDialog.this.prevColButton.isEnabled()) {
                --CollisionsDialog.this.currentSelection;
                CollisionsDialog.this.collisionsCanvas.setCurrentSelection(CollisionsDialog.this.currentSelection);
                CollisionsDialog.this.access$0();
                if (CollisionsDialog.this.collisionsListener != null) {
                    CollisionsDialog.this.collisionsListener.newCollisionChoosen(CollisionsDialog.this.currentSelection);
                }
            }
        }
    }

    class ToolbarListener
    extends MouseAdapter {
        String action;

        ToolbarListener(String string) {
            CollisionsDialog.this = CollisionsDialog.this;
            this.action = string;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            CollisionsDialog.this.currentSelection = this.action.equals("nextCol") ? ++CollisionsDialog.this.currentSelection : --CollisionsDialog.this.currentSelection;
            CollisionsDialog.this.collisionsCanvas.setCurrentSelection(CollisionsDialog.this.currentSelection);
            CollisionsDialog.this.access$0();
            if (CollisionsDialog.this.collisionsListener != null) {
                CollisionsDialog.this.collisionsListener.newCollisionChoosen(CollisionsDialog.this.currentSelection);
            }
        }
    }

    class CanvasListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = mouseEvent.getY();
                Dimension dimension = CollisionsDialog.this.collisionsCanvas.getSize();
                int n2 = dimension.height / CollisionsDialog.this.numOfFiles;
                int n3 = n / n2;
                if (CollisionsDialog.this.currentSelection != n3) {
                    CollisionsDialog.this.currentSelection = n3;
                    CollisionsDialog.this.collisionsCanvas.setCurrentSelection(CollisionsDialog.this.currentSelection);
                    CollisionsDialog.this.access$0();
                    if (CollisionsDialog.this.collisionsListener != null) {
                        CollisionsDialog.this.collisionsListener.newCollisionChoosen(CollisionsDialog.this.currentSelection);
                    }
                }
            }
        }

        CanvasListener() {
            CollisionsDialog.this = CollisionsDialog.this;
        }
    }
}

