/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;

public class Chunk
implements Serializable {
    int xstart;
    int xend;
    String xtype = " ";
    boolean xtext = false;
    Vector xdiff;

    Chunk() {
        this.xstart = 0;
        this.xend = 0;
        this.xtype = "e";
        this.xtext = false;
        this.xdiff = null;
    }

    Chunk(Chunk chunk) {
        this.xstart = 0;
        this.xend = 0;
        this.xtype = "e";
        this.xtext = false;
        this.xdiff = null;
    }

    Chunk(int n, int n2, String string, int n3, boolean bl, Vector vector) {
        this.xstart = n;
        this.xend = n2;
        this.xtype = string;
        this.xtext = bl;
        this.xdiff = vector;
    }

    Chunk assign(Chunk chunk) {
        this.xstart = chunk.xstart;
        this.xend = chunk.xend;
        this.xtype = chunk.xtype;
        this.xtext = chunk.xtext;
        this.xdiff = chunk.xdiff;
        return this;
    }

    int getstart() {
        return this.xstart;
    }

    int getend() {
        return this.xend;
    }

    String gettype() {
        return this.xtype;
    }

    boolean gettext() {
        return this.xtext;
    }

    Vector getdiff() {
        return this.xdiff;
    }

    void setText(boolean bl) {
        this.xtext = bl;
    }

    public Chunk setStart(int n) {
        if (n >= 0) {
            this.xstart = n;
        }
        return this;
    }

    public Chunk setEnd(int n) {
        if (n >= 0) {
            this.xend = n;
        }
        return this;
    }

    Chunk setType(String string) {
        this.xtype = string;
        return this;
    }

    void addDiffText(String string) {
        if (this.xdiff == null) {
            this.xdiff = new Vector();
        }
        this.xdiff.addElement(string);
    }

    void clearDiffText() {
        if (this.xdiff != null) {
            this.xdiff.removeAllElements();
        }
    }

    Chunk equaloperator(Chunk chunk) {
        return this.assign(chunk);
    }

    boolean equal(Chunk chunk) {
        return this.xstart == chunk.xstart && this.xend == chunk.xend && this.xtype == chunk.xtype;
    }

    boolean notequal(Chunk chunk) {
        return !this.equal(chunk);
    }

    boolean notequaloperator(Chunk chunk) {
        return this.notequal(chunk);
    }

    void print() {
        System.out.println("--------------");
        System.out.println("Start: " + this.xstart);
        System.out.println("End: " + this.xend);
        System.out.println("Type: " + this.xtype);
        System.out.println("Text: " + this.xtext);
        if (this.xdiff != null && this.xdiff.size() != 0) {
            System.out.println("Diff string: ");
            int n = 0;
            while (n < this.xdiff.size()) {
                System.out.println((String)this.xdiff.elementAt(n++));
            }
        }
        System.out.println("-----------------");
    }

    void print(PrintWriter printWriter) {
        printWriter.println("--------------");
        printWriter.println("Start: " + this.xstart);
        printWriter.println("End: " + this.xend);
        printWriter.println("Type: " + this.xtype);
        printWriter.println("Text: " + this.xtext);
        if (this.xdiff != null && this.xdiff.size() != 0) {
            printWriter.println("Diff string: ");
            int n = 0;
            while (n < this.xdiff.size()) {
                printWriter.println((String)this.xdiff.elementAt(n++));
            }
        }
        printWriter.println("-----------------");
    }
}

