/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.MergeGui;
import com.ibm.vatc.tcmerge.VDragDivider;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class VDragPanel
extends Panel
implements MouseListener,
MouseMotionListener,
ComponentListener {
    private int topDividerPos = MergeGui.INITIAL_TEXTAREA_HEIGHT / 3;
    private int bottomDividerPos = MergeGui.INITIAL_TEXTAREA_HEIGHT * 2 / 3;
    private int previousHeight = MergeGui.INITIAL_TEXTAREA_HEIGHT;
    private boolean topDividerDragged = false;
    private boolean bottomDividerDragged = false;
    private VDragDivider topDivider;
    private VDragDivider bottomDivider;

    public VDragPanel() {
        this.addComponentListener(this);
    }

    public Component add(String string, Component component) {
        if (string.equals("Two")) {
            this.topDivider = new VDragDivider();
            this.topDivider.addMouseListener(this);
            this.topDivider.addMouseMotionListener(this);
            super.add("TopDivider", this.topDivider);
        } else if (string.equals("Three")) {
            this.bottomDivider = new VDragDivider();
            this.bottomDivider.addMouseListener(this);
            this.bottomDivider.addMouseMotionListener(this);
            super.add("BottomDivider", this.bottomDivider);
        }
        return super.add(string, component);
    }

    public int getTopDividerPos() {
        return this.topDividerPos;
    }

    public int getBottomDividerPos() {
        return this.bottomDividerPos;
    }

    public void setTopDividerPos(int n) {
        this.topDividerPos = n;
    }

    public void setBottomDividerPos(int n) {
        this.bottomDividerPos = n;
    }

    public void setPreviousHeight(int n) {
        this.previousHeight = n;
    }

    public void maximizeOne() {
        this.invalidate();
        if (this.getComponentCount() == 5) {
            this.topDividerPos = this.getSize().height - 4;
            this.bottomDividerPos = this.getSize().height - 2;
        } else {
            this.topDividerPos = this.getSize().height - 2;
            this.bottomDividerPos = this.getSize().height - 2;
        }
        this.validate();
    }

    public void maximizeTwo() {
        this.invalidate();
        if (this.getComponentCount() == 5) {
            this.topDividerPos = 2;
            this.bottomDividerPos = this.getSize().height - 2;
        } else {
            this.topDividerPos = 2;
            this.bottomDividerPos = this.getSize().height - 2;
        }
        this.validate();
    }

    public void maximizeThree() {
        if (this.getComponentCount() == 5) {
            this.invalidate();
            this.topDividerPos = 2;
            this.bottomDividerPos = 4;
            this.validate();
        }
    }

    public void resetPanes() {
        this.invalidate();
        int n = this.getSize().height;
        if (this.getComponentCount() == 5) {
            this.topDividerPos = n / 3;
            this.bottomDividerPos = n * 2 / 3;
        } else {
            this.topDividerPos = n / 2;
            this.bottomDividerPos = this.getSize().height;
        }
        this.validate();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Cursor cursor = new Cursor(1);
        this.setCursor(cursor);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.topDividerDragged) {
            this.invalidate();
            Component component = this.getComponent(1);
            this.topDividerPos = mouseEvent.getY() + component.getLocation().y;
            if (this.topDividerPos >= this.bottomDividerPos - 1) {
                this.topDividerPos = this.bottomDividerPos - 2;
            } else if (this.topDividerPos <= 1) {
                this.topDividerPos = 2;
            }
            this.topDividerDragged = false;
            this.validate();
        } else if (this.bottomDividerDragged) {
            this.invalidate();
            Component component = this.getComponent(3);
            this.bottomDividerPos = mouseEvent.getY() + component.getLocation().y;
            if (this.bottomDividerPos >= this.getSize().height - 1) {
                this.bottomDividerPos = this.getSize().height - 2;
            } else if (this.bottomDividerPos <= this.topDividerPos + 1) {
                this.bottomDividerPos = this.topDividerPos + 2;
            }
            this.bottomDividerDragged = false;
            this.validate();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Cursor cursor = new Cursor(12);
        this.setCursor(cursor);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.topDividerDragged && !this.bottomDividerDragged) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        VDragDivider vDragDivider = (VDragDivider)mouseEvent.getSource();
        if (vDragDivider == this.topDivider) {
            this.topDividerDragged = true;
            return;
        }
        this.bottomDividerDragged = true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.invalidate();
        int n = this.getSize().height;
        this.topDividerPos = this.topDividerPos * n / this.previousHeight;
        this.bottomDividerPos = this.bottomDividerPos * n / this.previousHeight;
        this.validate();
        this.previousHeight = n;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

