/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.ToggleButtonUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import com.sun.java.swing.plaf.basic.BasicToggleButtonUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;

public class BasicRadioButtonUI
extends BasicToggleButtonUI
implements Serializable {
    protected static final Insets defaultMargin = new Insets(2, 2, 2, 2);
    protected Icon icon;
    protected static ToggleButtonUI radioButtonUI;
    ButtonModel model;

    public static ComponentUI createUI(JComponent jComponent) {
        if (radioButtonUI == null) {
            radioButtonUI = new BasicRadioButtonUI();
        }
        return radioButtonUI;
    }

    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        this.icon = this.createIcon();
        LookAndFeel.installColorsAndFont(abstractButton, "RadioButton.background", "RadioButton.foreground", "RadioButton.font");
    }

    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.model = abstractButton.getModel();
        Dimension dimension = jComponent.getSize();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle(dimension);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Icon icon = abstractButton.getIcon();
        String string = SwingUtilities.layoutCompoundLabel(fontMetrics, abstractButton.getText(), icon != null ? icon : this.icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, this.getDefaultTextIconGap(abstractButton));
        if (jComponent.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (icon != null) {
            if (!this.model.isEnabled()) {
                icon = abstractButton.getDisabledIcon();
            } else if (this.model.isPressed() && this.model.isArmed()) {
                icon = abstractButton.getPressedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (this.model.isSelected()) {
                icon = abstractButton.getSelectedIcon();
            } else if (abstractButton.isRolloverEnabled() && this.model.isRollover()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        } else {
            this.icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        }
        if (string != null) {
            if (this.model.isEnabled()) {
                graphics.setColor(abstractButton.getForeground());
                BasicGraphicsUtils.drawString(graphics, string, this.model.getMnemonic(), rectangle3.x, rectangle3.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(abstractButton.getBackground().brighter());
                BasicGraphicsUtils.drawString(graphics, string, this.model.getMnemonic(), rectangle3.x + 1, rectangle3.y + fontMetrics.getAscent() + 1);
                graphics.setColor(abstractButton.getBackground().darker());
                BasicGraphicsUtils.drawString(graphics, string, this.model.getMnemonic(), rectangle3.x, rectangle3.y + fontMetrics.getAscent());
            }
            if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && rectangle3.width > 0 && rectangle3.height > 0) {
                this.paintFocus(graphics, rectangle3, dimension);
            }
        }
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
    }

    public Icon createIcon() {
        return UIManager.getIcon("RadioButton.icon");
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        String string = abstractButton.getText();
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.icon;
        }
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getToolkit().getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : this.getDefaultTextIconGap(abstractButton));
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        return rectangle4.getSize();
    }

    public Insets getDefaultMargin(AbstractButton abstractButton) {
        return defaultMargin;
    }
}

