/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.CompositeView;
import com.ibm.vatc.tcmerge.FileOneView;
import com.ibm.vatc.tcmerge.FileTwoView;
import com.ibm.vatc.tcmerge.FileZeroView;
import com.ibm.vatc.tcmerge.MakeViews;
import com.ibm.vatc.tcmerge.MergeGui;
import com.ibm.vatc.tcmerge.Navigate;
import com.ibm.vatc.tcmerge.NavigatorDialog;
import com.ibm.vatc.tcmerge.OutputView;
import com.ibm.vatc.tcmerge.Status;
import com.ibm.vatc.tcmerge.ViewParam;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class MergeGuiKeyListener
extends KeyAdapter {
    private Status status;
    private MergeGui mergeGui;
    private ViewParam viewParam;
    private MakeViews makeViews;
    private FileZeroView fileZeroView;
    private FileOneView fileOneView;
    private FileTwoView fileTwoView;

    MergeGuiKeyListener(MergeGui mergeGui) {
        this.mergeGui = mergeGui;
        this.status = mergeGui.getStatus();
        this.viewParam = mergeGui.getViewParam();
        this.makeViews = mergeGui.getMakeViews();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.status.setMessageFlag(false);
        this.status.repaint();
        switch (keyEvent.getKeyCode()) {
            case 78: {
                if (keyEvent.isAltDown()) {
                    this.mergeGui.navigatorWindow();
                    return;
                }
                Navigate navigate = new Navigate(this.mergeGui);
                navigate.nextDifference();
                return;
            }
            case 80: {
                Navigate navigate = new Navigate(this.mergeGui);
                navigate.previousDifference();
                return;
            }
            case 67: {
                if (keyEvent.isControlDown()) {
                    this.mergeGui.copyToClipboard();
                    return;
                }
                if (!keyEvent.isAltDown()) break;
                this.mergeGui.collisionsWindow();
                return;
            }
            case 86: {
                if (!keyEvent.isControlDown()) break;
                this.mergeGui.pasteFromClipboard();
                return;
            }
            case 76: {
                if (!keyEvent.isAltDown()) break;
                this.mergeGui.legendWindow();
                return;
            }
            case 73: {
                if (!keyEvent.isAltDown()) break;
                this.mergeGui.maximizeInput();
                return;
            }
            case 79: {
                if (!keyEvent.isAltDown()) break;
                this.mergeGui.maximizeOutput();
                return;
            }
            case 82: {
                if (!keyEvent.isAltDown()) break;
                this.mergeGui.resetPanes();
                return;
            }
            case 155: {
                if (keyEvent.isControlDown()) {
                    this.mergeGui.copyToClipboard();
                    return;
                }
                if (!keyEvent.isShiftDown()) break;
                this.mergeGui.pasteFromClipboard();
                return;
            }
            case 49: {
                if (!keyEvent.isControlDown() || !keyEvent.isShiftDown()) break;
                int n = this.viewParam.getCurrentDiff();
                this.makeViews.insertOneDiff(0, n);
                this.mergeGui.getOutputView().repaint();
                this.viewParam.setOutputSaved(false);
                this.mergeGui.setOutputViewTitle();
                NavigatorDialog navigatorDialog = this.mergeGui.getNavigatorDialog();
                if (navigatorDialog == null || !navigatorDialog.isVisible()) break;
                navigatorDialog.updateNavigator();
                return;
            }
            case 50: {
                if (!keyEvent.isControlDown() || !keyEvent.isShiftDown()) break;
                int n = this.viewParam.getCurrentDiff();
                this.makeViews.insertOneDiff(1, n);
                this.mergeGui.getOutputView().repaint();
                this.viewParam.setOutputSaved(false);
                this.mergeGui.setOutputViewTitle();
                NavigatorDialog navigatorDialog = this.mergeGui.getNavigatorDialog();
                if (navigatorDialog == null || !navigatorDialog.isVisible()) break;
                navigatorDialog.updateNavigator();
                return;
            }
            case 51: {
                if (!keyEvent.isControlDown() || !keyEvent.isShiftDown()) break;
                int n = this.viewParam.getCurrentDiff();
                this.makeViews.insertOneDiff(2, n);
                this.mergeGui.getOutputView().repaint();
                this.viewParam.setOutputSaved(false);
                this.mergeGui.setOutputViewTitle();
                NavigatorDialog navigatorDialog = this.mergeGui.getNavigatorDialog();
                if (navigatorDialog == null || !navigatorDialog.isVisible()) break;
                navigatorDialog.updateNavigator();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        CompositeView compositeView = this.mergeGui.getCompositeView();
        OutputView outputView = this.mergeGui.getOutputView();
        this.fileZeroView = this.mergeGui.getFileZeroView();
        this.fileOneView = this.mergeGui.getFileOneView();
        this.fileTwoView = this.mergeGui.getFileTwoView();
        switch (keyEvent.getKeyCode()) {
            case 34: {
                int n;
                if (this.viewParam.getIsCompo()) {
                    n = compositeView.vAdj.getValue();
                    compositeView.vAdj.setValue(n += compositeView.getSize().height);
                    compositeView.repaint();
                } else {
                    n = this.fileZeroView.vAdj.getValue();
                    this.fileZeroView.vAdj.setValue(n += this.fileZeroView.getSize().height);
                    this.fileZeroView.repaint();
                    n = this.fileOneView.vAdj.getValue();
                    this.fileOneView.vAdj.setValue(n += this.fileOneView.getSize().height);
                    this.fileOneView.repaint();
                    n = this.fileTwoView.vAdj.getValue();
                    this.fileTwoView.vAdj.setValue(n += this.fileTwoView.getSize().height);
                    this.fileTwoView.repaint();
                }
                n = outputView.vAdj.getValue();
                outputView.vAdj.setValue(n += outputView.getSize().height);
                outputView.repaint();
                return;
            }
            case 33: {
                int n;
                if (this.viewParam.getIsCompo()) {
                    n = compositeView.vAdj.getValue();
                    if ((n -= compositeView.getSize().height) < 0) {
                        n = 0;
                    }
                    compositeView.vAdj.setValue(n);
                    compositeView.repaint();
                } else {
                    n = this.fileZeroView.vAdj.getValue();
                    if ((n -= this.fileZeroView.getSize().height) < 0) {
                        n = 0;
                    }
                    this.fileZeroView.vAdj.setValue(n);
                    this.fileZeroView.repaint();
                    n = this.fileOneView.vAdj.getValue();
                    if ((n -= this.fileOneView.getSize().height) < 0) {
                        n = 0;
                    }
                    this.fileOneView.vAdj.setValue(n);
                    this.fileOneView.repaint();
                    n = this.fileTwoView.vAdj.getValue();
                    if ((n -= this.fileTwoView.getSize().height) < 0) {
                        n = 0;
                    }
                    this.fileTwoView.vAdj.setValue(n);
                    this.fileTwoView.repaint();
                }
                n = outputView.vAdj.getValue();
                if ((n -= outputView.getSize().height) < 0) {
                    n = 0;
                }
                outputView.vAdj.setValue(n);
                outputView.repaint();
                return;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

