/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.AccessibleAction;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.accessibility.AccessibleValue;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.GrayFilter;
import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.OverlayLayout;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ButtonUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;

public abstract class AbstractButton
extends JComponent
implements ItemSelectable,
SwingConstants {
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String MNEMONIC_CHANGED_PROPERTY = "MnemonicChanged";
    public static final String MARGIN_CHANGED_PROPERTY = "margin";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String VERTICAL_TEXT_POSITION_CHANGED_PROPERTY = "verticalTextPosition";
    public static final String HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY = "horizontalTextPosition";
    public static final String BORDER_PAINTED_CHANGED_PROPERTY = "borderPainted";
    public static final String FOCUS_PAINTED_CHANGED_PROPERTY = "focusPainted";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    public static final String ICON_CHANGED_PROPERTY = "icon";
    public static final String PRESSED_ICON_CHANGED_PROPERTY = "pressedIcon";
    public static final String SELECTED_ICON_CHANGED_PROPERTY = "selectedIcon";
    public static final String ROLLOVER_ICON_CHANGED_PROPERTY = "rolloverIcon";
    public static final String ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY = "rolloverSelectedIcon";
    public static final String DISABLED_ICON_CHANGED_PROPERTY = "disabledIcon";
    public static final String DISABLED_SELECTED_ICON_CHANGED_PROPERTY = "disabledSelectedIcon";
    protected ButtonModel model;
    private String text = "";
    private Insets margin;
    private Icon defaultIcon;
    private Icon pressedIcon;
    private Icon disabledIcon;
    private Icon selectedIcon;
    private Icon disabledSelectedIcon;
    private Icon rolloverIcon;
    private Icon rolloverSelectedIcon;
    private boolean paintBorder = true;
    private boolean paintFocus = true;
    private boolean rolloverEnabled = false;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 0;
    private int verticalTextPosition = 0;
    private int horizontalTextPosition = 4;
    protected ChangeListener changeListener;
    protected ActionListener actionListener;
    protected ItemListener itemListener;
    protected transient ChangeEvent changeEvent;
    static /* synthetic */ Class class$com$sun$java$swing$event$ChangeListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String string2 = string;
        this.text = string;
        this.firePropertyChange(TEXT_CHANGED_PROPERTY, string2, string);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        this.invalidate();
        this.repaint();
    }

    public boolean isSelected() {
        return this.model.isSelected();
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.isSelected();
        if (this.accessibleContext != null && bl2 != bl) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        this.model.setSelected(bl);
    }

    public void doClick() {
        this.doClick(68);
    }

    public void doClick(int n) {
        Dimension dimension = this.getSize();
        this.model.setArmed(true);
        this.model.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, dimension.width, dimension.height));
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {}
        this.model.setPressed(false);
        this.model.setArmed(false);
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange(MARGIN_CHANGED_PROPERTY, insets2, insets);
        this.invalidate();
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return ((ButtonUI)this.ui).getDefaultMargin(this);
        }
        return this.margin;
    }

    public Icon getIcon() {
        return this.defaultIcon;
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.defaultIcon;
        this.defaultIcon = icon;
        this.firePropertyChange(ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        this.invalidate();
        this.repaint();
    }

    public Icon getPressedIcon() {
        return this.pressedIcon;
    }

    public void setPressedIcon(Icon icon) {
        Icon icon2 = this.pressedIcon;
        this.pressedIcon = icon;
        this.firePropertyChange(PRESSED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, this.defaultIcon);
        }
        this.invalidate();
        this.repaint();
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Icon icon) {
        Icon icon2 = this.selectedIcon;
        this.selectedIcon = icon;
        this.firePropertyChange(SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        this.invalidate();
        this.repaint();
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Icon icon) {
        Icon icon2 = this.rolloverIcon;
        this.rolloverIcon = icon;
        this.firePropertyChange(ROLLOVER_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        this.setRolloverEnabled(true);
        this.invalidate();
        this.repaint();
    }

    public Icon getRolloverSelectedIcon() {
        return this.rolloverSelectedIcon;
    }

    public void setRolloverSelectedIcon(Icon icon) {
        Icon icon2 = this.rolloverSelectedIcon;
        this.rolloverSelectedIcon = icon;
        this.firePropertyChange(ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        this.invalidate();
        this.repaint();
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null && this.defaultIcon != null && this.defaultIcon instanceof ImageIcon) {
            this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.defaultIcon).getImage()));
        }
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon icon) {
        Icon icon2 = this.disabledIcon;
        this.disabledIcon = icon;
        this.firePropertyChange(DISABLED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        this.invalidate();
        this.repaint();
    }

    public Icon getDisabledSelectedIcon() {
        if (this.disabledSelectedIcon == null) {
            if (this.selectedIcon != null && this.selectedIcon instanceof ImageIcon) {
                this.disabledSelectedIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.selectedIcon).getImage()));
            } else {
                return this.disabledIcon;
            }
        }
        return this.disabledSelectedIcon;
    }

    public void setDisabledSelectedIcon(Icon icon) {
        Icon icon2 = this.disabledSelectedIcon;
        this.disabledSelectedIcon = icon;
        this.firePropertyChange(DISABLED_SELECTED_ICON_CHANGED_PROPERTY, icon2, icon);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        this.invalidate();
        this.repaint();
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (n == this.verticalAlignment) {
            return;
        }
        int n2 = this.verticalAlignment;
        this.verticalAlignment = this.checkVerticalKey(n, VERTICAL_ALIGNMENT_CHANGED_PROPERTY);
        this.firePropertyChange(VERTICAL_ALIGNMENT_CHANGED_PROPERTY, n2, this.verticalAlignment);
        this.invalidate();
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (n == this.horizontalAlignment) {
            return;
        }
        int n2 = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(n, HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY);
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY, n2, this.horizontalAlignment);
        this.invalidate();
        this.repaint();
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int n) {
        if (n == this.verticalTextPosition) {
            return;
        }
        int n2 = this.verticalTextPosition;
        this.verticalTextPosition = this.checkVerticalKey(n, VERTICAL_TEXT_POSITION_CHANGED_PROPERTY);
        this.firePropertyChange(VERTICAL_TEXT_POSITION_CHANGED_PROPERTY, n2, this.verticalTextPosition);
        this.invalidate();
        this.repaint();
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int n) {
        if (n == this.horizontalTextPosition) {
            return;
        }
        int n2 = this.horizontalTextPosition;
        this.horizontalTextPosition = this.checkHorizontalKey(n, HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY);
        this.firePropertyChange(HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY, n2, this.horizontalTextPosition);
        this.invalidate();
        this.repaint();
    }

    protected int checkHorizontalKey(int n, String string) {
        if (n == 2 || n == 0 || n == 4) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    protected int checkVerticalKey(int n, String string) {
        if (n == 1 || n == 0 || n == 3) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    public void setActionCommand(String string) {
        this.getModel().setActionCommand(string);
    }

    public String getActionCommand() {
        String string = this.getModel().getActionCommand();
        if (string == null) {
            string = this.getText();
        }
        return string;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        boolean bl2 = this.paintBorder;
        this.paintBorder = bl;
        this.firePropertyChange(BORDER_PAINTED_CHANGED_PROPERTY, bl2, this.paintBorder);
        this.invalidate();
        this.repaint();
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public boolean isFocusPainted() {
        return this.paintFocus;
    }

    public void setFocusPainted(boolean bl) {
        boolean bl2 = this.paintFocus;
        this.paintFocus = bl;
        this.firePropertyChange(FOCUS_PAINTED_CHANGED_PROPERTY, bl2, this.paintFocus);
        this.invalidate();
        this.repaint();
    }

    public boolean isRolloverEnabled() {
        return this.rolloverEnabled;
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.rolloverEnabled;
        this.rolloverEnabled = bl;
        this.firePropertyChange(ROLLOVER_ENABLED_CHANGED_PROPERTY, bl2, this.rolloverEnabled);
        this.invalidate();
        this.repaint();
    }

    public int getMnemonic() {
        return this.model.getMnemonic();
    }

    public void setMnemonic(int n) {
        int n2 = this.getMnemonic();
        this.model.setMnemonic(n);
        this.firePropertyChange(MNEMONIC_CHANGED_PROPERTY, n2, n);
        this.invalidate();
        this.repaint();
    }

    public void setMnemonic(char n) {
        int n2 = n;
        if (n2 >= 97 && n2 <= 122) {
            n2 -= 32;
        }
        this.setMnemonic(n2);
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public void setModel(ButtonModel buttonModel) {
        ButtonModel buttonModel2 = this.getModel();
        if (buttonModel2 != null) {
            buttonModel2.removeChangeListener(this.changeListener);
            buttonModel2.removeActionListener(this.actionListener);
            this.changeListener = null;
            this.actionListener = null;
        }
        this.model = buttonModel;
        if (buttonModel != null) {
            this.changeListener = this.createChangeListener();
            this.actionListener = this.createActionListener();
            this.itemListener = this.createItemListener();
            buttonModel.addChangeListener(this.changeListener);
            buttonModel.addActionListener(this.actionListener);
            buttonModel.addItemListener(this.itemListener);
        }
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, buttonModel2, buttonModel);
        this.invalidate();
        this.repaint();
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    public void setUI(ButtonUI buttonUI) {
        super.setUI(buttonUI);
    }

    public void updateUI() {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = JComponent.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = JComponent.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : JComponent.class$("com.sun.java.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JComponent.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JComponent.class$("java.awt.event.ActionListener")), actionListener);
    }

    protected ChangeListener createChangeListener() {
        return new ButtonChangeListener();
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent2 = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : JComponent.class$("java.awt.event.ActionListener"))) {
                if (actionEvent2 == null) {
                    actionEvent2 = new ActionEvent(this, 1001, this.getActionCommand(), actionEvent.getModifiers());
                }
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent2);
            }
            n -= 2;
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ItemEvent itemEvent2 = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : JComponent.class$("java.awt.event.ItemListener"))) {
                if (itemEvent2 == null) {
                    itemEvent2 = new ItemEvent(this, 701, this, itemEvent.getStateChange());
                }
                ((ItemListener)objectArray[n + 1]).itemStateChanged(itemEvent2);
            }
            n -= 2;
        }
    }

    protected ActionListener createActionListener() {
        return new ForwardActionEvents();
    }

    protected ItemListener createItemListener() {
        return new ForwardItemEvents();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.model.setEnabled(bl);
    }

    public String getLabel() {
        return this.getText();
    }

    public void setLabel(String string) {
        this.setText(string);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = JComponent.class$("java.awt.event.ItemListener")), itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = JComponent.class$("java.awt.event.ItemListener")), itemListener);
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    protected void init(String string, Icon icon) {
        this.setLayout(new OverlayLayout(this));
        if (string != null) {
            this.setText(string);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.updateUI();
        this.addFocusListener(new 1());
        this.setAlignmentX(0.0f);
    }

    protected class ButtonChangeListener
    implements ChangeListener,
    Serializable {
        ButtonChangeListener() {
            AbstractButton.this = AbstractButton.this;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractButton.this.fireStateChanged();
            AbstractButton.this.repaint();
        }
    }

    private class ForwardActionEvents
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton.this.fireActionPerformed(actionEvent);
        }

        ForwardActionEvents() {
            AbstractButton.this = AbstractButton.this;
        }
    }

    private class ForwardItemEvents
    implements ItemListener,
    Serializable {
        public void itemStateChanged(ItemEvent itemEvent) {
            AbstractButton.this.fireItemStateChanged(itemEvent);
        }

        ForwardItemEvents() {
            AbstractButton.this = AbstractButton.this;
        }
    }

    private final class 1
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            if (AbstractButton.this.accessibleContext != null) {
                AbstractButton.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (AbstractButton.this.accessibleContext != null) {
                AbstractButton.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
            if (AbstractButton.this.isFocusPainted()) {
                AbstractButton.this.repaint();
            }
        }

        /* synthetic */ 1() {
        }
    }

    protected abstract class AccessibleAbstractButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleValue {
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (AbstractButton.this.getText() == null) {
                return super.getAccessibleName();
            }
            return AbstractButton.this.getText();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (AbstractButton.this.getModel().isArmed()) {
                accessibleStateSet.add(AccessibleState.ARMED);
            }
            if (AbstractButton.this.hasFocus()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (AbstractButton.this.getModel().isPressed()) {
                accessibleStateSet.add(AccessibleState.PRESSED);
            }
            if (AbstractButton.this.isSelected()) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return new String("click");
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            if (n == 0) {
                AbstractButton.this.doClick();
                return true;
            }
            return false;
        }

        public Number getCurrentAccessibleValue() {
            if (AbstractButton.this.isSelected()) {
                return new Integer(1);
            }
            return new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                int n = number.intValue();
                if (n == 0) {
                    AbstractButton.this.setSelected(false);
                } else {
                    AbstractButton.this.setSelected(true);
                }
                return true;
            }
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(1);
        }

        AccessibleAbstractButton() {
            super(AbstractButton.this);
            AbstractButton.this = AbstractButton.this;
        }
    }
}

