#
# COMPONENT_NAME: config.ld
#
# FUNCTIONS:  Contains the Team Connection config.ld definition.
#
# This table is loaded into the database Config table by the server
# tool fhclcnfg.  It is used by Team Connection to determine what
# values may be Used for certain Defect and Feature parameters
# e.g. Defect severity and for configurable fields.  When a
# configurable field is defined, the administrator may specify which,
# if any, Config table type controls the input values.
#
# To change this Config data, the administrator must modify this
# config.ld file and then execute fhclcnfg to reload the database.
#
# A row in config.ld contains the following information with each
# field separated by the | character.
# Lines at the start of the file beginning with the character #,
# or with a whitespace character, are considered comments.
#
# column 1    type    the Configuration type.   For example, rows with
#                     type "answerReturn" specify in the name column
#                     the values which may be used for the answer flag
#                     on the defect -return command.
#
# column 2    name    A value which may be selected for a parameter
#                     controlled by the type.
#
# column 3    dflt    This column may only contain the values "yes" or
#                     "no".  Only one row for a given type may contain
#                     the "yes" value.  If a parameter is required for
#                     an action and it is not specified by the team
#                     connection command, the name from the row with
#                     dflt equal to "yes" will be used.
#
# column 4    kind    This column defines the method of resolving
#                     the configured value.  A kind of 0 is the
#                     original kind of configurable field that is
#                     resolved by matching the (abbreviated) input
#                     value to a unique name value for the type.
#
#                     For a kind of 1, the input may contain a list
#                     of any of the values in the name column separated
#                     by blanks.  No abbreviations may be used.
#
#                     For a kind of 2, the input must match a "regular
#                     expression" defined in the name column.
#
#    The next four columns are used to define dependencies between
#    different parameters.  One parameter for a configurable object
#    (Defect, Feature, etc.) may be defined to be a "driver".  Other
#    parameters may be defined to be "dependent" on the "driver".
#    This is done by using non-zero values in the driver and dependent
#    fields.  The values which may be selected for the "dependent"
#    parameter are restricted by the value selected for the "driver".
#    The values for the driver and dependent fields must be the
#    same for all rows of a given type.  The type with a given non-zero
#    value in the dependent field is dependent on the parameter which
#    has that same value in its driver field.  The name value that is
#    selected for a driver parameter has some number in its driverSeq
#    field.  If the driverSeq is zero, any name values of a dependent
#    parameter may be selected.  If the driverSeq is not zero, then
#    values that may be selected for the dependent parameter must have
#    a dependSeq value that is the same as the driverSeq value or zero.
#
# column 5    driver     This column defines the driver value as
#                        described above.
#
# column 6    driverSeq  This column defines the driverSeq value as
#                        described above.
#
# column 7    dependent  This column defines the dependent value as
#                        described above.
#
# column 8    dependSeq  This column defines the dependSeq value as
#                        described above.
#
# column 9    choiceOrder This column defines the order in which
#                         the choices (names) are displayed by the GUI.
#
# column 10   description A short description of the meaning of the name.
#                         This may not contain any newline character.
#
# column 11   helpText    A long description of the meaning of the name.
#                         This will be displyed by the GUI if help for the
#                         name is requested.  A row in the Config table
#                         with a null value for the name may supply
#                         general help text for the config type.
#                         This may not contain newline characters if the
#                         field is enclosed in quotes.
#                         The preferred (by the GUI) format of helpText is:
#                         "xyz:
#                         This is help for
#                         the name xyz.
#                         "
#
# Refer to examples in this shipped default file for guidance.
#
severity||no|0|0|0|0|0|0||" Severity:
Severity is a measure of how bad the problem is.
"
severity|1|no|0|0|0|0|0|10|Wrong results or failure; critical to program execution|" 1:
Wrong results or failure; critical to program execution.
"
severity|2|no|0|0|0|0|0|20|Wrong results; not critical to program execution|" 2:
Wrong results; not critical to program execution.
"
severity|3|no|0|0|0|0|0|30|Unexpected behavior|" 3:
Unexpected behavior.
"
severity|4|no|0|0|0|0|0|40|Suggestion or enhancement request|" 4:
Suggestion or enhancement request.
"
phase||no|0|0|0|0|0|0||"Phase Found:
From the list, select the calendar phase in progress when the defect was
discovered. (e.g) Design Review, UT, Function Test, etc.  NOTE:   If the
defect was uncovered via a pre-general availability internal or external
customer test program (including, but not limited to, Early Ship Program,
Field Test, and BETA), the phase should reflect the calendar phase in
progress when the defect was uncovered. The phase chosen for APARs should
reflect that fact that the defect surfaced after the product was made
generally available.
"
phase|design|no|0|0|0|0|0|10|Design Phase|"design:
The defect was discovered during the design phase.
"
phase|planning|no|0|0|0|0|0|20|Planning Phase|"planning:
The defect was discovered during the planning phase.
"
phase|strategy|no|0|0|0|0|0|30|Strategic Planning Phase|"strategy:
The defect was discovered during the strategic planning phase.
"
phase|prototyping|no|0|0|0|0|0|40|Prototying Phase|"prototyping:
The defect was discovered during the prototying phase.
"
phase|development|no|0|0|0|0|0|50|Development Phase|"development:
The defect was discovered during the development phase.
"
phase|documenting|no|0|0|0|0|0|60|Documentation or Publication Phase|"documenting:
The defect was discovered during the documentation or publication phase.
"
phase|inspections|no|0|0|0|0|0|70|Inspection Phase|"inspections:
The defect was discovered during the inspection phase.
"
phase|maintenance|no|0|0|0|0|0|80|Maintenance Phase|"maintenance:
The defect was discovered during the maintenance phase.
"
phase|building|no|0|0|0|0|0|90|Building, Compiling or Module Integration Phase|"building:
The defect was discovered during the building, compiling or module
integration phase.
"
phase|unit_test|no|0|0|0|0|0|100|Unit Test|"unit_test:
The defect was discovered during the unit test phase.
"
phase|functional_test|no|0|0|0|0|0|110|Functional Test|"functional_test:
The defect was discovered during the functional test phase.
"
phase|regression_test|no|0|0|0|0|0|120|Regression Test|"regression_test:
The defect was discovered during the regression test phase.
"
phase|install_test|no|0|0|0|0|0|130|Installation Test|"install_test:
The defect was discovered during the installation test phase.
"
phase|config_test|no|0|0|0|0|0|140|Configuration Test|"config_test:
The defect was discovered during the configuration test phase.
"
phase|integrate_test|no|0|0|0|0|0|150|Integration Test|"integrate_test:
The defect was discovered during the integration test phase.
"
phase|quality_test|no|0|0|0|0|0|160|Quality Assurance Test|"quality_test:
The defect was discovered during the quality assurance test phase.
"
phase|usability_test|no|0|0|0|0|0|170|Usability Test|"usability_test:
The defect was discovered during the usability test phase.
"
phase|ship_test|no|0|0|0|0|0|180|Ship Test|"ship_test:
The defect was discovered during the ship test phase.
"
phase|beta_test|no|0|0|0|0|0|190|Beta Test|"beta_test:
The defect was discovered during the beta test phase.
"
phase|n/a|no|0|0|0|0|0|200|Not applicable to any particular phase|"n/a:
When the defect was discovered it did not apply to any particular phase.
"
symptom||no|0|0|0|0|0|0||"Symptom:
An indication of the symptom of the problem.
"
symptom|incorrect_i/o|no|0|0|0|0|0|10|Incorrect or unexpected input or output|"incorrect_i/o:
The symptom of the problem is incorrect or unexpected input or output.
"
symptom|program_defect|no|0|0|0|0|0|20|Program defect|"program_defect:
The symptom of the problem is a program defect.
"
symptom|design_wrong|no|0|0|0|0|0|30|Original design is incorrect; redesign required|"design_wrong:
The symptom of the problem is original design is incorrect and redesign
is required.
"
symptom|function_needed|no|0|0|0|0|0|40|Additional function is required|"function_needed:
A symptom of the problem is additional function is required.
"
symptom|plans_incorrect|no|0|0|0|0|0|50|Plans need to be changed or enhanced|"plans_incorrect:
A symptom of the problem is plans need to be changed or enhanced.
"
symptom|docs_incorrect|no|0|0|0|0|0|60|Documentation is incorrect|"docs_incorrect:
A symptom of the problem is documentation is incorrect.
"
symptom|prog_suspended|no|0|0|0|0|0|70|Program suspended during normal operation|"prog_suspended:
A symptom of the problem is program is suspended during normal operation.
"
symptom|core_dump|no|0|0|0|0|0|80|Core dump occurred during normal operation|"core_dump:
A symptom of the problem is a core dump occurred during normal operation.
"
symptom|lost_data|no|0|0|0|0|0|90|Data loss occurred during normal operation|"lost_data:
A symptom of the problem is data loss occurred during normal operations.
"
symptom|usability|no|0|0|0|0|0|100|Program or application is not usable as is|"usability:
A symptom of the problem is a program or application is not usuable as is.
"
symptom|test_failed|no|0|0|0|0|0|110|Test failed|"test_failed:
A symptom of the problem is a test failed.
"
symptom|build_failed|no|0|0|0|0|0|120|Build, compile, or module integration failed|"build_failed:
A symptom of the problem is a build, compile, or module integration failed.
"
symptom|install_failed|no|0|0|0|0|0|130|Installation failed|"install_failed:
A symptom of the problem is installation failed.
"
symptom|obsolete_code|no|0|0|0|0|0|140|Remove obsolete code|"obsolete_code:
A symptom of the problem is obsolete code.
"
symptom|intgr_problem|no|0|0|0|0|0|150|Integration problems with other applications|"intgr_problem:
A symptom of the problem is integration problems with other applications.
"
symptom|performance|no|0|0|0|0|0|160|Performance problems; code needs to be optimized|"performance:
A symptom of the problem is performance problems and code needs to be
optimized.
"
symptom|reliability|no|0|0|0|0|0|170|Reliability problems; code needs more work|"reliability:
A symptom of the problem is reliability problems; code needs more work.
"
symptom|non-standard|no|0|0|0|0|0|180|Coding practices or program execution is non-standard|"non_standard:
A symptom of the problem is coding practices or program execution is
non-standard.
"
symptom|not_to_spec|no|0|0|0|0|0|190|Program or application does not function as specified|"not_to_spec:
A symptom of the problem is a program or application does not function as
specified.
"
defectPrefix||no|0|0|0|0|0|0||"Prefix:
A prefix indicating the type of defect. The prefix attribute of a defect
or feature can be used to identify a problem as either a defect or a feature
when looking at information regarding both.  Use unique prefixes for defects.
"
defectPrefix|c|no|0|0|0|0|0|10|Defect reported by customer|"c:
The defect was reported by a customer.
"
defectPrefix|d|no|0|0|0|0|0|20|Defect reported by internal users|"d:
The defect was reported by internal users.
"
featurePrefix||no|0|0|0|0|0|0||"Prefix:
A prefix indicating the type of feature. The prefix attribute of a defect
or feature can be used to identify a problem as either a defect or a feature
when looking at information regarding both.  Use unique prefixes for features.
"
featurePrefix|s|no|0|0|0|0|0|10|Suggestion made by customer|"s:
A suggestion was made by a customer.
"
featurePrefix|f|no|0|0|0|0|0|20|Feature requested by internal users|"f:
The feature was requested by an internal user.
"
answerReturn||no|0|0|0|0|0|0||"Answer:
The answer to the defect used by the defect owner when returning the defect
to the originator.
"
answerReturn|fixed|no|0|0|0|0|0|10|The problem is already fixed|"fixed:
The reason the defect is being returned is that the problem is already
fixed.
"
answerReturn|future|no|0|0|0|0|0|20|Future releases or versions will address the defect or feature|"future:
The reason the defect is being returned is that future releases or versions
will address the problem.
"
answerReturn|duplicate|no|0|0|0|0|0|30|This is a duplicate of an existing defect or feature|"duplicate:
The reason the defect is being returned is that this is a duplicate of an
existing defect.
"
answerReturn|usage_error|no|0|0|0|0|0|40|The problem is caused by incorrect usage|"usage_error:
The reason the defect is being returned is that the problem is caused by
incorrect usage.
"
answerReturn|hardware_error|no|0|0|0|0|0|50|The problem is caused by a hardware error|"hardware_error:
The reason the defect is being returned is that the problem is caused by
a hardware error.
"
answerReturn|info_needed|no|0|0|0|0|0|60|More information is required|"info_needed:
The reason the defect is being returned is that more information is
required.
"
answerReturn|limitation|no|0|0|0|0|0|70|The problem is a current limitation|"limitation:
The reason the defect is being returned is that the problem is a current
limitation.
"
answerReturn|suggestion|no|0|0|0|0|0|80|This is a suggestion, not an error|" suggestion:
The reason the defect is being returned is that this is a suggestion, not
an error.
"
answerReturn|unrecreatable|no|0|0|0|0|0|90|The problem cannot be re-created|"unrecreatable:
The reason the defect is being returned is that the problem cannot be
recreated.
"
answerReturn|as_designed|no|0|0|0|0|0|100|The program works as designed|"as_designed:
The reason the defect is being returned is that the program works as
designed.
"
answerReturn|deviation|no|0|0|0|0|0|110|Code or documentation will deviate from the standards|"deviation:
The reason the defect is being returned is that the code or documentation
will deviate from the standards.
"
featureReturn||yes|0|0|0|0|0|0||"Answer:
The answer to the feature used by the feature owner when returning the
feature to the originator.
"
featureReturn|fixed|no|0|0|0|0|0|10|"The feature is already implemented"|"fixed:
The reason the feature is being returned is that the feature is already
implemented.
"
featureReturn|future|no|0|0|0|0|0|20|"Future releases or versions will address the feature"|"future:
The reason the feature is being returned is that future releases or
versions will address the feature.
"
featureReturn|duplicate|no|0|0|0|0|0|30|"This is a duplicate of an existing feature"|"duplicate:
The reason the feature is being returned is that this is a duplicate of
an existing feature.
"
featureReturn|info_needed|no|0|0|0|0|0|40|"More information is required"|"info_needed:
The reason the feature is being returned is that more information is
required.
"
featureReturn|deviation|no|0|0|0|0|0|50|"Code or documentation will deviate from the standards"|"deviation:
The reason the feature is being returned is that code or documentation
will deviate from the standards.
"
answerAccept||no|0|0|0|0|0|0||"Answer:
The answer to the defect used by the defect owner when agreeing to work
on the defect.
"
answerAccept|program_defect|no|0|0|0|0|0|10|The problem was due to a program error|"program_defect:
The reason the defect is being accepted is that the problem was due to
a program error.
"
answerAccept|docs_defect|no|0|0|0|0|0|20|Documentation needs to be changed|"docs_defect:
The reason the defect is being accepted is that the documentation needs
to be changed.
"
answerAccept|docs_change|no|0|0|0|0|0|30|Documentation needs to address new features|"docs_change:
The reason the defect is being accepted is that the documentation needs
to address new features.
"
answerAccept|plans_change|no|0|0|0|0|0|40|Plans or schedules need to be changed|"plans_change:
The reason the defect is being accepted is that plans or schedules need
to be changed.
"
answerAccept|new_function|no|0|0|0|0|0|50|New function will be added|"new_function:
The reason the defect is being accepted is that a new function will be
added.
"
answerAccept|redesign|no|0|0|0|0|0|60|Current function needs to be redesigned|"redesign:
The reason the defect is being accepted is that current function needs
to be redesigned.
"
answerAccept|fix_testcase|no|0|0|0|0|0|70|Testcase needs to be fixed|"fix_testcase:
The reason the defect is being accepted is that a testcase needs to be
fixed.
"
answerAccept|remove_code|no|0|0|0|0|0|80|Obsolete code needs to be removed|"remove_code:
The reason the defect is being accepted is that obsolete code needs to
be removed.
"
answerAccept|remove_support|no|0|0|0|0|0|90|Nonsupported functions need to be removed|"remove_support:
The reason the defect is being accepted is the nonsupported functions
need to be removed.
"
answerAccept|comply_with|no|0|0|0|0|0|100|Coding practices and operation needs to comply with standards|"comply_with:
The reason the defect is being accepted is that coding practices and
operation needs to comply with standards.
"
featureAccept||yes|0|0|0|0|0|0||"Answer:
The answer to the feature used by the feature owner when agreeing to
work on the feature.
"
featureAccept|docs_change|no|0|0|0|0|0|0|"Documentation needs to address new features"|"docs_change:
The reason the feature is being accepted is that documentation needs to
address the new features.
"
featureAccept|new_function|no|0|0|0|0|0|0|"New function will be added"|"new_function:
The reason the feature is being accepted is that new function will be
added.
"
featureAccept|redesign|no|0|0|0|0|0|0|"Current function needs to be redesigned"|"redesign:
The reason the feature is being accepted is that current functions needs
to be redesigned.
"
priority||no|0|0|0|0|0|0||"Priority:
An indication of the timing or scheduling requirements for resolving a
defect.
"
priority|mustfix|no|0|0|0|0|0|10|Defect or feature must be resolved in this release|"mustfix:
The scheduling requirements for resolving this defect is that it must
be resolved in this release.
"
priority|candidate|no|0|0|0|0|0|20|Defect or feature is a candidate if time permits|"candidate:
The scheduling requirements for resolving this defect is that it is
a candidate if time permits.
"
priority|deferred|no|0|0|0|0|0|30|Defect or feature deferred to next release|"deferred:
The scheduling requirements for resolving this defect is that it is
deferred to the next release.
"
priority|easy|no|0|0|0|0|0|40|Defect or feature is easy to solve or implement|"easy:
The scheduling requirements for resolving this defect is that it is
easy to solve or implement.
"
priority|moderate|no|0|0|0|0|0|50|Defect or feature is moderately difficult to resolve|"moderate:
The scheduling requirements for resolving this defect is that it is
moderately difficult to resolve.
"
priority|difficult|no|0|0|0|0|0|60|Defect or feature is difficult to solve or implement|"difficult:
The scheduling requirements for resolving this defect is that it is
difficult to solve or implement.
"
priority|n/a|no|0|0|0|0|0|70|Priority does not apply to this defect or feature|"n/a:
Priority does not apply to this defect.
"
drivertype||no|0|0|0|0|0|0||"drivertype:
Help for type drivertype to be added here.
"
drivertype|development|no|0|0|0|0|0|10|Development driver|"development:
Development driver
"
drivertype|production|no|0|0|0|0|0|20|Production driver|"production:
Production driver
"
drivertype|integration|no|0|0|0|0|0|30|Integration driver|"integration:
Integration driver
"
drivertype|prototype|no|0|0|0|0|0|40|Prototype driver|"prototype:
Prototype driver
"
drivertype|other|no|0|0|0|0|0|50|Other type of driver|"other:
Other type of driver
"
serial||no|2|0|0|0|0|0||"Serial:
A sample of a general expression type, such as a serial number.
Valid entries are:  NULL or 6 numerals.
"
serial|^NULL$|no|2|0|0|0|0|10|"null"|"^NULL$:
Sample of a expression type which requires NULL.
"
serial|^[0-9]\{6\}$|no|2|0|0|0|0|20|"serial = six numerals"|"^[0-9]\{6\}$:
Sample of an expression type which requires 6 numerals.
"
phone||no|2|0|0|0|0|0||"Phone:
Another example of a general expression type, such as phone.
Valid entries are NULL or format TL-PPP-NNNN, where PN are numerals.
"
phone|^NULL$|no|2|0|0|0|0|10|"null"|"^NULL$:
Sample of a general expression which requires NULL.
"
phone|^TL-[0-9]\{3\}-[0-9]\{4\}$|no|2|0|0|0|0|20|"phone format TL-PPP-NNNN, PN numerals"|"^TL-[0-9]\{3\}-[0-9]\{4\}$:
Sample of a general expression for a phone format TL-PPP-NNNN, where PN
are numerals.
"
list||no|1|0|0|0|0|0||"List:
An example of a list type.  More than one can be selected.
"
list|do|no|1|0|0|0|0|10|"Sample list type"|"do:
Example of one of the list items which can be selected.
"
list|re|no|1|0|0|0|0|20|"Sample list type"|"re:
Example of one of the list items which can be selected.
"
list|me|no|1|0|0|0|0|30|"Sample list type"|"me:
Example of one of the list items which can be selected.
"
list|fa|no|1|0|0|0|0|40|"Sample list type"|"fa:
Example of one of the list items which can be selected.
"
list|so|no|1|0|0|0|0|50|"Sample list type"|"so:
Example of one of the list items which can be selected.
"
list|la|no|1|0|0|0|0|60|"Sample list type"|"la:
Example of one of the list items which can be selected.
"
list|ti|no|1|0|0|0|0|70|"Sample list type"|"ti:
Example of one of the list items which can be selected.
"
iteration||no|0|0|0|0|0|0||"Iteration:
Help for type iteration goes here.
"
iteration|base_code|no|0|0|0|0|0|10|"Base Code/Prior Release"|"base_code:
Help for base_code iteration.
"
iteration|01|no|0|0|0|0|0|20|"01"|"01:
Help for 01 iteration.
"
iteration|02|no|0|0|0|0|0|30|"02"|"02:
Help for 02 iteration.
"
iteration|03|no|0|0|0|0|0|40|"03"|"03:
Help for 03 iteration.
"
iteration|04|no|0|0|0|0|0|50|"04"|"04:
Help for 04 iteration.
"
iteration|05|no|0|0|0|0|0|60|"05"|"05:
Help for 05 iteration.
"
iteration|06|no|0|0|0|0|0|70|"06"|"06:
Help for 06 iteration.
"
iteration|07|no|0|0|0|0|0|80|"07"|"07:
Help for 07 iteration.
"
iteration|08|no|0|0|0|0|0|90|"08"|"08:
Help for 08 iteration.
"
iteration|09|no|0|0|0|0|0|100|"09"|"09:
Help for 09 iteration.
"
iteration|10|no|0|0|0|0|0|110|"10"|"10:
Help for 10 iteration.
"
iteration|11|no|0|0|0|0|0|120|"11"|"11:
Help for 11 iteration.
"
iteration|12|no|0|0|0|0|0|130|"12"|"12:
Help for 12 iteration.
"
iteration|13|no|0|0|0|0|0|140|"13"|"13:
Help for 13 iteration.
"
iteration|14|no|0|0|0|0|0|150|"14"|"14:
Help for 14 iteration.
"
iteration|15|no|0|0|0|0|0|160|"15"|"15:
Help for 15 iteration.
"
activityODC||no|0|1|1|0|0|0||"Activity:
From the list, select the activity in progress when the
defect was discovered.  For example, during function test phase, you
might decide to do a code inspection.  In which case, the phase found
would be function test; the activity would be code inspection; and
the inspection triggers would apply.

NOTE - The activity of 'Field' should be chosen for any field
reported defects. This includes those discovered before general
availability during any internal or external customer test program
(including, but not limited to, Early Ship Program, Field Test, and
BETA), or after general availability (via APARs).
"
activityODC|review|no|0|1|1|0|0|10|"Review or inspection"|"review:
The defect was discovered during the review activity.
"
activityODC|ut/ft|no|0|1|2|0|0|20|"Unit Test or Functional Test"|"ut/ft:
The defect was discovered during the unit test or functional test activity.
"
activityODC|st|no|0|1|3|0|0|30|"System Test"|"st:
The defect was discovered during the system test activity.
"
activityODC|id|no|0|1|4|0|0|40|"Information Development"|"id:
The defect was discovered during the information development activity.
"
activityODC|customer|no|0|1|0|0|0|50|"Customer use"|"customer:
The defect was discovered during an internal or external customer test
activity.
"
triggerODC||no|0|0|0|1|1|0||"Trigger:
During Review and Inspection activities, choose the selection which
best describes what you were thinking about when you discovered the defect.
For Field defects, match the description with the environment or condition
which was the catalyst for the failure: design, flow, backward, lateral,
concurrency, document, language, side or rare.

During Unit or Function Test, select the trigger based on strategy or
intent of the test element which forced the defect to surface.  In the case
of field reported defects, select the trigger based on how closely the
description matches what the customer was attempting to execute when the
failure occurred: simple, complex, coverage, variation, sequencing, or
interaction.

During System Test, select the trigger based on strategy or intent of the
test element which forced the defect to surface, or the system environment
which was dominant when the defect surfaced: workload, recover, startup,
hw, sw, or normal.  Choose the Information trigger which best describes
what you were thinking about during documentation reviews. For field
reported defects, use the trigger which best matches the problem description:
accuracy, clarity, completeness, organization, retrievability, style, task
or aesthetics.

For Early Ship Programs, Field Test, BETA Tests, and Field, select the
trigger from the entire list of choices for either code defects or
documentation defects, based on what the customer was actually doing or the
environment or condition that was required in order for the previously
dormant defect to surface. Base your choice on the description of trigger,
not the title. For example, if the customer entered a single command with no
parameters, you would choose Test Coverage, even though the customer was in
production mode, rather than test.
"
triggerODC|design|no|0|0|0|1|1|10|Design Nonconformance|"design:
The document reviewer or the code inspector detects the defect while comparing
the design element or code segment being inspected with its specification in
the preceding stage(s). This would include design documents, code, development
practices and standards, or to ensure design requirements aren't missing or
ambiguous.
"
triggerODC|flow|no|0|0|0|1|1|20|Understanding Flow|"flow:
The inspector uses knowledge of basic programming practices and standards to
examine the flow of logic or data to ensure it is correct and complete.
"
triggerODC|backward|no|0|0|0|1|1|30|Backward Compatibility|"backward:
The inspector uses extensive product/component experience to identify an
incompatibility between the function described by the design document or
the code, and that of earlier versions of the same product or component.
From a field perspective, the customer's application, which ran
successfully on the prior release, fails on the current release.
"
triggerODC|lateral|no|0|0|0|1|1|40|Lateral Compatibility|"lateral:
The inspector with broad-based experience, detects an incompatibility
between the function described by the design document or the code,and the
other systems, products, services, components, or modules with which it
must interface.
"
triggerODC|concurrency|no|0|0|0|1|1|50|Concurrency|"concurrency:
The inspector is considering the serialization necessary for controlling a
shared resource when the defect is discovered. This would include the
serialization of multiple functions, threads, processes, or kernel contexts
as well as obtaining and releasing locks.
"
triggerODC|document|no|0|0|0|1|1|60|Internal Document Consistency/Completeness|"document:
There is incorrect information, inconsistency, or incompleteness within
internal documentation. Prologues and code comments represent some examples
of documentation which would fall under this category.
"
triggerODC|language|no|0|0|0|1|1|70|Language Dependencies|"language:
The developer detects the defect while checking the language specific
details of the implementation of a component or a function. Language
standards, compilation concerns, and language specific efficiencies are
examples of potential areas of concern.
"
triggerODC|side|no|0|0|0|1|1|80|Side Effects|"side:
The inspector uses extensive experience or product knowledge to foresee
some system, product, function, or component behavior which may result
from the design or code under review. The side effects would be
characterized as a result of common usage or configurations, but outside
of the scope of the component or function with which the design or code
under review is associated.
"
triggerODC|rare|no|0|0|0|1|1|90|Rare Situation|"rare:
The inspector uses extensive experience or product knowledge to foresee
some system behavior which is not considered or addressed by the
documented design or code under review, and would typically be associated
with unusual configurations or usage. Missing or incomplete error recovery
would NOT, in general, be classified with a trigger of Rare Situation, but
would most likely fall under Design Conformance if detected during
Review/Inspection.
"
triggerODC|simple|no|0|0|0|1|2|100|Simple Path|"simple:
In White/Gray Box testing, the test case that found the defect was
executing a simple code path related to a single function. This trigger
would not typically be selected for field reported defects, unless the
customer is very knowledgable of the code and design internals, and is
specifically invoking a specific path (as is sometimes the case when the
customer is a business partner or vendor).
"
triggerODC|complex|no|0|0|0|1|2|110|Complex Path|"complex:
In White/Gray Box testing, the test case that found the defect was
executing some contrived combinations of code paths related to multiple
functions. This trigger would only be selected for field reported defects
under the same circumstances as those described under Simple Path.
"
triggerODC|coverage|no|0|0|0|1|2|115|Test Coverage|"coverage:
During Black Box testing, the test case that found the defect was a
straightforward attempt to exercise code for a single function, using no
parameters or a single set of parameters.
"
triggerODC|variation|no|0|0|0|1|2|120|Test Variation|"variation:
During Black Box testing, the test case that found the defect was a
straightforward attempt to exercise code for a single function but using
a variety of inputs and parameters. These might include invalid parameters,
extreme values, boundary conditions, and combinations of parameters.
"
triggerODC|sequencing|no|0|0|0|1|2|130|Test Sequencing|"sequencing:
During Black Box testing, the test case that found the defect executed
multiple functions in a very specific sequence. This trigger is only
chosen when each function executes successfully when run independently,
but fails in this specific sequence. It may also be possible to execute
a different sequence successfully.
"
triggerODC|interaction|no|0|0|0|1|2|140|Test Interaction|"interaction:
During Black Box testing, the test case that found the defect initiated an
interaction among two or more bodies of code. This trigger is only chosen
when each function executes successfully when run independently, but fails
in this specific combination.  The interaction was more involved than a
simple serial sequence of the executions.
"
triggerODC|workload|no|0|0|0|1|3|150|Workload Volume/Stress|"workload:
The system is operating at or near some resource limit, either upper or
lower. These resource limits can be created by means of a variety of
mechanisms, including running small or large loads, running a few or many
products at a time, letting the system run for an extended period of time.
"
triggerODC|recover|no|0|0|0|1|3|160|Recovery/Exception|"recover:
The system is being tested with the intent of invoking an exception
handler or some type of recovery code.  The defect would not have
surfaced if some earlier exception had not caused exception or recovery
processing to be invoked. From a field perspective, this trigger would
be selected if the defect is in the system's or product's ability to
recover from a failure, not the failure itself.
"
triggerODC|startup|no|0|0|0|1|3|170|Startup/Restart|"startup:
The system or subsystem was being initialized or restarted following some
earlier shutdown or complete system or subsystem failure.
"
triggerODC|hw|no|0|0|0|1|3|180|Hardware Configuration|"hw:
The system is being tested to ensure functions execute correctly under
specific hardware configurations.
"
triggerODC|sw|no|0|0|0|1|3|190|Software Configuration|"sw:
The system is being tested to ensure functions execute correctly under
specific software configurations.
"
triggerODC|normal|no|0|0|0|1|3|200|Normal Mode|"normal:
The product is operating well within resource limits and the defect
surfaced without any particular strategy. This trigger would be used when
the System Test scenarios could not be run because there are basic
problems which prevent their execution. This trigger is not typically
used in field reported defects.
"
triggerODC|accuracy|no|0|0|0|1|4|210|Accuracy|"accuracy:
The information does not describe the product correctly; there are factual
errors.
"
triggerODC|clarity|no|0|0|0|1|4|220|Clarity|"clarity:
The information is confusing or difficult to understand.
"
triggerODC|completeness|no|0|0|0|1|4|230|Completeness|"completeness:
Necessary information is missing.
"
triggerODC|organization|no|0|0|0|1|4|240|Organization|"organization:
The relationship between parts or between a part and the whole is not
conveyed.
"
triggerODC|retrievability|no|0|0|0|1|4|250|Retrievability|"retrievability:
The information is difficult to find.
"
triggerODC|style|no|0|0|0|1|4|260|Style|"style:
The manner of expression is inappropriate or difficult to understand.
"
triggerODC|task|no|0|0|0|1|4|270|Task Orientation|"task:
The presentation of why and how to perform a task is inappropriate.
"
triggerODC|aesthetics|no|0|0|0|1|4|280|Graphic Design/Aesthetics|"aesthetics:
The appearance and layout of the information is inappropriate.
"
impactODC||no|0|0|0|1|0|0||"Impact:
Select the impact which you judge the defect would have had upon the
customer if it had escaped to the field. For field reported defects,
select the impact the failure had on the customer.
"
impactODC|installability|no|0|0|0|1|0|10|Installability|"installability:
The ability of the customer to prepare and place the software in
position for use. (Does not include Usability).
"
impactODC|security|no|0|0|0|1|0|20|Integrity/Security|"security:
The protection of systems, programs, and data from inadvertent or
malicious destruction, alteration, or disclosure.
"
impactODC|performance|no|0|0|0|1|0|30|Performance|"performance:
The speed of the software as perceived by the customer and the
customer's end users, in terms of their ability to perform their
tasks.
"
impactODC|maintenance|no|0|0|0|1|0|40|Maintenance|"maintenance:
The ease of applying preventive or corrective fixes to the software.
Example:
The application of maintenance requires a great deal of manual
effort, or is calling for many pre- or corequisite maintenance.
"
impactODC|serviceability|no|0|0|0|1|0|50|Serviceability|"serviceability:
The ability to diagnose failures easily and quickly, with minimal
impact to the customer
"
impactODC|migration|no|0|0|0|1|0|60|Migration|"migration:
The ease of upgrading to a current release, particularly in terms of
the impact on existing customer data and operations.
Examples:
1. Planning for migration is difficult due to inadequate
   documentation.
2. Act of migrating to a new level of a product introduces
   compatability issues with the customer's existing applications.
"
impactODC|documentation|no|0|0|0|1|0|70|Documentation|"documentation:
The degree to which the publication aids provided for understanding the
structure and intended uses of the software are correct and complete.
"
impactODC|usability|no|0|0|0|1|0|80|Usability|"usability:
The degree to which the software and publication aids enable the
product to be easily understood and conveniently employed by its end
user.
"
impactODC|standards|no|0|0|0|1|0|90|Standards|"standards:
The degree to which the software complies with established pertinent
standards.
"
impactODC|reliability|no|0|0|0|1|0|100|Reliability|"reliability:
The ability of the software to consistently perform its intended
function without unplanned interruption.  Severe interruptions, such
as ABEND and WAIT would always be considered reliability.
"
impactODC|requirements|no|0|0|0|1|0|110|Requirements|"requirements:
A customer expectation, with regard to capability, which was
not known, understood, or prioritized as a requirement for the
current product or release.  This value should be chosen during
development for additions to the plan of record.  It should also
be selected, after a product is made generally available, when
customers report that the capability of the function or product
does not meet their expectation.
"
impactODC|capability|no|0|0|0|1|0|120|Capability|"capability:
The ability of the software to perform its intended functions, and
satisfy KNOWN requirements, where the customer is not impacted
in any of the previous categories.
"
targetODC||no|0|2|0|0|0|0||"Defect Target:
Represents the high level identity of the entity that was fixed.
"
targetODC|requirements|no|0|2|1|0|0|10|Requirements|"requirements:
Examples:
-Scope of function must be comparable to competitor
-Must be able to isolate source of failure in an open environment
-Support for new software configuration.
"
targetODC|design|no|0|2|1|0|0|20|Design|"design:
Examples:
-Interface with new DASD not included in design
-Excessive paging will result in Performance impact.
"
targetODC|code|no|0|2|1|0|0|30|Code|"code:
Examples:
-Failure to check for return codes
-Incorrect Assignment.
"
targetODC|build|no|0|2|4|0|0|40|Build/Package/Merge|"build:
Problems encountered during the driver build process, in library systems,
or with management of change or version control.
Examples include:
-Part not defined to build process. Mapping macros required to assemble
 application programs missing from a public library.
-Module compiled using a back-level version of a source code part.
"
targetODC|information|no|0|2|2|0|0|50|Information/User Documentation|"information:
The problem is with the written description contained in user guides,
installation manuals, on-line help, user messages.
Examples include:
-An installation problem is experienced because there was no user
 documentation of the datasets to be allocated before the installation
 was attempted.
"
targetODC|ui|no|0|2|3|0|0|60|User Interface|"ui:
Problems encountered in the implementation of user interface, only from
the presentation perspective and not function.
Examples include:
-The color of the icon is difficult to see
-The window is too large for the screen, requiring constant scrolling.
"
targetODC|nls|no|0|2|4|0|0|70|National Language Support|"nls:
Problems encountered in the implementation of the product functions in
languages other than English.
Examples include:
-Message contains garbage for French only
-Cannot print German specific characters.
"
defTypeODC||no|0|0|0|2|0|0||"Defect Type:
Represents the actual correction that was made.
"
defTypeODC|assignment|no|0|0|0|2|1|10|Assignment/Initialization|"assignment:
Value(s) assigned incorrectly or not assigned at all; but note that a
fix involving multiple assignment corrections may be of type Algorithm.
Examples include:
-Internal variable or variable within a control block did not have
 correct value, or did not have any value at all.
-Initialization of parameters
-Resetting a variable's value
-The instance variable capturing a characteristic of an object (e.g.,
 the color of a car) is omitted.
-The instance variables that capture the state of an object are not
 correctly initialized.
"
defTypeODC|checking|no|0|0|0|2|1|15|Checking|"checking:
Errors caused by missing or incorrect validation of parameters or data
in conditional statements. It might be expected that a consequence of
checking for a value would require additional code such as a do while loop
or branch. If the missing or incorrect check is the critical error,
checking would still be the type chosen.
Examples include:
-Value greater than 100 is not valid, but the check to make sure that the
 value was less than 100 was missing.
-The conditional loop should have stopped on the ninth iteration.  But it
 kept looping while the counter was <= 10.
"
defTypeODC|algorithm|no|0|0|0|2|1|20|Algorithm/Method|"algorithm:
Efficiency or correctness problems that affect the task and can be fixed
by (re)implementing an algorithm or local data structure without the need
for requesting a design change.  Problem in the procedure, template, or
overloaded function that describes a service offered by an object.
Examples include:
-The low-level design called for the use of an algorithm that improves
 throughput over the link by delaying transmission of some messages, but
 the implementation transmitted all messages as soon as they arrived. The
 algorithm that delayed transmission was missing.
-The algorithm for searching a chain of control blocks was corrected to
 use a linear-linked list instead of a circular-linked list.
-The number and/or types of parameters of a method or an operation are
 incorrectly specified.
-A method or an operation is not made public in the specification of a
 class.
"
defTypeODC|function|no|0|0|0|2|1|30|Function/Class/Object|"function:
The error should require a formal design change, as it affects significant
capability, end-user interfaces, product interfaces, interface with
hardware architecture, or global data structure(s); The error occurred
when implementing the state and capabilities of a real or an abstract
entity.
Examples include:
-A database did not include a field for street address, although the
 requirements specified it.
-A database included a field for postal zip code, but it was too small to
 contain international postal codes as specified in the requirements.
-A C++ or SmallTalk class was omitted during system design.
-An object of a given class was not instantiated before being accessed by
 other objects of the system.
"
defTypeODC|timing|no|0|0|0|2|1|40|Timing/Serialization|"timing:
Necessary serialization of shared resource was missing, the wrong resource
was serialized, or the wrong serialization technique was employed.
Examples include:
-Serialization is missing when making updates to a shared control block.
-A hierarchical locking scheme is in use, but the defective code failed
 to acquire the locks in the prescribed sequence.
"
defTypeODC|interface|no|0|0|0|2|1|50|Interface/O-O Messages|"interface:
Communication problem between:
-modules
-components
-device drivers
-objects
via
-macros
-call statements
-control blocks
-parameter lists
Examples:
-A database implements both insertion and deletion functions, but the
 deletion interface was not made callable.
-The interfaces specifies a pointer to a number, but the implementation
 is expecting a pointer to a character.
-The OO-message incorrectly specifies the name of a service.
-The number and/or types of parameters of the OO-message do not conform
 with the signature of the requested service.
"
defTypeODC|relationship|no|0|0|0|2|1|50|Relationship|"relationship:
Problems related to associations among procedures, data structures and
objects. Such associations may be conditional.
Examples include:
-The structure of code/data in one place assumes a certain structure of
 code/data in another. Without appropriate consideration of their
  relationship, program will not execute or execute incorrectly.
-The inheritence relationship between two classes is missing or incorrectly
 specified.
-The limit on the number of objects that may be instantiated from a given
 class is incorrect and causes performance degradation of the system.
"
defTypeODC|editorial|no|0|0|0|2|2|80|Editorial|"editorial:
Defects relates to grammar, spelling, punctuation, organization, etc...
necessary to build the information describing a product.
"
defTypeODC|technical|no|0|0|0|2|2|90|Technical|"technical:
Defects related to the description of a product and its interfaces.
"
defTypeODC|navigational|no|0|0|0|2|2|100|Navigational|"navigational:
Defects that prevent users from finding needed information about a product
including errors in mechanisms used to connect information (i.e. hyperlinks,
 indices, tables of contents, cross references, book shelves, etc...).
"
defTypeODC|GUI|no|0|0|0|2|3|110|Graphical User Interface|"GUI:
Graphical User Interface.
"
defTypeODC|cmdline|no|0|0|0|2|3|120|Command Line Interface|"cmdline:
Command Line Interface.
"
defTypeODC|panels|no|0|0|0|2|3|130|Panels|"panels:
Panels.
"
defTypeODC|na|no|0|0|0|2|4|140|Not Available|"na:
Not Available.
"
qualifierODC||no|0|0|0|0|0|0||"Defect Qualifier:
Indication of whether the defect was an omission, a commission, or
extraneous.
"
qualifierODC|missing|no|0|0|0|0|0|10|Missing|"missing:
The defect was to due to an omission.  For example, an assignment statement
was missing.
"
qualifierODC|incorrect|no|0|0|0|0|0|20|Incorrect|"incorrect:
The defect was to due to a commission.  For example, a checking statement
used the incorrect values.
"
qualifierODC|extraneous|no|0|0|0|0|0|30|Extraneous|"extraneous:
The defect was to due to something not relevant or pertinent to the document
or code.  For example, there is a section of the design document which is
not pertinent and should be removed.
"
sourceODC||no|0|0|0|2|0|0||"Source:
Choose the selection which identifies the source of the code or
information which was fixed.  Applies to all defect Targets.
"
sourceODC|here|no|0|0|0|2|0|10|Developed Here|"here:
A defect is in code which was developed in house.
"
sourceODC|reused|no|0|0|0|2|0|20|Reused|"reused:
A defect is encountered using a part of a standard reuse library.  The
problem could be that the reused part was incorrectly used or that there
is a problem within the reused part itself.
"
sourceODC|outsourced|no|0|0|0|2|0|30|Outsourced|"outsourced:
A defect is in a part provided by a vendor.
"
sourceODC|ported|no|0|0|0|2|0|40|Ported|"ported:
The defect has to do with the use of a part that was validated for a
different environment.
"
sourceODC|reference|no|0|0|0|2|2|50|Reference Information|"reference:
Defect contained in detailed descriptive information such as definitions,
 dictionary entries, glossary items, parameter explanations, etc...
"
sourceODC|tasks|no|0|0|0|2|2|60|Tasks|"tasks:
Defect contained in guidance information that describes the user tasks of
the underlying product.
Examples:
Defect contained in special descriptive information of a detailed nature
showing specific applications of the described product.
"
sourceODC|presentation|no|0|0|0|2|2|70|Presentation|"presentation:
Defect contained in graphical and other elements used to present the
information, such as music, fonts, colors, layout, packaging, tables, etc...
"
sourceODC|concepts|no|0|0|0|2|2|80|Concepts/Decision Support|"concepts:
Defect contained in high level overview and conceptual information
describing important characteristics of the product like functionality or
performance.
"
sourceODC|examples|no|0|0|0|2|2|90|Examples|"examples:
Examples.
"
sourceODC|na|no|0|0|0|2|2|100|Not Available or Not Applicable.|"na:
Not available or not applicable.
"
srcHistoryODC||no|0|0|0|2|0|0||"Source History:
Choose the selection which identifies the history of the code or
information which was fixed.  Applies to all defect Targets.
"
srcHistoryODC|base|no|0|0|0|2|0|10|Base|"base:
The defect is in part of the product which has not been modified by the
current project and is not part of a standard reuse library.  The defect
was not injected by the current project, and was therefore a latent defect.
"
srcHistoryODC|new|no|0|0|0|2|0|20|New|"new:
The defect is in a function which was created by and for the current
project and which introduces new function.
"
srcHistoryODC|rewritten|no|0|0|0|2|0|30|Rewritten|"rewritten:
The defect was introduced as a direct result of redesign and/or rewrite of
old function in an attempt to improve its design or quality.
"
srcHistoryODC|refixed|no|0|0|0|2|0|40|Refixed|"refixed:
The defect was introduced by the solution provided to fix a previous defect.
"
translation||no|0|0|0|0|0|0||"Translation:
An indication of how a part is related to the translation process.
For example, a part might be translated into another language, used
while translating other parts, or completely unrelated to translation.
"
translation|no|yes|0|0|0|0|0|10|Part is not involved in translation|"no:
The part is not involved in translation.
"
translation|yes|no|0|0|0|0|0|20|Part is translated into other languages|"yes:
The part is translated into other languages.
"
translation|related|no|0|0|0|0|0|30|Part is not translated but is related to translation process|"related:
The part is not translated but is related to the translation process.
"
