/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcadmin;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class NoColumnEntry {
    Action oldKeyHandler;
    ActionListener oldPasteHandler;

    private NoColumnEntry(JTextComponent jTextComponent) {
        this.oldKeyHandler = jTextComponent.getKeymap().getDefaultAction();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(86, 2);
        this.oldPasteHandler = jTextComponent.getKeymap().getAction(keyStroke);
        Keymap keymap = JTextComponent.getKeymap("NoColumnKeyMap");
        if (keymap == null) {
            keymap = JTextComponent.addKeymap("NoColumnKeyMap", jTextComponent.getKeymap());
            keymap.setDefaultAction(new UndefinedAction());
            keymap.removeKeyStrokeBinding(keyStroke);
            keymap.addActionForKeyStroke(keyStroke, new NoColumnInsertAction());
        }
        jTextComponent.setKeymap(keymap);
    }

    public static void filter(JTextComponent jTextComponent) {
        new NoColumnEntry(jTextComponent);
    }

    class UndefinedAction
    extends TextAction {
        public UndefinedAction() {
            super("default-typed");
            NoColumnEntry.this = NoColumnEntry.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent.isEditable()) {
                if (actionEvent.getActionCommand().indexOf("|") != -1) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                NoColumnEntry.this.oldKeyHandler.actionPerformed(actionEvent);
            }
        }
    }

    class NoColumnInsertAction
    extends DefaultEditorKit.PasteAction {
        NoColumnInsertAction() {
            NoColumnEntry.this = NoColumnEntry.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Clipboard clipboard;
            Transferable transferable;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent.isEditable() && (transferable = (clipboard = Toolkit.getDefaultToolkit().getSystemClipboard()).getContents(jTextComponent)) != null) {
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (string.indexOf("|") != -1) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    if (NoColumnEntry.this.oldPasteHandler != null) {
                        NoColumnEntry.this.oldPasteHandler.actionPerformed(actionEvent);
                        return;
                    }
                    super.actionPerformed(actionEvent);
                    return;
                }
                catch (Exception exception) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
        }
    }
}

