/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcadmin;

import com.ibm.vatc.tcadmin.stzObject;
import com.ibm.vatc.tcadmin.tblModel;
import com.ibm.vatc.tcadmin.tcadmin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ListResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class fmtModel {
    private ListResourceBundle locResource;
    private File fmtFile;
    private int type;
    private Vector outList;
    private Vector columns;
    private Vector widths;
    private Vector formats;
    private Vector stzList;
    private Vector DefaultDefects;
    private Vector DefaultFeatures;
    private Vector DefaultUsers;
    private Vector DefaultParts;
    private Vector DefaultReleases;
    private Vector DefaultWorkareas;
    private tblModel table;
    private boolean IsWriteable = false;
    private boolean needsRead = true;
    private boolean needsInit = true;
    private Vector NLSDefects;
    private Vector NLSFeatures;
    private Vector NLSUsers;
    private Vector NLSParts;
    private Vector NLSReleases;
    private Vector NLSWorkareas;
    static final String[] StringDefects = new String[]{"prefix", "name", "compName", "releaseName", "ownerLogin", "state", "answer", "severity", "abstract", "age", "envName", "driverName", "duplicate", "lastUpdate", "addDate", "assignDate", "responseDate", "endDate", "ownerName", "ownerArea", "reference", "originLogin", "originName", "originArea"};
    static final String[] StringFeatures = new String[]{"prefix", "name", "compName", "ownerLogin", "ownerName", "state", "abstract", "age", "duplicate", "lastUpdate", "addDate", "assignDate", "responseDate", "endDate", "ownerArea", "reference", "originLogin", "originName", "originArea", "releaseName", "answer"};
    static final String[] StringParts = new String[]{"basename", "releaseName", "compName", "committedVersion", "addDate", "dropDate", "lastUpdate", "pathName", "currentVersion", "nuAddDate", "nuDropDate", "nuPathName", "userLogin", "fmode", "fileType", "changeType", "workAreaName", "partType", "temporary", "builderName", "parserName", "parentName", "hasChildren", "buildStatus", "typeOfRelation", "parameters", "workAreaChange", "translation", "transState", "restricted"};
    static final String[] StringUsers = new String[]{"login", "name", "area", "address", "addDate", "dropDate", "lastUpdate", "superUser"};
    static final String[] StringReleases = new String[]{"name", "compName", "relProcess", "userLogin", "userName", "userArea", "addDate", "dropDate", "lastUpdate", "description", "track", "approve", "fix", "lvl", "test", "developmentMode", "autoPrune", "outputVersions", "dbName"};
    static final String[] StringWorkareas = new String[]{"name", "releaseName", "defectName", "defectReference", "state", "target", "addDate", "userLogin", "userName", "userArea", "actual", "lastUpdate", "defectPrefix", "defectAbstract", "defectType", "branchPoint"};
    static final String[] NLSStringDefects = new String[]{"STR_DEFECT_PREFIX", "STR_DEFECT_NAME", "STR_DEFECT_COMPNAME", "STR_DEFECT_RELNAME", "STR_DEFECT_OWNERLOGIN", "STR_DEFECT_STATE", "STR_DEFECT_ANSWER", "STR_DEFECT_SEVERITY", "STR_DEFECT_ABSTRACT", "STR_DEFECT_AGE", "STR_DEFECT_ENVNAME", "STR_DEFECT_DRIVERNAME", "STR_DEFECT_DUPLICATE", "STR_DEFECT_LASTUPDATE", "STR_DEFECT_ADDDATE", "STR_DEFECT_ASSIGNDATE", "STR_DEFECT_RESPONSEDATE", "STR_DEFECT_ENDDATE", "STR_DEFECT_OWNERNAME", "STR_DEFECT_OWNERAREA", "STR_DEFECT_REFERENCE", "STR_DEFECT_ORIGINLOGIN", "STR_DEFECT_ORIGINNAME", "STR_DEFECT_ORIGINAREA"};
    static final String[] NLSStringFeatures = new String[]{"STR_FEATURE_PREFIX", "STR_FEATURE_NAME", "STR_FEATURE_COMPNAME", "STR_FEATURE_OWNERLOGIN", "STR_FEATURE_OWNERNAME", "STR_FEATURE_STATE", "STR_FEATURE_ABSTRACT", "STR_FEATURE_AGE", "STR_FEATURE_DUPLICATE", "STR_FEATURE_LASTUPDATE", "STR_FEATURE_ADDDATE", "STR_FEATURE_ASSIGNDATE", "STR_FEATURE_RESPONSEDATE", "STR_FEATURE_ENDDATE", "STR_FEATURE_OWNERAREA", "STR_FEATURE_REFERENCE", "STR_FEATURE_ORIGINLOGIN", "STR_FEATURE_ORIGINNAME", "STR_FEATURE_ORIGINAREA", "STR_FEATURE_RELNAME", "STR_FEATURE_ANSWER"};
    static final String[] NLSStringParts = new String[]{"STR_PART_BASENAME", "STR_PART_RELEASENAME", "STR_PART_COMPNAME", "STR_PART_COMMITTEDVERSION", "STR_PART_ADDDATE", "STR_PART_DROPDATE", "STR_PART_LASTUPDATE", "STR_PART_PATHNAME", "STR_PART_CURRENTVERSION", "STR_PART_NUADDDATE", "STR_PART_NUDROPDATE", "STR_PART_NUPATHNAME", "STR_PART_USERLOGIN", "STR_PART_FMODE", "STR_PART_FILETYPE", "STR_PART_CHANGETYPE", "STR_PART_WORKAREANAME", "STR_PART_PARTTYPE", "STR_PART_TEMPORARY", "STR_PART_BUILDERNAME", "STR_PART_PARSERNAME", "STR_PART_PARENTNAME", "STR_PART_HASCHILDREN", "STR_PART_BUILDSTATUS", "STR_PART_TYPEOFRELATION", "STR_PART_PARAMETERS", "STR_PART_WORKAREACHANGE", "STR_PART_TRANSLATION", "STR_PART_TRANSSTATE", "STR_PART_RESTRICTED"};
    static final String[] NLSStringUsers = new String[]{"STR_USER_LOGIN", "STR_USER_NAME", "STR_USER_AREA", "STR_USER_ADDRESS", "STR_USER_ADDDATE", "STR_USER_DROPDATE", "STR_USER_LASTUPDATE", "STR_USER_SUPERUSER"};
    static final String[] NLSStringReleases = new String[]{"STR_RELEASE_NAME", "STR_RELEASE_COMPNAME", "STR_RELEASE_RELPROCESS", "STR_RELEASE_USERLOGIN", "STR_RELEASE_USERNAME", "STR_RELEASE_USERAREA", "STR_RELEASE_ADDDATE", "STR_RELEASE_DROPDATE", "STR_RELEASE_LASTUPDATE", "STR_RELEASE_DESCRIPTION", "STR_RELEASE_TRACK", "STR_RELEASE_APPROVE", "STR_RELEASE_FIX", "STR_RELEASE_LVL", "STR_RELEASE_TEST", "STR_RELEASE_DEVELOPMENTMODE", "STR_RELEASE_AUTOPRUNE", "STR_RELEASE_OUTPUTVERSIONS", "STR_RELEASE_DBNAME"};
    static final String[] NLSStringWorkareas = new String[]{"STR_WORKAREA_NAME", "STR_WORKAREA_RELEASENAME", "STR_WORKAREA_DEFECTNAME", "STR_WORKAREA_DEFECTREFERENCE", "STR_WORKAREA_STATE", "STR_WORKAREA_TARGET", "STR_WORKAREA_ADDDATE", "STR_WORKAREA_USERLOGIN", "STR_WORKAREA_USERNAME", "STR_WORKAREA_USERAREA", "STR_WORKAREA_ACTUAL", "STR_WORKAREA_LASTUPDATE", "STR_WORKAREA_DEFECTPREFIX", "STR_WORKAREA_DEFECTABSTRACT", "STR_WORKAREA_DEFECTTYPE", "STR_WORKAREA_BRANCHPOINT"};

    public fmtModel(File file, tblModel tblModel2, int n) {
        this.fmtFile = file;
        this.locResource = tcadmin.locResource;
        this.type = n;
        this.table = tblModel2;
    }

    public fmtModel(tblModel tblModel2, int n) {
        this.locResource = tcadmin.locResource;
        this.type = n;
        this.table = tblModel2;
        this.needsRead = false;
    }

    public void insertNLS(int n, String string) {
        if (this.type == 0) {
            this.NLSDefects.insertElementAt(string, n);
        }
        if (this.type == 1) {
            this.NLSFeatures.insertElementAt(string, n);
        }
        if (this.type == 2) {
            this.NLSParts.insertElementAt(string, n);
        }
        if (this.type == 4) {
            this.NLSUsers.insertElementAt(string, n);
        }
        if (this.type == 3) {
            this.NLSReleases.insertElementAt(string, n);
        }
        if (this.type == 5) {
            this.NLSWorkareas.insertElementAt(string, n);
        }
    }

    public void setNLS(int n, String string) {
        if (this.type == 0) {
            this.NLSDefects.setElementAt(string, n);
        }
        if (this.type == 1) {
            this.NLSFeatures.setElementAt(string, n);
        }
        if (this.type == 2) {
            this.NLSParts.setElementAt(string, n);
        }
        if (this.type == 4) {
            this.NLSUsers.setElementAt(string, n);
        }
        if (this.type == 3) {
            this.NLSReleases.setElementAt(string, n);
        }
        if (this.type == 5) {
            this.NLSWorkareas.setElementAt(string, n);
        }
    }

    public void removeNLS(int n) {
        if (this.type == 0) {
            this.NLSDefects.removeElementAt(n);
        }
        if (this.type == 1) {
            this.NLSFeatures.removeElementAt(n);
        }
        if (this.type == 2) {
            this.NLSParts.removeElementAt(n);
        }
        if (this.type == 4) {
            this.NLSUsers.removeElementAt(n);
        }
        if (this.type == 3) {
            this.NLSReleases.removeElementAt(n);
        }
        if (this.type == 5) {
            this.NLSWorkareas.removeElementAt(n);
        }
    }

    public void insertDefault(int n, String string) {
        if (this.type == 0) {
            this.DefaultDefects.insertElementAt(string, n);
        }
        if (this.type == 1) {
            this.DefaultFeatures.insertElementAt(string, n);
        }
        if (this.type == 2) {
            this.DefaultParts.insertElementAt(string, n);
        }
        if (this.type == 4) {
            this.DefaultUsers.insertElementAt(string, n);
        }
        if (this.type == 3) {
            this.DefaultReleases.insertElementAt(string, n);
        }
        if (this.type == 5) {
            this.DefaultWorkareas.insertElementAt(string, n);
        }
    }

    public void setDefault(int n, String string) {
        if (this.type == 0) {
            this.DefaultDefects.setElementAt(string, n);
        }
        if (this.type == 1) {
            this.DefaultFeatures.setElementAt(string, n);
        }
        if (this.type == 2) {
            this.DefaultParts.setElementAt(string, n);
        }
        if (this.type == 4) {
            this.DefaultUsers.setElementAt(string, n);
        }
        if (this.type == 3) {
            this.DefaultReleases.setElementAt(string, n);
        }
        if (this.type == 5) {
            this.DefaultWorkareas.setElementAt(string, n);
        }
    }

    public void removeDefault(int n) {
        if (this.type == 0) {
            this.DefaultDefects.removeElementAt(n);
        }
        if (this.type == 1) {
            this.DefaultFeatures.removeElementAt(n);
        }
        if (this.type == 2) {
            this.DefaultParts.removeElementAt(n);
        }
        if (this.type == 4) {
            this.DefaultUsers.removeElementAt(n);
        }
        if (this.type == 3) {
            this.DefaultReleases.removeElementAt(n);
        }
        if (this.type == 5) {
            this.DefaultWorkareas.removeElementAt(n);
        }
    }

    public String getDefaults(Integer n) {
        return this.getDefaults((int)n);
    }

    public String getDefaults(int n) {
        if (n < 0 || n > this.getDefaultsLength()) {
            return null;
        }
        if (this.type == 0) {
            return (String)this.DefaultDefects.elementAt(n);
        }
        if (this.type == 1) {
            return (String)this.DefaultFeatures.elementAt(n);
        }
        if (this.type == 2) {
            return (String)this.DefaultParts.elementAt(n);
        }
        if (this.type == 4) {
            return (String)this.DefaultUsers.elementAt(n);
        }
        if (this.type == 3) {
            return (String)this.DefaultReleases.elementAt(n);
        }
        if (this.type == 5) {
            return (String)this.DefaultWorkareas.elementAt(n);
        }
        return null;
    }

    public String getNLSDefaults(Integer n) {
        return this.getNLSDefaults((int)n);
    }

    public String getNLSDefaults(int n) {
        if (n < 0 || n > this.getNLSDefaultsLength()) {
            return null;
        }
        if (this.type == 0) {
            return (String)this.NLSDefects.elementAt(n);
        }
        if (this.type == 1) {
            return (String)this.NLSFeatures.elementAt(n);
        }
        if (this.type == 2) {
            return (String)this.NLSParts.elementAt(n);
        }
        if (this.type == 4) {
            return (String)this.NLSUsers.elementAt(n);
        }
        if (this.type == 3) {
            return (String)this.NLSReleases.elementAt(n);
        }
        if (this.type == 5) {
            return (String)this.NLSWorkareas.elementAt(n);
        }
        return null;
    }

    public int getStringDefaultsLength() {
        if (this.type == 0) {
            return StringDefects.length;
        }
        if (this.type == 1) {
            return StringFeatures.length;
        }
        if (this.type == 2) {
            return StringParts.length;
        }
        if (this.type == 4) {
            return StringUsers.length;
        }
        if (this.type == 3) {
            return StringReleases.length;
        }
        if (this.type == 5) {
            return StringWorkareas.length;
        }
        return 0;
    }

    public int getNLSDefaultsLength() {
        if (this.type == 0) {
            return this.NLSDefects.size();
        }
        if (this.type == 1) {
            return this.NLSFeatures.size();
        }
        if (this.type == 2) {
            return this.NLSParts.size();
        }
        if (this.type == 4) {
            return this.NLSUsers.size();
        }
        if (this.type == 3) {
            return this.NLSReleases.size();
        }
        if (this.type == 5) {
            return this.NLSWorkareas.size();
        }
        return 0;
    }

    public int getDefaultsLength() {
        if (this.type == 0) {
            return this.DefaultDefects.size();
        }
        if (this.type == 1) {
            return this.DefaultFeatures.size();
        }
        if (this.type == 2) {
            return this.DefaultParts.size();
        }
        if (this.type == 4) {
            return this.DefaultUsers.size();
        }
        if (this.type == 3) {
            return this.DefaultReleases.size();
        }
        if (this.type == 5) {
            return this.DefaultWorkareas.size();
        }
        return 0;
    }

    public int getIndexOfNLS(String string) {
        int n = 1;
        while (n < this.getNLSDefaultsLength()) {
            if (this.getNLSDefaults(n).equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getIndexOf(String string) {
        int n = 1;
        while (n < this.getDefaultsLength()) {
            if (this.getDefaults(n).equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void cloneDefaults(fmtModel fmtModel2) {
        if (this.type == 0) {
            this.DefaultDefects = (Vector)fmtModel2.DefaultDefects.clone();
        }
        if (this.type == 1) {
            this.DefaultFeatures = (Vector)fmtModel2.DefaultFeatures.clone();
        }
        if (this.type == 2) {
            this.DefaultParts = (Vector)fmtModel2.DefaultParts.clone();
        }
        if (this.type == 4) {
            this.DefaultUsers = (Vector)fmtModel2.DefaultUsers.clone();
        }
        if (this.type == 3) {
            this.DefaultReleases = (Vector)fmtModel2.DefaultReleases.clone();
        }
        if (this.type == 5) {
            this.DefaultWorkareas = (Vector)fmtModel2.DefaultWorkareas.clone();
        }
    }

    public tblModel getTable() {
        return this.table;
    }

    public int getType() {
        return this.type;
    }

    public void renameConfigField(String string, String string2) {
        int n = this.getIndexOf(string);
        this.setDefault(n, string2);
    }

    public void renameNLSConfigField(String string, String string2) {
        int n = this.getIndexOfNLS(string);
        this.setNLS(n, string2);
    }

    public void addConfigField(int n, String string, int n2) {
        int n3 = this.getStringDefaultsLength() + n + 1;
        this.insertDefault(n3, string);
        this.outList.addElement(new Integer(n3));
        this.formats.insertElementAt(new String("s"), n3);
        this.widths.insertElementAt(new Integer(n2), n3);
    }

    public void addNLSConfigField(int n, String string, int n2) {
        int n3 = this.getStringDefaultsLength() + n + 1;
        this.insertNLS(n3, string);
    }

    public void deleteConfigField(String string) {
        int n = this.getIndexOf(string);
        Integer n2 = new Integer(n);
        this.columns.removeElement(n2);
        this.outList.removeElement(n2);
        this.removeDefault(n);
    }

    public void deleteNLSConfigField(String string) {
        int n = this.getIndexOfNLS(string);
        new Integer(n);
        this.removeNLS(n);
    }

    public int getStanzaElements() {
        return this.stzList.size();
    }

    public String[] getStanzaRow(int n) {
        String[] stringArray = new String[4];
        stringArray[0] = ((stzObject)this.stzList.elementAt(n)).getCol1();
        String string = ((stzObject)this.stzList.elementAt(n)).getValue1();
        stringArray[1] = string == null ? string : this.getDefaults(Integer.parseInt(string));
        stringArray[2] = ((stzObject)this.stzList.elementAt(n)).getCol2();
        string = ((stzObject)this.stzList.elementAt(n)).getValue2();
        stringArray[3] = string == null ? string : this.getDefaults(Integer.parseInt(string));
        return stringArray;
    }

    public String getStanzaType(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (string != null) {
            int n = 0;
            while (n < this.stzList.size()) {
                string2 = ((stzObject)this.stzList.elementAt(n)).getValue1();
                if (string2 != null && string.equals(string4 = this.getDefaults(Integer.parseInt(string2)))) {
                    return ((stzObject)this.stzList.elementAt(n)).getType1();
                }
                string3 = ((stzObject)this.stzList.elementAt(n)).getValue2();
                if (string3 != null && string.equals(string5 = this.getDefaults(Integer.parseInt(string3)))) {
                    return ((stzObject)this.stzList.elementAt(n)).getType2();
                }
                ++n;
            }
        }
        return new String("s");
    }

    public Vector getWidths() {
        return this.widths;
    }

    public void setStzCol1(String string, int n) {
        if (string == null || string.length() < 1) {
            ((stzObject)this.stzList.elementAt(n)).setCol1(null);
            return;
        }
        ((stzObject)this.stzList.elementAt(n)).setCol1(string);
    }

    public void setStzCol2(String string, int n) {
        if (string == null || string.length() < 1) {
            ((stzObject)this.stzList.elementAt(n)).setCol2(null);
            return;
        }
        ((stzObject)this.stzList.elementAt(n)).setCol2(string);
    }

    public void setStzValue1(String string, int n) {
        if (string == null) {
            stzObject stzObject2 = (stzObject)this.stzList.elementAt(n);
            stzObject2.setValue1(null);
            stzObject2.setType1("s");
            return;
        }
        ((stzObject)this.stzList.elementAt(n)).setValue1(Integer.toString(this.getIndexOf(string)));
    }

    public void setStzValue2(String string, int n) {
        if (string == null) {
            stzObject stzObject2 = (stzObject)this.stzList.elementAt(n);
            stzObject2.setValue2(null);
            stzObject2.setType2("s");
            return;
        }
        ((stzObject)this.stzList.elementAt(n)).setValue2(Integer.toString(this.getIndexOf(string)));
    }

    public void removeStzObject(int n) {
        this.stzList.removeElementAt(n);
    }

    public void moveValue(int n, int n2) {
        stzObject stzObject2 = (stzObject)this.stzList.elementAt(n + n2);
        this.stzList.setElementAt(this.stzList.elementAt(n), n + n2);
        this.stzList.setElementAt(stzObject2, n);
    }

    public void addEmptyStzObject(int n) {
        this.stzList.insertElementAt(new stzObject(null, null, null, null), n);
    }

    public void setTableWidth(String string, int n) {
        Integer n2 = new Integer(this.getIndexOfNLS(string));
        this.widths.setElementAt(new Integer(n), n2);
    }

    public int getTableElements() {
        return this.columns.size();
    }

    public int getHiddenElements() {
        return this.outList.size();
    }

    public String getColumns(int n) {
        if (this.columns.size() == 0) {
            return null;
        }
        return this.getNLSDefaults((Integer)this.columns.elementAt(n));
    }

    public Vector getColumns() {
        return this.columns;
    }

    public String getHiddenColumns(int n) {
        return this.getNLSDefaults((Integer)this.outList.elementAt(n));
    }

    public Vector getOutList() {
        return this.outList;
    }

    public void addTableColumn(String string, int n, int n2) {
        Integer n3 = new Integer(this.getIndexOfNLS(string));
        this.columns.setElementAt(n3, n);
        this.outList.removeElementAt(n2);
    }

    public void removeTableColumn(String string, int n, int n2) {
        Integer n3 = new Integer(this.getIndexOfNLS(string));
        this.outList.setElementAt(n3, n2);
        this.columns.removeElementAt(n);
    }

    public void addStzObject(Object[] objectArray, fmtModel fmtModel2) {
        Object object;
        String[] stringArray = new String[4];
        if (objectArray == null) {
            stringArray[0] = null;
            stringArray[1] = null;
            stringArray[2] = null;
            stringArray[3] = null;
        } else {
            object = (String)objectArray[0];
            stringArray[0] = object == null ? null : (((String)object).equals("") ? null : object);
            stringArray[1] = (String)objectArray[1];
            object = (String)objectArray[2];
            stringArray[2] = object == null ? null : (((String)object).equals("") ? null : object);
            stringArray[3] = (String)objectArray[3];
        }
        object = new stzObject(stringArray[0], Integer.toString(this.getIndexOf(stringArray[1])), stringArray[2], Integer.toString(this.getIndexOf(stringArray[3])));
        ((stzObject)object).setType1(fmtModel2.getStanzaType(stringArray[1]));
        ((stzObject)object).setType2(fmtModel2.getStanzaType(stringArray[3]));
        this.stzList.addElement(object);
    }

    public void addStzObject(String string) {
        int n;
        String string2;
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = stringTokenizer.countTokens();
        if (n2 == 0) {
            this.stzList.addElement(new stzObject(null, null, null, null));
        }
        if (n2 == 2) {
            string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            int n3 = string2.indexOf(37) + 1;
            int n4 = string2.indexOf(36);
            String string4 = string2.substring(n3, n4);
            int n5 = -1;
            String string5 = null;
            if (string2.charAt(++n4) == '-') {
                n = string2.lastIndexOf(46);
                n5 = Integer.parseInt(string2.substring(++n4, n));
            }
            if (!string2.endsWith("s")) {
                string5 = new String(string2.substring(n4));
            }
            stzObject stzObject2 = new stzObject(string3, string4, null, null);
            if (string5 != null) {
                stzObject2.setType1(string5);
            }
            this.stzList.addElement(stzObject2);
        }
        if (n2 == 4) {
            string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            int n6 = string2.indexOf(37) + 1;
            n = string2.indexOf(36);
            String string6 = string2.substring(n6, n);
            int n7 = -1;
            String string7 = null;
            if (string2.charAt(++n) == '-') {
                int n8 = string2.lastIndexOf(46);
                n7 = Integer.parseInt(string2.substring(++n, n8));
            }
            if (!string2.endsWith("s")) {
                string7 = new String(string2.substring(n));
            }
            String string8 = stringTokenizer.nextToken();
            String string9 = stringTokenizer.nextToken();
            n6 = string9.indexOf(37) + 1;
            n = string9.indexOf(36);
            String string10 = string9.substring(n6, n);
            int n9 = -1;
            String string11 = null;
            if (string9.charAt(++n) == '-') {
                int n10 = string9.lastIndexOf(46);
                n9 = Integer.parseInt(string9.substring(++n, n10));
            }
            if (!string9.endsWith("s")) {
                string11 = new String(string9.substring(n));
            }
            stzObject stzObject3 = new stzObject(string3, string6, string8, string10);
            if (string7 != null) {
                stzObject3.setType1(string7);
            }
            if (string11 != null) {
                stzObject3.setType2(string11);
            }
            this.stzList.addElement(stzObject3);
        }
    }

    public void parseColumns(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.countTokens() > 0) {
            Integer n = new Integer(this.getIndexOf(stringTokenizer.nextToken()));
            this.columns.addElement(n);
            this.outList.removeElement(n);
        }
    }

    public void parseWidths(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        while (stringTokenizer.countTokens() > 0) {
            String string2 = stringTokenizer.nextToken();
            this.widths.setElementAt(new Integer(string2.length()), (Integer)this.columns.elementAt(n));
            ++n;
        }
    }

    public void parseFormats(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.countTokens() > 0) {
            String string3 = stringTokenizer.nextToken();
            n2 = string3.indexOf(37) + 1;
            n = string3.indexOf(36);
            string2 = string3.substring(n2, n);
            n3 = Integer.parseInt(string2);
            if (!string3.endsWith("ld")) continue;
            this.formats.setElementAt(new String("ld"), n3);
        }
    }

    public void moveColumn(int n, int n2) {
        Object e = this.columns.elementAt(n);
        this.columns.removeElementAt(n);
        this.columns.insertElementAt(e, n2);
    }

    public void addColumn(String string) {
        Integer n = new Integer(this.getIndexOfNLS(string));
        this.columns.addElement(n);
        this.outList.removeElement(n);
    }

    public void removeColumn(String string) {
        Integer n = new Integer(this.getIndexOfNLS(string));
        this.columns.removeElement(n);
        this.outList.addElement(n);
    }

    public void addColumn(String string, int n) {
        Integer n2 = new Integer(this.getIndexOfNLS(string));
        this.columns.insertElementAt(n2, n);
        this.outList.removeElement(n2);
    }

    public void removeColumn(String string, int n) {
        Integer n2 = new Integer(this.getIndexOfNLS(string));
        this.columns.removeElement(n2);
        this.outList.insertElementAt(n2, n);
    }

    public void setWriteable(boolean bl) {
        this.IsWriteable = bl;
    }

    public boolean getWriteable() {
        return this.IsWriteable;
    }

    public void setNeedsRead(boolean bl) {
        this.needsRead = bl;
    }

    public boolean getNeedsRead() {
        return this.needsRead;
    }

    public void setNeedsInit(boolean bl) {
        this.needsInit = bl;
    }

    public boolean getNeedsInit() {
        return this.needsInit;
    }

    public File getFile() {
        return this.fmtFile;
    }

    private void reorderDefaults(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 1;
        while (stringTokenizer.countTokens() > 0) {
            int n2 = this.getIndexOf(stringTokenizer.nextToken());
            if (n != n2 && n2 != -1) {
                string2 = this.getDefaults(n2);
                this.removeDefault(n2);
                this.insertDefault(n, string2);
                string2 = this.getNLSDefaults(n2);
                this.removeNLS(n2);
                this.insertNLS(n, string2);
            }
            ++n;
        }
    }

    public void ReadSettings() {
        Object object;
        int n;
        if (this.needsRead || this.needsInit) {
            int n2;
            int n3;
            this.outList = new Vector();
            this.columns = new Vector();
            this.widths = new Vector(30);
            this.formats = new Vector(30);
            this.stzList = new Vector();
            this.formats.addElement(new String("s"));
            this.widths.addElement(new Integer(25));
            n = 0;
            if (this.type == 0) {
                object = this.table.getTable();
                this.DefaultDefects = new Vector();
                this.NLSDefects = new Vector();
                this.DefaultDefects.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                this.NLSDefects.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                n = 1;
                while (n < StringDefects.length + 1) {
                    this.DefaultDefects.addElement(StringDefects[n - 1]);
                    ++n;
                }
                n3 = 0;
                while (n3 < ((Vector)object).size()) {
                    this.DefaultDefects.addElement(this.table.getDbname(n3));
                    ++n3;
                }
                n = 1;
                while (n < NLSStringDefects.length + 1) {
                    this.NLSDefects.addElement((String)this.locResource.handleGetObject(NLSStringDefects[n - 1]));
                    ++n;
                }
                n2 = 0;
                while (n2 < ((Vector)object).size()) {
                    this.NLSDefects.addElement(this.table.getFieldName(n2));
                    ++n2;
                }
                n = 1;
                while (n < this.DefaultDefects.size()) {
                    this.outList.addElement(new Integer(n));
                    this.formats.addElement(new String("s"));
                    this.widths.addElement(new Integer(25));
                    ++n;
                }
            }
            if (this.type == 1) {
                object = this.table.getTable();
                this.DefaultFeatures = new Vector();
                this.NLSFeatures = new Vector();
                this.DefaultFeatures.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                this.NLSFeatures.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                n = 1;
                while (n < StringFeatures.length + 1) {
                    this.DefaultFeatures.addElement(StringFeatures[n - 1]);
                    ++n;
                }
                n3 = 0;
                while (n3 < ((Vector)object).size()) {
                    this.DefaultFeatures.addElement(this.table.getDbname(n3));
                    ++n3;
                }
                n = 1;
                while (n < NLSStringFeatures.length + 1) {
                    this.NLSFeatures.addElement((String)this.locResource.handleGetObject(NLSStringFeatures[n - 1]));
                    ++n;
                }
                n2 = 0;
                while (n2 < ((Vector)object).size()) {
                    this.NLSFeatures.addElement(this.table.getFieldName(n2));
                    ++n2;
                }
                n = 1;
                while (n < this.DefaultFeatures.size()) {
                    this.outList.addElement(new Integer(n));
                    this.formats.addElement(new String("s"));
                    this.widths.addElement(new Integer(25));
                    ++n;
                }
            }
            if (this.type == 2) {
                object = this.table.getTable();
                this.DefaultParts = new Vector();
                this.NLSParts = new Vector();
                this.DefaultParts.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                this.NLSParts.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                n = 1;
                while (n < StringParts.length + 1) {
                    this.DefaultParts.addElement(StringParts[n - 1]);
                    ++n;
                }
                n3 = 0;
                while (n3 < ((Vector)object).size()) {
                    this.DefaultParts.addElement(this.table.getDbname(n3));
                    ++n3;
                }
                n = 1;
                while (n < NLSStringParts.length + 1) {
                    this.NLSParts.addElement((String)this.locResource.handleGetObject(NLSStringParts[n - 1]));
                    ++n;
                }
                n2 = 0;
                while (n2 < ((Vector)object).size()) {
                    this.NLSParts.addElement(this.table.getFieldName(n2));
                    ++n2;
                }
                n = 1;
                while (n < this.DefaultParts.size()) {
                    this.outList.addElement(new Integer(n));
                    this.formats.addElement(new String("s"));
                    this.widths.addElement(new Integer(25));
                    ++n;
                }
            }
            if (this.type == 4) {
                object = this.table.getTable();
                this.DefaultUsers = new Vector();
                this.NLSUsers = new Vector();
                this.DefaultUsers.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                this.NLSUsers.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                n = 1;
                while (n < StringUsers.length + 1) {
                    this.DefaultUsers.addElement(StringUsers[n - 1]);
                    ++n;
                }
                n3 = 0;
                while (n3 < ((Vector)object).size()) {
                    this.DefaultUsers.addElement(this.table.getDbname(n3));
                    ++n3;
                }
                n = 1;
                while (n < NLSStringUsers.length + 1) {
                    this.NLSUsers.addElement((String)this.locResource.handleGetObject(NLSStringUsers[n - 1]));
                    ++n;
                }
                n2 = 0;
                while (n2 < ((Vector)object).size()) {
                    this.NLSUsers.addElement(this.table.getFieldName(n2));
                    ++n2;
                }
                n = 1;
                while (n < this.DefaultUsers.size()) {
                    this.outList.addElement(new Integer(n));
                    this.formats.addElement(new String("s"));
                    this.widths.addElement(new Integer(25));
                    ++n;
                }
            }
            if (this.type == 3) {
                object = this.table.getTable();
                this.DefaultReleases = new Vector();
                this.NLSReleases = new Vector();
                this.DefaultReleases.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                this.NLSReleases.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                n = 1;
                while (n < StringReleases.length + 1) {
                    this.DefaultReleases.addElement(StringReleases[n - 1]);
                    ++n;
                }
                n3 = 0;
                while (n3 < ((Vector)object).size()) {
                    this.DefaultReleases.addElement(this.table.getDbname(n3));
                    ++n3;
                }
                n = 1;
                while (n < NLSStringReleases.length + 1) {
                    this.NLSReleases.addElement((String)this.locResource.handleGetObject(NLSStringReleases[n - 1]));
                    ++n;
                }
                n2 = 0;
                while (n2 < ((Vector)object).size()) {
                    this.NLSReleases.addElement(this.table.getFieldName(n2));
                    ++n2;
                }
                n = 1;
                while (n < this.DefaultReleases.size()) {
                    this.outList.addElement(new Integer(n));
                    this.formats.addElement(new String("s"));
                    this.widths.addElement(new Integer(25));
                    ++n;
                }
            }
            if (this.type == 5) {
                object = this.table.getTable();
                this.DefaultWorkareas = new Vector();
                this.NLSWorkareas = new Vector();
                this.DefaultWorkareas.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                this.NLSWorkareas.addElement((String)this.locResource.handleGetObject("STR_CFG_NONE"));
                n = 1;
                while (n < StringWorkareas.length + 1) {
                    this.DefaultWorkareas.addElement(StringWorkareas[n - 1]);
                    ++n;
                }
                n3 = 0;
                while (n3 < ((Vector)object).size()) {
                    this.DefaultWorkareas.addElement(this.table.getDbname(n3));
                    ++n3;
                }
                n = 1;
                while (n < NLSStringWorkareas.length + 1) {
                    this.NLSWorkareas.addElement((String)this.locResource.handleGetObject(NLSStringWorkareas[n - 1]));
                    ++n;
                }
                n2 = 0;
                while (n2 < ((Vector)object).size()) {
                    this.NLSWorkareas.addElement(this.table.getFieldName(n2));
                    ++n2;
                }
                n = 1;
                while (n < this.DefaultWorkareas.size()) {
                    this.outList.addElement(new Integer(n));
                    this.formats.addElement(new String("s"));
                    this.widths.addElement(new Integer(25));
                    ++n;
                }
            }
            this.needsInit = false;
        }
        if (this.needsRead) {
            n = 0;
            try {
                String string;
                object = new BufferedReader(new FileReader(this.fmtFile));
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    if (string.length() != 0) {
                        if (string.charAt(0) == '#') continue;
                        if (string.charAt(0) == ':') {
                            ++n;
                            continue;
                        }
                    }
                    if (n == 0) {
                        this.addStzObject(string);
                        continue;
                    }
                    if (string.length() == 0) continue;
                    if (n == 1) {
                        this.reorderDefaults(string);
                        continue;
                    }
                    if (n == 2) continue;
                    if (n == 3) {
                        this.parseColumns(string);
                        continue;
                    }
                    if (n != 4 || string.charAt(0) != '-') continue;
                    this.parseWidths(string);
                }
                ((BufferedReader)object).close();
                this.needsRead = false;
                return;
            }
            catch (IOException iOException) {
                System.err.println("IO Exception" + iOException);
                return;
            }
        }
    }

    public void WriteStanzaView(BufferedWriter bufferedWriter) {
        StringBuffer stringBuffer = null;
        try {
            String string = new String("# StanzaViewFormat");
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            int n = 0;
            int n2 = 0;
            while (n2 < this.stzList.size()) {
                n = ((stzObject)this.stzList.elementAt(n2)).WriteStanzaViewFormat(bufferedWriter, n);
                ++n2;
            }
            string = new String(":");
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = new String("# StanzaViewColumn");
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            stringBuffer = new StringBuffer();
            String string2 = null;
            String string3 = null;
            n = 0;
            n2 = 0;
            while (n2 < this.stzList.size()) {
                string2 = ((stzObject)this.stzList.elementAt(n2)).getValue1();
                string3 = ((stzObject)this.stzList.elementAt(n2)).getValue2();
                if (string2 != null || string3 != null) {
                    if (string2 != null) {
                        if (++n > 1) {
                            stringBuffer.append("," + this.getDefaults(Integer.parseInt(string2)));
                        } else {
                            stringBuffer.append(this.getDefaults(Integer.parseInt(string2)));
                        }
                    }
                    if (string3 != null) {
                        if (++n > 1) {
                            stringBuffer.append("," + this.getDefaults(Integer.parseInt(string3)));
                        } else {
                            stringBuffer.append(this.getDefaults(Integer.parseInt(string3)));
                        }
                    }
                }
                ++n2;
            }
            string = new String(stringBuffer);
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = new String(":");
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            return;
        }
        catch (IOException iOException) {
            System.err.println("IO Exception" + iOException);
            return;
        }
    }

    public void WriteTableView(BufferedWriter bufferedWriter) {
        StringBuffer stringBuffer = null;
        Integer n = new Integer(0);
        try {
            String string;
            String string2 = new String("# TableViewFormat");
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            stringBuffer = new StringBuffer();
            boolean bl = false;
            int n2 = 0;
            while (n2 < this.columns.size()) {
                n = (Integer)this.columns.elementAt(n2);
                if (n2 > 0) {
                    stringBuffer.append(" %");
                } else {
                    stringBuffer.append("%");
                    bl = true;
                }
                stringBuffer.append("-" + ((Integer)this.widths.elementAt(n)).toString() + "." + ((Integer)this.widths.elementAt(n)).toString() + this.formats.elementAt(n));
                ++n2;
            }
            string2 = new String(stringBuffer);
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            string2 = new String(":");
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            string2 = new String("# TableViewColumn");
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            n2 = 0;
            while (n2 < this.columns.size()) {
                if (n2 > 0) {
                    stringBuffer.append("," + this.getDefaults((Integer)this.columns.elementAt(n2)));
                } else {
                    stringBuffer = new StringBuffer(this.getDefaults((Integer)this.columns.elementAt(n2)));
                }
                ++n2;
            }
            string2 = new String(stringBuffer);
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            string2 = new String(":");
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            string2 = new String("# TableViewHeader");
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            String string3 = null;
            String string4 = new String("                                                                                                     ");
            String string5 = null;
            int n3 = 0;
            stringBuffer = new StringBuffer();
            n2 = 0;
            while (n2 < this.columns.size()) {
                string3 = new String();
                n = (Integer)this.columns.elementAt(n2);
                string5 = this.getNLSDefaults((Integer)this.columns.elementAt(n2));
                byte[] byArray = string5.getBytes();
                n3 = (Integer)this.widths.elementAt(n);
                if (n3 > byArray.length) {
                    string3 = string4.substring(0, n3 - byArray.length);
                    n3 = byArray.length;
                } else {
                    string3 = "";
                }
                string = new String(byArray, 0, n3);
                if (string.length() < 1) {
                    string = new String(byArray, 0, n3 - 1);
                    string = string.concat(" ");
                }
                if (n2 > 0) {
                    stringBuffer.append(" " + string + string3);
                } else {
                    stringBuffer.append(String.valueOf(string) + string3);
                }
                ++n2;
            }
            string2 = new String(stringBuffer);
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            string = new String("---------------------------------------------------------------------------------");
            n2 = 0;
            while (n2 < this.columns.size()) {
                n = (Integer)this.columns.elementAt(n2);
                n3 = (Integer)this.widths.elementAt(n);
                if (n2 > 0) {
                    stringBuffer.append(" " + string.substring(0, n3));
                } else {
                    stringBuffer = new StringBuffer(string.substring(0, n3));
                }
                ++n2;
            }
            string2 = new String(stringBuffer);
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            string2 = new String(":");
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
            return;
        }
        catch (IOException iOException) {
            System.err.println("IO Exception" + iOException);
            return;
        }
    }

    public void WriteSettings() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.fmtFile));
            this.WriteStanzaView(bufferedWriter);
            this.WriteTableView(bufferedWriter);
            bufferedWriter.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println("IO Exception" + iOException);
            return;
        }
    }

    public static void main(String[] stringArray) {
        try {
            tblModel tblModel2 = new tblModel(new File("defect.tbl"));
            tblModel2.ReadSettings();
            fmtModel fmtModel2 = new fmtModel(new File("defect.fmt"), tblModel2, 0);
            fmtModel2.ReadSettings();
            fmtModel2.WriteSettings();
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of ldPage" + throwable);
            System.exit(0);
            return;
        }
    }
}

