/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.util;

import com.ibm.vatc.util.ItemProcessor;
import java.util.Vector;

public class Item {
    private static String Copyright = "\r\n\r\nLicensed Materials - Property of IBM.\r\n(C) Copyright IBM Corporation 1997.\r\nAll Rights Reserved US Government Users Restricted Rights -\r\nUse, duplication or disclosure\r\nrestricted by GSA ADP Schedule Contract\r\nwith IBM Corp.\r\n\r\n";
    private Item parent = null;
    private Item nextSibling = null;
    private Item previousSibling = null;
    private Item aChild = null;
    private Object description;
    private Object data;
    private Vector children;
    private boolean hideChildren;

    public Item() {
        this(null, null);
    }

    public Item(Object object) {
        this(object, null);
    }

    public Item(Object object, Object object2) {
        this.data = object2;
        this.description = object;
        this.hideChildren = true;
        this.children = new Vector(10, 5);
    }

    public Item addBefore(Item item) {
        this.nextSibling = item;
        this.previousSibling = item.previousSibling;
        this.parent = item.parent;
        item.previousSibling = this;
        if (this.previousSibling != null) {
            this.previousSibling.nextSibling = this;
        }
        this.addAsChild(this.parent);
        return this;
    }

    public Item moveBefore(Item item) {
        this.remove();
        return this.addBefore(item);
    }

    public Item addAfter(Item item) {
        this.previousSibling = item;
        this.nextSibling = item.nextSibling;
        this.parent = item.parent;
        item.nextSibling = this;
        if (this.nextSibling != null) {
            this.nextSibling.previousSibling = this;
        }
        this.addAsChild(this.parent);
        return this;
    }

    public Item moveAfter(Item item) {
        this.remove();
        return this.addAfter(item);
    }

    public Item addFirst(Item item) {
        return this.addBefore(item.getFirst());
    }

    public Item moveFirst(Item item) {
        this.remove();
        return this.addFirst(item);
    }

    public Item addLast(Item item) {
        return this.addAfter(item.getLast());
    }

    public Item moveLast(Item item) {
        this.remove();
        return this.addLast(item);
    }

    public Item replace(Item item) {
        if (item != null) {
            this.nextSibling = item.nextSibling;
            this.previousSibling = item.previousSibling;
            item.nextSibling = null;
            item.previousSibling = null;
            item.remove();
        }
        return this;
    }

    public Item remove() {
        this.removeAsChild();
        if (this.nextSibling != null) {
            this.nextSibling.previousSibling = this.previousSibling;
        }
        if (this.previousSibling != null) {
            this.previousSibling.nextSibling = this.nextSibling;
        }
        this.nextSibling = null;
        this.previousSibling = null;
        return this;
    }

    public Item prune() {
        Item item = this.aChild;
        this.remove();
        if (item != null) {
            item = item.getFirst();
            while (item != null) {
                Item item2 = item.nextSibling;
                item.prune();
                item = item2;
            }
        }
        return this;
    }

    public Item addAsChild(Item item) {
        this.parent = item;
        if (item != null) {
            if (item.aChild == null) {
                item.aChild = this;
                item.children.addElement(this);
            } else if (this.getItemPosition(item.aChild) < 0) {
                this.addLast(item.aChild);
                item.children.addElement(this);
            }
        }
        return this;
    }

    public Item removeAsChild() {
        if (this.parent != null && this.parent.aChild != null) {
            if (this.parent.aChild.equals(this)) {
                this.parent.aChild = this.previousSibling != null ? this.previousSibling : this.nextSibling;
            } else if (this.getItemPosition(this.parent.aChild) >= 0) {
                this.parent.children.removeElementAt(this.parent.children.indexOf(this));
                this.parent = null;
                this.remove();
            }
        }
        this.parent = null;
        return this;
    }

    public void setDescription(Object object) {
        this.description = object;
    }

    public Object getDescription() {
        return this.description;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public Object getData() {
        return this.data;
    }

    public void setChildrenVisible(boolean bl) {
        this.hideChildren = !bl;
    }

    public boolean isChildrenVisible() {
        return !this.hideChildren;
    }

    public Item getFirst() {
        Item item = this;
        while (item.previousSibling != null) {
            item = item.previousSibling;
        }
        return item;
    }

    public Item getNext() {
        return this.nextSibling;
    }

    public Item getPrevious() {
        return this.previousSibling;
    }

    public Item getLast() {
        Item item = this;
        while (item.nextSibling != null) {
            item = item.nextSibling;
        }
        return item;
    }

    public Item getItem(int n) {
        Item item = this.getFirst();
        while (n > 0 && item != null) {
            item = item.nextSibling;
            --n;
        }
        if (item == null) {
            throw new IllegalArgumentException("No such item");
        }
        return item;
    }

    public int getItemPosition() {
        int n = 0;
        Item item = this.previousSibling;
        while (item != null) {
            item = item.previousSibling;
            ++n;
        }
        return n;
    }

    public int getItemPosition(Item item) {
        int n = -1;
        Item item2 = this.getFirst();
        int n2 = 0;
        while (n2 < this.getItemCount() && n < 0) {
            if (item2.equals(item)) {
                n = n2;
            } else {
                item2 = item2.nextSibling;
            }
            ++n2;
        }
        return n;
    }

    public int getItemCount() {
        int n = 0;
        Item item = this.getFirst();
        while (item != null) {
            ++n;
            item = item.nextSibling;
        }
        return n;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Item getParent() {
        return this.parent;
    }

    public Item getFirstChild() {
        Item item = null;
        if (this.children.size() > 0) {
            item = (Item)this.children.elementAt(0);
        }
        return item;
    }

    public Item getChild(int n) {
        if (n < 0 || n >= this.children.size()) {
            throw new IllegalArgumentException("No such child item");
        }
        return (Item)this.children.elementAt(n);
    }

    public void traverse(ItemProcessor itemProcessor, Object object) {
        this.traverse(itemProcessor, object, true);
    }

    public void traverse(ItemProcessor itemProcessor, Object object, boolean bl) {
        Item item = this.getFirst();
        int n = 0;
        while (item != null) {
            if (itemProcessor.processItem(item, object)) {
                if (item.getChildCount() > 0 && (!item.hideChildren || bl)) {
                    item = item.getFirstChild();
                    ++n;
                    continue;
                }
                if (item.getNext() != null) {
                    item = item.getNext();
                    continue;
                }
                item = item.getParent();
                boolean bl2 = item != null && --n >= 0;
                while (bl2) {
                    if (item.getNext() == null) {
                        item = item.getParent();
                        bl2 = item != null && --n >= 0;
                        continue;
                    }
                    item = item.getNext();
                    bl2 = false;
                }
                if (n >= 0) continue;
                item = null;
                continue;
            }
            item = null;
        }
    }

    public void sort(ItemProcessor itemProcessor) {
        int n = this.getItemCount();
        if (n > 1) {
            Item[] itemArray = this.getItemList();
            this.quickSort(itemProcessor, itemArray, 0, itemArray.length - 1);
            this.rebuildSiblingChain(itemArray);
        }
    }

    private Item[] getItemList() {
        int n = this.getItemCount();
        Item[] itemArray = new Item[n];
        itemArray[0] = this.getFirst();
        int n2 = 1;
        while (n2 < n) {
            itemArray[n2] = itemArray[n2 - 1].nextSibling;
            ++n2;
        }
        return itemArray;
    }

    /*
     * Unable to fully structure code
     */
    private void quickSort(ItemProcessor var1_1, Item[] var2_2, int var3_3, int var4_4) {
        block5: {
            var5_5 = var3_3;
            var6_6 = var4_4;
            if (var4_4 <= var3_3) break block5;
            var7_7 = var2_2[(var4_4 + var3_3) / 2];
            ** GOTO lbl16
            {
                ++var5_5;
                do {
                    if (var5_5 < var4_4 && var1_1.compareItems(var2_2[var5_5], var7_7) == -1) continue block0;
                    while (var6_6 > var3_3 && var1_1.compareItems(var2_2[var6_6], var7_7) == 1) {
                        --var6_6;
                    }
                    if (var5_5 > var6_6) continue;
                    this.swapItems(var2_2, var5_5, var6_6);
                    ++var5_5;
                    --var6_6;
lbl16:
                    // 3 sources

                } while (var5_5 <= var6_6);
            }
            if (var3_3 < var6_6) {
                this.quickSort(var1_1, var2_2, var3_3, var6_6);
            }
            if (var5_5 < var4_4) {
                this.quickSort(var1_1, var2_2, var5_5, var4_4);
            }
        }
    }

    private void swapItems(Item[] itemArray, int n, int n2) {
        Item item = itemArray[n];
        itemArray[n] = itemArray[n2];
        itemArray[n2] = item;
    }

    private void rebuildSiblingChain(Item[] itemArray) {
        itemArray[0].previousSibling = null;
        int n = 1;
        while (n < itemArray.length) {
            itemArray[n - 1].nextSibling = itemArray[n];
            itemArray[n].previousSibling = itemArray[n - 1];
            ++n;
        }
        itemArray[itemArray.length - 1].nextSibling = null;
        int n2 = 1;
        while (n2 < itemArray.length) {
            itemArray[n2] = null;
            ++n2;
        }
    }
}

