/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.DiffInfoCommon;
import com.ibm.vatc.tcmerge.DiffInfoComposite;
import com.ibm.vatc.tcmerge.DiffInput;
import com.ibm.vatc.tcmerge.DiffOutput;
import com.ibm.vatc.tcmerge.MergeGui;
import com.ibm.vatc.tcmerge.Navigate;
import com.ibm.vatc.tcmerge.TextComposite;
import com.ibm.vatc.tcmerge.TextRefFiles;
import com.ibm.vatc.tcmerge.TextRefOutput;
import com.ibm.vatc.tcmerge.UndoInfo;
import com.ibm.vatc.tcmerge.tcmerge;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

class MakeViews {
    private MergeGui mergeGui;
    private DiffOutput diffOutput;
    private DiffInput diffInput;
    private Vector tableComposite;
    private Vector tableOutput;
    private Vector tableFileZero;
    private Vector tableFileOne;
    private Vector tableFileTwo;
    private Vector tableEdit;
    private Vector tableUndo;
    private Vector diffTableComposite;
    private Vector diffTableOutput;
    private Vector diffTableFileZero;
    private Vector diffTableFileOne;
    private Vector diffTableFileTwo;
    private String zerothFile;
    private String firstFile;
    private String secondFile;
    boolean isTwowayMerge;
    int totalDifferences;
    static final short STRING_BUFF_SIZE = 1024;
    static final short NUMBER_OF_UNDO = 6;
    static final byte NOTMATCHED = 1;
    static final byte CURRENTDIFF = 2;
    static final byte MARKERNEEDED = 4;
    static final byte FILLEDMARKER = 8;
    static final byte ZEROTHFILE = 16;
    static final byte FIRSTFILE = 32;
    static final byte SECONDFILE = 64;
    static final byte MASKMARKER = 115;
    static final byte MASKFILES = 15;
    static final byte EDITEDTEXT = 8;

    public MakeViews(MergeGui mergeGui) throws IOException {
        this.mergeGui = mergeGui;
        this.diffInput = mergeGui.getDiffInput();
        this.diffOutput = mergeGui.getDiffOutput();
        Vector vector = this.diffInput.getInputFiles();
        this.zerothFile = (String)vector.elementAt(0);
        this.firstFile = (String)vector.elementAt(1);
        if (vector.size() == 3) {
            this.secondFile = (String)vector.elementAt(2);
            this.isTwowayMerge = false;
        } else if (vector.size() == 2) {
            this.secondFile = (String)vector.elementAt(1);
            this.isTwowayMerge = true;
        }
        this.tableComposite = new Vector();
        this.tableOutput = new Vector();
        this.tableFileZero = new Vector();
        this.tableFileOne = new Vector();
        this.tableFileTwo = new Vector();
        this.tableEdit = new Vector();
        this.tableUndo = new Vector();
        this.diffTableComposite = new Vector();
        this.diffTableOutput = new Vector();
        this.diffTableFileZero = new Vector();
        this.diffTableFileOne = new Vector();
        this.diffTableFileTwo = new Vector();
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        this.makeTables();
        runtime.gc();
        int n = this.diffInput.getPrimeOutput();
        if (n != -1 && n < 3) {
            this.primeAllDiffs(n);
        }
    }

    public void updateMakeViews() {
        Vector vector = this.diffInput.getInputFiles();
        this.zerothFile = (String)vector.elementAt(0);
        this.firstFile = (String)vector.elementAt(1);
        if (vector.size() == 3) {
            this.secondFile = (String)vector.elementAt(2);
            this.isTwowayMerge = false;
        } else if (vector.size() == 2) {
            this.secondFile = (String)vector.elementAt(1);
            this.isTwowayMerge = true;
        }
        this.tableComposite.removeAllElements();
        this.tableOutput.removeAllElements();
        this.tableFileZero.removeAllElements();
        this.tableFileOne.removeAllElements();
        this.tableFileTwo.removeAllElements();
        this.tableEdit.removeAllElements();
        this.tableUndo.removeAllElements();
        this.diffTableComposite.removeAllElements();
        this.diffTableOutput.removeAllElements();
        this.diffTableFileZero.removeAllElements();
        this.diffTableFileOne.removeAllElements();
        this.diffTableFileTwo.removeAllElements();
        this.makeTables();
        int n = this.diffInput.getPrimeOutput();
        if (n != -1 && n < 3) {
            this.primeAllDiffs(n);
        }
    }

    public void makeTables() {
        try {
            String string;
            TextRefFiles textRefFiles;
            TextRefOutput textRefOutput;
            TextComposite textComposite;
            int n = this.diffOutput.getDiffOutputSize();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 1;
            int n11 = -1;
            int n12 = 0;
            int n13 = -1;
            if (!this.isTwowayMerge) {
                n13 = this.diffInput.getIgnoreDiff();
                if (this.diffInput.getAutomerge()) {
                    n13 = 111;
                }
                n12 = n13 == 1 || n13 == 2 ? 0 : 2;
            }
            String string2 = (String)this.diffInput.getInputFiles().elementAt(n12);
            FileReader fileReader = new FileReader(string2);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            this.totalDifferences = 0;
            int n14 = 0;
            while (n14 < n) {
                boolean bl;
                int n15 = this.diffOutput.getChangedFile(n14);
                boolean bl2 = this.diffInput.getAutomerge();
                boolean bl3 = n15 != n13 && !bl2;
                boolean bl4 = bl = n15 == n13 && bl2;
                if (bl3 || bl) {
                    int n16;
                    String string3;
                    int n17;
                    int n18;
                    Vector vector;
                    ++this.totalDifferences;
                    n10 = 1;
                    DiffInfoComposite diffInfoComposite = new DiffInfoComposite();
                    DiffInfoCommon diffInfoCommon = new DiffInfoCommon();
                    DiffInfoCommon diffInfoCommon2 = new DiffInfoCommon();
                    DiffInfoCommon diffInfoCommon3 = new DiffInfoCommon();
                    DiffInfoCommon diffInfoCommon4 = new DiffInfoCommon();
                    diffInfoComposite.setChangedFile(this.diffOutput.getChangedFile(n14));
                    int n19 = n14 == 0 || n11 == -1 ? 1 : this.diffOutput.getEnd(n11, n12) + 1;
                    n11 = n14;
                    int n20 = this.diffOutput.getText(n14, n12) ? this.diffOutput.getStart(n14, n12) : this.diffOutput.getStart(n14, n12) + 1;
                    int n21 = n19;
                    while (n21 < n20) {
                        textComposite = new TextComposite();
                        textComposite.text = bufferedReader.readLine();
                        textComposite.flag = 0;
                        textComposite.line = n3;
                        this.tableComposite.addElement(textComposite);
                        textRefOutput = new TextRefOutput();
                        textRefOutput.textRef = n2;
                        textRefOutput.flag = 0;
                        this.tableOutput.addElement(textRefOutput);
                        textRefFiles = new TextRefFiles();
                        textRefFiles.reference = n2;
                        textRefFiles.line = n7;
                        this.tableFileZero.addElement(textRefFiles);
                        textRefFiles = new TextRefFiles();
                        textRefFiles.reference = n2;
                        textRefFiles.line = n8;
                        this.tableFileOne.addElement(textRefFiles);
                        if (!this.isTwowayMerge) {
                            textRefFiles = new TextRefFiles();
                            textRefFiles.reference = n2;
                            textRefFiles.line = n9;
                            this.tableFileTwo.addElement(textRefFiles);
                        }
                        ++n3;
                        ++n7;
                        ++n8;
                        if (!this.isTwowayMerge) {
                            ++n9;
                        }
                        ++n4;
                        ++n5;
                        if (!this.isTwowayMerge) {
                            ++n6;
                        }
                        ++n2;
                        ++n21;
                    }
                    if (this.diffOutput.getText(n14, 0)) {
                        diffInfoComposite.setStart(0, n2);
                        diffInfoCommon2.setStartBlock(n4);
                        vector = this.diffOutput.getDiffText(n14, 0);
                        n18 = this.diffOutput.getStart(n14, 0);
                        n17 = this.diffOutput.getStart(n14, 0);
                        while (n17 <= this.diffOutput.getEnd(n14, 0)) {
                            textComposite = new TextComposite();
                            if (n12 == 0) {
                                string3 = bufferedReader.readLine();
                            }
                            textComposite.text = (String)vector.elementAt(n17 - n18);
                            textComposite.flag = this.totalDifferences == 1 ? (byte)19 : (byte)17;
                            if (n17 - this.diffOutput.getStart(n14, 0) == 0) {
                                textComposite.flag = (byte)(textComposite.flag | 4);
                                if (this.diffOutput.getChangedFile(n14) == 0 || this.diffOutput.getChangedFile(n14) == 111) {
                                    textComposite.flag = (byte)(textComposite.flag | 8);
                                }
                            }
                            textComposite.line = n3++;
                            this.tableComposite.addElement(textComposite);
                            textRefFiles = new TextRefFiles();
                            textRefFiles.reference = n2++;
                            textRefFiles.line = n7++;
                            this.tableFileZero.addElement(textRefFiles);
                            ++n4;
                            ++n17;
                        }
                        diffInfoComposite.setEnd(0, n2 - 1);
                        diffInfoCommon2.setEndBlock(n4 - 1);
                        n16 = this.diffOutput.getEnd(n14, 0) - this.diffOutput.getStart(n14, 0) + 1;
                        if (n16 > n10) {
                            n10 = n16;
                        }
                    } else {
                        diffInfoComposite.setStart(0, n2);
                        diffInfoCommon2.setStartBlock(n4);
                        textComposite = new TextComposite();
                        textComposite.text = "^~:ZeroLength:~^";
                        textComposite.flag = this.totalDifferences == 1 ? (byte)19 : (byte)17;
                        this.tableComposite.addElement(textComposite);
                        textRefFiles = new TextRefFiles();
                        textRefFiles.reference = n2++;
                        this.tableFileZero.addElement(textRefFiles);
                        diffInfoComposite.setEnd(0, n2 - 1);
                        diffInfoCommon2.setEndBlock(++n4 - 1);
                    }
                    if (this.diffOutput.getText(n14, 1)) {
                        diffInfoComposite.setStart(1, n2);
                        diffInfoCommon3.setStartBlock(n5);
                        vector = this.diffOutput.getDiffText(n14, 1);
                        n18 = this.diffOutput.getStart(n14, 1);
                        n17 = this.diffOutput.getStart(n14, 1);
                        while (n17 <= this.diffOutput.getEnd(n14, 1)) {
                            textComposite = new TextComposite();
                            if (n12 == 1) {
                                string3 = bufferedReader.readLine();
                            }
                            textComposite.text = (String)vector.elementAt(n17 - n18);
                            textComposite.flag = this.totalDifferences == 1 ? (byte)35 : (byte)33;
                            if (n17 - this.diffOutput.getStart(n14, 1) == 0) {
                                textComposite.flag = (byte)(textComposite.flag | 4);
                                if (this.diffOutput.getChangedFile(n14) == 1 || this.diffOutput.getChangedFile(n14) == 111) {
                                    textComposite.flag = (byte)(textComposite.flag | 8);
                                }
                            }
                            textComposite.line = n17 - 1;
                            this.tableComposite.addElement(textComposite);
                            textRefFiles = new TextRefFiles();
                            textRefFiles.reference = n2++;
                            textRefFiles.line = n8++;
                            this.tableFileOne.addElement(textRefFiles);
                            ++n5;
                            ++n17;
                        }
                        diffInfoComposite.setEnd(1, n2 - 1);
                        diffInfoCommon3.setEndBlock(n5 - 1);
                        n16 = this.diffOutput.getEnd(n14, 1) - this.diffOutput.getStart(n14, 1) + 1;
                        if (n16 > n10) {
                            n10 = n16;
                        }
                    } else {
                        diffInfoComposite.setStart(1, n2);
                        diffInfoCommon3.setStartBlock(n5);
                        textComposite = new TextComposite();
                        textComposite.text = "^~:ZeroLength:~^";
                        textComposite.flag = this.totalDifferences == 1 ? (byte)35 : (byte)33;
                        this.tableComposite.addElement(textComposite);
                        textRefFiles = new TextRefFiles();
                        textRefFiles.reference = n2++;
                        this.tableFileOne.addElement(textRefFiles);
                        diffInfoComposite.setEnd(1, n2 - 1);
                        diffInfoCommon3.setEndBlock(++n5 - 1);
                    }
                    if (!this.isTwowayMerge) {
                        if (this.diffOutput.getText(n14, 2)) {
                            diffInfoComposite.setStart(2, n2);
                            diffInfoCommon4.setStartBlock(n6);
                            vector = this.diffOutput.getDiffText(n14, 2);
                            n18 = this.diffOutput.getStart(n14, 2);
                            n17 = this.diffOutput.getStart(n14, 2);
                            while (n17 <= this.diffOutput.getEnd(n14, 2)) {
                                textComposite = new TextComposite();
                                if (n12 == 2) {
                                    string3 = bufferedReader.readLine();
                                }
                                textComposite.text = (String)vector.elementAt(n17 - n18);
                                textComposite.flag = this.totalDifferences == 1 ? (byte)67 : (byte)65;
                                if (n17 - this.diffOutput.getStart(n14, 2) == 0) {
                                    textComposite.flag = (byte)(textComposite.flag | 4);
                                    if (this.diffOutput.getChangedFile(n14) == 2 || this.diffOutput.getChangedFile(n14) == 111) {
                                        textComposite.flag = (byte)(textComposite.flag | 8);
                                    }
                                }
                                textComposite.line = n17 - 1;
                                this.tableComposite.addElement(textComposite);
                                textRefFiles = new TextRefFiles();
                                textRefFiles.reference = n2++;
                                textRefFiles.line = n9++;
                                this.tableFileTwo.addElement(textRefFiles);
                                ++n6;
                                ++n17;
                            }
                            diffInfoComposite.setEnd(2, n2 - 1);
                            diffInfoCommon4.setEndBlock(n6 - 1);
                            n16 = this.diffOutput.getEnd(n14, 2) - this.diffOutput.getStart(n14, 2) + 1;
                            if (n16 > n10) {
                                n10 = n16;
                            }
                        } else {
                            diffInfoComposite.setStart(2, n2);
                            diffInfoCommon4.setStartBlock(n6);
                            textComposite = new TextComposite();
                            textComposite.text = "^~:ZeroLength:~^";
                            textComposite.flag = this.totalDifferences == 1 ? (byte)67 : (byte)65;
                            this.tableComposite.addElement(textComposite);
                            textRefFiles = new TextRefFiles();
                            textRefFiles.reference = n2++;
                            this.tableFileTwo.addElement(textRefFiles);
                            diffInfoComposite.setEnd(2, n2 - 1);
                            diffInfoCommon4.setEndBlock(++n6 - 1);
                        }
                    }
                    diffInfoCommon.setStartBlock(this.tableOutput.size());
                    textRefOutput = new TextRefOutput();
                    textRefOutput.textRef = -1;
                    textRefOutput.flag = this.totalDifferences == 1 ? (byte)3 : (byte)1;
                    this.tableOutput.addElement(textRefOutput);
                    diffInfoCommon.setEndBlock(this.tableOutput.size() - 1);
                    this.diffTableComposite.addElement(diffInfoComposite);
                    this.diffTableOutput.addElement(diffInfoCommon);
                    this.diffTableFileZero.addElement(diffInfoCommon2);
                    this.diffTableFileOne.addElement(diffInfoCommon3);
                    if (!this.isTwowayMerge) {
                        this.diffTableFileTwo.addElement(diffInfoCommon4);
                    }
                }
                ++n14;
            }
            while ((string = bufferedReader.readLine()) != null) {
                textComposite = new TextComposite();
                textComposite.text = string;
                textComposite.flag = 0;
                textComposite.line = n3;
                this.tableComposite.addElement(textComposite);
                textRefOutput = new TextRefOutput();
                textRefOutput.textRef = n2;
                textRefOutput.flag = 0;
                this.tableOutput.addElement(textRefOutput);
                textRefFiles = new TextRefFiles();
                textRefFiles.reference = n2;
                textRefFiles.line = n7;
                this.tableFileZero.addElement(textRefFiles);
                textRefFiles = new TextRefFiles();
                textRefFiles.reference = n2;
                textRefFiles.line = n8;
                this.tableFileOne.addElement(textRefFiles);
                if (!this.isTwowayMerge) {
                    textRefFiles = new TextRefFiles();
                    textRefFiles.reference = n2;
                    textRefFiles.line = n9;
                    this.tableFileTwo.addElement(textRefFiles);
                }
                ++n3;
                ++n7;
                ++n4;
                ++n8;
                ++n5;
                if (!this.isTwowayMerge) {
                    ++n9;
                    ++n6;
                }
                ++n2;
            }
            bufferedReader.close();
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string = tcmerge.locResource.getString("STR_MEMORY_ERROR");
            System.err.println(string);
            System.exit(1);
            return;
        }
        catch (IOException iOException) {
            String string = tcmerge.locResource.getString("STR_TABLE_IO_ERROR");
            System.err.println(string);
            System.exit(1);
            return;
        }
    }

    public void primeOneDiff(int n, int n2) {
        TextRefOutput textRefOutput;
        DiffInfoComposite diffInfoComposite = (DiffInfoComposite)this.diffTableComposite.elementAt(n2);
        DiffInfoCommon diffInfoCommon = (DiffInfoCommon)this.diffTableOutput.elementAt(n2);
        int n3 = diffInfoComposite.getStart(n);
        int n4 = diffInfoComposite.getEnd(n);
        int n5 = diffInfoCommon.getStartBlock();
        int n6 = diffInfoCommon.getEndBlock();
        UndoInfo undoInfo = new UndoInfo();
        undoInfo.diffNumber = n2;
        DiffInfoCommon diffInfoCommon2 = (DiffInfoCommon)this.diffTableOutput.elementAt(n2);
        int n7 = diffInfoCommon2.getStartBlock();
        while (n7 <= diffInfoCommon2.getEndBlock()) {
            textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n7);
            TextRefOutput textRefOutput2 = new TextRefOutput();
            textRefOutput2.textRef = textRefOutput.textRef;
            textRefOutput2.flag = textRefOutput.flag;
            textRefOutput2.flag = (byte)(textRefOutput2.flag ^ 2);
            undoInfo.diffTextRef.addElement(textRefOutput2);
            ++n7;
        }
        this.tableUndo.addElement(undoInfo);
        while (this.tableUndo.size() > 6) {
            this.tableUndo.removeElementAt(0);
        }
        if (n4 - n3 == n6 - n5) {
            int n8 = n3;
            while (n8 <= n4) {
                textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n5 + n8 - n3);
                TextComposite textComposite = (TextComposite)this.tableComposite.elementAt(n8);
                textRefOutput.textRef = textComposite.text.equals("^~:ZeroLength:~^") ? -2 : n8;
                textRefOutput.flag = textComposite.flag;
                textRefOutput.flag = (byte)(textRefOutput.flag & 0x73);
                ++n8;
            }
            return;
        }
        if (n4 - n3 > n6 - n5) {
            int n9 = n5;
            while (n9 <= n6) {
                textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n9);
                TextComposite textComposite = (TextComposite)this.tableComposite.elementAt(n3 + n9 - n5);
                textRefOutput.textRef = textComposite.text.equals("^~:ZeroLength:~^") ? -2 : n3 + n9 - n5;
                textRefOutput.flag = textComposite.flag;
                textRefOutput.flag = (byte)(textRefOutput.flag & 0x73);
                ++n9;
            }
            int n10 = n4 - n3 - (n6 - n5);
            int n11 = 1;
            while (n11 <= n10) {
                textRefOutput = new TextRefOutput();
                TextComposite textComposite = (TextComposite)this.tableComposite.elementAt(n3 + n6 - n5 + n11);
                textRefOutput.textRef = textComposite.text.equals("^~:ZeroLength:~^") ? -2 : n3 + n6 - n5 + n11;
                textRefOutput.flag = textComposite.flag;
                textRefOutput.flag = (byte)(textRefOutput.flag & 0x73);
                this.tableOutput.insertElementAt(textRefOutput, n6 + n11);
                ++n11;
            }
            int n12 = n2;
            while (n12 < this.totalDifferences) {
                DiffInfoCommon diffInfoCommon3 = (DiffInfoCommon)this.diffTableOutput.elementAt(n12);
                int n13 = diffInfoCommon3.getStartBlock();
                int n14 = diffInfoCommon3.getEndBlock();
                if (n12 != n2) {
                    diffInfoCommon3.setStartBlock(n13 + n10);
                }
                diffInfoCommon3.setEndBlock(n14 + n10);
                ++n12;
            }
            return;
        }
        if (n4 - n3 < n6 - n5) {
            int n15 = n3;
            while (n15 <= n4) {
                textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n5 + n15 - n3);
                TextComposite textComposite = (TextComposite)this.tableComposite.elementAt(n15);
                textRefOutput.textRef = textComposite.text.equals("^~:ZeroLength:~^") ? -2 : n15;
                textRefOutput.flag = textComposite.flag;
                textRefOutput.flag = (byte)(textRefOutput.flag & 0x73);
                ++n15;
            }
            int n16 = n6 - n5 - (n4 - n3);
            int n17 = 0;
            while (n17 < n16) {
                this.tableOutput.removeElementAt(n5 + (n4 - n3) + 1);
                ++n17;
            }
            int n18 = n2;
            while (n18 < this.totalDifferences) {
                DiffInfoCommon diffInfoCommon4 = (DiffInfoCommon)this.diffTableOutput.elementAt(n18);
                int n19 = diffInfoCommon4.getStartBlock();
                int n20 = diffInfoCommon4.getEndBlock();
                if (n18 != n2) {
                    diffInfoCommon4.setStartBlock(n19 - n16);
                }
                diffInfoCommon4.setEndBlock(n20 - n16);
                ++n18;
            }
        }
    }

    public void insertOneDiff(int n, int n2) {
        Object object;
        TextRefOutput textRefOutput;
        DiffInfoComposite diffInfoComposite = (DiffInfoComposite)this.diffTableComposite.elementAt(n2);
        DiffInfoCommon diffInfoCommon = (DiffInfoCommon)this.diffTableOutput.elementAt(n2);
        int n3 = diffInfoComposite.getStart(n);
        int n4 = diffInfoComposite.getEnd(n);
        int n5 = diffInfoCommon.getStartBlock();
        int n6 = diffInfoCommon.getEndBlock();
        int n7 = 0;
        boolean bl = true;
        UndoInfo undoInfo = new UndoInfo();
        undoInfo.diffNumber = n2;
        DiffInfoCommon diffInfoCommon2 = (DiffInfoCommon)this.diffTableOutput.elementAt(n2);
        int n8 = diffInfoCommon2.getStartBlock();
        while (n8 <= diffInfoCommon2.getEndBlock()) {
            TextRefOutput textRefOutput2 = (TextRefOutput)this.tableOutput.elementAt(n8);
            textRefOutput = new TextRefOutput();
            textRefOutput.textRef = textRefOutput2.textRef;
            textRefOutput.flag = textRefOutput2.flag;
            textRefOutput.flag = (byte)(textRefOutput.flag ^ 2);
            undoInfo.diffTextRef.addElement(textRefOutput);
            ++n8;
        }
        this.tableUndo.addElement(undoInfo);
        while (this.tableUndo.size() > 6) {
            this.tableUndo.removeElementAt(0);
        }
        int n9 = n3;
        while (n9 <= n4) {
            if (bl) {
                textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n5);
                object = (TextComposite)this.tableComposite.elementAt(n9);
                if (textRefOutput.textRef == -1) {
                    textRefOutput.textRef = ((TextComposite)object).text.equals("^~:ZeroLength:~^") ? -2 : -3;
                    textRefOutput.flag = ((TextComposite)object).flag;
                    textRefOutput.flag = (byte)(textRefOutput.flag & 0x73);
                } else {
                    textRefOutput = new TextRefOutput();
                    textRefOutput.textRef = -3;
                    textRefOutput.flag = ((TextComposite)object).flag;
                    textRefOutput.flag = (byte)(textRefOutput.flag & 0x73);
                    this.tableOutput.insertElementAt(textRefOutput, n6 + ++n7);
                }
                textRefOutput = new TextRefOutput();
                textRefOutput.textRef = ((TextComposite)object).text.equals("^~:ZeroLength:~^") ? -2 : n9;
                textRefOutput.flag = ((TextComposite)object).flag;
                textRefOutput.flag = (byte)(textRefOutput.flag & 0x73);
                this.tableOutput.insertElementAt(textRefOutput, n6 + ++n7);
                bl = false;
            } else {
                ++n7;
                textRefOutput = new TextRefOutput();
                object = (TextComposite)this.tableComposite.elementAt(n9);
                textRefOutput.textRef = ((TextComposite)object).text.equals("^~:ZeroLength:~^") ? -2 : n9;
                textRefOutput.flag = ((TextComposite)object).flag;
                textRefOutput.flag = (byte)(textRefOutput.flag & 0x73);
                this.tableOutput.insertElementAt(textRefOutput, n6 + n7);
            }
            ++n9;
        }
        int n10 = n2;
        while (n10 < this.totalDifferences) {
            object = (DiffInfoCommon)this.diffTableOutput.elementAt(n10);
            int n11 = ((DiffInfoCommon)object).getStartBlock();
            int n12 = ((DiffInfoCommon)object).getEndBlock();
            if (n10 != n2) {
                ((DiffInfoCommon)object).setStartBlock(n11 + n7);
            }
            ((DiffInfoCommon)object).setEndBlock(n12 + n7);
            ++n10;
        }
    }

    public void addUndoInfo(UndoInfo undoInfo) {
        this.tableUndo.addElement(undoInfo);
        while (this.tableUndo.size() > 6) {
            this.tableUndo.removeElementAt(0);
        }
    }

    public void undoLastAction() {
        if (this.tableUndo.size() != 0) {
            int n;
            UndoInfo undoInfo = (UndoInfo)this.tableUndo.elementAt(this.tableUndo.size() - 1);
            DiffInfoCommon diffInfoCommon = (DiffInfoCommon)this.diffTableOutput.elementAt(undoInfo.diffNumber);
            int n2 = diffInfoCommon.getStartBlock();
            int n3 = diffInfoCommon.getEndBlock();
            if (undoInfo.diffTextRef.size() == n3 - n2 + 1) {
                n = n2;
                while (n <= n3) {
                    TextRefOutput textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n);
                    TextRefOutput textRefOutput2 = (TextRefOutput)undoInfo.diffTextRef.elementAt(n - n2);
                    textRefOutput.textRef = textRefOutput2.textRef;
                    textRefOutput.flag = textRefOutput2.flag;
                    if (undoInfo.diffNumber == this.mergeGui.getViewParam().getCurrentDiff()) {
                        textRefOutput.flag = (byte)(textRefOutput.flag | 2);
                    }
                    ++n;
                }
            } else if (undoInfo.diffTextRef.size() > n3 - n2 + 1) {
                Object object;
                n = n2;
                while (n <= n3) {
                    TextRefOutput textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n);
                    TextRefOutput textRefOutput3 = (TextRefOutput)undoInfo.diffTextRef.elementAt(n - n2);
                    textRefOutput.textRef = textRefOutput3.textRef;
                    textRefOutput.flag = textRefOutput3.flag;
                    if (undoInfo.diffNumber == this.mergeGui.getViewParam().getCurrentDiff()) {
                        textRefOutput.flag = (byte)(textRefOutput.flag | 2);
                    }
                    ++n;
                }
                int n4 = 0;
                int n5 = n3 + 1;
                while (n5 < n2 + undoInfo.diffTextRef.size()) {
                    ++n4;
                    TextRefOutput textRefOutput = new TextRefOutput();
                    object = (TextRefOutput)undoInfo.diffTextRef.elementAt(n5 - n2);
                    textRefOutput.textRef = ((TextRefOutput)object).textRef;
                    textRefOutput.flag = ((TextRefOutput)object).flag;
                    if (undoInfo.diffNumber == this.mergeGui.getViewParam().getCurrentDiff()) {
                        textRefOutput.flag = (byte)(textRefOutput.flag | 2);
                    }
                    this.tableOutput.insertElementAt(textRefOutput, n5);
                    ++n5;
                }
                int n6 = undoInfo.diffNumber;
                while (n6 < this.totalDifferences) {
                    object = (DiffInfoCommon)this.diffTableOutput.elementAt(n6);
                    int n7 = ((DiffInfoCommon)object).getStartBlock();
                    int n8 = ((DiffInfoCommon)object).getEndBlock();
                    if (n6 != undoInfo.diffNumber) {
                        ((DiffInfoCommon)object).setStartBlock(n7 + n4);
                    }
                    ((DiffInfoCommon)object).setEndBlock(n8 + n4);
                    ++n6;
                }
            } else if (undoInfo.diffTextRef.size() < n3 - n2 + 1) {
                n = n2;
                while (n < n2 + undoInfo.diffTextRef.size()) {
                    TextRefOutput textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n);
                    TextRefOutput textRefOutput4 = (TextRefOutput)undoInfo.diffTextRef.elementAt(n - n2);
                    textRefOutput.textRef = textRefOutput4.textRef;
                    textRefOutput.flag = textRefOutput4.flag;
                    if (undoInfo.diffNumber == this.mergeGui.getViewParam().getCurrentDiff()) {
                        textRefOutput.flag = (byte)(textRefOutput.flag | 2);
                    }
                    ++n;
                }
                int n9 = 0;
                int n10 = n2 + undoInfo.diffTextRef.size();
                while (n10 <= n3) {
                    ++n9;
                    this.tableOutput.removeElementAt(n2 + undoInfo.diffTextRef.size());
                    ++n10;
                }
                int n11 = undoInfo.diffNumber;
                while (n11 < this.totalDifferences) {
                    DiffInfoCommon diffInfoCommon2 = (DiffInfoCommon)this.diffTableOutput.elementAt(n11);
                    int n12 = diffInfoCommon2.getStartBlock();
                    int n13 = diffInfoCommon2.getEndBlock();
                    if (n11 != undoInfo.diffNumber) {
                        diffInfoCommon2.setStartBlock(n12 - n9);
                    }
                    diffInfoCommon2.setEndBlock(n13 - n9);
                    ++n11;
                }
            }
            this.tableUndo.removeElementAt(this.tableUndo.size() - 1);
            Navigate navigate = new Navigate(this.mergeGui);
            navigate.gotoDifference(undoInfo.diffNumber);
        }
    }

    public void primeAllDiffs(int n) {
        int n2 = 0;
        while (n2 < this.diffTableComposite.size()) {
            this.primeOneDiff(n, n2);
            ++n2;
        }
    }

    public void setCurrentDiff(int n, int n2) {
        Object object;
        DiffInfoComposite diffInfoComposite = (DiffInfoComposite)this.diffTableComposite.elementAt(n);
        int n3 = diffInfoComposite.getStart(0);
        int n4 = !this.isTwowayMerge ? diffInfoComposite.getEnd(2) : diffInfoComposite.getEnd(1);
        int n5 = n3;
        while (n5 <= n4) {
            object = (TextComposite)this.tableComposite.elementAt(n5);
            ((TextComposite)object).flag = (byte)(((TextComposite)object).flag ^ 2);
            ++n5;
        }
        object = (DiffInfoCommon)this.diffTableOutput.elementAt(n);
        int n6 = ((DiffInfoCommon)object).getStartBlock();
        int n7 = ((DiffInfoCommon)object).getEndBlock();
        int n8 = n6;
        while (n8 <= n7) {
            TextRefOutput textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n8);
            textRefOutput.flag = (byte)(textRefOutput.flag ^ 2);
            ++n8;
        }
        diffInfoComposite = (DiffInfoComposite)this.diffTableComposite.elementAt(n2);
        n3 = diffInfoComposite.getStart(0);
        n4 = !this.isTwowayMerge ? diffInfoComposite.getEnd(2) : diffInfoComposite.getEnd(1);
        int n9 = n3;
        while (n9 <= n4) {
            TextComposite textComposite = (TextComposite)this.tableComposite.elementAt(n9);
            textComposite.flag = (byte)(textComposite.flag | 2);
            ++n9;
        }
        object = (DiffInfoCommon)this.diffTableOutput.elementAt(n2);
        n6 = ((DiffInfoCommon)object).getStartBlock();
        n7 = ((DiffInfoCommon)object).getEndBlock();
        int n10 = n6;
        while (n10 <= n7) {
            TextRefOutput textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n10);
            textRefOutput.flag = (byte)(textRefOutput.flag | 2);
            ++n10;
        }
    }

    public void print() {
        int n = this.tableComposite.size();
        System.out.println(n);
        int n2 = 0;
        while (n2 < n) {
            TextComposite textComposite = new TextComposite();
            textComposite = (TextComposite)this.tableComposite.elementAt(n2);
            byte by = textComposite.flag;
            String string = Integer.toHexString(by);
            System.out.println(string);
            ++n2;
        }
        System.out.println("=======================");
    }

    public Vector getTableComposite() {
        return this.tableComposite;
    }

    public Vector getTableOutput() {
        return this.tableOutput;
    }

    public Vector getTableFileZero() {
        return this.tableFileZero;
    }

    public Vector getTableFileOne() {
        return this.tableFileOne;
    }

    public Vector getTableFileTwo() {
        return this.tableFileTwo;
    }

    public Vector getTableEdit() {
        return this.tableEdit;
    }

    public Vector getUndoTable() {
        return this.tableUndo;
    }

    public Vector getDiffTableComposite() {
        return this.diffTableComposite;
    }

    public Vector getDiffTableOutput() {
        return this.diffTableOutput;
    }

    public Vector getDiffTableFileZero() {
        return this.diffTableFileZero;
    }

    public Vector getDiffTableFileOne() {
        return this.diffTableFileOne;
    }

    public Vector getDiffTableFileTwo() {
        return this.diffTableFileTwo;
    }

    public DiffInput getDiffInput() {
        return this.diffInput;
    }
}

