/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.reuse.awt.ButtonPanel;
import com.ibm.vatc.reuse.awt.EButton;
import com.ibm.vatc.reuse.awt.GridTools;
import com.ibm.vatc.tcmerge.DiffInput;
import com.ibm.vatc.tcmerge.Location;
import com.ibm.vatc.tcmerge.MergeOptionsDialog;
import com.ibm.vatc.tcmerge.SingleLineCanvas;
import com.ibm.vatc.tcmerge.TCMergeException;
import com.ibm.vatc.tcmerge.TCMergeHelp;
import com.ibm.vatc.tcmerge.WarningDialog;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Label;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

class MergeFilesDialog
extends Dialog {
    Frame parentFrame;
    TextField file1TextField;
    TextField file2TextField;
    TextField file3TextField;
    TextField outputTextField;
    Checkbox replaceCheckbox;
    String action;
    DiffInput diffInput;
    boolean recalculate;
    boolean modalOn;
    MergeOptionsDialog mergeOptionsDialog;
    Location fileLocators;
    String CWD;

    public MergeFilesDialog(Frame frame, DiffInput diffInput, Location location) {
        super(frame, tcmerge.locResource.getString("TITLE_MERGE_FILE"), true);
        this.parentFrame = frame;
        this.diffInput = diffInput;
        this.fileLocators = location;
        ((Component)this).setSize(355, 415);
        this.setLayout(new GridBagLayout());
        this.recalculate = false;
        this.modalOn = false;
        ((Component)this).setFont(tcmerge.getDefaultFont());
        this.CWD = System.getProperty("user.dir");
        DialogListener dialogListener = new DialogListener();
        this.addWindowListener(dialogListener);
        KeyboardListener keyboardListener = new KeyboardListener();
        this.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_Input")), (int)1, (int)1, (int)1, (int)1);
        GridTools.constrain((Container)this, (Component)new SingleLineCanvas(270), (int)2, (int)1, (int)4, (int)1);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_FILE1")), (int)2, (int)2, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        this.file1TextField = diffInput.numInputFiles() >= 1 ? new TextField(diffInput.getInputFileAt(0), 20) : new TextField(20);
        this.file1TextField.setFont(tcmerge.getDefaultFont());
        this.file1TextField.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)this.file1TextField, (int)2, (int)3, (int)2, (int)1);
        EButton eButton = new EButton(tcmerge.locResource.getString("STR_BROWSE"));
        eButton.setActionCommand("browse1");
        eButton.addActionListener(new ButtonListener());
        eButton.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)eButton, (int)5, (int)3, (int)1, (int)1);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_FILE2")), (int)2, (int)4, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        this.file2TextField = diffInput.numInputFiles() >= 2 ? new TextField(diffInput.getInputFileAt(1), 20) : new TextField(20);
        this.file2TextField.setFont(tcmerge.getDefaultFont());
        this.file2TextField.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)this.file2TextField, (int)2, (int)5, (int)2, (int)1);
        EButton eButton2 = new EButton(tcmerge.locResource.getString("STR_BROWSE"));
        eButton2.setActionCommand("browse2");
        eButton2.addActionListener(new ButtonListener());
        eButton2.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)eButton2, (int)5, (int)5, (int)1, (int)1);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_FILE3")), (int)2, (int)6, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        this.file3TextField = diffInput.numInputFiles() >= 3 ? new TextField(diffInput.getInputFileAt(2), 20) : new TextField(20);
        this.file3TextField.setFont(tcmerge.getDefaultFont());
        this.file3TextField.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)this.file3TextField, (int)2, (int)7, (int)2, (int)1);
        EButton eButton3 = new EButton(tcmerge.locResource.getString("STR_BROWSE"));
        eButton3.setActionCommand("browse3");
        eButton3.addActionListener(new ButtonListener());
        eButton3.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)eButton3, (int)5, (int)7, (int)1, (int)1);
        EButton eButton4 = new EButton(tcmerge.locResource.getString("STR_MERGE_OPTIONS"));
        eButton4.setActionCommand("mergeOptions");
        eButton4.addActionListener(new ButtonListener());
        eButton4.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)eButton4, (int)2, (int)9, (int)1, (int)1);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_Output")), (int)1, (int)11, (int)1, (int)1);
        GridTools.constrain((Container)this, (Component)new SingleLineCanvas(270), (int)2, (int)11, (int)4, (int)1);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_OUTPUT_FILE_NAME")), (int)2, (int)12, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        this.outputTextField = new TextField("", 20);
        this.outputTextField.setFont(tcmerge.getDefaultFont());
        GridTools.constrain((Container)this, (Component)this.outputTextField, (int)2, (int)13, (int)2, (int)1);
        EButton eButton5 = new EButton(tcmerge.locResource.getString("STR_BROWSE"));
        eButton5.setActionCommand("browseOutput");
        eButton5.addActionListener(new ButtonListener());
        eButton5.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)eButton5, (int)5, (int)13, (int)1, (int)1);
        this.replaceCheckbox = new Checkbox(tcmerge.locResource.getString("STR_REPLACE"), diffInput.getReplace());
        this.replaceCheckbox.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)this.replaceCheckbox, (int)2, (int)14, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        String[][] stringArray = new String[][]{{tcmerge.locResource.getString("STR_OK"), "OK"}, {tcmerge.locResource.getString("STR_CANCEL"), "Cancel"}, {tcmerge.locResource.getString("STR_HELP"), "Help"}};
        ButtonPanel buttonPanel = new ButtonPanel(stringArray, (ActionListener)new ButtonListener());
        buttonPanel.addKeyListener((KeyListener)keyboardListener);
        GridTools.constrain((Container)this, (Component)buttonPanel, (int)2, (int)16, (int)4, (int)1, (int)0, (int)0, (int)13, (int)0);
        Canvas canvas = new Canvas();
        canvas.setSize(20, 15);
        GridTools.constrain((Container)this, (Component)canvas, (int)4, (int)8, (int)1, (int)1);
        Canvas canvas2 = new Canvas();
        canvas2.setSize(15, 15);
        GridTools.constrain((Container)this, (Component)canvas2, (int)6, (int)10, (int)1, (int)1);
        Canvas canvas3 = new Canvas();
        canvas3.setSize(1, 20);
        GridTools.constrain((Container)this, (Component)canvas3, (int)1, (int)15, (int)1, (int)1);
        Canvas canvas4 = new Canvas();
        canvas4.setSize(1, 15);
        GridTools.constrain((Container)this, (Component)canvas4, (int)1, (int)17, (int)1, (int)1);
        this.pack();
        Dimension dimension = this.parentFrame.getSize();
        Dimension dimension2 = this.getSize();
        try {
            Point point = this.parentFrame.getLocationOnScreen();
            ((Component)this).setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
            return;
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            Dimension dimension3 = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dimension3.width - dimension2.width) / 2, (dimension3.height - dimension2.height) / 2);
            return;
        }
    }

    public String getAction() {
        return this.action;
    }

    public boolean recalculateNeeded() {
        return this.recalculate;
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
            MergeFilesDialog.this = MergeFilesDialog.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.startsWith("browse")) {
                String string2 = string.substring(6);
                String string3 = tcmerge.locResource.getString("STR_FILE" + string2);
                FileDialog fileDialog = new FileDialog(MergeFilesDialog.this.parentFrame, string3, 0);
                ((Component)fileDialog).setFont(tcmerge.getDefaultFont());
                String string4 = "";
                if (MergeFilesDialog.this.fileLocators != null) {
                    if (string2.equals("1")) {
                        string4 = MergeFilesDialog.this.fileLocators.getPrimeLocation();
                    } else if (string2.equals("2")) {
                        string4 = MergeFilesDialog.this.fileLocators.getFirstLocation();
                    } else if (string2.equals("3")) {
                        string4 = MergeFilesDialog.this.fileLocators.getSecondLocation();
                    } else if (string2.equals("Output")) {
                        string4 = MergeFilesDialog.this.fileLocators.getOutputLocation();
                    }
                    if (string4 != null && new File(string4).isDirectory()) {
                        fileDialog.setDirectory(string4);
                    }
                }
                fileDialog.show();
                String string5 = fileDialog.getDirectory();
                if (string5 != null && !string5.equals(string4)) {
                    string5 = String.valueOf(string5) + fileDialog.getFile();
                    if (string2.equals("1")) {
                        ((TextComponent)MergeFilesDialog.this.file1TextField).setText(string5);
                        return;
                    }
                    if (string2.equals("2")) {
                        ((TextComponent)MergeFilesDialog.this.file2TextField).setText(string5);
                        return;
                    }
                    if (string2.equals("3")) {
                        ((TextComponent)MergeFilesDialog.this.file3TextField).setText(string5);
                        return;
                    }
                    if (string2.equals("Output")) {
                        ((TextComponent)MergeFilesDialog.this.outputTextField).setText(string5);
                        if (System.getProperty("os.name").equals("Windows NT") || System.getProperty("os.name").equals("Windows 95")) {
                            MergeFilesDialog.this.replaceCheckbox.setState(true);
                        }
                        return;
                    }
                }
            } else if (string.equals("mergeOptions")) {
                if (MergeFilesDialog.this.modalOn) {
                    return;
                }
                MergeFilesDialog.this.modalOn = true;
                if (MergeFilesDialog.this.mergeOptionsDialog == null) {
                    MergeFilesDialog.this.mergeOptionsDialog = MergeFilesDialog.this.file3TextField.getText().equals("") ? new MergeOptionsDialog(MergeFilesDialog.this.parentFrame, 2) : new MergeOptionsDialog(MergeFilesDialog.this.parentFrame, 3);
                    MergeFilesDialog.this.mergeOptionsDialog.setIgnoreBlanksAnswer(MergeFilesDialog.this.diffInput.getIgnoreBlanks());
                    MergeFilesDialog.this.mergeOptionsDialog.setIgnoreUniqueDifferencesAnswer(MergeFilesDialog.this.diffInput.getIgnoreDiff());
                    MergeFilesDialog.this.mergeOptionsDialog.setPrimeOutputFileAnswer(MergeFilesDialog.this.diffInput.getPrimeOutput());
                    MergeFilesDialog.this.mergeOptionsDialog.setColumnsToIgnoreAnswer(MergeFilesDialog.this.diffInput.getColsToIgnore());
                    MergeFilesDialog.this.mergeOptionsDialog.setIgnoreCaseSensitiveAnswer(MergeFilesDialog.this.diffInput.getIgnoreCaseSensitive());
                    MergeFilesDialog.this.mergeOptionsDialog.setAutomergeAnswer(MergeFilesDialog.this.diffInput.getAutomerge());
                    MergeFilesDialog.this.mergeOptionsDialog.setIgnoreBlankLinesAnswer(MergeFilesDialog.this.diffInput.getIgnoreBlankLines());
                    MergeFilesDialog.this.mergeOptionsDialog.setTitlesAnswer(MergeFilesDialog.this.diffInput.getTitles());
                    MergeFilesDialog.this.mergeOptionsDialog.createDialog();
                } else if (MergeFilesDialog.this.file3TextField.getText().equals("")) {
                    MergeFilesDialog.this.mergeOptionsDialog.setNumFiles(2);
                } else {
                    MergeFilesDialog.this.mergeOptionsDialog.setNumFiles(3);
                }
                MergeFilesDialog.this.mergeOptionsDialog.show();
                MergeFilesDialog.this.modalOn = false;
                if (!MergeFilesDialog.this.mergeOptionsDialog.getAction().equals("OK")) {
                    MergeFilesDialog.this.mergeOptionsDialog.dispose();
                    MergeFilesDialog.this.mergeOptionsDialog = null;
                    return;
                }
            } else {
                if (string.equals("OK")) {
                    if (MergeFilesDialog.this.modalOn) {
                        return;
                    }
                    try {
                        String string6 = MergeFilesDialog.this.file1TextField.getText();
                        if (string6.equals("")) {
                            throw new TCMergeException(3, tcmerge.locResource.getString("STR_INPUT_FILE_1"));
                        }
                        File file = new File(string6);
                        if (file.isDirectory()) {
                            throw new TCMergeException(29, string6);
                        }
                        if (!file.canRead()) {
                            throw new TCMergeException(1, string6);
                        }
                        if (MergeFilesDialog.this.diffInput.numInputFiles() >= 1) {
                            if (!MergeFilesDialog.this.diffInput.getInputFileAt(0).equals(string6)) {
                                MergeFilesDialog.this.diffInput.setInputFileAt(string6, 0);
                                MergeFilesDialog.this.recalculate = true;
                            }
                        } else {
                            MergeFilesDialog.this.diffInput.addInputFile(string6);
                        }
                        if ((string6 = MergeFilesDialog.this.file2TextField.getText()).equals("")) {
                            throw new TCMergeException(3, tcmerge.locResource.getString("STR_INPUT_FILE_2"));
                        }
                        file = new File(string6);
                        if (file.isDirectory()) {
                            throw new TCMergeException(29, string6);
                        }
                        if (!file.canRead()) {
                            throw new TCMergeException(1, string6);
                        }
                        if (MergeFilesDialog.this.diffInput.numInputFiles() >= 2) {
                            if (!MergeFilesDialog.this.diffInput.getInputFileAt(1).equals(string6)) {
                                MergeFilesDialog.this.diffInput.setInputFileAt(string6, 1);
                                MergeFilesDialog.this.recalculate = true;
                            }
                        } else {
                            MergeFilesDialog.this.diffInput.addInputFile(string6);
                        }
                        if (!(string6 = MergeFilesDialog.this.file3TextField.getText()).equals("")) {
                            file = new File(string6);
                            if (file.isDirectory()) {
                                throw new TCMergeException(29, string6);
                            }
                            if (!file.canRead()) {
                                throw new TCMergeException(1, string6);
                            }
                            if (MergeFilesDialog.this.diffInput.numInputFiles() >= 3) {
                                if (!MergeFilesDialog.this.diffInput.getInputFileAt(2).equals(string6)) {
                                    MergeFilesDialog.this.diffInput.setInputFileAt(string6, 2);
                                    MergeFilesDialog.this.recalculate = true;
                                }
                            } else {
                                MergeFilesDialog.this.diffInput.addInputFile(string6);
                                MergeFilesDialog.this.recalculate = true;
                            }
                        } else if (MergeFilesDialog.this.diffInput.numInputFiles() >= 3) {
                            MergeFilesDialog.this.diffInput.removeInputFileAt(2);
                            MergeFilesDialog.this.recalculate = true;
                        }
                        if ((string6 = MergeFilesDialog.this.outputTextField.getText()).equals("")) {
                            MergeFilesDialog.this.diffInput.setOutputFile("");
                        } else {
                            file = new File(string6);
                            if (file.isDirectory()) {
                                throw new TCMergeException(29, string6);
                            }
                            if (file.exists() && !file.canWrite()) {
                                throw new TCMergeException(20, string6);
                            }
                            if (file.exists() && !MergeFilesDialog.this.replaceCheckbox.getState()) {
                                throw new TCMergeException(4, string6);
                            }
                            MergeFilesDialog.this.diffInput.setOutputFile(string6);
                            MergeFilesDialog.this.diffInput.setReplace(true);
                        }
                        if (MergeFilesDialog.this.mergeOptionsDialog != null) {
                            if (MergeFilesDialog.this.mergeOptionsDialog.getAction().equals("OK")) {
                                if (MergeFilesDialog.this.mergeOptionsDialog.recalculateNeeded()) {
                                    MergeFilesDialog.this.recalculate = true;
                                }
                                MergeFilesDialog.this.diffInput.setIgnoreBlanks(MergeFilesDialog.this.mergeOptionsDialog.getIgnoreBlanksAnswer());
                                MergeFilesDialog.this.diffInput.setPrimeOutput(MergeFilesDialog.this.mergeOptionsDialog.getPrimeOutputFileAnswer());
                                MergeFilesDialog.this.diffInput.setColsToIgnore(MergeFilesDialog.this.mergeOptionsDialog.getColumnsToIgnoreAnswer());
                                MergeFilesDialog.this.diffInput.setIgnoreCaseSensitive(MergeFilesDialog.this.mergeOptionsDialog.getIgnoreCaseSensitiveAnswer());
                                MergeFilesDialog.this.diffInput.setTitles(MergeFilesDialog.this.mergeOptionsDialog.getTitlesAnswer());
                                MergeFilesDialog.this.diffInput.setIgnoreBlankLines(MergeFilesDialog.this.mergeOptionsDialog.getIgnoreBlankLinesAnswer());
                                if (MergeFilesDialog.this.diffInput.numInputFiles() == 2) {
                                    MergeFilesDialog.this.diffInput.setAutomerge(false);
                                    MergeFilesDialog.this.diffInput.setIgnoreDiff(-1);
                                    if (MergeFilesDialog.this.diffInput.getPrimeOutput() == 2) {
                                        MergeFilesDialog.this.diffInput.setPrimeOutput(-1);
                                    }
                                } else {
                                    MergeFilesDialog.this.diffInput.setAutomerge(MergeFilesDialog.this.mergeOptionsDialog.getAutomergeAnswer());
                                    MergeFilesDialog.this.diffInput.setIgnoreDiff(MergeFilesDialog.this.mergeOptionsDialog.getIgnoreUniqueDifferencesAnswer());
                                }
                            }
                            MergeFilesDialog.this.mergeOptionsDialog.dispose();
                        }
                        MergeFilesDialog.this.diffInput.clearInputDirectories();
                        MergeFilesDialog.this.diffInput.setOutputDirectory("");
                        MergeFilesDialog.this.action = "OK";
                        ((Component)MergeFilesDialog.this).setVisible(false);
                        return;
                    }
                    catch (TCMergeException tCMergeException) {
                        WarningDialog warningDialog = new WarningDialog(MergeFilesDialog.this.parentFrame, tCMergeException.toString());
                        MergeFilesDialog.this.modalOn = true;
                        warningDialog.show();
                        MergeFilesDialog.this.modalOn = false;
                        warningDialog.dispose();
                        return;
                    }
                }
                if (string.equals("Cancel")) {
                    if (MergeFilesDialog.this.modalOn) {
                        return;
                    }
                    MergeFilesDialog.this.action = "CANCEL";
                    ((Component)MergeFilesDialog.this).setVisible(false);
                    return;
                }
                if (string.equals("Help")) {
                    TCMergeHelp.showHelp(MergeFilesDialog.this.parentFrame, "HDRHDI0250");
                }
            }
        }
    }

    class DialogListener
    extends WindowAdapter {
        int aixkluge;

        public void windowClosing(WindowEvent windowEvent) {
            if (MergeFilesDialog.this.modalOn) {
                return;
            }
            MergeFilesDialog.this.action = "CANCEL";
            ((Component)MergeFilesDialog.this).setVisible(false);
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (this.aixkluge == 0) {
                MergeFilesDialog.this.file1TextField.requestFocus();
            }
            this.aixkluge = 1;
        }

        DialogListener() {
            MergeFilesDialog.this = MergeFilesDialog.this;
        }
    }

    class KeyboardListener
    extends KeyAdapter {
        KeyboardListener() {
            MergeFilesDialog.this = MergeFilesDialog.this;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                MergeFilesDialog.this.action = "CANCEL";
                ((Component)MergeFilesDialog.this).setVisible(false);
            }
        }
    }
}

