CREATE TABLE ERWPart_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     description               VarChar(254)   ,
     note                      VarChar(254)   ,
     constraint PKERWPart_version Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWObject 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     created                   VarChar(254)   ,
     updated                   VarChar(254)   ,
     constraint PKERWObject Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWObject AS --Plasma for ERWObject
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWObject a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWPycOjtvs   -- ERWPhysicalObject_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     targetServerID            Int   ,
     objectTypeCode            Int   ,
     objectTypeName            VarChar(254)   ,
     inSchema                  DBOID   ,
     inLibrary                 DBOID   ,
     constraint PKERPycOjtvs Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWPhysObjProperty 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     propertyType              VarChar(254)   ,
     isString                  Int   ,
     isNumber                  Int   ,
     isReference               Int   ,
     stringVal                 Blob(1G) COMPACT    ,
     numberVal                 Int   ,
     blobVal                   Blob(1G) COMPACT    ,
     forPhysObject             DBOID   ,
     constraint PKERWPhysObjPrprty Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_EWhsbPpt AS --Plasma for ERWPhysObjProperty
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWPhysObjProperty a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWProperty 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     propertyType              VarChar(254)   ,
     count                     Int   ,
     datatype                  VarChar(254)   ,
     note                      VarChar(254)   ,
     description               VarChar(254)   ,
     forObject                 DBOID   ,
     forPart                   DBOID   ,
     constraint PKERWProperty Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWProperty AS --Plasma for ERWProperty
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWProperty a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWPartition 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     partitionNo               Int   ,
     cardinality               Int   ,
     freePage                  Int   ,
     pctFree                   Int   ,
     pctActive                 Int   ,
     pctDrop                   Int   ,
     space                     Int   ,
     statsTime                 VarChar(254)   ,
     GBPCache                  Int   ,
     farIndRef                 Int   ,
     nearIndRef                Int   ,
     farOnPos                  Int   ,
     nearOffPos                Int   ,
     leafDist                  Int   ,
     chkFlag                   Int   ,
     checkRID                  VarChar(254)   ,
     pageSave                  Int   ,
     forTable                  DBOID   ,
     usedBy                    DBOID   ,
     constraint PKERWPartition Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWPartition AS --Plasma for ERWPartition
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWPartition a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWPropertyValue 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     propertyType              VarChar(254)   ,
     elementIndex              Int   ,
     value                     Int   ,
     property                  DBOID   ,
     constraint PKERWPropertyValue Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWPropertyValu AS --Plasma for ERWPropertyValue
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWPropertyValue a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWDataType 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     typeName                  VarChar(254)   ,
     constraint PKERWDataType Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWDataType AS --Plasma for ERWDataType
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWDataType a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWModelObject 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     objectID                  Int   ,
     objectName                VarChar(254)   ,
     objectType                VarChar(254)   ,
     description               VarChar(254)   ,
     note                      VarChar(254)   ,
     constraint PKERWModelObject Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWModelObject AS --Plasma for ERWModelObject
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWModelObject a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWPropertyDefintn   -- ERWPropertyDefinition
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     isHidden                  Int   ,
     dataType                  VarChar(254)   ,
     defaultValue              VarChar(254)   ,
     constraint PKERWPropertyDfntn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWProprtyDfntn AS --Plasma for ERWPropertyDefinition
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWPropertyDefintn a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWAttribute 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     ofEntity                  DBOID   ,
     forSubType                DBOID   ,
     constraint PKERWAttribute Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWAttribute AS --Plasma for ERWAttribute
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWAttribute a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWColumn 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     loggedLOB                 Int   ,
     compactLOB                Int   ,
     nullsAllowed              Int   ,
     usesDomain                DBOID   ,
     forTable                  DBOID   ,
     view                      DBOID   ,
     constraint PKERWColumn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWColumn AS --Plasma for ERWColumn
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWColumn a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWTable_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     audit                     Int   ,
     usingHashing              Int   ,
     targetServerID            Int   ,
     icon                      Blob(1G) COMPACT    ,
     alterDTS                  VarChar(254)   ,
     chkFlag                   Int   ,
     chkRID                    VarChar(254)   ,
     dataCaptureFlag           Int   ,
     editProc                  VarChar(254)   ,
     pctPages                  Int   ,
     pctRowComp                Int   ,
     recordLength              Int   ,
     validProc                 VarChar(254)   ,
     restrictOnDrop            Int   ,
     CCSID                     Int   ,
     numPartitions             Int   ,
     randUpdateFlag            Int   ,
     logPrimary                Int   ,
     logSecondary              Int   ,
     logFileSize               Int   ,
     initByForeignSrc          Int   ,
     notLoggedInitially        Int   ,
     catalogDBID               Int   ,
     catalogOBID               Int   ,
     keyOBID                   Int   ,
     numPages                  Int   ,
     index                     DBOID   ,
     longIn                    DBOID   ,
     indexIn                   DBOID   ,
     storedIn                  DBOID   ,
     inSchema                  DBOID   ,
     containedBy               DBOID   ,
     inRelationship            DBOID   ,
     hasPartitioningKey        DBOID   ,
     constraint PKERWTable_version Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWEntity_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     icon                      Blob(1G) COMPACT    ,
     inRelationship            DBOID   ,
     inDiagram                 DBOID   ,
     inSubtypeSet              DBOID   ,
     constraint PKERWEntity_versin Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWSubjectAre_vrsn   -- ERWSubjectArea_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     diagram                   DBOID   ,
     constraint PKERWSubjctAr_vrsn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWSynonym_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     forTable                  DBOID   ,
     constraint PKERWSynonym_versn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWDiagram_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     modelType                 Int   ,
     client                    DBOID   ,
     pDBMS                     DBOID   ,
     inLibrary                 DBOID   ,
     constraint PKERWDiagram_versn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWLibrary_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     inLibrary                 DBOID   ,
     constraint PKERWLibrary_versn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWDBMS_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     DBMSType                  VarChar(254)   ,
     majorVersion              Int   ,
     minorVersion1             Int   ,
     minorVersion2             Int   ,
     diagram                   DBOID   ,
     constraint PKERWDBMS_version Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWView_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     query                     VarChar(254)   ,
     where                     VarChar(254)   ,
     groupBy                   VarChar(254)   ,
     orderBy                   VarChar(254)   ,
     withCheck                 Int   ,
     body                      VarChar(254)   ,
     distinct                  Int   ,
     having                    VarChar(254)   ,
     force                     Int   ,
     orReplace                 Int   ,
     constraintName            VarChar(254)   ,
     wOption                   Int   ,
     derivedBy                 DBOID   ,
     diagram                   DBOID   ,
     containedBy               DBOID   ,
     constraint PKERWView_version Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWGraphicFeature 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     featureType               VarChar(254)   ,
     value                     Int   ,
     parentObject              DBOID   ,
     pStoredDisplay            DBOID   ,
     hasProperty               DBOID   ,
     constraint PKERWGraphicFeatur Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWGraphicFeatr AS --Plasma for ERWGraphicFeature
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWGraphicFeature a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWStoredDisplay 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     subjectArea               DBOID   ,
     constraint PKERWStoredDisplay Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWStoredDisply AS --Plasma for ERWStoredDisplay
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWStoredDisplay a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWTextBlock 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     diagram                   DBOID   ,
     constraint PKERWTextBlock Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWTextBlock AS --Plasma for ERWTextBlock
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWTextBlock a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWRelationship 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     diagram                   DBOID   ,
     constraint PKERWRelationship Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWRelationship AS --Plasma for ERWRelationship
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWRelationship a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWDepndncyRltnshp   -- ERWDependencyRelationship
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     parentEntity              DBOID   ,
     childEntity               DBOID   ,
     constraint PKERDnnylnh Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_RDnnylnh AS --Plasma for ERWDependencyRelationship
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWDepndncyRltnshp a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWSubType 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     hasDiscriminator          DBOID   ,
     parentEntity              DBOID   ,
     constraint PKERWSubType Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWSubType AS --Plasma for ERWSubType
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWSubType a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWDefaultValue 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     library                   DBOID   ,
     constraint PKERWDefaultValue Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWDefaultValue AS --Plasma for ERWDefaultValue
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWDefaultValue a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWValidValue 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     library                   DBOID   ,
     validationRule            DBOID   ,
     constraint PKERWValidValue Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWValidValue AS --Plasma for ERWValidValue
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWValidValue a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWValidationRule 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     library                   DBOID   ,
     constraint PKERWValidationRul Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWValidationRl AS --Plasma for ERWValidationRule
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWValidationRule a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWTriggerTemplate 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     triggerCode               VarChar(254)   ,
     triggerType               VarChar(254)   ,
     disabled                  Int   ,
     triggerFire               Int   ,
     triggerScope              Int   ,
     library                   DBOID   ,
     constraint PKERWTriggerTemplt Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWTriggerTmplt AS --Plasma for ERWTriggerTemplate
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWTriggerTemplate a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWTrigger 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     diagram                   DBOID   ,
     constraint PKERWTrigger Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWTrigger AS --Plasma for ERWTrigger
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWTrigger a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWClient 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     version                   VarChar(254)   ,
     diagram                   DBOID   ,
     constraint PKERWClient Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWClient AS --Plasma for ERWClient
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWClient a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWDatabase_versin   -- ERWDatabase_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     catalogDBID               Int   ,
     codePage                  VarChar(254)   ,
     driveLetter               Int   ,
     ROShare                   VarChar(254)   ,
     CCSID                     Int   ,
     constraint PKERWDatabase_vrsn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWNodeGroup_versn   -- ERWNodeGroup_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     allNodes                  Int   ,
     numNodes                  Int   ,
     constraint PKERWNodeGrop_vrsn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWBufferPool_vrsn   -- ERWBufferPool_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     bufPoolNo                 Int   ,
     bufSize                   Int   ,
     bufType                   Int   ,
     usageIntent               VarChar(254)   ,
     allNodes                  Int   ,
     extendedStorage           Int   ,
     constraint PKERWBufferPl_vrsn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWStorageGrp_vrsn   -- ERWStorageGroup_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     password                  VarChar(254)   ,
     pwdFlag                   Int   ,
     space                     Int   ,
     spaceDate                 VarChar(254)   ,
     defType                   VarChar(254)   ,
     reqdSpace                 Int   ,
     constraint PKERWStorgGrp_vrsn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWTblIndxSpc_vrsn   -- ERWTableIndexSpace_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     freePage                  Int   ,
     pctFree                   Int   ,
     numParts                  Int   ,
     GBPCache                  Int   ,
     closeRule                 Int   ,
     dsetPassword              VarChar(254)   ,
     dsetPwdFlag               Int   ,
     deferRule                 Int   ,
     subPages                  Int   ,
     compressFlag              Int   ,
     implicit                  Int   ,
     locksize                  Int   ,
     nActive                   Int   ,
     nTables                   Int   ,
     pageSize                  Int   ,
     segSize                   Int   ,
     space                     Int   ,
     status                    Int   ,
     lockMax                   Int   ,
     maxValue                  Int   ,
     maxRows                   Int   ,
     lockPart                  Int   ,
     largeTS                   Int   ,
     CCSID                     Int   ,
     keepInMain                Int   ,
     usageIntent               Int   ,
     TSType                    Int   ,
     extentSize                Int   ,
     prefetchSize              Int   ,
     overhead                  VarChar(254)   ,
     transferRate              Int   ,
     managedBy                 Int   ,
     refersToSG                DBOID   ,
     refersToBP                DBOID   ,
     storesIndex               DBOID   ,
     constraint PKEWbIdScvs Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE ERWIndex 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     isUnique                  Int   ,
     clustered                 Int   ,
     numLeafs                  Int   ,
     numLevels                 Int   ,
     clusterRatio              Int   ,
     catalogDBID               Int   ,
     catalogISOBID             Int   ,
     catalogOBID               Int   ,
     pageSize                  Int   ,
     space                     Int   ,
     whereNotNull              Int   ,
     indexType                 Int   ,
     pieceSize                 Int   ,
     dataRcdsInIndx            Int   ,
     distinctValues            Int   ,
     containedBy               DBOID   ,
     storedIn                  DBOID   ,
     constraint PKERWIndex Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWIndex AS --Plasma for ERWIndex
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWIndex a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWIndexColumn 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     isAscending               Int   ,
     sequenceNumber            Int   ,
     forIndex                  DBOID   ,
     memberColumn              DBOID   ,
     constraint PKERWIndexColumn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWIndexColumn AS --Plasma for ERWIndexColumn
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWIndexColumn a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWAlternateKey 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     partitionKeyFor           DBOID   ,
     constraint PKERWAlternateKey Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWAlternateKey AS --Plasma for ERWAlternateKey
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWAlternateKey a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE ERWRIRule 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     parentDeleteRule          VarChar(254)   ,
     parentUpdateRule          VarChar(254)   ,
     parentInsertRule          VarChar(254)   ,
     childDeleteRule           VarChar(254)   ,
     childUpdateRule           VarChar(254)   ,
     childInsertRule           VarChar(254)   ,
     belongsToRel              DBOID   ,
     constraint PKERWRIRule Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_ERWRIRule AS --Plasma for ERWRIRule
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    ERWRIRule a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

