CREATE TABLE DSDBD_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     dliAccess                 DBOID   ,
     versionString             VarChar(254)   ,
     constraint v302PKDSDBD_versin Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSDBDaccess 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     containingDBD             DBOID   ,
     dliAccess                 VarChar(254)   ,
     osAccess                  Int   ,
     passwordFlag              Int   ,
     constraint v302PKDSDBDaccess Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSDBDaccess AS --Plasma for DSDBDaccess
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSDBDaccess a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSDBDdedb 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     rmName                    VarChar(254)   ,
     stage                     Int   ,
     extendedCall              Int   ,
     constraint v302PKDSDBDdedb Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSDBDdedb AS --Plasma for DSDBDdedb
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSDBDdedb a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSDBDhdam 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     relativeBlockNumbr        Int   ,
     rootAnchorPoints          Int   ,
     rootMaxBytes              Int   ,
     constraint v302PKDSDBDhdam Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSDBDhdam AS --Plasma for DSDBDhdam
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSDBDhdam a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSDBDhidam 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     primaryIndex              DBOID   ,
     rootSequenceField         DBOID   ,
     constraint v302PKDSDBDhidam Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSDBDhidam AS --Plasma for DSDBDhidam
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSDBDhidam a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSDBDindex 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     dosCompatibility          Int   ,
     primaryIndexTarget        DBOID   ,
     protect                   Int   ,
     secondaryIndexTrgt        DBOID   ,
     sharedDBD                 DBOID   ,
     constraint v302PKDSDBDindex Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSDBDindex AS --Plasma for DSDBDindex
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSDBDindex a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSDBDmsdb 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     msdbField                 VarChar(254)   ,
     msdbType                  VarChar(254)   ,
     constraint v302PKDSDBDmsdb Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSDBDmsdb AS --Plasma for DSDBDmsdb
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSDBDmsdb a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSSegment 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     compRoutine               DBOID   ,
     containingDBD             DBOID   ,
     exitFlag                  Int   ,
     frequency                 VarChar(254)   ,
     mappingStructure          DBOID   ,
     maximumLength             Int   ,
     minimumLength             Int   ,
     physicalParent            DBOID   ,
     rules                     VarChar(254)   ,
     segmName                  DBOID   ,
     constraint v302PKDSSegment Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSSegment AS --Plasma for DSSegment
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSSegment a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSSegmentComplex 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     dataset                   DBOID   ,
     deleteFlag                Int   ,
     insertFlag                Int   ,
     logParent                 DBOID   ,
     pairedLogChild            DBOID   ,
     replaceFlag               Int   ,
     segmPointer               VarChar(254)   ,
     constraint v302PKDSSgmntCmplx Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSSegmentComplx AS --Plasma for DSSegmentComplex
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSSegmentComplex a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSSegmentDEDB 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     directDependent           Int   ,
     subsetPointers            Int   ,
     constraint v302PKDSSegmntDEDB Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSSegmentDEDB AS --Plasma for DSSegmentDEDB
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSSegmentDEDB a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSSegmentLogical 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     segmentName               VarChar(254)   ,
     constraint v302PKDSSegmntLgcl Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSSegmentLogicl AS --Plasma for DSSegmentLogical
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSSegmentLogical a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSField 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     fldName                   DBOID   ,
     isRootSequence            DBOID   ,
     sequenceField             Int   ,
     sourceSegment             DBOID   ,
     targetDataItem            DBOID   ,
     uniqueSequence            Int   ,
     sharedDataItem            DBOID   ,
     constraint v302PKDSField Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSField AS --Plasma for DSField
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSField a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSXDFLD 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     constant                  VarChar(254)   ,
     exitRoutine               VarChar(254)   ,
     indexSource               DBOID   ,
     nullValue                 VarChar(254)   ,
     sourceSEGMcmpx            DBOID   ,
     symbolic                  Int   ,
     targetDBDindex            DBOID   ,
     xdfldName                 VarChar(254)   ,
     constraint v302PKDSXDFLD Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSXDFLD AS --Plasma for DSXDFLD
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSXDFLD a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSCompRoutine 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     dataOnly                  Int   ,
     initialization            Int   ,
     routine                   VarChar(254)   ,
     segment                   DBOID   ,
     constraint v302PKDSCompRoutin Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSCompRoutine AS --Plasma for DSCompRoutine
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSCompRoutine a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSExit 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     capturedDBD               DBOID   ,
     captureRoutine            VarChar(254)   ,
     cascade                   Int   ,
     cascadeData               Int   ,
     cascadeKey                Int   ,
     cascadePath               Int   ,
     exitData                  Int   ,
     exitKey                   Int   ,
     exitPath                  Int   ,
     logFlag                   Int   ,
     constraint v302PKDSExit Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSExit AS --Plasma for DSExit
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSExit a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSIMSDDname 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     ddsName                   VarChar(254)   ,
     implementedDBDs           DBOID   ,
     constraint v302PKDSIMSDDname Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSIMSDDname AS --Plasma for DSIMSDDname
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSIMSDDname a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSArea 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     areaSize                  Int   ,
     collector                 DBOID   ,
     root                      Int   ,
     rootOverflow              Int   ,
     uow                       Int   ,
     uowOverflow               Int   ,
     constraint v302PKDSArea Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSArea AS --Plasma for DSArea
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSArea a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSIMSDataset 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     collector                 DBOID   ,
     datasetLabel              VarChar(254)   ,
     dd2                       DBOID   ,
     freeBlockFrequency        Int   ,
     freeSpacePercentag        Int   ,
     inputRecordLength         Int   ,
     outputRecordLength        Int   ,
     overflowBlckngFctr        Int   ,
     primaryBlockngFctr        Int   ,
     recordFormat              VarChar(254)   ,
     scanCylinders             Int   ,
     searchAlgorithm           Int   ,
     size1                     Int   ,
     size2                     Int   ,
     constraint v302PKDSIMSDataset Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSIMSDataset AS --Plasma for DSIMSDataset
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSIMSDataset a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSPSB_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     compatibility             Int   ,
     hpPSBName                 VarChar(254)   ,
     ioaSize                   Int   ,
     ioErrorOption             Int   ,
     language                  VarChar(254)   ,
     lockMaximum               Int   ,
     maximumQxCalls            Int   ,
     onlineImageCopy           Int   ,
     ssaSize                   Int   ,
     writeToOperator           Int   ,
     constraint v302PKDSPSB_versin Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSPCB_version 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     list                      Int   ,
     typeOfPCB                 DBOID   ,
     constraint v302PKDSPCB_versin Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSPCBtype 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     typedPCB                  DBOID   ,
     constraint v302PKDSPCBtype Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSPCBtype AS --Plasma for DSPCBtype
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSPCBtype a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSPCBbased 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     baseDBD                   DBOID   ,
     procoptPCB                VarChar(254)   ,
     constraint v302PKDSPCBbased Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSPCBbased AS --Plasma for DSPCBbased
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSPCBbased a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSPCBdb 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     keyLength                 Int   ,
     positioning               Int   ,
     procseq                   DBOID   ,
     sequentialBufferng        VarChar(254)   ,
     constraint v302PKDSPCBdb Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSPCBdb AS --Plasma for DSPCBdb
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSPCBdb a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSPCBtp 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     alternateResponse         Int   ,
     destination               DBOID   ,
     express                   Int   ,
     modify                    Int   ,
     sameTerminal              Int   ,
     constraint v302PKDSPCBtp Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSPCBtp AS --Plasma for DSPCBtp
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSPCBtp a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSOutputDest 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     destinationType           VarChar(254)   ,
     ltermName                 VarChar(254)   ,
     constraint v302PKDSOutputDest Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSOutputDest AS --Plasma for DSOutputDest
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSOutputDest a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSSenSegment 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     parentSenseg              DBOID   ,
     procoptSENSEG             VarChar(254)   ,
     sourcePCB                 DBOID   ,
     subsetPointer1            Int   ,
     subsetPointer2            Int   ,
     subsetPointer3            Int   ,
     subsetPointer4            Int   ,
     subsetPointer5            Int   ,
     subsetPointer6            Int   ,
     subsetPointer7            Int   ,
     subsetPointer8            Int   ,
     targetSegment             DBOID   ,
     constraint v302PKDSSenSegment Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSSenSegment AS --Plasma for DSSenSegment
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSSenSegment a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSSenField 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     replace                   Int   ,
     startPosition             Int   ,
     sourceSENSEG              DBOID   ,
     targetFIELD               DBOID   ,
     constraint v302PKDSSenField Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSSenField AS --Plasma for DSSenField
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSSenField a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSLChild 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     counter                   Int   ,
     lcPointer                 VarChar(254)   ,
     lparent                   Int   ,
     ltwin                     VarChar(254)   ,
     pairedSegment             DBOID   ,
     rules                     VarChar(254)   ,
     virtualParent             VarChar(254)   ,
     constraint v302PKDSLChild Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSLChild AS --Plasma for DSLChild
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSLChild a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSParent 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pcPointer                 VarChar(254)   ,
     constraint v302PKDSParent Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSParent AS --Plasma for DSParent
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSParent a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSSource 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     dataAlso                  Int   ,
     constraint v302PKDSSource Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSSource AS --Plasma for DSSource
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSSource a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSDSColl 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     areaAttributes            DBOID   ,
     datasetAttributes         DBOID   ,
     dsDevice                  VarChar(254)   ,
     dsModel                   VarChar(254)   ,
     constraint v302PKDSDSColl Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSDSColl AS --Plasma for DSDSColl
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSDSColl a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

