CREATE TABLE FHBuildInfo 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     PartTimeStamp             VarChar(254)   ,
     constraint v302PKFHBuildInfo Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE VIEW Pl_FHBuildInfo AS --Plasma for FHBuildInfo
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    FHBuildInfo a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE FHBDependsOnRel 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     manualIncludeFlag         Int   ,
     includePath               VarChar(254)   ,
     constraint v302PKFHBDpndsOnRl Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE VIEW Pl_FHBDependsOnRel AS --Plasma for FHBDependsOnRel
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    FHBDependsOnRel a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE FHBuildEvent_versn   -- FHBuildEvent_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     OIDC                      DBOIDC   ,
     staleIndicatorFlag        Int   ,
     dynamcBldIndctrFlg        Int   ,
     osrelBuilderId            DBOID   ,
     beTS                      VarChar(254)   ,
     pBuilderMsgs              DBOID   ,
     builderRC                 Int   ,
     outputFileParms           VarChar(254)   ,
     buildParms                VarChar(254)   ,
     constraint v30PFBdvtvs Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE TABLE FHBGeneratesInfo 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pBE                       DBOID   ,
     pOutput                   DBOID   ,
     constraint v302PKFHBGenrtsInf Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE VIEW Pl_FHBGeneratesInf AS --Plasma for FHBGeneratesInfo
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    FHBGeneratesInfo a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE FHBuildDictionary 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     key                       DBOID   ,
     startTime                 Int   ,
     buildFrTmprryPrpss        Int   ,
     buildScopeId              DBOID   ,
     constraint v302PKFHBuldDctnry Primary Key( OID ) )
     IN KERNEL ;

CREATE TABLE FHBDictionaryElmnt   -- FHBDictionaryElement
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     pBE                       DBOID   ,
     buildDictId               DBOID   ,
     constraint v30PFBcnyln Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHBuildScope 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     unconditional             Int   ,
     forcedFlag                Int   ,
     pool                      VarChar(254)   ,
     userID                    DBOID   ,
     clientHostId              VarChar(254)   ,
     detailFile                VarChar(254)   ,
     portId                    VarChar(254)   ,
     initialJobNum             Int   ,
     buildFileId               DBOID   ,
     recomputeFlag             Int   ,
     haltFlag                  Int   ,
     buildParms                VarChar(254)   ,
     type                      VarChar(254)   ,
     noKeys                    Int   ,
     osrelWorkAreaId           DBOID   ,
     osrelJobQueue             DBOID   ,
     constraint v302PKFHBuildScope Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHBIntermediateScp   -- FHBIntermediateScope
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     pPart                     DBOID   ,
     buildScopeId              DBOID   ,
     constraint v302KHItmtc Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHBTransformdByInf   -- FHBTransformedByInfo
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     includeFlag               Int   ,
     pBE                       DBOID   ,
     pInput                    DBOID   ,
     constraint v30PFBrsrdyn Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE VIEW Pl_FBrsrdyn AS --Plasma for FHBTransformedByInfo
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    FHBTransformdByInf a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

