/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcadmin;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.MemoryImageSource;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SpinButton
extends JPanel
implements Adjustable,
ActionListener,
KeyListener,
MouseListener,
FocusListener,
Runnable {
    private static final int BUTTON_WIDTH = 9;
    private static final int BUTTON_HEIGHT = 4;
    private static final int MIN_VALUE = Integer.MIN_VALUE;
    private static final int MAX_VALUE = Integer.MAX_VALUE;
    private static final int UP = 0;
    private static final int DOWN = 1;
    private int value;
    private int min_value = Integer.MIN_VALUE;
    private int max_value = Integer.MAX_VALUE;
    private JTextField edit_area;
    private JButton upButton;
    private JButton downButton;
    private int numPositionsShown;
    private boolean prependZeros;
    private int direction = 0;
    Thread spinner;
    private boolean init = false;
    static /* synthetic */ Class class$java$awt$event$AdjustmentListener;

    public SpinButton(int n, int n2, int n3) {
        this.setupSpinButton(n, false);
        this.setRange(n2, n3);
    }

    public SpinButton(int n, boolean bl) {
        this.setupSpinButton(n, bl);
    }

    public void setupSpinButton(int n, boolean bl) {
        this.setLayout(new BorderLayout(0, 0));
        this.numPositionsShown = n;
        this.prependZeros = bl;
        this.edit_area = new JTextField(this.numPositionsShown);
        this.edit_area.addKeyListener(this);
        this.edit_area.addFocusListener(this);
        this.add((Component)this.edit_area, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 0, 0));
        this.upButton = new JButton(new ImageIcon(this.createUpImage()));
        this.upButton.setPreferredSize(new Dimension(15, 10));
        this.upButton.addMouseListener(this);
        this.downButton = new JButton(new ImageIcon(this.createDownImage()));
        this.downButton.setPreferredSize(new Dimension(15, 10));
        this.downButton.addMouseListener(this);
        jPanel.add(this.upButton);
        jPanel.add(this.downButton);
        this.add((Component)jPanel, "East");
        this.min_value = -((0xA ^ n) - 1);
        this.max_value = (0xA ^ n) - 1;
        this.showValue();
        this.setVisible(true);
        this.init = true;
    }

    private Image createUpImage() {
        int n = 9;
        int n2 = 4;
        int[] nArray = new int[36];
        nArray[4] = 1;
        nArray[12] = 1;
        nArray[13] = 1;
        nArray[14] = 1;
        nArray[20] = 1;
        nArray[21] = 1;
        nArray[22] = 1;
        nArray[23] = 1;
        nArray[24] = 1;
        nArray[28] = 1;
        nArray[29] = 1;
        nArray[30] = 1;
        nArray[31] = 1;
        nArray[32] = 1;
        nArray[33] = 1;
        nArray[34] = 1;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[n * n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                nArray3[n3++] = nArray2[n * n4 + n5] == 0 ? 0xFFFFFF : -16777216;
                ++n5;
            }
            ++n4;
        }
        Image image = this.getToolkit().createImage(new MemoryImageSource(n, n2, nArray3, 0, n));
        return image;
    }

    private Image createDownImage() {
        int n = 9;
        int n2 = 4;
        int[] nArray = new int[36];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[13] = 1;
        nArray[14] = 1;
        nArray[15] = 1;
        nArray[21] = 1;
        nArray[22] = 1;
        nArray[23] = 1;
        nArray[31] = 1;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[n * n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                nArray3[n3++] = nArray2[n * n4 + n5] == 0 ? 0xFFFFFF : -16777216;
                ++n5;
            }
            ++n4;
        }
        Image image = this.getToolkit().createImage(new MemoryImageSource(n, n2, nArray3, 0, n));
        return image;
    }

    public void setRange(int n, int n2) {
        this.min_value = n;
        this.max_value = n2;
        if (this.value > this.max_value) {
            this.setValue(this.max_value);
            return;
        }
        if (this.value < this.min_value) {
            this.setValue(this.min_value);
        }
    }

    public int getLower() {
        return this.min_value;
    }

    public int getUpper() {
        return this.max_value;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.edit_area.getMinimumSize().width + this.upButton.getPreferredSize().width, Math.max(this.edit_area.getMinimumSize().height, this.upButton.getPreferredSize().height + this.downButton.getPreferredSize().height));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.edit_area.getPreferredSize().width + this.upButton.getPreferredSize().width, Math.max(this.edit_area.getPreferredSize().height, this.upButton.getPreferredSize().height + this.downButton.getPreferredSize().height));
        return dimension;
    }

    public void setValue(int n) {
        this.value = n;
        this.showValue();
        this.fireAdjustmentValueChanged(new AdjustmentEvent(this, 0, 601, this.value));
    }

    public int getValue() {
        return this.value;
    }

    public void setEnabled(boolean bl) {
        this.edit_area.setEditable(bl);
        this.edit_area.setEnabled(bl);
        this.upButton.setEnabled(bl);
        this.downButton.setEnabled(bl);
        super.setEnabled(bl);
    }

    private void showValue() {
        int n = 0;
        n = this.numPositionsShown - String.valueOf(this.value).length();
        String string = null;
        if (n > 0 && this.prependZeros) {
            int n2 = 0;
            while (n2 < n) {
                string = string == null ? new String("0") : new String(String.valueOf(string) + "0");
                ++n2;
            }
            this.edit_area.setText(String.valueOf(string) + String.valueOf(this.value));
            return;
        }
        this.edit_area.setText(String.valueOf(this.value));
    }

    private void handleIncrement(int n) {
        int n2 = Math.abs(this.value);
        this.value += n - (n2 - n2 / n * n);
        if (this.value > this.max_value) {
            this.value = this.min_value;
        }
        this.showValue();
        this.fireAdjustmentValueChanged(new AdjustmentEvent(this, 0, 601, this.value));
    }

    private void handleDecrement(int n) {
        int n2 = Math.abs(this.value);
        int n3 = n2 - n2 / n * n;
        this.value = n3 == 0 ? (this.value -= n) : (this.value -= n3);
        if (this.value < this.min_value) {
            this.value = this.max_value;
        }
        this.showValue();
        this.fireAdjustmentValueChanged(new AdjustmentEvent(this, 0, 601, this.value));
    }

    public void run() {
        int n = 0;
        int n2 = 300;
        int n3 = 1;
        while (this.spinner != null) {
            if (n > 5) {
                n3 = 5;
            }
            try {
                if (this.direction == 0) {
                    this.handleIncrement(n3);
                } else {
                    this.handleDecrement(n3);
                }
                ++n;
                Thread.sleep(n2);
            }
            catch (Exception exception) {}
        }
    }

    public void handleMouseClicked() {
        if (this.direction == 0) {
            this.handleIncrement(1);
            return;
        }
        this.handleDecrement(1);
    }

    public void start() {
        if (this.spinner == null) {
            this.spinner = new Thread(this);
            this.spinner.start();
        }
    }

    public void stop() {
        if (this.spinner != null) {
            this.spinner.stop();
            this.spinner = null;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object instanceof JTextField) {
            if (keyEvent.getKeyCode() == 38) {
                this.handleIncrement(1);
                return;
            }
            if (keyEvent.getKeyCode() == 40) {
                this.handleDecrement(1);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        this.direction = (JButton)object == this.upButton ? 0 : 1;
        this.handleMouseClicked();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof TextField) {
            this.validateValue();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.edit_area.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.validateValue();
    }

    private void validateValue() {
        StringBuffer stringBuffer = new StringBuffer(this.edit_area.getText());
        int n = 0;
        int n2 = stringBuffer.length();
        if (n2 > 0) {
            while (n < n2 && (stringBuffer.charAt(n) >= '0' && stringBuffer.charAt(n) <= '9' || stringBuffer.charAt(n) == '-')) {
                ++n;
            }
            if (n < n2) {
                this.edit_area.setText(Integer.toString(this.value));
                return;
            }
            int n3 = Integer.parseInt(this.edit_area.getText());
            if (n3 > this.max_value || n3 < this.min_value) {
                this.edit_area.setText(Integer.toString(this.value));
                return;
            }
            this.value = n3;
        }
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.add(class$java$awt$event$AdjustmentListener != null ? class$java$awt$event$AdjustmentListener : (class$java$awt$event$AdjustmentListener = SpinButton.class$("java.awt.event.AdjustmentListener")), adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listenerList.remove(class$java$awt$event$AdjustmentListener != null ? class$java$awt$event$AdjustmentListener : (class$java$awt$event$AdjustmentListener = SpinButton.class$("java.awt.event.AdjustmentListener")), adjustmentListener);
    }

    protected void fireAdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$AdjustmentListener != null ? class$java$awt$event$AdjustmentListener : SpinButton.class$("java.awt.event.AdjustmentListener"))) {
                ((AdjustmentListener)objectArray[n + 1]).adjustmentValueChanged(adjustmentEvent);
            }
            n -= 2;
        }
    }

    public void setMinimum(int n) {
        this.min_value = n;
        if (this.value < this.min_value) {
            this.setValue(this.min_value);
        }
    }

    public int getMinimum() {
        return this.min_value;
    }

    public void setMaximum(int n) {
        this.max_value = n;
        if (this.value > this.max_value) {
            this.setValue(this.max_value);
        }
    }

    public int getMaximum() {
        return this.max_value;
    }

    public void setUnitIncrement(int n) {
    }

    public int getUnitIncrement() {
        return 1;
    }

    public void setBlockIncrement(int n) {
    }

    public int getBlockIncrement() {
        return 1;
    }

    public void setVisibleAmount(int n) {
    }

    public int getVisibleAmount() {
        return 1;
    }

    public int getOrientation() {
        return 0;
    }

    public void setFont(Font font) {
        if (this.init) {
            this.edit_area.setFont(font);
            this.upButton.setFont(font);
            this.downButton.setFont(font);
        }
        super.setFont(font);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

