/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcadmin;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class TextLimit {
    ActionListener oldKeyHandler;
    ActionListener oldPasteHandler;
    int limit = 32;

    private TextLimit(JTextComponent jTextComponent, int n) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(86, 2);
        this.oldPasteHandler = jTextComponent.getKeymap().getAction(keyStroke);
        this.oldKeyHandler = jTextComponent.getKeymap().getDefaultAction();
        Keymap keymap = JTextComponent.getKeymap("LimitedTextKeyMap" + n);
        if (keymap == null) {
            keymap = JTextComponent.addKeymap("LimitedTextKeyMap" + n, jTextComponent.getKeymap());
            keymap.setDefaultAction(new UndefinedAction());
            keymap.removeKeyStrokeBinding(keyStroke);
            keymap.addActionForKeyStroke(keyStroke, new InsertLimitAction());
        }
        jTextComponent.setKeymap(keymap);
        this.limit = n;
    }

    public static void limit(JTextComponent jTextComponent, int n) {
        new TextLimit(jTextComponent, n);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Key limit of JTextComponent");
        JTextField jTextField = new JTextField("Limit 10");
        JTextArea jTextArea = new JTextArea("Limit 50");
        jFrame.getContentPane().add((Component)jTextField, "North");
        jFrame.getContentPane().add((Component)jTextArea, "Center");
        TextLimit.limit(jTextField, 10);
        TextLimit.limit(jTextArea, 50);
        ((Component)jFrame).setSize(640, 480);
        ((Component)jFrame).setVisible(true);
    }

    class UndefinedAction
    extends TextAction {
        public UndefinedAction() {
            super("default-typed");
            TextLimit.this = TextLimit.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent.isEditable()) {
                char c;
                byte[] byArray;
                int n = 0;
                String string = jTextComponent.getSelectedText();
                if (string != null) {
                    byArray = string.getBytes();
                    n = byArray.length;
                }
                byArray = jTextComponent.getText().getBytes();
                String string2 = actionEvent.getActionCommand();
                byte[] byArray2 = string2.getBytes();
                int n2 = actionEvent.getModifiers();
                if (string2 != null && string2.length() > 0 && (n2 & 8) == 0 && (c = string2.charAt(0)) >= ' ' && c != '\u007f') {
                    if (byArray.length - n + byArray2.length > TextLimit.this.limit) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    TextLimit.this.oldKeyHandler.actionPerformed(actionEvent);
                }
            }
        }
    }

    class InsertLimitAction
    extends DefaultEditorKit.PasteAction {
        InsertLimitAction() {
            TextLimit.this = TextLimit.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent.isEditable()) {
                byte[] byArray;
                int n = 0;
                String string = jTextComponent.getSelectedText();
                if (string != null) {
                    byArray = string.getBytes();
                    n = byArray.length;
                }
                byArray = jTextComponent.getText().getBytes();
                byte[] byArray2 = null;
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(jTextComponent);
                if (transferable != null) {
                    try {
                        String string2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        byArray2 = string2.getBytes();
                    }
                    catch (Exception exception) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
                if (byArray.length - n + byArray2.length > TextLimit.this.limit) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (TextLimit.this.oldPasteHandler != null) {
                    TextLimit.this.oldPasteHandler.actionPerformed(actionEvent);
                    return;
                }
                super.actionPerformed(actionEvent);
            }
        }
    }
}

