/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.reuse.awt.EButton;
import com.ibm.vatc.reuse.awt.GridTools;
import com.ibm.vatc.reuse.awt.ImageButton;
import com.ibm.vatc.tcmerge.DirectoryCanvas;
import com.ibm.vatc.tcmerge.TCMergeException;
import com.ibm.vatc.tcmerge.WarningDialog;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class DirectoryDialog
extends Dialog {
    Frame parentFrame;
    String selectedDirectory;
    String lookInDirectory;
    String choosenDirectory;
    TextField lookInTextField;
    TextField folderNameTextField;
    DirectoryCanvas directoryCanvas;
    String[] directoryChoices;
    ScrollPane scrollPane;
    static /* synthetic */ Class class$com$ibm$vatc$tcmerge$DirectoryDialog;

    public DirectoryDialog(Frame frame, String string) {
        super(frame, string, true);
        this.parentFrame = frame;
        this.lookInDirectory = System.getProperty("user.dir");
        this.createDialog();
    }

    public DirectoryDialog(Frame frame, String string, String string2) {
        super(frame, string, true);
        this.parentFrame = frame;
        this.lookInDirectory = string2;
        this.createDialog();
    }

    public String getDirectory() {
        return this.choosenDirectory;
    }

    public String getFolderName() {
        return this.selectedDirectory;
    }

    public String getLookInDirectory() {
        return this.lookInDirectory;
    }

    public void setFolderName(String string) {
        this.selectedDirectory = string;
        ((TextComponent)this.folderNameTextField).setText(this.selectedDirectory);
    }

    public void setLookInDirectory(String string) {
        this.lookInDirectory = string;
        File file = new File(this.lookInDirectory);
        try {
            ((TextComponent)this.lookInTextField).setText(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            ((TextComponent)this.lookInTextField).setText(string);
        }
        this.directoryChoices = file.list(new DirectoryFilter());
        this.sortDirectories(0, this.directoryChoices.length - 1);
        this.directoryCanvas.setDirectoryList(this.directoryChoices);
        this.scrollPane.doLayout();
    }

    private void createDialog() {
        ((Component)this).setFont(tcmerge.getDefaultFont());
        this.addWindowListener(new DialogListener());
        this.addKeyListener(new KeyListener("NA"));
        this.setLayout(new GridBagLayout());
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_LOOK_IN")), (int)2, (int)2, (int)1, (int)1);
        this.lookInTextField = new TextField(this.lookInDirectory, 30);
        this.lookInTextField.setFont(tcmerge.getDefaultFont());
        this.lookInTextField.addKeyListener(new KeyListener("LookUp"));
        GridTools.constrain((Container)this, (Component)this.lookInTextField, (int)3, (int)2, (int)2, (int)1);
        this.directoryCanvas = new DirectoryCanvas(new DirectoryCanvasListener());
        this.scrollPane = new ScrollPane(0);
        this.scrollPane.setBackground(Color.white);
        this.scrollPane.setSize(320, 180);
        this.scrollPane.add(this.directoryCanvas, null, 0);
        this.scrollPane.getHAdjustable().setUnitIncrement(12);
        GridTools.constrain((Container)this, (Component)this.scrollPane, (int)2, (int)4, (int)3, (int)1, (int)0, (int)0, (int)10, (int)1);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_FOLDER_NAME")), (int)2, (int)6, (int)1, (int)1);
        this.folderNameTextField = new TextField(30);
        this.folderNameTextField.setFont(tcmerge.getDefaultFont());
        this.folderNameTextField.addKeyListener(new KeyListener("FolderName"));
        GridTools.constrain((Container)this, (Component)this.folderNameTextField, (int)3, (int)6, (int)2, (int)1);
        Image image = Toolkit.getDefaultToolkit().getImage((class$com$ibm$vatc$tcmerge$DirectoryDialog != null ? class$com$ibm$vatc$tcmerge$DirectoryDialog : (class$com$ibm$vatc$tcmerge$DirectoryDialog = DirectoryDialog.class$("com.ibm.vatc.tcmerge.DirectoryDialog"))).getResource("upone.gif"));
        ImageButton imageButton = new ImageButton(image);
        imageButton.addMouseListener(new ImageButtonListener());
        GridTools.constrain((Container)this, (Component)imageButton, (int)6, (int)2, (int)1, (int)1);
        EButton eButton = new EButton(tcmerge.locResource.getString("STR_OK"));
        eButton.setActionCommand("OK");
        EButton eButton2 = new EButton(tcmerge.locResource.getString("STR_CANCEL"));
        eButton2.setActionCommand("Cancel");
        GridLayout gridLayout = new GridLayout(2, 1);
        Panel panel = new Panel(gridLayout);
        gridLayout.setVgap(10);
        eButton.addActionListener(new ButtonListener());
        eButton2.addActionListener(new ButtonListener());
        eButton.addKeyListener(new KeyListener("NA"));
        eButton2.addKeyListener(new KeyListener("NA"));
        panel.add((Component)eButton);
        panel.add((Component)eButton2);
        GridTools.constrain((Container)this, (Component)panel, (int)6, (int)2, (int)1, (int)4);
        this.setLookInDirectory(this.lookInDirectory);
        Canvas canvas = new Canvas();
        canvas.setSize(10, 10);
        GridTools.constrain((Container)this, (Component)canvas, (int)1, (int)1, (int)1, (int)1);
        Canvas canvas2 = new Canvas();
        canvas2.setSize(10, 10);
        GridTools.constrain((Container)this, (Component)canvas2, (int)5, (int)3, (int)1, (int)1);
        Canvas canvas3 = new Canvas();
        canvas3.setSize(10, 10);
        GridTools.constrain((Container)this, (Component)canvas3, (int)5, (int)5, (int)1, (int)1);
        Canvas canvas4 = new Canvas();
        canvas4.setSize(10, 10);
        GridTools.constrain((Container)this, (Component)canvas4, (int)7, (int)7, (int)1, (int)1);
        this.pack();
        Dimension dimension = this.parentFrame.getSize();
        Dimension dimension2 = this.getSize();
        try {
            Point point = this.parentFrame.getLocationOnScreen();
            ((Component)this).setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
            return;
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            Dimension dimension3 = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dimension3.width - dimension2.width) / 2, (dimension3.height - dimension2.height) / 2);
            return;
        }
    }

    private void sortDirectories(int n, int n2) {
        if (n >= n2) {
            return;
        }
        int n3 = this.partition(n, n2);
        this.sortDirectories(n, n3 - 1);
        this.sortDirectories(n3 + 1, n2);
    }

    /*
     * Unable to fully structure code
     */
    private int partition(int var1_1, int var2_2) {
        var3_3 = this.directoryChoices[var1_1];
        var5_4 = var2_2;
        var4_5 = var1_1;
        ** GOTO lbl15
        {
            ++var4_5;
            do {
                if (this.directoryChoices[var4_5].compareTo(var3_3) <= 0 && var4_5 < var2_2) continue block0;
                while (this.directoryChoices[var5_4].compareTo(var3_3) > 0) {
                    --var5_4;
                }
                if (var4_5 >= var5_4) continue;
                var6_6 = this.directoryChoices[var4_5];
                this.directoryChoices[var4_5] = this.directoryChoices[var5_4];
                this.directoryChoices[var5_4] = var6_6;
lbl15:
                // 3 sources

            } while (var4_5 < var5_4);
        }
        this.directoryChoices[var1_1] = this.directoryChoices[var5_4];
        this.directoryChoices[var5_4] = var3_3;
        return var5_4;
    }

    private void okEvent() {
        File file = new File(String.valueOf(this.lookInDirectory) + File.separator + this.folderNameTextField.getText());
        if (file.isDirectory()) {
            try {
                this.choosenDirectory = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                this.choosenDirectory = file.toString();
            }
            ((Component)this).setVisible(false);
            return;
        }
        try {
            throw new TCMergeException(28, file.toString());
        }
        catch (TCMergeException tCMergeException) {
            WarningDialog warningDialog = new WarningDialog(this.parentFrame, tCMergeException.toString());
            warningDialog.show();
            warningDialog.dispose();
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DirectoryFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            return file2.isDirectory();
        }

        DirectoryFilter() {
            DirectoryDialog.this = DirectoryDialog.this;
        }
    }

    class KeyListener
    extends KeyAdapter {
        String action;

        KeyListener(String string) {
            DirectoryDialog.this = DirectoryDialog.this;
            this.action = string;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                ((Component)DirectoryDialog.this).setVisible(false);
                return;
            }
            if (keyEvent.getKeyCode() == 10) {
                if (this.action.equals("LookUp")) {
                    File file;
                    String string = DirectoryDialog.this.lookInTextField.getText();
                    if (string.length() == 2 && string.charAt(1) == ':') {
                        string = String.valueOf(string) + '\\';
                    }
                    if ((file = new File(string)).isDirectory()) {
                        DirectoryDialog.this.setLookInDirectory(string);
                        return;
                    }
                    try {
                        throw new TCMergeException(28, string);
                    }
                    catch (TCMergeException tCMergeException) {
                        WarningDialog warningDialog = new WarningDialog(DirectoryDialog.this.parentFrame, tCMergeException.toString());
                        warningDialog.show();
                        warningDialog.dispose();
                        ((TextComponent)DirectoryDialog.this.lookInTextField).setText(DirectoryDialog.this.lookInDirectory);
                        return;
                    }
                }
                if (this.action.equals("FolderName")) {
                    DirectoryDialog.this.okEvent();
                }
            }
        }
    }

    class ImageButtonListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            File file = new File(DirectoryDialog.this.lookInDirectory);
            String string = file.getParent();
            if (string != null) {
                DirectoryDialog.this.setLookInDirectory(string);
            }
        }

        ImageButtonListener() {
            DirectoryDialog.this = DirectoryDialog.this;
        }
    }

    class DirectoryCanvasListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = DirectoryDialog.this.directoryCanvas.updateSelectedIndex(mouseEvent);
            if (n >= DirectoryDialog.this.directoryChoices.length) {
                return;
            }
            if (mouseEvent.getClickCount() == 2) {
                DirectoryDialog.this.setLookInDirectory(String.valueOf(DirectoryDialog.this.lookInDirectory) + File.separator + DirectoryDialog.this.directoryChoices[n]);
                DirectoryDialog.this.setFolderName("");
                return;
            }
            if (mouseEvent.getClickCount() == 1) {
                DirectoryDialog.this.setFolderName(DirectoryDialog.this.directoryChoices[n]);
            }
        }

        DirectoryCanvasListener() {
            DirectoryDialog.this = DirectoryDialog.this;
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
            DirectoryDialog.this = DirectoryDialog.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                DirectoryDialog.this.okEvent();
                return;
            }
            if (string.equals("Cancel")) {
                ((Component)DirectoryDialog.this).setVisible(false);
            }
        }
    }

    class DialogListener
    extends WindowAdapter {
        int aixkluge;

        public void windowClosing(WindowEvent windowEvent) {
            ((Component)DirectoryDialog.this).setVisible(false);
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (this.aixkluge == 0) {
                DirectoryDialog.this.lookInTextField.requestFocus();
            }
            this.aixkluge = 1;
        }

        DialogListener() {
            DirectoryDialog.this = DirectoryDialog.this;
        }
    }
}

