/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.newLine;
import com.ibm.vatc.tcmerge.printFont;
import com.ibm.vatc.tcmerge.printString;
import com.ibm.vatc.tcmerge.printTab;
import com.ibm.vatc.tcmerge.printerObject;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.util.Vector;

class Printer
extends Canvas {
    Frame f;
    PrintJob pjob;
    Graphics pg;
    Vector objects;
    Point pt;
    Font fnt;
    Font tabFont;

    public Printer(Frame frame) {
        this.f = frame;
        this.f.add(this);
        this.setVisible(false);
        this.pjob = null;
        this.pt = new Point(0, 0);
        this.objects = new Vector();
        this.tabFont = new Font("MonoSpaced", 0, 12);
        this.fnt = new Font("SansSerif", 0, 12);
    }

    public void setFont(Font font) {
        this.objects.addElement(new printFont(font));
    }

    public void print(String string) {
        this.objects.addElement(new printString(string));
    }

    public void println(String string) {
        if (!string.equals("")) {
            this.print(string);
        }
        this.objects.addElement(new newLine());
    }

    public void newPage() {
        if (this.pjob == null) {
            this.pjob = this.getToolkit().getPrintJob(this.f, "", null);
        }
        this.pg = this.pjob.getGraphics();
        this.print(this.pg);
        this.pg.dispose();
        this.pt = new Point(0, 0);
        this.objects = new Vector();
    }

    public void finalize() {
        if (this.objects.size() > 0) {
            this.newPage();
        }
        this.endJob();
    }

    public void endJob() {
        this.pjob.end();
    }

    public void tab(int n) {
        this.objects.addElement(new printTab(this.tabFont, n));
    }

    public Dimension pageSize() {
        if (this.pjob == null) {
            return new Dimension(620, 790);
        }
        this.pjob = this.getToolkit().getPrintJob(this.f, "Printer", null);
        return this.pjob.getPageDimension();
    }

    public void paint(Graphics graphics) {
        this.pt = new Point(0, 0);
        this.print(graphics);
    }

    public void print(Graphics graphics) {
        ((Component)this.f).setFont(this.fnt);
        int n = 0;
        while (n < this.objects.size()) {
            printerObject printerObject2 = (printerObject)this.objects.elementAt(n);
            printerObject2.draw(graphics, this.pt);
            ++n;
        }
    }

    public Dimension createPrintJob() {
        this.pjob = this.getToolkit().getPrintJob(this.f, "", null);
        if (this.pjob == null) {
            return null;
        }
        return this.pjob.getPageDimension();
    }
}

