/*
*********************************************************************
*             IBM Visualage TeamConnection
*
*                       5622-717
*    (C) Copyright, IBM Corp., 1997. All Rights Reserved.
*             Licensed Materials - Property of IBM
*
*         US Government Users Restricted Rights
*     - Use, duplication or disclosure restricted by
*         GSA ADP Schedule Contract with IBM Corp.
*
*              IBM is a registered trademark of
*        International Business Machines Corporation
*********************************************************************
*
*           NOTICE TO USERS OF THE SOURCE CODE EXAMPLES
*
* INTERNATIONAL BUSINESS MACHINES CORPORATION PROVIDES THE SOURCE CODE
* EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, "AS IS" WITHOUT
* WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE
* OF THE SOURCE CODE EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS,
* IS WITH YOU.  SHOULD ANY PART OF THE SOURCE CODE EXAMPLES PROVE
* DEFECTIVE, YOU (AND NOT IBM OR AN AUTHORIZED DEALER) ASSUME THE ENTIRE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
*********************************************************************

    PROGRAM:    tcnotes

    FILE:       tcnotes.c

    SYNTAX:     tcnotes  <Message filename> <tc family> <To User> <additional users>

                where <To User> is of the form

                 NotesID@host

    PURPOSE:    Sample TeamConnection mailexit for Lotus Notes using the
                Lotus Notes C API.

    DESCRIPTION:
        This mailexit when called by the TeamConnection notification
        daemon will send notification to TeamConnection users.

        Mail Addresses from the TeamConnection Notifyd are of the
        form user@host.  This mailexit assumes that the "user" is
        a Lotus Notes ID.  It can be either a short or regular Notes
	ID.  If the TC_NO_HOST environment variable is set, the 
	"@host" is truncated and only the "user" is used.

        This mailexit:
        - Uses only the Notes API NSF functions (no Mail* or VIM*).
        - Sends a memo to the recipients specified in the SendTo
          field of the command line argument.
        - Does not look up the name in the Name & Address book.
        - Sets the SendTo and the Recipients fields of the memo field
          to the SendTo value specified on the command line. 
        - Sets the Subject and Body according to the command line. 
        - Sets the Composed Date to the current date and time.
        - Sets the Form field to "Memo".
        - Sets the Delivery Priority to Normal, the Delivery Report to basic,
          and the Return Receipt to No.
        - Puts the memo in the MAIL.BOX file on the mail server specified
          in the NOTES.INI file.

        This sample should work on all platforms supported by the
        Lotus Notes C API Toolkit.  Please refer to the toolkit
        documentation for build instructions.

        tcnotes.mak is a sample WIN32 makefile for NT.

        The Lotus Notes C+ API toolkit can be downloaded from
        http://www.lotus-developer.com/ then select Downloads
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <io.h>

#include <global.h>
#include <globerr.h>
#include <names.h>
#include <stdnames.h>                   /* FIELD_FORM, etc */
#include <osfile.h>
#include <nsf.h>
#include <kfm.h>                        /* SECKFMUserInfo */
#include <nsfdb.h>
#include <nsfnote.h>
#include <nsfsearc.h>
#include <nsferr.h>
#include <ostime.h>
#include <osmem.h>
#include <ods.h>
#include <osenv.h>                      /* OSGetEnvironmentString */
#include <fontid.h>

#define TEMP_MAIL_BODY_ITEM   "TempBody"

/************************************************************************

    FUNCTION:   NotesMain

*************************************************************************/
STATUS LNPUBLIC NotesMain (int argc, char * argv[])
{
    STATUS      error = NOERROR;
    char       *szSubject;
    char       *szBody;
    char        szFrom[MAXUSERNAME+1];
    char        szMailServerName[MAXUSERNAME+1];
    char        szMailBoxPath[MAXPATH+1];
    DBHANDLE    hMailBox;
    NOTEHANDLE  hMemo;
    TIMEDATE    tdCurrent;
    BLOCKID     bidItem;
    WORD        wDataType;
    BLOCKID     bidValue;
    DWORD       dwValueLen;
    HANDLE      hRichTextBody;
    DWORD       dwRichTextLen;
    BYTE      * pRichTextBody;
    char      * subject;
    char      * body;
    FILE      * stream;
    int         numread;
    int         i;
    int         fhandle;
    char      * hostname;
    char      * noSubject="No Subject";

    if ((argc < 3))
       {
        printf("*** Usage Error ***\n");
        printf("Usage: %s <Message fileName> <Family Name> <To User ID> [<additional users>]",argv[0]);
        return(ERR(error));
       }


    /* Read the notification file */
    body = (char *)malloc(32000);
    memset(body,0,sizeof(body));
    if( (stream = fopen( argv[1], "r" )) != NULL )
    {
       fhandle = _fileno( stream );
       /* Attempt to read in the file */
       numread = fread( body, sizeof( char ), _filelength(fhandle), stream );
       fclose( stream );

       subject = body;
       /* Is there a subject line */
       if (strchr(subject,':'))
       {
         /* Increment body past the subject line */
         subject = strchr(subject,':') + 2;
         body = strchr(body,'\n');
         *body = '\0';
         body++;
       }
       else  /* no subject line found */
         subject = noSubject;
    }
    else
    {
       printf("Error: %s could not be opened",argv[1]);
       return(ERR(error));
    }

    szSubject = subject;
    szBody = body;


    if (error = SECKFMUserInfo(KFM_ui_GetUserInfo, szFrom, NULL))
    {
        printf ("Error: unable to get user name.\n");
        return (ERR(error));
    }
    if (!OSGetEnvironmentString("MAILSERVER", szMailServerName, MAXUSERNAME))
    {
        printf ("Error: unable to get mail server name.\n");
        return (NOERROR);
    }
    OSPathNetConstruct( NULL,               /* port name  */
                        szMailServerName,
                        "MAIL.BOX",
                        szMailBoxPath);

    if (error = NSFDbOpen (szMailBoxPath, &hMailBox))
    {
        printf ("Error: unable to open '%s'.\n", szMailBoxPath);
        return (ERR(error));
    }

    OSCurrentTIMEDATE(&tdCurrent);

    if (error = NSFNoteCreate(hMailBox, &hMemo))
    {
        printf ("Error: unable to create memo in MAIL.BOX.\n");
        NSFDbClose(hMailBox);
        return(ERR(error));
    }

    if (error = NSFItemSetText( hMemo,
                                FIELD_FORM,     /* "Form" */
                                MAIL_MEMO_FORM, /* "Memo" = Standard memo */
                                MAXWORD))
    {
        printf ("Error: unable to set item '%s' into memo.\n", FIELD_FORM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return(ERR(error));
    }


   /* create the list of recipients with a ' ' between. */
   for(i=3; argv[i] != NULL; i++)
   {
      /* break up the user and host name if there is an @ */
      /* otherwise we just use the full value of arg[i]   */
      if (getenv("TC_NO_HOST"))
      {
        hostname = strchr(argv[i],'@');
        if (hostname)
        {
          *hostname = '\0';
          hostname++;
        }
      } /* endif */

      /* append each user id */

      /* if it is the first address then create the textlist */
      if (error = NSFItemAppendTextList( hMemo,
                                MAIL_SENDTO_ITEM,  /* "SendTo" */
                                argv[i],
                                MAXWORD,TRUE))
      {
        printf ("Error: unable to set item '%s' into memo.\n",
                                                        MAIL_SENDTO_ITEM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return(ERR(error));
      }
      if (error = NSFItemAppendTextList( hMemo,
                                MAIL_RECIPIENTS_ITEM,
                                argv[i],
                                MAXWORD,TRUE))
      {
        printf ("Error: unable to set item to text list '%s' into memo.\n",
                                MAIL_RECIPIENTS_ITEM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return(ERR(error));
      }
    }

    if (error = NSFItemSetText( hMemo,
                                MAIL_FROM_ITEM,     /* "From" */
                                szFrom,
                                MAXWORD))
    {
        printf ("Error: unable to set item '%s' into memo.\n", MAIL_FROM_ITEM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return(ERR(error));
    }

    if (error = NSFItemSetText( hMemo,
                                MAIL_SUBJECT_ITEM,     /* "Subject" */
                                szSubject,
                                MAXWORD))
    {
        printf ("Error: unable to set item '%s' into memo.\n",
                                MAIL_SUBJECT_ITEM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return(ERR(error));
    }

    if (error = NSFItemSetText( hMemo,
                                MAIL_DELIVERYPRIORITY_ITEM, /* "DeliveryPriority" */
                                "Normal",
                                MAXWORD))
    {
        printf ("Error: unable to set item '%s' into memo.\n",
                                MAIL_DELIVERYPRIORITY_ITEM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return(ERR(error));
    }

    if (error = NSFItemSetText( hMemo,
                                MAIL_DELIVERYREPORT_ITEM, /* "DeliveryReport" */
                                "Basic",
                                MAXWORD))
    {
        printf ("Error: unable to set item '%s' into memo.\n",
                                MAIL_DELIVERYREPORT_ITEM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return(ERR(error));
    }

    if (error = NSFItemSetText( hMemo,
                                MAIL_RETURNRECEIPT_ITEM,  /* "ReturnReceipt" */
                                "No",
                                MAXWORD))
    {
        printf ("Error: unable to set item '%s' into memo.\n",
                                MAIL_RETURNRECEIPT_ITEM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return(ERR(error));
    }

    if (error = NSFItemSetTime( hMemo,
                                MAIL_COMPOSEDDATE_ITEM, /* "ComposedDate" */
                                &tdCurrent))
    {
        printf ("Error: unable to set item '%s' into memo.\n",
                                MAIL_COMPOSEDDATE_ITEM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return(ERR(error));
    }

    if (error = NSFItemSetText( hMemo,
                                TEMP_MAIL_BODY_ITEM,  /* "TempBody" */
                                szBody,
                                MAXWORD))
    {
        printf ("Error: unable to set item '%s' into memo.\n",
                                TEMP_MAIL_BODY_ITEM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return(ERR(error));
    }

    if (error = NSFItemInfo(hMemo,
                            TEMP_MAIL_BODY_ITEM,
                            strlen(TEMP_MAIL_BODY_ITEM),
                            &bidItem, &wDataType, &bidValue, &dwValueLen))
    {
        printf ("Error: unable to get info re item '%s'.\n",
                            TEMP_MAIL_BODY_ITEM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return (ERR(error));
    }

    if (error = ConvertItemToComposite(bidValue, dwValueLen,
                DEFAULT_FONT_ID, "\r\n", PARADELIM_ANYLINE,
                &hRichTextBody, &dwRichTextLen,
                FALSE, NULL, 0, FALSE))
    {
        printf ("Error: unable to convert text item to composite.\n");
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return (ERR(error));
    }

    pRichTextBody = OSLockObject(hRichTextBody) ;
    pRichTextBody += sizeof(WORD);
    dwRichTextLen -= sizeof(WORD);

    if (error = NSFItemAppend(hMemo, 0, MAIL_BODY_ITEM,
                    strlen(MAIL_BODY_ITEM), TYPE_COMPOSITE, pRichTextBody,
                    dwRichTextLen))
    {
        printf ("Error: unable to append item '%s' to note.\n",
                            MAIL_BODY_ITEM);
        OSUnlockObject(hRichTextBody);
        OSMemFree(hRichTextBody);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return (ERR(error));
    }

    OSUnlockObject(hRichTextBody) ;
    OSMemFree(hRichTextBody);

    if (error = NSFItemDelete(hMemo, TEMP_MAIL_BODY_ITEM,
                            strlen(TEMP_MAIL_BODY_ITEM)))
    {
        printf ("Error: unable to delete item '%s' to note.\n",
                            TEMP_MAIL_BODY_ITEM);
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return (ERR(error));
    }

    if (error = NSFNoteUpdate(hMemo, 0))
    {
        printf ("Error: unable to update note in MAIL.BOX.\n");
        NSFNoteClose(hMemo);
        NSFDbClose(hMailBox);
        return (ERR(error));
    }

    if (error = NSFNoteClose(hMemo))
    {
        printf ("Error: unable to close note.\n");
        NSFDbClose(hMailBox);
        return (ERR(error));
    }

    if (error = NSFDbClose(hMailBox))
    {
        printf ("Error: unable to close mail box.\n");
        return (ERR(error));
    }

    printf ("%s: successfully deposited memo '%s' in mail box.\n",
                argv[0], szSubject);

    return(NOERROR);
}

