/*
*********************************************************************

SAMPLE NAME:  viewExit.cmd

USAGE:        User Exit, see <family dir>\config\UserExit for details

ENVIRONMENT VARIABLES:
                       none

DESCRIPTION:  This sample user exit displays the parameter list passed to
              a user exit from a TeamConnection command.  This is the
              REXX sample, there are equivalent samples for c and ksh.

              The REXX code removed the beginning and ending quote from
              each string, as well as backslashes in front of quotes
              imbedded in each string.  This is done automatically for
              c and ksh.

CONFIGURATION:
         In order to use this program, you need to define a similar 
         entry in the file  %TC_HOME%\config\userexit as follows. 
         This example uses the action UserView at user exit id 0.

         * For OS/2:

         UserView           0  d:\teamc\samples\viewexit.cmd

         * For Windows (you need to specify "rexx" before the command file):

         UserView           0  rexx d:\teamc\samples\viewexit.cmd

*********************************************************************
*             IBM TeamConnection for OS/2
*                     Version 2 Release 0
*
*                       5622-717
*    (C) Copyright, IBM Corp., 1996. All Rights Reserved.
*             Licensed Materials - Property of IBM
*
*         US Government Users Restricted Rights
*     - Use, duplication or disclosure restricted by
*         GSA ADP Schedule Contract with IBM Corp.
*
*              IBM is a registered trademark of
*        International Business Machines Corporation
*********************************************************************
*
*           NOTICE TO USERS OF THE SOURCE CODE EXAMPLES
*
* INTERNATIONAL BUSINESS MACHINES CORPORATION PROVIDES THE SOURCE CODE
* EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, "AS IS" WITHOUT
* WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE
* OF THE SOURCE CODE EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS,
* IS WITH YOU.  SHOULD ANY PART OF THE SOURCE CODE EXAMPLES PROVE
* DEFECTIVE, YOU (AND NOT IBM OR AN AUTHORIZED DEALER) ASSUME THE ENTIRE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
*********************************************************************
*/
/* trace r */
/* Gets the name of the command.                                       */
parse source . . cmdName
cmdName = filespec("name",cmdName)
cmdName = substr(cmdName,1,lastPos('.',cmdName)-1)
parse source . . name .
say 'UEprogram:              ' cmdName

/* Get parameter list                                                  */
/* - all strings (after this program) are encased in quotes            */
/* - all imbedded quotes are "escaped" (i.e. a back-slash is inserted) */
parse arg '"'UEparm'"' params

/* User Exit Parameter string                                          */
/* The first string in the list contains the parameters                */
/* defined by the user in the config\userExit file                     */
if (UEparm <> "")
then
   say 'UEparameters string:    ' UEparm
else
   say 'UEparameters string is NULL'

/* Is there an EnvFile                                                 */
/* The second string in the list contains the EnvFile name,            */
/* if ENV=() is in the user in the config\userExit file                */
if (pos('"', params) > 0)
then do
   parse var params '"'EnvFile'"' params
   say 'EnvFile name:           '  EnvFile
end
else do
   EnvFile = ""
   say 'No environment file; string is NULL'
end

/* Display positional parameters                                       */

/* Remove leading open quote                                           */
parse var params '"'params

/* Extract each action parameter from list into a separate variable    */
do i = 1 by 1 while (length(params) > 0)

   /* find first quote + space + end quote (" ")                       */
   quote = pos('" "', params)

   if (quote > 0)
   then do
      /* get up to next quote for current parameter                    */
      parse var params param.i'" "'params
   end
   else do
      /* get up to last quote for last parameter                       */
      param.i = substr(params, 1, length(params)-1)
      params = ''
   end

   /* remove backslashes from imbedded quotes (e.g. \" -> ")           */
   j =  pos('\"',param)
   do while (j  <> 0)
      param.i=substr(param.i,1,j-1)substr(param.i,j+1)
      j =  pos('\"',param.i)
   end

   /* TeamConnection action parameters                              */
   /* The order of these parameters is defined for each             */
   /* TeamConnection action in the User's Guide                     */

   /* Truncate to last 3 characters of parameter to check for       */
   /* truncation:                                                   */
   /* - Each parameter limited to 400 bytes in OS/2, Windows and    */
   /*   Windows NT, and 16000 bytes in Unix                         */
   /* - Total command string limited to 1024 bytes in OS/2, Windows */
   /*   and Windows NT, and 32000 bytes in Unix                     */

   n = length(param.i)
   if (n <> 0)
   then do
      say 'Action parameter ['i']:   ' param.i
      if (n > 2) /* Check for ellipse only if 3 chars or more */
      then do
         if (substr(param.i,(n-2),3) = '...')
         then do
            say '                         parameter' i 'string was truncated!'
            if (pos('" "', params) = 0)
            then
               say 'Parameter list was truncated!'
         end
      end
   end
   else
      say 'Action parameter ['i'] is NULL'
end

/* Compute and display the number of action parameters passed          */
totalParms = i - 1
say 'Total action parameters:' totalParms

/* If you have compiled teamcenv, you can call it here to print the    */
/* contents of the temporary environment file                          */
/* if (EnvFile = '') then                                              */
/*   say "No environment file"                                         */
/* else                                                                */
/*   'teamcenv' EnvFile                                                */

return 0

/* End of File */
