//*------------------------------------------------------
//* PROGRAM:  EDCC
//* IBM C/370 Procedure for MVS Sample TeamConnection Build Script
//* Compile Procedure Only
//*                                                      
//* COPYRIGHT: Copyright (C) International Business      
//*            Corp. 1995                                
//*                                                      
//* DISCLAIMER OF WARRANTIES:                            
//*  The following enclosed code is sample code created  
//*  by IBM Corporation.  This sample code is not part   
//*  any standard product and is provided to you solely  
//*  for the purpose of assisting you in the development 
//*  of your applications.  The code is provide "AS IS", 
//*  without warranty of any kind. IBM shall not be      
//*  liable for any damages arising out of your use      
//*  of the sample code                                  
//*------------------------------------------------------ 
//*  Some dataset names may need to be modified
//*  according to your system's customization
//*------------------------------------------------------ 
//**********************************************************/
//* EDCC   *                                               */
//***********      C/370 -- MVS                            */
//*          VERSION 2 RELEASE 1 MODIFICATION 0            */
//*                                                        */
//* 5648-056 (C) COPYRIGHT IBM CORP. 1993, 1994            */
//*                                                        */
//*                                                        */
//**********************************************************/
//*                                                        */
//*USING THIS CATALOGUED PROCEDURE:                        */
//*--------------------------------                        */
//* WHEN USING THIS CATALOGUED PROCEDURE, THE USER MUST    */
//* SPECIFY THE QUALIFIED INPUT FILE NAME (SOURCE PROGRAM).*/
//*                                                        */
//* THE MINIMUM A USER CAN CODE TO INVOKE THIS PROCEDURE   */
//* IS:                                                    */
//*                                                        */
//*  //USERID   JOB...                                     */
//*  //STEPNAME EXEC EDCC,                                 */
//*             INFILE='QUALIFIED DATA SET NAME'           */
//* DEFAULT VALUES WILL APPLY TO ALL REMAINING PARAMETERS. */
//*                                                        */
//**********************************************************/
//*                                                        */
//*SETTING UP THIS CATALOGUED PROCEDURE:                   */
//*-------------------------------------                   */
//*THE FOLLOWING SYMBOLIC PARAMETERS ARE USED IN THIS      */
//*CATALOGUED PROCEDURE AND MUST BE CUSTOMIZED WHEN IT IS  */
//*INSTALLED. THE MEANINGS OF THE PARAMETERS ARE AS        */
//*FOLLOWS:                                                */
//*                                                        */
//*                                                        */
//* &CREGSIZ  - COMPILER REGION SIZE                       */
//* &INFILE   - INPUT DATA SET                             */
//* &OUTFILE  - OUTPUT DATA SET                            */
//* &OUTDCB   - DCB FOR OUTPUT FILE                        */
//* &CPARM    - COMPILER OPTIONS                           */
//*                                                        */
//* &VSCCHD   - PREFIX FOR SYSTEM FILES                    */
//* &COMHD    - PREFIX FOR COMMON LIBRARY                  */
//* &CVER     - VERSION OF COMPILER                        */
//* &COMVER   - VERSION OF COMMON LIBRARY                  */
//* &COMPL    - C COMPILER MODULES                         */
//* &EDCMSGS  - C COMPILER MESSAGES                        */
//* &LANG     - MESSAGE LANGUAGE                           */
//* &COMLINK  - COMMON DYNAMIC RUNTIME LIBRARY             */
//* &CLINK    - C DYNAMIC LIBRARY                          */
//* &EDCHDRS  - C SYSTEM HEADERS                           */
//* &WORKDA   - UNIT TYPE FOR WORK FILES                   */
//* &WRKSPC   - SPACE ALLOCATED FOR WORK FILES             */
//* &DCB80    - DCB FOR LRECL OF 80                        */
//* &DCB3200  - DCB FOR LRECL OF 3200                      */
//* &SYSOUT1  - COMPILER OUTPUT                            */
//* &SYSOUT6  - COMPILER LISTING                           */
//*                                                        */
//* THE SYMBOLIC PARAMETERS DIRECTLY FOLLOW THIS COMMENT   */
//* BLOCK AND MOST LIKELY REQUIRE CUSTOMIZATION BY YOUR    */
//* INSTALLATION.                                          */
//*                                                        */
//**********************************************************/
//EDCC PROC CREGSIZ='1536K',
//*  INFILE=,
//*OUTFILE='&&LOADSET,DISP=(MOD,PASS),UNIT=VIO,SPACE=(80,(250,100))',
//*  CPARM=,
//*------------------------------------------------------------
//   VSCCHD='SYS1.',
//   COMHD='SYS1.',
//   CVER='EDC.',
//   COMVER='PLI.',
//   COMPL='SEDCCOMP',
//   EDCMSGS='SEDCMSGS',
//   LANG='EDCMSGE',
//   COMLINK='SIBMLINK',
//   CLINK='SEDCLINK',
//   EDCHDRS='SEDCHDRS',
//*------------------------------------------------------------
//   WORKDA='VIO',
//   WRKSPC='(32000,(30,30))',
//   OUTDCB='(RECFM=FB,LRECL=80,BLKSIZE=3200)',
//   DCB80='(RECFM=FB,LRECL=80,BLKSIZE=3200)',
//   DCB3200='(RECFM=FB,LRECL=3200,BLKSIZE=12800)',
//*-----------------------------------------------------------------
//   SYSOUT1='*',
//   SYSOUT6='*'
//*-----------------------------------------------------------------
//*  COMPILE STEP:
//*------------------------------------------------------------------
//COMPILE EXEC PGM=EDCCOMP,PARM=(,
//   '&CPARM'),REGION=&CREGSIZ
//STEPLIB   DD DSN=&VSCCHD&CVER&CLINK,DISP=SHR
//          DD DSN=&COMHD&COMVER&COMLINK,DISP=SHR
//          DD DSN=&VSCCHD&CVER&COMPL,DISP=SHR
//SYSMSGS   DD DSN=&VSCCHD&CVER&EDCMSGS(&LANG),DISP=SHR
//SYSIN     DD DSN=&INFILE,DISP=SHR
//SYSLIB    DD DSN=&VSCCHD&CVER&EDCHDRS,DISP=SHR
//SYSLIN    DD DSN=&OUTFILE,DCB=&OUTDCB
//SYSPRINT  DD SYSOUT=&SYSOUT1
//SYSCPRT   DD SYSOUT=&SYSOUT6
//SYSUT1    DD DSN=&&SYSUT1,UNIT=&WORKDA,DISP=(NEW,DELETE),
//   SPACE=&WRKSPC,DCB=&DCB80
//SYSUT4    DD DSN=&&SYSUT4,UNIT=&WORKDA,DISP=(NEW,DELETE),
//   SPACE=&WRKSPC,DCB=&DCB80
//SYSUT5    DD DSN=&&SYSUT5,UNIT=&WORKDA,DISP=(NEW,DELETE),
//   SPACE=&WRKSPC,DCB=&DCB3200
//SYSUT6    DD DSN=&&SYSUT6,UNIT=&WORKDA,DISP=(NEW,DELETE),
//   SPACE=&WRKSPC,DCB=&DCB3200
//SYSUT7    DD DSN=&&SYSUT7,UNIT=&WORKDA,DISP=(NEW,DELETE),
//   SPACE=&WRKSPC,DCB=&DCB3200
//SYSUT8    DD DSN=&&SYSUT8,UNIT=&WORKDA,DISP=(NEW,DELETE),
//   SPACE=&WRKSPC,DCB=&DCB3200
//SYSUT9    DD DSN=&&SYSUT9,UNIT=&WORKDA,DISP=(NEW,DELETE),
//   SPACE=&WRKSPC,DCB=(RECFM=VB,LRECL=137,BLKSIZE=882)
//SYSUT10   DD SYSOUT=&SYSOUT6
//*
