
package COM.ibm.ivj.javabeans;


public class IMessageBox extends java.awt.Frame
						 implements java.awt.event.ActionListener
{
   private static String copywrite = "IBM(R) VisualAge(TM) for Java(TM), Version 1 and others\n - Licensed Material - Program-Property of IBM\n(C) Copyright IBM Corp. 1997 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
   private static java.util.ResourceBundle resources = null;
   private java.awt.Button ivjButton1 = null;
   private java.awt.TextArea ivjTextArea1 = null;
   private static boolean printStackTrace = false;
   private java.awt.Dimension size;


   /**
	* Default constructor
	* @return
	*/
   public IMessageBox()
   {
	   this(null);
   }   
   /**
	* IMessageBox constructor comment.
	* @return IMessageBox
	* @param title java.lang.String
	*/
   public IMessageBox(java.lang.String title)
   {
	  super(title);

	  // try to load resources
	  if ( resources == null )
		 try { resources =  java.util.ResourceBundle.getBundle("COM.ibm.ivj.javabeans.IMessageBoxResources"); }
		 catch (Exception exc) {}

	  super.setLayout(new java.awt.GridBagLayout());
	  java.awt.Panel controlPanel = new java.awt.Panel(new java.awt.FlowLayout());

	  ivjButton1 = new java.awt.Button("Ok");
	  controlPanel.add(ivjButton1);
	  ivjButton1.addActionListener(this);

	  java.awt.GridBagConstraints c;

	  c = new java.awt.GridBagConstraints();
	  c.fill = java.awt.GridBagConstraints.BOTH;
	  c.weightx = 1.0;
	  c.weighty = 1.0;
	  c.gridwidth = java.awt.GridBagConstraints.REMAINDER; //end row
	  ivjTextArea1 = new java.awt.TextArea();
	  ivjTextArea1.setEditable(false); // don't allow input
	  add(ivjTextArea1,c);
	  c.weightx = 0.0;
	  c.weighty = 0.0;
	  add(controlPanel,c);

	  enableEvents( java.awt.AWTEvent.WINDOW_EVENT_MASK );
   }   
   /**
	* Method to handle events for the ActionListener interface.
	* @param e java.awt.event.ActionEvent
	*/
   public void actionPerformed(java.awt.event.ActionEvent e)
   {
	   if ( e.getSource() == ivjButton1 )
	   {
		  try { setVisible(false); }
		  catch (java.lang.Throwable exception) {}
	   }
   }   
   public java.awt.Dimension getSize()
   {
	 if (size == null) {
		 return getPreferredSize();
	  }
	  else {
		 return size;
	  }
   }      
   // resource access
   private static String getString( String id )
   {
	  if ( resources != null )
		 return resources.getString(id);
	  else
		 return id;
   }   
   /**
	* report state of printStackTrace when exception thrown mode
	* @return boolean
	*/
   public static boolean isPrintStackTrace() { return printStackTrace; }   
   /**
	* Method to handle all the events within the part
	* @return boolean
	* @param evt java.awt.Event
	*/
   public void processEvent(java.awt.AWTEvent evt)
   {
	   if (evt.getID() == java.awt.Event.WINDOW_DESTROY)
		  dispose();
	   super.processEvent(evt);
   }   
   // Hide this method, to prevent the layout from being changed.
   // Also has the benifit of hiding the property in the VB
   public void setLayout( java.awt.LayoutManager aManager ) {}   
   /**
	* enable/disable printStackTrace when exception thrown
	* @param enable boolean
	*/
   public static void setPrintStackTrace(boolean enable)
   {
	  printStackTrace = enable;
   }   
   /**
	* Set the size of this message box when displayed
	* @param newSize java.awt.Dimension
	*/
   public void setSize(java.awt.Dimension newSize)
   {
	   if (newSize == null) {
		 size = getSize();
	  }
	  else {
		 size = newSize;
	  }
   }      
   /**
	* Show a message
	* @param text java.lang.String
	*/
   public void show(String text)
   {
	  if ( getTitle() == null )
		 setTitle(getString("Information"));
	  ivjTextArea1.setText( text );
	  pack();
	  super.setSize(size);	  
	  show();
   }      
   /**
	* Show an event
	* @param evt java.util.EventObject
	*/
   public void showEvent(java.util.EventObject evt)
   {
	  if ( evt instanceof IParameterEvent &&
			((IParameterEvent)evt).getParameter() != null &&
			((IParameterEvent)evt).getParameter() instanceof Throwable )
		 showException( (Throwable) ((IParameterEvent)evt).getParameter() );
	  else
	  {
		 if ( getTitle() == null )
			setTitle(getString("Event"));
		 ivjTextArea1.setText(evt.toString());
		 pack();
		 super.setSize(size);
		 show();
	  }
   }   
   /**
	* Show a Throwable
	* @param e java.lang.Throwable
	*/
   public void showException(Throwable e)
   {
	  if ( printStackTrace ) e.printStackTrace();
	  if ( getTitle() == null )
		 setTitle(getString("Exception"));
	  ivjTextArea1.setText(stringFor(e));
	  pack();
	  super.setSize(size);	  
	  show();
   }      
   // determine message associated with this object
   protected static String stringFor(Throwable exc)
   {
	  if ( exc instanceof IException )
	  {
		 String msg = exc.getClass().getName() + "\n\n";
		 IException e2 = (IException)exc;
		 msg += e2.getId() + "\n" + exc.getMessage() + "\n";
		 Object ei = e2.getExtendedInfo();
		 if ( ei != null )
		 {
			if ( ei instanceof java.sql.SQLException )
			{
			   // message already in the IException
			   java.sql.SQLException s = (java.sql.SQLException) ei;
			   msg += getString("SQLState") + " " + s.getSQLState() + "\n" +
					  getString("ErrorCode") + " " + s.getErrorCode() + "\n";
			   if ( s.getNextException() != null )
				  msg += "\n" + stringFor(s.getNextException());
			}
			else
			   msg += ei.toString() + "\n";
		 }
		 return msg;
	  }
	  else if ( exc instanceof java.sql.SQLException )
	  {
		 java.sql.SQLException s = (java.sql.SQLException)exc;
		 String msg = s.getMessage() + "\n";
		 msg += getString("SQLState") + " " + s.getSQLState() + "\n" +
				getString("ErrorCode") + " " + s.getErrorCode() + "\n";
		 if ( s.getNextException() != null )
			msg += "\n" + stringFor(s.getNextException());
		 return msg;
	  }
	  else
		 return exc.getClass().getName() + "\n\n" + exc.getMessage();
   }   
}
