-- -----------------------------------------------------------
--
--  IBM(R) VisualAge(TM) for Java(TM) Version 1 and others
--   - Licensed Material - Program-Property of IBM
--  (C) Copyright IBM Corp. 1997 - All Rights Reserved.
--  US Government Users Restricted Rights - Use, duplication or disclosure
--  restricted by GSA ADP Schedule Contract with IBM Corp.
--
-- -----------------------------------------------------------

-- This file contains the procedures for generating SQL statements.
--

managerUpdateStmt()
{
  Sub class

  if (class->QuoteChar != "") {
     /*UPDATE %QUAL%$class->QuoteChar$$class->tableName$$class->QuoteChar$ SET */ endl
  } else {
     /*UPDATE %QUAL%$class->tableName$ SET */ endl
  }

  repeat (class->attr | middle { /*,*/ endl}) {
    if (class->QuoteChar != "") {
       /*                  $class->QuoteChar$$attr->column$$class->QuoteChar$ = $scalarConversion(&attr->SQLType,&attr->currentUpdate)$*/
    } else {
       /*                  $attr->column$ = $scalarConversion(&attr->SQLType,&attr->currentUpdate)$*/
    }
  }
  /*
          WHERE CURRENT OF */
}

dataIdManUpdateStmt()
{
  Sub class

  if (class->QuoteChar != "") {
     /*UPDATE %QUAL%$class->QuoteChar$$class->tableName$$class->QuoteChar$ SET */ endl
  } else {
     /*UPDATE %QUAL%$class->tableName$ SET */ endl
  }


  repeat (class->attr | middle { /*,*/ endl } condition(attr->isDataId) ) {
    if (class->QuoteChar != "") {
      /*                  $class->QuoteChar$$attr->column$$class->QuoteChar$ = $scalarConversion(&attr->SQLType,&attr->currentUpdate)$*/
    } else {
      /*                  $attr->column$ = $scalarConversion(&attr->SQLType,&attr->currentUpdate)$*/
    }
  }

  /*
          WHERE CURRENT OF */
}

managerDeleteStmt()
{
  Sub class
  if (class->QuoteChar != "") {
     /*DELETE FROM %QUAL%$class->QuoteChar$$class->tableName$$class->QuoteChar$ WHERE CURRENT OF */
  } else {
     /*DELETE FROM %QUAL%$class->tableName$ WHERE CURRENT OF */
  }

}

esqlFixedPart()
{
  Sub class

  if (class->isVO) { /*$class->VOStatement$ */ }
  else {
    /*SELECT */
    repeat (class->attr | middle { /*, */ endl /*               */ } ) {
      if (class->QuoteChar != "") {
        scalarColumn(&attr->ELEMENT, "T1." + class->QuoteChar + attr->column + class->QuoteChar)
      } else {
        scalarColumn(&attr->ELEMENT, "T1." + attr->column)
      }
    }
    if (class->QuoteChar != "") {
       /*
        FROM $Qualifier()$$class->QuoteChar$$class->tableName$$class->QuoteChar$ T1 */
    } else {
       /*
        FROM $Qualifier()$$class->tableName$ T1 */
    }
  }
}

esqlDataIdFixedPart()
{
  Sub class

  /*SELECT */

  repeat (class->attr | middle { /*, */ endl /*               */ } condition(attr->isDataId) ) {
    if (class->QuoteChar != "") {
       /*$scalarColumn(&attr->ELEMENT, "T1." + class->QuoteChar + attr->column + class->QuoteChar)$*/
    } else {
       /*$scalarColumn(&attr->ELEMENT, "T1." + attr->column)$*/
    }
  }

    if (class->QuoteChar != "") {
       /*
        FROM $Qualifier()$$class->QuoteChar$$class->tableName$$class->QuoteChar$ T1 */
    } else {
       /*
        FROM $Qualifier()$$class->tableName$ T1 */
    }
}

--
-- Generate manager fixed part for displaying in the PDQ method dialog
-- remove all newlines and unnecessary spaces
--
displayFixedPart()
{
  Sub class

  if (class->isVO) {
    /*$class->VOStatement$ */
  } else {
    /*SELECT */
    repeat (class->attr | middle { /*, */ } ) {
      /*T1.$attr->column$*/
    }
    if (class->QuoteChar != "") {
       /* FROM %QUAL%$class->QuoteChar$$class->tableName$$class->QuoteChar$ T1 */
    } else {
       /* FROM %QUAL%$class->tableName$ T1 */
    }
  }
}

managerFixedPart()
{
  Sub class
  if (class->isVO) {
    /*$class->VOStatement$ */
  } else {

    /*SELECT */
    repeat (class->attr | middle { /*, */ endl /*                  */ }) {
      if (class->QuoteChar != "") {
         /*T1.$class->QuoteChar$$attr->column$$class->QuoteChar$*/
      } else {
         /*T1.$attr->column$*/
      }
    }

    if (class->QuoteChar != "") {
       /*
        FROM %QUAL%$class->QuoteChar$$class->tableName$$class->QuoteChar$ T1 */
    } else {
       /*
        FROM %QUAL%$class->tableName$ T1 */
    }
  }
}

dataIdManFixedPart()
{
  Sub class

  if (class->isVO) {
    /*$class->VOStatement$ */
  } else {
    /*SELECT */
    repeat (class->attr | middle { /*, */ endl /*                  */ } condition(attr->isDataId) ) {
      if (class->QuoteChar != "") {
         /*T1.$class->QuoteChar$$attr->column$$class->QuoteChar$*/
      } else {
         /*T1.$attr->column$*/
      }
    }
    if (class->QuoteChar != "") {
       /*
        FROM %QUAL%$class->QuoteChar$$class->tableName$$class->QuoteChar$ T1 */
    } else {
       /*
        FROM %QUAL%$class->tableName$ T1 */
    }
  }
}

retrieveStatement()
{
  Sub class

  /*SELECT */ endl
  if (class->allDataIds) {
    repeat (class->attr | middle { /*,*/ endl }) {
      if (class->QuoteChar != "") {
         /*            $class->QuoteChar$$attr->column$$class->QuoteChar$*/
      } else {
         /*            $attr->column$*/
      }
    }
  } else {
    repeat (class->attr | middle { /*,*/ endl } condition(!attr->isDataId) ) {
      if (class->QuoteChar != "") {
         /*            $class->QuoteChar$$attr->column$$class->QuoteChar$*/
      } else {
         /*            $attr->column$*/
      }
    }
  }

  if (class->QuoteChar != "") {
     /*
        FROM %QUAL%$class->QuoteChar$$class->tableName$$class->QuoteChar$ WHERE */ whereDataId()
  } else {
     /*
        FROM %QUAL%$class->tableName$ WHERE */ whereDataId()
  }
}

addStatement()
{
  Sub class

  if (class->QuoteChar != "") {
     /*INSERT INTO %QUAL%$class->QuoteChar$$class->tableName$$class->QuoteChar$ (*/
  } else {
     /*INSERT INTO %QUAL%$class->tableName$ (*/
  }

  repeat (class->attr | middle { /*,*/ } ) {
    if (class->QuoteChar != "") {
       endl /*                  $class->QuoteChar$$attr->column$$class->QuoteChar$*/
    } else {
       endl /*                  $attr->column$*/
    }
  }
  /* )
          VALUES (*/
  repeat (class->attr | middle { /*,*/ endl /*                  */ }  ) {
    scalarConversion(&attr->SQLType,&attr->currentInsert)
  }
  /*)*/
}

deleteStatement()
{
  Sub class

  if (class->QuoteChar != "") {
     /*DELETE FROM %QUAL%$class->QuoteChar$$class->tableName$$class->QuoteChar$ WHERE */ whereDataId()
  } else {
     /*DELETE FROM %QUAL%$class->tableName$ WHERE */ whereDataId()
  }
}

updateStatement()
{
  Sub class

  if (class->QuoteChar != "") {
     /*UPDATE %QUAL%$class->QuoteChar$$class->tableName$$class->QuoteChar$ SET */ endl
   } else {
     /*UPDATE %QUAL%$class->tableName$ SET */ endl
   }

  if (class->allDataIds) {
    repeat (class->attr | middle { /*, */ endl } ) {
      if (class->QuoteChar != "") {
        /*                 $class->QuoteChar$$attr->column$$class->QuoteChar$ = $scalarConversion(&attr->SQLType, &attr->currentUpdate)$*/
      } else {
        /*                  $attr->column$ = $scalarConversion(&attr->SQLType, &attr->currentUpdate)$*/
      }
    }
  }
  else {
    repeat (class->attr | middle { /*, */ endl } condition (!attr->isDataId) ) {
      if (class->QuoteChar != "") {
        /*                  $class->QuoteChar$$attr->column$$class->QuoteChar$ = $scalarConversion(&attr->SQLType, &attr->currentUpdate)$*/
      } else {
        /*                  $attr->column$ = $scalarConversion(&attr->SQLType, &attr->currentUpdate)$*/
      }
    }
  }

  /*
        WHERE */ whereDataId()
}

updateDataIdStatement()
{
  Sub class

  if (class->QuoteChar != "") {
     /*UPDATE %QUAL%$class->QuoteChar$$class->tableName$$class->QuoteChar$ SET */ endl
   } else {
     /*UPDATE %QUAL%$class->tableName$ SET */ endl
   }

  repeat (class->attr | middle { /*, */ endl } ) {
    if (class->QuoteChar != "") {
      /*                  $class->QuoteChar$$attr->column$$class->QuoteChar$ = $scalarConversion(&attr->SQLType,&attr->currentUpdate)$*/
    } else {
      /*                  $attr->column$ = $scalarConversion(&attr->SQLType,&attr->currentUpdate)$*/
    }
  }

  /*
        WHERE */ whereDataId()
}

esqlRetrieveStatement()
{
  Sub class

  /*SELECT */

  if (class->allDataIds) {
   repeat (class->attr | middle { /*, */ endl /*            */ } ) {
     if (class->QuoteChar != "") {
        /*$scalarColumn(&attr->ELEMENT, class->QuoteChar + attr->column + class->QuoteChar)$*/
     } else {
      /*$scalarColumn(&attr->ELEMENT, attr->column)$*/
     }
   }
  }
  else {
   repeat (class->attr | middle { /*, */ endl /*            */ }
                         condition(!attr->isDataId) ) {
    if (class->QuoteChar != "") {
      /*$scalarColumn(&attr->ELEMENT, class->QuoteChar + attr->column + class->QuoteChar)$*/
    } else {
      /*$scalarColumn(&attr->ELEMENT, attr->column)$*/
    }
   }
  }

  endl
  /*        INTO */

  if (class->allDataIds) {
   repeat (class->attr | middle {/*, */ endl /*             */ } ) { /*?*/ }
  }
  else {
   repeat (class->attr | middle {/*, */ endl /*             */ }
                         condition(!attr->isDataId) ) { /*?*/ }
  }

  endl

  if (class->QuoteChar != "") {
     /*        FROM $Qualifier()$$class->QuoteChar$$class->tableName$$class->QuoteChar$ WHERE */ whereDataId()
  } else {
     /*        FROM $Qualifier()$$class->tableName$ WHERE */ whereDataId()
  }
}

scalarConversion(SQLType,current)
{
  if (SQLType == "DATE" && current) /*CURRENT DATE*/
  else if (SQLType == "TIME" && current) /*CURRENT TIME*/
  else if (SQLType == "TIMESTAMP" && current) /*CURRENT TIMESTAMP*/
  else /*?*/
}

whereDataId()
{
  Sub class

  repeat (class->attr | condition(attr->isDataId) middle { /* AND */ } ) {
    endl /*            $UDTCast(&attr, attr->column)$ = ?*/
  }
}

UDTCast(attr, column)
{
  if ( attr->UDTBaseType == "" ) { column }
  else if (attr->UDTBaseType == "CHAR" || attr->UDTBaseType == "VARCHAR" ||
           attr->UDTBaseType == "CLOB" || attr->UDTBaseType == "VARGRAPHIC" ||
           attr->UDTBaseType == "CHARFORBITDATA" || attr->UDTBaseType =="VARCHARFORBITDATA" ) {
    /*CAST($column$ AS $attr->UDTBaseType$($attr->length$))*/
  }
  else if (attr->UDTBaseType == "DECIMAL" || attr->UDTBaseType == "NUMERIC") {
    /*CAST($column$ AS $attr->UDTBaseType$($attr->precision$,$attr->scale$))*/
  }
  else {
    /*$attr->UDTBaseType$($column$)*/
  }
}

scalarColumn(attr, column)
{
  if (attr->SQLType=="DATE" || attr->SQLType=="TIME") {
    /*CHAR($UDTCast(&attr, column)$,ISO)*/
  }
  else if ( (attr->SQLType=="DECIMAL" || attr->SQLType=="NUMERIC")
            && attr->hostBufferType == "char*") {
    /*CHAR($UDTCast(&attr, column)$,'.')*/
  }
  else {
    column
  }
}

scalarInput(arg)
{
  Var name

  name = hostVariable(arg->hostBufferName)

  if ((arg->SQLType=="DECIMAL" || arg->SQLType=="NUMERIC") && arg->hostBufferType == "char*" ) {
    /*DECIMAL($name$, $arg->precision$, $arg->scale$)*/
  }
  else if (arg->SQLType=="DATE") {
    /*DATE($name$)*/
  }
  else if (arg->SQLType=="TIME") {
    /*TIME($name$)*/
  }
  else if (arg->SQLType=="TIMESTAMP") {
    /*TIMESTAMP($name$)*/
  }
  else {
    name
  }

}

hostVariable(bufferName)
{
  /*:$bufferName$ :$bufferName$_IND*/
}

javaDynamicSQL(SQLStatement)
{
  Sub class

  SQLStatement|change("\\","\\\\")|change("\"", "\\\"")|changeToken("%QUAL%", "\" + " + class->name + ".getQualifier() + \"")|change("\r\n", "\n")|change("\n", "\" +\n\" ")|change("\r"," ")
}

cppDynamicSQL(SQLStatement)
{
  Sub class

  SQLStatement|change("\\","\\\\")|change("\"", "\\\"")|changeToken("%QUAL%", "\" + " + class->name + "::getQualifier() + \"")|change("\r\n", "\n")|change("\r"," ")|change("\n"," \\\n")
}

cppStaticSQL(statement, arg)
{
  Var stmt, name

  stmt = statement

  repeat( arg | condition (arg->isAttribute || (!arg->isResultCol)) ) {
    if (arg->isInput) { name = scalarInput(&arg) }
    else { name = hostVariable(arg->hostBufferName) }
    stmt = stmt|changeToken("?", name, 1)
  }

  stmt|changeToken("%QUAL%", Qualifier())|change("\r\n","\n")|change("\r"," ")
}

Qualifier()
{
  Sub class
  if (class->qualifier != "") { /*$class->qualifier$.*/ }
}
