-- -----------------------------------------------------------
--
--  IBM(R) VisualAge(TM) for Java(TM) Version 1 and others
--   - Licensed Material - Program-Property of IBM
--  (C) Copyright IBM Corp. 1997 - All Rights Reserved.
--  US Government Users Restricted Rights - Use, duplication or disclosure
--  restricted by GSA ADP Schedule Contract with IBM Corp.
--
-- -----------------------------------------------------------

--
-- This template file generates the Manager and DataIdManager classes.
--

manager()
{
  Sub class
  managerImpl("", &class->pdqMethod, &class->mSpcMethod)
}

dataIdManager()
{
  Sub class
  managerImpl("DataId", &class->pdqMethod, &class->mSpcMethod)
}

resultForm()
{
  Sub class
  resultFormImpl("")
}

dataIdResultForm()
{
  Sub class
  resultFormImpl("DataId")
}


--
-- implementation for the manager class (and DataIdManager class)
--
managerImpl(DataId, pdqMethod, mSpcMethod)
{
  Sub class
  Counter counter(1,1), parmCounter(0,1), index(0,1)
  Var CLASSNAME, PO, selectStmt, deleteStmt, updateStmt

  CLASSNAME = class->name + DataId

  if (DataId == "") {
    PO = "PersistentObject"
    selectStmt = javaDynamicSQL(managerFixedPart())
    deleteStmt = javaDynamicSQL(managerDeleteStmt())
    updateStmt = javaDynamicSQL(managerUpdateStmt())
  }
  else {
    PO = "PODataId"
    selectStmt = javaDynamicSQL(dataIdManFixedPart())
    deleteStmt = javaDynamicSQL(managerDeleteStmt())
    updateStmt = javaDynamicSQL(dataIdManUpdateStmt())
  }

  /*//---------------------------------------------------------------------------
// This code was generated by IBM VisualAge for Java Data Access Builder.
// WARNING: Modifications to this code will be lost on next code generation.
//---------------------------------------------------------------------------

$package()$

import java.lang.*;
import java.math.*;
import java.util.*;
import java.sql.*;
import COM.ibm.ivj.eab.data.*;
import COM.ibm.ivj.javabeans.*;
import java.awt.*;

//----------------------------------------------------------------
//
//  $CLASSNAME$Manager
//
//----------------------------------------------------------------

public class $CLASSNAME$Manager extends DAManager */ if (class->hasMngrAttr) /*implements DataAccessObject*/ /*
{
  public static String getSQLBaseQuery() { return "$selectStmt$"; }

 //----------------------------------------------------------------
 // Constructors
 //----------------------------------------------------------------
  public $CLASSNAME$Manager() {}
  public $CLASSNAME$Manager(DatastoreJDBC aDatastore) {
    super(aDatastore);
  }*/ endl
  -- define attributes (VO only)
  if (class->hasMngrAttr) {
    -- constructor that takes all attributes
    /*  public $CLASSNAME$Manager( */
    repeat (class->mngrAttr | middle { /*,*/ endl /*                   */ } ) {
      /*$mngrAttr->type$ a$mngrAttr->Name$*/
    }

    /* ) {*/ endl
    repeat (class->mngrAttr) {
      /*    set$mngrAttr->Name$(a$mngrAttr->Name$); */ endl
    }
   /*  }

 //----------------------------------------------------------------
 // DataAccessObject interface
 //----------------------------------------------------------------
  private boolean _isModified = false;
  public boolean isModified() {
     return _isModified;
  }
  public void setModified(boolean enable) {
    boolean temp = _isModified;
    _isModified = enable;
    firePropertyChange("modified", new Boolean(temp), new Boolean(_isModified));
  }

  public String[] getAttributeStrings() {
    String[] s = { */
    repeat(class->mngrAttr | middle { /*,*/ endl /*                   */ } ) {
      attrToString(&mngrAttr)
    }
 /* };
    return (s);
  }

  public Object[] getAttributes() {
    Object[] o = { */
   repeat(class->mngrAttr | middle { /*,*/ endl /*                   */ } ) {
     if ( isPrimitive(mngrAttr->type) ) {
      /*new $primitiveClass(mngrAttr->type)$(get$mngrAttr->Name$())*/
     } else {
      /*get$mngrAttr->Name$()*/
     }
   }
 /* };
    return (o);
  }

 //----------------------------------------------------------------
 // $CLASSNAME$Manager Attributes
 //---------------------------------------------------------------- */ endl
    repeat(class->mngrAttr) { /*
  //--------------------------------------------------------------
  // attribute: $mngrAttr->displayName$
  //-------------------------------------------------------------- */ endl
      attributeImpl(&mngrAttr, "", "false", "true")
    }
  }
/*
 //----------------------------------------------------------------
 // Database access methods
 //----------------------------------------------------------------

  public void select(String sqlSuffix) throws DAException {

    if ( !_onBackground() && isAsynchronous() ) {
      Object[] params = { sqlSuffix };
      _putOnBackgroundThread( "select(String)", params );
      return;
    }

    try {
      if (getCurrentDatastore() == null) throw new DAException(DAResource.NO_CONNECT_EXIST);
      if (isOpen()) close();
      if (sqlSuffix == null) sqlSuffix = "";

      _stmt = getCurrentDatastore().getConnection().prepareStatement(getSQLBaseQuery() + sqlSuffix); */ endl
     counter|reset()
     if (class->hasMngrAttr) endl
     bindMngrAttr("      ", &counter)
      /*
      _setStmtOptions();
      _rs = _stmt.executeQuery();
      _map = new $CLASSNAME$Map();
      _fillInternalSequence();
    } catch(SQLException exc) {
      throw new DAException (DAResource.SELECT_FAILED, exc);
    } finally {
      _dbclose();
      _setBusy(false);
    }

    _managerSupport.fireSelectComplete("select(String)");
  }

  public void open(String sqlSuffix) throws DAException {

    if ( !_onBackground() && isAsynchronous() ) {
      Object[] params = { sqlSuffix };
      _putOnBackgroundThread( "open(String)", params );
      return;
    }

    try {
      if (getCurrentDatastore() == null) throw new DAException(DAResource.NO_CONNECT_EXIST);
      if (isOpen()) close();
      if (sqlSuffix == null) sqlSuffix = "";

      _stmt = getCurrentDatastore().getConnection().prepareStatement(getSQLBaseQuery() + sqlSuffix); */ endl
     counter|reset()
     if (class->hasMngrAttr) endl
     bindMngrAttr("      ", &counter)
      /*
      _setStmtOptions();
      _rs = _stmt.executeQuery();
      _map = new $CLASSNAME$Map();
      _setOpen(true);

    } catch(SQLException exc) {
      throw new DAException(DAResource.OPEN_FAILED, exc);
    } finally {
      _setBusy(false);
    }

    _managerSupport.fireOpenComplete("open(String)");
  } */ endl

  if ( (!class->isVO) && (!class->defaultReadOnly) ) {
    /*
  public void deleteFetched() throws DAException {

    if ( !_onBackground() && isAsynchronous() ) {
      _putOnBackgroundThread( "deleteFetched()", null );
      return;
    }

    try {
      if (!isOpen()) throw new DAException(DAResource.CURSOR_NOT_OPEN);
      if (!isFetched()) throw new DAException(DAResource.ROW_NOT_FETCHED);

      PreparedStatement deleteStmt = getCurrentDatastore().getConnection().prepareStatement(
          "$deleteStmt$" + _rs.getCursorName()
        );

      deleteStmt.executeUpdate();

    } catch(SQLException exc) {
      throw new DAException(DAResource.ERROR_IN_METHOD, "deleteFetched() ", exc);
    } finally {
      _setBusy(false);
    }

    _setFetched(false);
    element().setModified(false);
    _managerSupport.fireDeleteFetchedComplete();
  }

  public void updateFetched() throws DAException {

    if ( !_onBackground() && isAsynchronous() ) {
      _putOnBackgroundThread( "updateFetched()", null );
      return;
    }

    $class->name$$DataId$ obj = element();

    try {
      if (!isOpen()) throw new DAException(DAResource.CURSOR_NOT_OPEN);
      if (!isFetched()) throw new DAException(DAResource.ROW_NOT_FETCHED);
      if (!obj.isModified()) throw new DAException(DAResource.NO_CHANGES_MADE);

      if (getCurrentDatastore().haveQuoteChar)
         $class->name$.generator.QuoteChar = getCurrentDatastore().quoteChar; */ endl

    if (DataId == "") {
        /*
      PreparedStatement updateStmt = getCurrentDatastore().getConnection().prepareStatement(
          $class->name$.generator.genUpdateFetched($class->name$.getQualifier(),
              */
      if (class->genDataId) /*obj.getDataId().modified*/
      else /*null*/
      /*, obj.modified) + _rs.getCursorName()
        );

      int index=1; */ endl

      index|reset()
      repeat(class->attr | condition(attr->isDataId && (!attr->currentUpdate)) ) {
        /*
      if (obj.getDataId().modified[$index$]) { */ endl
        setBuffer(&attr, "true", "obj.", "index++", "updateStmt", "        ")
        /*      }*/ endl
        index|increment()
      }

      index|reset()
      repeat(class->attr | condition((!attr->isDataId) && (!attr->currentUpdate)) ) {
        /*
      if (obj.modified[$index$]) { */ endl
        setBuffer(&attr, "true", "obj.", "index++", "updateStmt", "        ")
        /*      }*/ endl
        index|increment()
      }
    } else {
        /*
      PreparedStatement updateStmt = getCurrentDatastore().getConnection().prepareStatement(
          $class->name$.generator.genUpdateDataIdFetched($class->name$.getQualifier(), obj.modified) + _rs.getCursorName()
        );

      int index=1; */ endl

      index|reset()
      repeat(class->attr | condition(attr->isDataId && (!attr->currentUpdate)) ) {
        /*
      if (obj.modified[$index$]) { */ endl
        setBuffer(&attr, "true", "obj.", "index++", "updateStmt", "        ")
        /*      }*/ endl
        index|increment()
      }
    }

      /*
      updateStmt.executeUpdate();
      updateStmt.close();
    } catch(SQLException exc) {
      throw new DAException(DAResource.ERROR_IN_METHOD, "updateFetched() ", exc);
    } finally {
      _setBusy(false);
    }

    obj.setModified(false);
    _managerSupport.fireUpdateFetchedComplete();
  } */ endl
  }


  PDQMethods(&pdqMethod, DataId)
  mSPCMethods(&mSpcMethod, DataId)

  /*
  public $CLASSNAME$ element() { return ($CLASSNAME$)_cachedObject; }
  protected DataAccessObject newElement() { return new $CLASSNAME$(); }
*/
if (DataId == "") {
/*
  protected final DataAccessObject _newElement() {
    DataAccessObject newObject = newElement();
    (($CLASSNAME$)newObject).setObjectsDatastore(getObjectsDatastore());
    return newObject;
  }

  public void setObjectsDatastore(DatastoreJDBC aDatastore) {
    super.setObjectsDatastore(aDatastore);
    (($CLASSNAME$)_cachedObject).setObjectsDatastore(aDatastore);
  }
*/
}
/*

  public DatastoreJDBC getCurrentDatastore() {
    if (getObjectsDatastore() != null) return getObjectsDatastore();
    else if ($class->name$.getDefaultDatastore() != null) return $class->name$.getDefaultDatastore();
    else return DatastoreJDBC.getApplicationDatastore();
  }

  protected void firePropertyChange(String property, Object oldValue, Object newValue) {
    super.firePropertyChange(property, oldValue, newValue);
  }

  protected void _setBusy(boolean flag) { super._setBusy(flag); }

  ManagerCompleteSupport _getManagerSupport() { return _managerSupport; }

  public void _executeAction( String _methodName, Object[] _params ) throws Exception { */ endl endl

  Var elseif

  if ((!class->isVO) && (!class->defaultReadOnly)) {
   /*    if ( _methodName.equals("deleteFetched()") ) {
      deleteFetched();
    }
    else if ( _methodName.equals("updateFetched()") ) {
      updateFetched();
    } */ endl
    elseif = "else if"
  } else { elseif = "if" }

  repeat(pdqMethod) {
    callAMethodOnThread(&pdqMethod->ELEMENT, "open" + pdqMethod->name, "open" + methodID(&pdqMethod), elseif)
    callAMethodOnThread(&pdqMethod->ELEMENT, "select" + pdqMethod->name, "select" + methodID(&pdqMethod), "else if")
    elseif = "else if"
  }

  repeat(mSpcMethod) {
    callAMethodOnThread(&mSpcMethod->ELEMENT, "open" + mSpcMethod->name, "open" + methodID(&mSpcMethod), elseif)
    callAMethodOnThread(&mSpcMethod->ELEMENT, "select" + mSpcMethod->name, "select" + methodID(&mSpcMethod), "else if")
    elseif = "else if"
  }

  if (elseif != "if") {
    /*    else
      super._executeAction(_methodName,_params); */ endl
  } else {
    /*    super._executeAction(_methodName,_params); */ endl
  }
    /*
  }

}

//-----------------------------------------------------------------------------------
// The following class(es) are used to _map a result set into a $CLASSNAME$
//-----------------------------------------------------------------------------------
class $CLASSNAME$Map implements DAMap
{
  public void putResultSetInto(DataAccessObject obj, ResultSet rs, boolean saveStream) throws DAException, SQLException {
    $CLASSNAME$ theObj = ($CLASSNAME$)obj;
*/ endl
   counter|reset()
   if (DataId == "") {
     repeat(class->attr) {
       getBuffer(&attr, "theObj.", counter, "rs", "    ", "saveStream")
       counter|increment()
     }
   } else {
     repeat(class->attr | condition( attr->isDataId) ) {
       getBuffer(&attr, "theObj.", counter, "rs", "    ", "saveStream")
       counter|increment()
     }
   } /*
  }
} */ endl

  repeat ( mSpcMethod | before { endl
/*//----------------------------------------------------------------------------
// Classes for mapping $CLASSNAME$ to stored procedure result sets
//----------------------------------------------------------------------------*/ endl } ) {
  /*
class $CLASSNAME$From$mSpcMethod->name$Map implements DAMap
{
  public void putResultSetInto(DataAccessObject obj, ResultSet rs, boolean saveStream) throws DAException, SQLException  {
    $CLASSNAME$ theObj = ($CLASSNAME$)obj;
*/ endl
  if (DataId == "") {
    counter|reset()
    repeat(mSpcMethod->arg | condition (arg->isResultCol) ) {
      if (arg->isMapped) {
        getBuffer(&arg, "theObj.", counter, "rs", "    ", "saveStream")
      }
      counter|increment()
    }
  }
  else {
    counter|reset()
    repeat(mSpcMethod->arg | condition (arg->isResultCol) ) {
      if (arg->isMapped && arg->isDataId) {
        getBuffer(&arg, "theObj.", counter, "rs", "    ", "saveStream")
      }
      counter|increment()
    }
  }
/*
  }

}*/ endl
 }

} -- managerImpl

--
-- this snippet defines manager PDQ methods
--
PDQMethods(pdqMethodList, DataId)
{
 set escape "~"
 repeat ( pdqMethodList | before {  /*
 //----------------------------------------------------------------
 // Predefined Queries:
 //----------------------------------------------------------------*/ endl } ) {
  if (pdqMethodList->comment != "") {
   /*
  ~/**
    * $format(&pdqMethodList->comment, "    ")$
  *~/ */ endl
  }
   PDQImpl(&pdqMethodList, "open", DataId)
   PDQImpl(&pdqMethodList, "select", DataId)
 }
 set escape ""
}

--
-- this snippet defines manager Stored Procedure methods
--
mSPCMethods(spcMethodList, DataId)
{
  set escape "~"
  repeat ( spcMethodList | before {  /*
 //----------------------------------------------------------------
 // Stored Procedures:
 //----------------------------------------------------------------*/ endl } ) {
  if (spcMethodList->comment != "") {
   /*
  ~/**
    * $format(&spcMethodList->comment, "    ")$
  *~/ */ endl
  }
    SPCImpl(&spcMethodList, "open", DataId)
    SPCImpl(&spcMethodList, "select", DataId)
  }
  set escape ""
}

SPCImpl(method, methodType, DataId)
{
  Sub class
  Counter counter(1,1)
  Var ID

  ID = methodID(&method)
  /*
  public $method->returnType$ $methodType$$method->name$($Parameters(&method)$) throws DAException { */ endl

  if (method->returnType != "void") { endl /*    $method->returnType$ $method->returnName$; */ endl endl}

  putOnThread(&method, methodType + ID, "")

   /*
    try {
      if (getCurrentDatastore() == null) throw new DAException(DAResource.NO_CONNECT_EXIST);
      if (isOpen()) close();

      _stmt = getCurrentDatastore().getConnection().prepareCall(
          "$method->SQLStatement$"
        ); */ endl

  --
  -- Put arguments into statement
  --
  counter|reset()
  repeat(method->arg | before { endl } condition (arg->isOutput || arg->isInput) ) {
    if (arg->isInput)  { setBuffer(&arg, "false", "", &counter, "_stmt", "      ") }
    counter|increment()
  }

  --
  -- register output arguments
  --
  counter|reset()
  repeat(method->arg | before { endl } condition (arg->isOutput || arg->isInput) ) {
    if (arg->isOutput && arg->isMapped)  {
      /*      ((CallableStatement)_stmt).registerOutParameter($counter$, $getSQLType(&arg->SQLType)$$checkNumeric(&arg)$); */ endl
    }
    counter|increment()
  }

  /*
      _setStmtOptions();
      _rs = _stmt.executeQuery();*/ endl

  --
  -- get output parameters
  --
  counter|reset()
  repeat(method->arg | before { endl } condition (arg->isInput || arg->isOutput) ) {
    if (arg->isOutput && arg->isMapped) getBuffer(&arg, "", &counter, "((CallableStatement)_stmt)", "      ", "false")
    counter|increment()
  }

  /*      _map = new $class->name$$DataId$From$method->name$Map(); */ endl
  if (methodType == "select") {
   /*      _fillInternalSequence();*/ endl
  }
  else { /*     _setOpen(true); */ endl }

  /*
    } catch(SQLException exc) {
      throw new DAException(DAResource.ERROR_IN_METHOD, "$methodType$$ID$ ", exc);
    } finally { */
    if (methodType == "select") { /*
      _dbclose(); */
    } /*
      _setBusy(false);
    }

    _managerSupport.fire$methodType|upperCase(1,1)$Complete("$methodType$$ID$", $varAsObject(method->returnName, method->returnType)$);
*/ endl

  if (method->returnType != "void") { /*    return $method->returnName$; */ endl }

  /*
  }*/ endl

}

--
-- methodType is a flag that indicates if it is an open or select method
--
PDQImpl(method, methodType, DataId)
{
  Sub class
  Counter counter(1,1)
  Var ID

  ID = methodID(&method)

  /*
  public void $methodType$$method->name$($Parameters(&method)$) throws DAException { */ endl

   putOnThread(&method, methodType + ID, "")

   /*
    try {
      if (getCurrentDatastore() == null) throw new DAException(DAResource.NO_CONNECT_EXIST);
      if (isOpen()) close();
      if (sqlSuffix == null) sqlSuffix = "";

      _stmt = getCurrentDatastore().getConnection().prepareStatement(getSQLBaseQuery() +
         "$javaDynamicSQL(method->whereClause)$ " + sqlSuffix);*/ endl

  --
  -- Put arguments into statement
  --
  counter|reset()
  if (class->hasMngrAttr) endl
  bindMngrAttr("      ", &counter)

  repeat(method->arg | before { endl } condition (arg->isInput) ) {
    setBuffer(&arg, "false", "", &counter, "_stmt", "      ")
    counter|increment()
  }

  /*
      _setStmtOptions();
      _rs = _stmt.executeQuery();
      _map = new $class->name$$DataId$Map(); */ endl

  if (methodType == "select") {
   /*      _fillInternalSequence();*/ endl
  }
  else { /*      _setOpen(true); */ endl }
  /*
    } catch(SQLException exc) {
      throw new DAException (DAResource.ERROR_IN_METHOD, "$methodType$$ID$ ", exc);
    } finally { */
      if (methodType == "select") { /*
      _dbclose(); */
      } /*
      _setBusy(false);
    }

    _managerSupport.fire$methodType|upperCase(1,1)$Complete("$methodType$$ID$");
  }*/ endl

} -- PDQImpl

Parameters(method)
{
  repeat(method->arg | middle { /*, */ } condition (arg->isParameter) ) {
    /*$arg->type$ $arg->name$*/
    if (arg->isOutput || arg->isResultCol) { /*[]*/ }
  }
}

resultFormImpl(DataId)
{
  Sub class

  Var CLASSNAME

  CLASSNAME = class->name + DataId

 /*//------------------------------------------------------------------------
// This code was generated by IBM VisualAge for Java Data Access Builder.
// WARNING: Modifications to this code will be lost on next code generation.
//------------------------------------------------------------------------

$package()$

import java.lang.*;
import COM.ibm.ivj.eab.data.*;
import java.beans.*;

public class $CLASSNAME$ResultForm extends DataAccessResultForm
{
   public $CLASSNAME$ResultForm()
   {
      this( new $CLASSNAME$Manager() );
   }
   public $CLASSNAME$ResultForm($CLASSNAME$Manager aManager)
   {
      super(attributeLabels);
      setManager(aManager);
   }
   private static String[] attributeLabels = {
            */
if (DataId == "") {
  repeat(class->attr | middle { /*,*/ endl /*            */ } ) {
   /*"$attr->name$"*/
  }
}
else {
  repeat(class->attr | middle { /*,*/ endl /*            */ } condition(attr->isDataId) ) {
   /*"$attr->name$"*/
  }
}
/*  };
   // only allow labels to be changed, not the number of columns
   public void setColumns( String[] labels )
   {
      if ( labels.length != attributeLabels.length )
         throw new IllegalArgumentException();
      else
         super.setColumns(labels);
   }

}
*/

} -- resultFormImpl

managerForm()
{
  Sub class
  Counter counter(1,1)
  Var temp

/*//------------------------------------------------------------------------
// This code was generated by IBM VisualAge for Java Data Access Builder.
// WARNING: Modifications to this code will be lost on next code generation.
//------------------------------------------------------------------------

$package()$

import java.lang.*;
import java.math.*;
import java.util.*;
import java.beans.*;
import java.sql.*;
import COM.ibm.ivj.eab.data.*;
import java.io.Serializable;

public class $class->name$ManagerForm extends DataAccessObjectForm
{
  public $class->name$ManagerForm()
  {
    this( new $class->name$Manager() );
  }
  public $class->name$ManagerForm($class->name$Manager target)
  {
    super( attributeNames
         , attributeLabels
         , attributeNullables
         , attributeClasses );
    setTarget(target);
  }

  public $class->name$Manager getTargetAs$class->name$Manager()
  {
    return ($class->name$Manager) getTarget();
  }

  public void setTargetAs$class->name$Manager( $class->name$Manager aTarget )
  {
    super.setTarget( (DataAccessObject) aTarget );
  }
  protected DataAccessObject validateTarget(DataAccessObject aTarget)
  {
    return ($class->name$Manager) aTarget;
  }

  public static Class[] attributeClasses = {
*/
repeat(class->mngrAttr | middle { /*,*/ endl /*            */ } ) {
         AttributeClass(mngrAttr->type)
}
/*
  };
  public static String[] attributeLabels = {
            */
 repeat(class->mngrAttr | middle { /*,*/ endl /*            */ } ) {
  /*"$mngrAttr->displayName$"*/
 }
/*  };
  public static String[] attributeNames = {
            */
 repeat(class->mngrAttr | middle { /*,*/ endl /*            */ } ) {
  /*"$mngrAttr->name$"*/
 }
/*  };
  private static boolean[] attributeNullables = {
            */
 repeat(class->mngrAttr | middle { /*,*/ endl /*            */ } ) {
  /*true*/
 }
/*  };
  private static int[] attributeWidths = {
            */
 repeat(class->mngrAttr | middle { /*,*/ endl /*            */ } ) {
  /*$mngrAttr->length$*/
 }
/*  };
  public void attributeFromEditor(String attributeName, PropertyEditor editor) throws DAException
  {
    if ( editor == null )
      return;
*/
repeat(class->mngrAttr) {
/*    else if ( attributeName.equals("$mngrAttr->name$") )
         getTargetAs$class->name$Manager().set$mngrAttr->Name$($GetFromEditor(mngrAttr->type,"editor")$);
 */
}

/*
  }

  public void attributeIntoEditor(String attributeName, PropertyEditor editor)
  {
    if ( editor == null )
      return;
*/
repeat(class->mngrAttr) {
/*    else if ( attributeName.equals("$mngrAttr->name$") )
*/
  if (isPrimitive(mngrAttr->type))
  {
/*      editor.setValue(new $primitiveClass(mngrAttr->type)$(getTargetAs$class->name$Manager().get$mngrAttr->Name$()));
 */
  }
  else
  {
/*      editor.setValue(getTargetAs$class->name$Manager().get$mngrAttr->Name$());
 */
  }
}

/*
  }

}
*/

} -- managerForm

bindMngrAttr(spaces, counter)
{
  Sub class

  if (class->hasMngrAttr) {
    repeat( class->mngrAttr) {
      setBuffer(&mngrAttr, "true", "", counter, "_stmt", spaces)
      counter|increment()
    }
  }
}
