/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.command;

import com.ibm.connector.AlreadyConnectedException;
import com.ibm.connector.Communication;
import com.ibm.connector.CommunicationException;
import com.ibm.connector.ConnectionSpec;
import com.ibm.connector.ConnectorException;
import com.ibm.connector.InteractionSpec;
import com.ibm.connector.LogonException;
import com.ibm.connector.NoConnectionAvailableException;
import com.ibm.connector.NotConnectedException;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.ivj.eab.command.Command;
import com.ibm.ivj.eab.command.CommandEvent;
import com.ibm.ivj.eab.command.ExecutionException;
import com.ibm.ivj.eab.command.ICommandPrimitive;
import com.ibm.ivj.eab.util.BeanDumper;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ResourceBundle;

public class CommandCommunicationPrimitive
implements ICommandPrimitive {
    private static ResourceBundle resCommandResourceBundle = ResourceBundle.getBundle("com.ibm.ivj.eab.command.CommandResourceBundle");
    static final String copyright = "(c) Copyright IBM Corporation 1998.";
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private ConnectionSpec fieldConnectionSpec = null;
    private InteractionSpec fieldInteractionSpec = null;
    private Communication fieldCommunication = null;
    private boolean fieldDisconnectCommunication = true;
    private Object fieldInput = null;
    private Object fieldOutput = null;
    private boolean fieldInternalBeforeAfter = false;
    private boolean fieldIsExternalCommunication = false;
    private Command fieldParentCommand = null;

    public synchronized void addPropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.addPropertyChangeListener(arg1);
    }

    public void afterExecute(CommandEvent commandEvent) {
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("->  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".afterExecute(CommandEvent)]");
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() == 3) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(this.toString());
        }
        if (commandEvent.getPropertyNamed("__ComIbmIvjEabCommand_Exception") != null) {
            if (this.getCommunication() != null && !this.fieldIsExternalCommunication) {
                try {
                    this.getCommunication().disconnect();
                }
                catch (Throwable throwable) {}
                this.fieldCommunication = null;
            }
            return;
        }
        Communication communication = null;
        if (!this.getInternalBeforeAfter()) {
            if (!this.fieldIsExternalCommunication && this.getDisconnectCommunication() && this.getCommunication() != null) {
                try {
                    this.getCommunication().disconnect();
                    this.fieldCommunication = null;
                }
                catch (NotConnectedException notConnectedException) {
                }
                catch (CommunicationException communicationException) {
                    if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 1) {
                        RuntimeContext.getCurrent().getRASService().logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".afterExecute(CommandEvent) error: Unable to stop communication.]");
                    }
                    throw new RuntimeException(resCommandResourceBundle.getString("IVJC0855__Unable_to_stop_c"));
                }
            }
            if ((communication = this.getCommunication()) != null) {
                if (this.fieldIsExternalCommunication) {
                    commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Communication", communication);
                } else if (!this.getDisconnectCommunication()) {
                    commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Communication", communication);
                }
            }
        } else if (this.getCommunication() != null) {
            commandEvent.setPropertyNamed("__ComIbmIvjEabCommand_Communication", this.getCommunication());
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("<-  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".afterExecute(CommandEvent)]");
        }
    }

    public void beforeExecute(CommandEvent commandEvent) {
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("->  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent)]");
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() == 3) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(this.toString());
        }
        Communication communication = (Communication)commandEvent.getPropertyNamed("__ComIbmIvjEabCommand_Communication");
        if (!this.getInternalBeforeAfter()) {
            if (communication != null) {
                this.fieldCommunication = communication;
                this.fieldIsExternalCommunication = true;
            }
            if (this.getCommunication() == null && this.getConnectionSpec() != null) {
                this.fieldCommunication = this.getConnectionSpec().createCommunication();
                try {
                    this.getCommunication().connect();
                }
                catch (LogonException ex1) {
                    if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 1) {
                        RuntimeContext.getCurrent().getRASService().logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent) error: connect throws LogonException]");
                    }
                    throw ex1;
                }
                catch (NoConnectionAvailableException ex2) {
                    if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 1) {
                        RuntimeContext.getCurrent().getRASService().logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent) error: connect throws NoConnectionAvailableException]");
                    }
                    throw ex2;
                }
                catch (AlreadyConnectedException ex3) {
                    if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 1) {
                        RuntimeContext.getCurrent().getRASService().logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent) error: connect throws AlreadyConnectedException]");
                    }
                    throw ex3;
                }
                catch (CommunicationException ex4) {
                    if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 1) {
                        RuntimeContext.getCurrent().getRASService().logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent) error: connect throws CommunicationException]");
                    }
                    throw ex4;
                }
            }
        } else if (communication != null) {
            this.fieldCommunication = communication;
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("<-  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".beforeExecute(CommandEvent)]");
        }
    }

    public void execute() {
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("->  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute()]");
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() == 3) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(this.toString());
        }
        if (this.getCommunication() == null) {
            RuntimeContext.getCurrent().getRASService().logError(resCommandResourceBundle.getString("IVJC0864__Communication_no"));
            if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 1) {
                RuntimeContext.getCurrent().getRASService().logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute() error: Communication not provided]");
            }
            throw new ExecutionException(resCommandResourceBundle.getString("IVJC0864__Communication_no"));
        }
        if (this.getInteractionSpec() == null) {
            RuntimeContext.getCurrent().getRASService().logError(resCommandResourceBundle.getString("IVJC0865__InteractionSpeci"));
            if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 1) {
                RuntimeContext.getCurrent().getRASService().logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute() error: InteractionSpecification not provided]");
            }
            throw new ExecutionException(resCommandResourceBundle.getString("IVJC0865__InteractionSpeci"));
        }
        try {
            this.getCommunication().execute(this.getInteractionSpec(), this.getInput(), this.getOutput());
        }
        catch (ConnectorException exception) {
            block13: {
                if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 1) {
                    RuntimeContext.getCurrent().getRASService().logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute() error: execute throws ConnectorException]");
                }
                try {
                    this.getCommunication().disconnect();
                }
                catch (Exception exception2) {
                    if (RuntimeContext.getCurrent().getRASService().getTraceLevel() < 1) break block13;
                    RuntimeContext.getCurrent().getRASService().logTraceInfo("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute() error: disconnect after exception in exectue failed]");
                }
            }
            throw exception;
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() == 3) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo(this.toString());
        }
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("<-  [com.ibm.ivj.eab.command.CommandCommunicationPrimitive@" + this.hashCode() + ".execute()]");
        }
    }

    public void firePropertyChange(String arg1, Object arg2, Object arg3) {
        this.propertyChange.firePropertyChange(arg1, arg2, arg3);
    }

    public Communication getCommunication() {
        return this.fieldCommunication;
    }

    public ConnectionSpec getConnectionSpec() {
        return this.fieldConnectionSpec;
    }

    public boolean getDisconnectCommunication() {
        return this.fieldDisconnectCommunication;
    }

    public Object getInput() {
        return this.fieldInput;
    }

    public InteractionSpec getInteractionSpec() {
        return this.fieldInteractionSpec;
    }

    public boolean getInternalBeforeAfter() {
        return this.fieldInternalBeforeAfter;
    }

    public Object getOutput() {
        return this.fieldOutput;
    }

    public Command getParentCommand() {
        return this.fieldParentCommand;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener arg1) {
        this.propertyChange.removePropertyChangeListener(arg1);
    }

    public void setCommunication(Communication communication) {
        this.fieldIsExternalCommunication = true;
        Communication oldValue = this.fieldCommunication;
        this.fieldCommunication = communication;
        this.firePropertyChange("communication", oldValue, communication);
    }

    public void setConnectionSpec(ConnectionSpec connectionSpec) {
        ConnectionSpec oldValue = this.fieldConnectionSpec;
        this.fieldConnectionSpec = connectionSpec;
        this.firePropertyChange("connectionSpec", oldValue, connectionSpec);
    }

    public void setDisconnectCommunication(boolean disconnectCommunication) {
        boolean oldValue = this.fieldDisconnectCommunication;
        this.fieldDisconnectCommunication = disconnectCommunication;
        this.firePropertyChange("disconnectCommunication", new Boolean(oldValue), new Boolean(disconnectCommunication));
    }

    public void setInput(Object input) {
        Object oldValue = this.fieldInput;
        this.fieldInput = input;
        this.firePropertyChange("input", oldValue, input);
    }

    public void setInteractionSpec(InteractionSpec interactionSpec) {
        InteractionSpec oldValue = this.fieldInteractionSpec;
        this.fieldInteractionSpec = interactionSpec;
        this.firePropertyChange("interactionSpec", oldValue, interactionSpec);
    }

    public void setInternalBeforeAfter(boolean internalBeforeAfter) {
        boolean oldValue = this.fieldInternalBeforeAfter;
        this.fieldInternalBeforeAfter = internalBeforeAfter;
        this.firePropertyChange("internalBeforeAfter", new Boolean(oldValue), new Boolean(internalBeforeAfter));
    }

    public void setOutput(Object output) {
        if (this.fieldOutput == null) {
            Object oldValue = this.fieldOutput;
            this.fieldOutput = output;
            this.firePropertyChange("output", oldValue, output);
        }
    }

    public void setParentCommand(Command parentCommand) {
        Command oldValue = this.fieldParentCommand;
        this.fieldParentCommand = parentCommand;
        this.firePropertyChange("parentCommand", oldValue, parentCommand);
    }

    public String toString() {
        String dumpString = "";
        try {
            StringWriter strwrtr = new StringWriter();
            if (strwrtr == null) {
                return dumpString;
            }
            PrintWriter pwrtr = new PrintWriter((Writer)strwrtr, true);
            if (pwrtr == null) {
                return dumpString;
            }
            pwrtr.println("    [com.ibm.ivj.eab.command.CommandCommunicationPrimitive]");
            BeanDumper.setIndentation("        ");
            pwrtr.println("      fieldInput: ");
            pwrtr.println("        [" + BeanDumper.toString(this.fieldInput) + "        ]");
            pwrtr.println("      fieldOutput: ");
            pwrtr.println("        [" + BeanDumper.toString(this.fieldOutput) + "        ]");
            pwrtr.println("      fieldConnectionSpec: ");
            pwrtr.println("        [" + BeanDumper.toString(this.fieldConnectionSpec) + "        ]");
            pwrtr.println("      fieldInteractionSpec: ");
            pwrtr.println("        [" + BeanDumper.toString(this.fieldInteractionSpec) + "        ]");
            pwrtr.println("      fieldCommunication: ");
            pwrtr.println("        [" + BeanDumper.toString(this.fieldCommunication) + "        ]");
            BeanDumper.setIndentation("    ");
            pwrtr.println("      fieldDisconnectCommunication: ");
            pwrtr.println("        [" + new Boolean(this.fieldDisconnectCommunication).toString() + "        ]");
            pwrtr.println("      fieldInternalBeforeAfter: ");
            pwrtr.println("        [" + new Boolean(this.fieldInternalBeforeAfter).toString() + "        ]");
            pwrtr.println("      fieldIsExternalCommunication: ");
            pwrtr.println("        [" + new Boolean(this.fieldIsExternalCommunication).toString() + "        ]");
            dumpString = strwrtr.toString();
        }
        catch (Exception exception) {
            return dumpString;
        }
        return dumpString;
    }
}

