/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.record.cobol;

import com.ibm.ivj.eab.record.cobol.CobolRecordResource;
import com.ibm.ivj.eab.record.cobol.CodePageConversionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

class CobolIconvHost
implements Serializable,
Cloneable {
    private static String copyrights = "(c) Copyright IBM Corporation 1997, 1998.";
    private String targetCodePage;
    private static final boolean DEBUG = false;

    public CobolIconvHost(String aTargetCodePage) {
        this.targetCodePage = aTargetCodePage;
    }

    public String asDebugInfo() {
        return this.targetCodePage;
    }

    public String asString() {
        return new String("CobolIconvHost");
    }

    public Object clone() {
        try {
            CobolIconvHost newIconv = (CobolIconvHost)super.clone();
            newIconv.targetCodePage = new String(this.targetCodePage);
            return newIconv;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public String iconvFromHost(byte[] hostString) {
        String resultString2 = null;
        try {
            resultString2 = new String(hostString, this.targetCodePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0217E", this.targetCodePage));
        }
        catch (IOException iOException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
        }
        return resultString2;
    }

    public byte[] iconvToHost(String unicode) {
        byte[] tmp = new byte[]{};
        try {
            ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)outBuffer, this.targetCodePage);
            outWriter.write(unicode, 0, unicode.length());
            outWriter.flush();
            tmp = outBuffer.toByteArray();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0217E", this.targetCodePage));
        }
        catch (IOException iOException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
        }
        return tmp;
    }

    public static void printBuffer(byte[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            int j = (buffer[i] & 0xF0) >> 4;
            int k = buffer[i] & 0xF;
            System.out.print(Integer.toString(j, 16));
            System.out.print(Integer.toString(k, 16));
            System.out.print(" ");
            ++i;
        }
        System.out.println();
    }
}

