/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.imstoc;

import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.imstoc.IMSOTMAMsgProperties;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IMSTRNSeg
implements IMSOTMAMsgProperties {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private short dataLength;
    private byte IMSState = 0;
    private byte syncType = 0;
    private byte syncLevel = 0;
    private byte reserved;
    private byte[] mapName;
    private byte[] serverToken;
    private byte[] correlator;
    private byte[] contextID;
    private byte[] LTERMName;
    private short userDataLen;
    protected RuntimeContext _RuntimeContext = RuntimeContext.getCurrent();

    public IMSTRNSeg() {
        this.dataLength = this.sizeOfTRNSeg();
        this.reserved = (byte)64;
        this.mapName = new byte[8];
        int i = 0;
        while (i < this.mapName.length) {
            this.mapName[i] = 64;
            ++i;
        }
        this.serverToken = new byte[16];
        i = 0;
        while (i < this.serverToken.length) {
            this.serverToken[i] = 0;
            ++i;
        }
        this.correlator = new byte[16];
        i = 0;
        while (i < this.correlator.length) {
            this.correlator[i] = 0;
            ++i;
        }
        this.contextID = new byte[16];
        i = 0;
        while (i < this.contextID.length) {
            this.contextID[i] = 0;
            ++i;
        }
        this.LTERMName = new byte[8];
        i = 0;
        while (i < this.LTERMName.length) {
            this.LTERMName[i] = 64;
            ++i;
        }
        this.userDataLen = 0;
    }

    public byte[] export() throws IOException {
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        bos = new ByteArrayOutputStream();
        dos = new DataOutputStream(bos);
        byte[] newByteArray = null;
        char[] cArray = new char[]{' ', ' '};
        String methodName = String.valueOf(super.toString()) + ".export()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        dos.writeShort(this.dataLength);
        dos.writeByte(this.IMSState);
        dos.writeByte(this.syncType);
        dos.writeByte(this.syncLevel);
        dos.writeByte(this.reserved);
        int i = 0;
        while (i < this.mapName.length) {
            dos.writeByte(this.mapName[i]);
            ++i;
        }
        i = 0;
        while (i < this.serverToken.length) {
            dos.writeByte(this.serverToken[i]);
            ++i;
        }
        i = 0;
        while (i < this.correlator.length) {
            dos.writeByte(this.correlator[i]);
            ++i;
        }
        i = 0;
        while (i < this.contextID.length) {
            dos.writeByte(this.contextID[i]);
            ++i;
        }
        i = 0;
        while (i < this.LTERMName.length) {
            dos.writeByte(this.LTERMName[i]);
            ++i;
        }
        dos.writeShort(this.userDataLen);
        newByteArray = bos.toByteArray();
        return newByteArray;
    }

    public void setBitONCommitMode(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONCommitMode(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.syncType = (byte)(this.syncType | bitValue);
    }

    public void setBitONIMSState(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONIMSState(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.IMSState = (byte)(this.IMSState | bitValue);
    }

    public void setBitONSyncLevel(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONSyncLevel(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.syncLevel = (byte)(this.syncLevel | bitValue);
    }

    public void setLTERMName(byte[] aLTName) {
        String methodName = String.valueOf(super.toString()) + ".setLTERMName(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (aLTName != null && aLTName.length <= 8) {
            int i = 0;
            while (i < aLTName.length) {
                this.LTERMName[i] = aLTName[i];
                ++i;
            }
        }
    }

    public short sizeOfTRNSeg() {
        short size = 0;
        String methodName = String.valueOf(super.toString()) + ".sizeOfTRNSeg()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        size = (short)(size + 2 + 1 + 1 + 1 + 1 + 8 + 16 + 16 + 16 + 8 + 2);
        return size;
    }

    public String toString() {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        byte[] newByteArray = null;
        String hexString = null;
        String retString = "0x";
        char[] h = new char[]{' ', ' '};
        String methodName = String.valueOf(super.toString()) + ".toString()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        try {
            newByteArray = this.export();
            int i = 0;
            while (i < newByteArray.length) {
                h[0] = hex[newByteArray[i] >> 4 & 0xF];
                h[1] = hex[newByteArray[i] & 0xF];
                hexString = new String(h);
                retString = String.valueOf(retString) + hexString;
                ++i;
            }
        }
        catch (IOException iOException) {}
        return retString;
    }
}

