/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.imstoc;

import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.imstoc.IMSOTMAMsgProperties;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IMSMCISeg
implements IMSOTMAMsgProperties {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private byte msgLevel = 1;
    private byte msgType = 0;
    private byte respInd = 0;
    private byte cmtState = 0;
    private byte cmdType = 0;
    private byte procType = 0;
    private byte[] tpipeName;
    private byte chainState;
    private byte prefixFlag;
    private int sendSeqNumber;
    private short senseCode;
    private short reasonCode;
    private int recoverableMsgSeqNumber;
    private short segSeqNumber;
    private byte[] reserved;
    protected RuntimeContext _RuntimeContext = RuntimeContext.getCurrent();

    public IMSMCISeg() {
        this.tpipeName = new byte[8];
        int i = 0;
        while (i < this.tpipeName.length) {
            this.tpipeName[i] = 64;
            ++i;
        }
        this.chainState = (byte)-96;
        this.prefixFlag = 0;
        this.sendSeqNumber = 0;
        this.senseCode = 0;
        this.reasonCode = 0;
        this.recoverableMsgSeqNumber = 0;
        this.segSeqNumber = 0;
        this.reserved = new byte[2];
        i = 0;
        while (i < this.reserved.length) {
            this.reserved[i] = 0;
            ++i;
        }
    }

    public byte[] export() throws IOException {
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        bos = new ByteArrayOutputStream();
        dos = new DataOutputStream(bos);
        byte[] newByteArray = null;
        String methodName = String.valueOf(super.toString()) + ".export()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        dos.writeByte(this.msgLevel);
        dos.writeByte(this.msgType);
        dos.writeByte(this.respInd);
        dos.writeByte(this.cmtState);
        dos.writeByte(this.cmdType);
        dos.writeByte(this.procType);
        int i = 0;
        while (i < this.tpipeName.length) {
            dos.writeByte(this.tpipeName[i]);
            ++i;
        }
        dos.writeByte(this.chainState);
        dos.writeByte(this.prefixFlag);
        dos.writeInt(this.sendSeqNumber);
        dos.writeShort(this.senseCode);
        dos.writeShort(this.reasonCode);
        dos.writeInt(this.recoverableMsgSeqNumber);
        dos.writeShort(this.segSeqNumber);
        dos.writeByte(this.reserved[0]);
        dos.writeByte(this.reserved[1]);
        newByteArray = bos.toByteArray();
        return newByteArray;
    }

    public void setBitOFFChainState(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitOFFChainState(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.chainState = (byte)(this.chainState & (0xFF ^ bitValue));
    }

    public void setBitOFFMsgType(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitOFFMsgType(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.msgType = (byte)(this.msgType & (0xFF ^ bitValue));
    }

    public void setBitONChainState(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONChainState(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.chainState = (byte)(this.chainState | bitValue);
    }

    public void setBitONCommitConfirm(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONCommitConfirm(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.cmtState = (byte)(this.cmtState | bitValue);
    }

    public void setBitONMsgType(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONMsgType(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.msgType = (byte)(this.msgType | bitValue);
    }

    public void setBitONPrefixFlag(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONPrefixFlag(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.prefixFlag = (byte)(this.prefixFlag | bitValue);
    }

    public void setBitONResponseIndicator(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONResponseIndicator(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.respInd = (byte)(this.respInd | bitValue);
    }

    public void setBitONResumeTpipe(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONResumeTpipe(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        this.cmdType = (byte)(this.cmdType | bitValue);
    }

    public void setSegSeqNumber(short seqNum) {
        String methodName = String.valueOf(super.toString()) + ".setSegSeqNumber(short)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> ]" + methodName + "]");
        }
        this.segSeqNumber = seqNum;
    }

    public short sizeOfMCISeg() {
        String methodName = String.valueOf(super.toString()) + ".sizeOfMCISeg()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        short size = 0;
        size = (short)(size + 1 + 1 + 1 + 1 + 1 + 1 + 8 + 1 + 1 + 4 + 2 + 2 + 4 + 2 + 2);
        return size;
    }

    public String toString() {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        byte[] newByteArray = null;
        String hexString = null;
        String retString = "0x";
        char[] h = new char[]{' ', ' '};
        String methodName = String.valueOf(super.toString()) + ".toString()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        try {
            newByteArray = this.export();
            int i = 0;
            while (i < newByteArray.length) {
                h[0] = hex[newByteArray[i] >> 4 & 0xF];
                h[1] = hex[newByteArray[i] & 0xF];
                hexString = new String(h);
                retString = String.valueOf(retString) + hexString;
                ++i;
            }
        }
        catch (IOException iOException) {}
        return retString;
    }
}

