/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.util;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;

public class BeanDumper {
    private static String fieldIndentation = "    ";

    public static void setIndentation(String aIndentation) {
        if (aIndentation != null) {
            fieldIndentation = aIndentation;
        }
    }

    public static String toString(Object bean) {
        String dumpString = "";
        String indentString = fieldIndentation;
        if (bean == null) {
            return "null";
        }
        try {
            StringWriter strwrtr = new StringWriter();
            if (strwrtr == null) {
                return dumpString;
            }
            PrintWriter pwrtr = new PrintWriter((Writer)strwrtr, true);
            if (pwrtr == null) {
                return dumpString;
            }
            PropertyDescriptor[] propDescr = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors();
            if (propDescr == null) {
                return dumpString;
            }
            pwrtr.println(String.valueOf(indentString) + "[" + bean.toString() + "]");
            indentString = String.valueOf(indentString) + "    ";
            int i = 0;
            while (i < propDescr.length) {
                try {
                    Method method = propDescr[i].getReadMethod();
                    if (method != null) {
                        if (method.getParameterTypes().length == 0) {
                            pwrtr.print(String.valueOf(indentString) + propDescr[i].getName() + ": [");
                            Object field = method.invoke(bean, null);
                            if (field != null) {
                                pwrtr.print(field.toString());
                                pwrtr.println("]");
                            } else {
                                pwrtr.println("null]");
                            }
                        } else {
                            pwrtr.println("");
                        }
                    } else {
                        pwrtr.println("");
                    }
                }
                catch (Exception exception) {
                    pwrtr.println(" | ");
                }
                ++i;
            }
            dumpString = strwrtr.toString();
        }
        catch (Exception exception) {
            return String.valueOf(dumpString) + " || ";
        }
        return dumpString;
    }
}

