/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.imstoc;

import com.ibm.connector.AlreadyConnectedException;
import com.ibm.connector.CommunicationException;
import com.ibm.connector.NotConnectedException;
import com.ibm.connector.imstoc.DFSProperties;
import com.ibm.connector.imstoc.IMSAPIState;
import com.ibm.connector.imstoc.IMSAdapterResource;
import com.ibm.connector.imstoc.IMSConnectionSpec;
import com.ibm.connector.imstoc.IMSInteractionSpec;
import com.ibm.connector.imstoc.IMSTOCProperties;
import com.ibm.connector.imstoc.IMSTOCResourceException;
import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.connector.internal.BadInvOrderException;
import com.ibm.connector.internal.ResourceException;
import com.ibm.imstoc.IMSConverter;
import com.ibm.imstoc.IMSException;
import com.ibm.imstoc.IMSOTMAMsg;
import com.ibm.imstoc.IMSOTMAMsgList;
import com.ibm.imstoc.IMSOTMAMsgProperties;
import com.ibm.imstoc.IMSOutputSegment;
import com.ibm.imstoc.IMSOutputSegmentList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Random;

public class IMSAdapter
implements IMSOTMAMsgProperties,
IMSTOCProperties,
DFSProperties {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    protected RuntimeContext _RuntimeContext = RuntimeContext.getCurrent();
    private String _mapName = "";
    private String _dataStoreName = "";
    private String _userID = "        ";
    private String _groupName = "        ";
    private String _passWord = "        ";
    private String _userName = null;
    private int _commitMode = 1;
    private int _syncLevel = 0;
    private String _ltermName = "";
    public IMSConverter _aConvObj;
    private short _currentSegment = 1;
    private IMSOTMAMsgList _aIMSInList = null;
    private IMSOutputSegmentList _aIMSOutList = null;
    private Socket _Socket = null;
    private IMSConnectionSpec _connectionSpec = null;
    private int _mode = 0;
    private IMSAPIState _IMSAPIState;
    private IMSAdapterResource _res = new IMSAdapterResource();

    public IMSAdapter() {
        this._RuntimeContext = RuntimeContext.getCurrent();
        this._IMSAPIState = new IMSAPIState();
        this._aConvObj = new IMSConverter("Cp037");
    }

    public void addInputSegment(byte[] aSegment, boolean hasLLZZ) throws ResourceException {
        IMSOTMAMsg aOTMAMsg = null;
        byte[] destBytes = null;
        byte[] ltrmBytes = null;
        byte[] userBytes = null;
        byte[] usIDBytes = null;
        byte[] gpNMBytes = null;
        byte[] passWdBytes = null;
        String methodName = String.valueOf(super.toString()) + ".addInputSegment(byte[], boolean)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        try {
            if (this._currentSegment == 1) {
                this.generateUserName();
                this._aIMSInList = new IMSOTMAMsgList(this._userName);
                aOTMAMsg = new IMSOTMAMsg(this._currentSegment, aSegment, hasLLZZ, true);
                aOTMAMsg.setFirst();
                destBytes = this._aConvObj.getBytes(this._dataStoreName, false);
                aOTMAMsg.setDestID(destBytes);
                ltrmBytes = this._aConvObj.getBytes(this._ltermName, false);
                aOTMAMsg.setLTERMName(ltrmBytes);
                userBytes = this._aConvObj.getBytes(this._userName, false);
                aOTMAMsg.setOriginalID(userBytes);
                usIDBytes = this._aConvObj.getBytes(this._userID, false);
                aOTMAMsg.setUserId(usIDBytes);
                gpNMBytes = this._aConvObj.getBytes(this._groupName, false);
                aOTMAMsg.setGroupId(gpNMBytes);
                passWdBytes = this._aConvObj.getBytes(this._passWord, false);
                aOTMAMsg.setPassword(passWdBytes);
                if (this._mode == 3) {
                    aOTMAMsg.setBitONMsgType((byte)8);
                }
                if (this._IMSAPIState.isInConversation()) {
                    aOTMAMsg.setBitONIMSState((byte)-128);
                    aOTMAMsg.setBitONMsgType((byte)-128);
                } else {
                    aOTMAMsg.setBitONMsgType((byte)64);
                }
                if (this._commitMode == 0) {
                    aOTMAMsg.setBitONCommitMode((byte)64);
                } else {
                    aOTMAMsg.setBitONCommitMode((byte)32);
                }
                if (this._syncLevel == 1) {
                    aOTMAMsg.setBitONSyncLevel((byte)1);
                }
            } else {
                aOTMAMsg = new IMSOTMAMsg(this._currentSegment, aSegment, hasLLZZ, true);
                aOTMAMsg.setMiddle();
            }
            this._aIMSInList.addElement(aOTMAMsg);
            this._currentSegment = (short)(this._currentSegment + 1);
        }
        catch (UnsupportedEncodingException e1) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e1});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e1.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e1.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IOException e2) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e2});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e2.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e2.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IMSException e3) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e3});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e3.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e3.printStackTrace(printErrorWriter);
            throw e;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void clearInputSegments() {
        String methodName = String.valueOf(super.toString()) + ".clearInputSegments()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        this._currentSegment = 1;
        if (this._aIMSInList != null) {
            Enumeration en = null;
            IMSOTMAMsg aOTMAMsg = null;
            en = this._aIMSInList.elements();
            if (en != null) {
                while (en.hasMoreElements()) {
                    aOTMAMsg = (IMSOTMAMsg)en.nextElement();
                    this._aIMSInList.removeElement(aOTMAMsg);
                }
            }
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void clearOutputSegments() {
        String methodName = String.valueOf(super.toString()) + ".clearOutputSegments()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        if (this._aIMSOutList != null) {
            Enumeration en = null;
            IMSOutputSegment outputSeg = null;
            en = this._aIMSOutList.elements();
            if (en != null) {
                while (en.hasMoreElements()) {
                    outputSeg = (IMSOutputSegment)en.nextElement();
                    this._aIMSOutList.removeElement(outputSeg);
                }
            }
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public synchronized void connect() throws AlreadyConnectedException, CommunicationException, BadInvOrderException {
        String methodName = String.valueOf(super.toString()) + ".connect()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        try {
            if (this.isConnected()) {
                String errMsg = this._res.getString("0002E", new Object[]{methodName});
                AlreadyConnectedException e = new AlreadyConnectedException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e.printStackTrace(printErrorWriter);
                throw e;
            }
            this._userName = null;
            if (this._IMSAPIState.getState() == 0) {
                this._Socket = new Socket(this._connectionSpec.getHostName(), this._connectionSpec.getPortNumber());
                if (rasService.getTraceLevel() >= 3) {
                    rasService.logTraceInfo("   " + methodName + "Connected to HostName [" + this._connectionSpec.getHostName() + "] Port number [" + this._connectionSpec.getPortNumber() + "]");
                }
            } else {
                String errMsg = this._res.getString("0003E", new Object[]{methodName, new String("CONNECT_STATE"), String.valueOf(0), this._IMSAPIState.getStateAsText()});
                BadInvOrderException e = new BadInvOrderException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                    rasService.logTraceInfo(e.toString());
                    e.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e.printStackTrace(printErrorWriter);
                throw e;
            }
            this._IMSAPIState.setState(1);
        }
        catch (IOException e1) {
            String errMsg = this._res.getString("0004E", new Object[]{methodName, this._connectionSpec.getHostName(), String.valueOf(this._connectionSpec.getPortNumber()), e1});
            CommunicationException e = new CommunicationException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e1.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e1.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IllegalArgumentException e2) {
            String errMsg = this._res.getString("0004E", new Object[]{methodName, this._connectionSpec.getHostName(), String.valueOf(this._connectionSpec.getPortNumber()), e2});
            CommunicationException e = new CommunicationException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e2.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e2.printStackTrace(printErrorWriter);
            throw e;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public synchronized void disconnect() throws NotConnectedException, BadInvOrderException {
        String methodName = String.valueOf(super.toString()) + ".disconnect()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        try {
            if (this.isConnected()) {
                this._Socket.close();
                if (rasService.getTraceLevel() >= 3) {
                    rasService.logTraceInfo(String.valueOf(methodName) + ": Socket closed.");
                }
            } else {
                String errMsg = this._res.getString("0005E", new Object[]{methodName});
                NotConnectedException e = new NotConnectedException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e.printStackTrace(printErrorWriter);
                throw e;
            }
            this._IMSAPIState.setState(0);
            this._Socket = null;
        }
        catch (IOException e1) {
            this._Socket = null;
            String errMsg = this._res.getString("0006E", new Object[]{methodName, e1});
            CommunicationException e = new CommunicationException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e1.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e1.printStackTrace(printErrorWriter);
            throw e;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public String dumpBytesInHex(byte[] buffer) {
        String str = "\t[\n\t\t";
        int rowCount = 0;
        int i = 0;
        while (i < buffer.length) {
            int jj = (buffer[i] & 0xF0) >> 4;
            int k = buffer[i] & 0xF;
            str = String.valueOf(str) + Integer.toString(jj, 16);
            str = String.valueOf(str) + Integer.toString(k, 16);
            str = String.valueOf(str) + " ";
            if (++rowCount >= 16) {
                str = String.valueOf(str) + "\n\t\t";
                rowCount = 0;
            }
            ++i;
        }
        str = String.valueOf(str) + "\n\t]";
        return str;
    }

    public synchronized void exitConversation() {
        IMSOTMAMsg aOTMAMsg = null;
        int buffLen = 0;
        int buffIndx = 0;
        byte[] newByteArray = null;
        byte[] prodName = null;
        byte[] buffer = null;
        byte[] aOTMABuff = null;
        byte[] destBytes = null;
        byte[] userNameBytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        String methodName = String.valueOf(super.toString()) + ".exitConversation()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        try {
            aOTMAMsg = new IMSOTMAMsg(1, null, false, true);
            aOTMAMsg.setFirst();
            destBytes = this._aConvObj.getBytes(this._dataStoreName, false);
            aOTMAMsg.setDestID(destBytes);
            aOTMAMsg.setBitONMsgType((byte)8);
            if (this._commitMode == 0) {
                aOTMAMsg.setBitONCommitMode((byte)64);
            } else {
                aOTMAMsg.setBitONCommitMode((byte)32);
            }
            aOTMAMsg.setLast();
            buffLen = 498;
            buffer = new byte[buffLen];
            dos.writeInt(buffLen);
            dos.writeShort(28);
            dos.writeShort(0);
            newByteArray = bos.toByteArray();
            prodName = this._aConvObj.getBytes("*HWSJAV*", false);
            int i = 0;
            while (i < newByteArray.length) {
                buffer[buffIndx] = newByteArray[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < prodName.length) {
                buffer[buffIndx] = prodName[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            buffer[buffIndx] = 64;
            buffer[++buffIndx] = -64;
            ++buffIndx;
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            userNameBytes = this._aConvObj.getBytes(this._userName, false);
            i = 0;
            while (i < userNameBytes.length) {
                buffer[buffIndx] = userNameBytes[i];
                ++buffIndx;
                ++i;
            }
            buffIndx = 32;
            aOTMABuff = aOTMAMsg.export();
            i = 0;
            while (i < aOTMABuff.length) {
                buffer[buffIndx] = aOTMABuff[i];
                ++buffIndx;
                ++i;
            }
        }
        catch (UnsupportedEncodingException e1) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e1});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e1.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e1.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IOException e2) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e2});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e2.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e2.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IMSException e3) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e3});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e3.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e3.printStackTrace(printErrorWriter);
            throw e;
        }
        try {
            if (rasService.getTraceLevel() >= 3) {
                rasService.logTraceInfo("  Buffer to send:");
                rasService.logTraceInfo(this.dumpBytesInHex(buffer));
            }
            DataOutputStream out1 = new DataOutputStream(this._Socket.getOutputStream());
            int i = 0;
            while (i < buffer.length) {
                out1.writeByte(buffer[i]);
                ++i;
            }
        }
        catch (IOException e4) {
            String errMsg = this._res.getString("0016E", new Object[]{methodName, e4});
            CommunicationException e = new CommunicationException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e4.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e4.printStackTrace(printErrorWriter);
            throw e;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void generateUserName() {
        int aRandomNumber = 0;
        int len = 0;
        byte[] cfr_ignored_0 = new byte[8];
        String methodName = String.valueOf(super.toString()) + ".generateUserName()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        if (this._userName == null) {
            if (this._commitMode == 1) {
                String newID;
                Random aRandomGenerator;
                if (this.isConnected()) {
                    try {
                        this._Socket.getLocalPort();
                        InetAddress localAdd1 = this._Socket.getLocalAddress();
                        byte[] address = localAdd1.getAddress();
                        StringBuffer addBuf = new StringBuffer(address.length * 3 + 100);
                        int i = 0;
                        while (i < address.length) {
                            int unsignedByte = address[i] < 0 ? address[i] + 256 : address[i];
                            String str = Integer.toString(unsignedByte);
                            if (i > 0) {
                                int j = 0;
                                while (j < 3 - str.length()) {
                                    addBuf.append("0");
                                    ++j;
                                }
                            }
                            addBuf.append(str);
                            ++i;
                        }
                        addBuf.append(this._Socket.getLocalPort());
                        Long addAsLong = new Long(addBuf.toString());
                        aRandomGenerator = new Random(addAsLong);
                    }
                    catch (Exception exception) {
                        aRandomGenerator = new Random();
                    }
                } else {
                    aRandomGenerator = new Random();
                }
                if ((newID = Integer.toString(aRandomNumber = aRandomGenerator.nextInt(), 36).toUpperCase()).charAt(0) == '-') {
                    newID = newID.substring(1);
                }
                while (true) {
                    if ((len = newID.length()) > 5) {
                        newID = newID.substring(len - 5, len);
                        break;
                    }
                    if (len >= 5) break;
                    aRandomNumber = aRandomGenerator.nextInt();
                    String nextID = Integer.toString(aRandomNumber, 36).toUpperCase();
                    if (nextID.charAt(0) == '-') {
                        nextID = nextID.substring(1);
                    }
                    newID = newID.concat(nextID);
                }
                String HWSID = new String("HWS");
                HWSID = String.valueOf(HWSID) + newID;
                this.setUserName(HWSID);
            } else {
                this.setUserName(this._userID);
            }
        }
    }

    public int getCommitMode() {
        String methodName = String.valueOf(super.toString()) + ".getCommitMode()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return this._commitMode;
    }

    public IMSAPIState getIMSAPIState() {
        String methodName = String.valueOf(super.toString()) + ".getIMSAPIState()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return this._IMSAPIState;
    }

    public int getSyncLevel() {
        String methodName = String.valueOf(super.toString()) + ".getSyncLevel()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return this._syncLevel;
    }

    public String getUserName() {
        String methodName = String.valueOf(super.toString()) + ".getCommitMode()";
        if (RuntimeContext.getCurrent().getRASService().getTraceLevel() >= 2) {
            RuntimeContext.getCurrent().getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return this._userName;
    }

    public boolean isConnected() {
        String methodName = String.valueOf(super.toString()) + ".isConnected()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        return this._Socket != null;
    }

    public String parseStringRep(String stringRep) {
        String ID = new String();
        int split = stringRep.indexOf(64);
        ID = stringRep.substring(split + 1);
        return ID;
    }

    public synchronized Object receive(IMSInteractionSpec interactionSpec) throws ResourceException {
        DataInputStream in = null;
        DataInputStream in2 = null;
        ByteArrayInputStream bos = null;
        int retcode = 0;
        int lengthOfDataSoFar = 0;
        byte[] exitIDplusTwo = new byte[10];
        byte[] skip1 = new byte[12];
        byte[] skip2 = new byte[4];
        byte[] skip3 = new byte[12];
        byte[] skip5 = new byte[3];
        byte[] skip8 = new byte[200];
        byte[] skip9 = new byte[208];
        short sensecode = 0;
        int recLength = 0;
        byte[] mapNameBytes = new byte[8];
        byte[] rescodeBytes = new byte[8];
        byte[] mci = new byte[32];
        byte[] ll = new byte[2];
        byte[] cfr_ignored_0 = new byte[2];
        byte[] buff = null;
        byte[] buff2 = null;
        int outputSegNum = 0;
        int totalLength = 0;
        boolean commError = false;
        String methodName = String.valueOf(super.toString()) + ".receive()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        try {
            try {
                in = new DataInputStream(this._Socket.getInputStream());
                totalLength = in.readInt();
                in.readFully(exitIDplusTwo);
                byte responseIndicator = in.readByte();
                in.readFully(skip1);
                in.readByte();
                in.readFully(skip2);
                sensecode = in.readShort();
                in.readFully(skip3);
                byte state = in.readByte();
                in.readFully(skip5);
                in.readFully(mapNameBytes);
                if (rasService.getTraceLevel() >= 3) {
                    rasService.logTraceInfo("  [" + super.toString() + ".receive()]");
                    rasService.logTraceInfo("  MapName is: [" + mapNameBytes + "]");
                    rasService.logTraceInfo(this.dumpBytesInHex(mapNameBytes));
                }
                String mapName = this._aConvObj.getString(mapNameBytes, false);
                interactionSpec.setMapName(mapName);
                this._aIMSOutList = new IMSOutputSegmentList(mapName);
                in.readFully(skip8);
                retcode = in.readInt();
                in.readFully(rescodeBytes);
                String rescode = this._aConvObj.getString(rescodeBytes, false);
                in.readFully(skip9);
                lengthOfDataSoFar = 478;
                if (lengthOfDataSoFar < totalLength) {
                    in.readFully(ll);
                    bos = new ByteArrayInputStream(ll);
                    in2 = new DataInputStream(bos);
                    recLength = in2.readShort();
                    buff = new byte[recLength];
                    in.readFully(buff, 2, recLength - 2);
                    buff[0] = ll[0];
                    buff[1] = ll[1];
                    if (rasService.getTraceLevel() >= 3) {
                        rasService.logTraceInfo("  [" + super.toString() + ".receive()]");
                        rasService.logTraceInfo("  Buffer received:");
                        rasService.logTraceInfo(this.dumpBytesInHex(buff));
                    }
                    if (mapName.equals("DFSMO1  ") || mapName.equals("DFSMO2  ") || mapName.equals("DFSMO3  ") || mapName.equals("DFSMO4  ") || mapName.equals("DFSMO5  ") || mapName.equals("DFSDSPO1")) {
                        buff2 = new byte[123];
                        int i = 4;
                        while (i < 123) {
                            buff2[i] = 64;
                            ++i;
                        }
                        buff2[0] = 0;
                        buff2[1] = 123;
                        buff2[2] = buff[2];
                        buff2[3] = buff[3];
                        if (recLength - 4 > 119) {
                            recLength = 123;
                        }
                        i = 4;
                        while (i < recLength) {
                            buff2[i] = buff[i];
                            ++i;
                        }
                        if (rasService.getTraceLevel() >= 3) {
                            rasService.logTraceInfo("  [" + super.toString() + ".receive()]");
                            rasService.logTraceInfo("  DFSMO1 Buffer constructed:");
                            rasService.logTraceInfo(this.dumpBytesInHex(buff2));
                        }
                        recLength = 123;
                        this._aIMSOutList.addElement(new IMSOutputSegment(buff2));
                    } else {
                        this._aIMSOutList.addElement(new IMSOutputSegment(buff));
                    }
                    ++outputSegNum;
                    lengthOfDataSoFar += recLength;
                    while (lengthOfDataSoFar < totalLength) {
                        in.readFully(mci);
                        lengthOfDataSoFar += mci.length;
                        in.readFully(ll);
                        bos = new ByteArrayInputStream(ll);
                        in2 = new DataInputStream(bos);
                        recLength = in2.readShort();
                        buff = new byte[recLength];
                        in.readFully(buff, 2, recLength - 2);
                        buff[0] = ll[0];
                        buff[1] = ll[1];
                        this._aIMSOutList.addElement(new IMSOutputSegment(buff));
                        ++outputSegNum;
                        lengthOfDataSoFar += recLength;
                    }
                }
                if (retcode != 0) {
                    String errMsg = this._res.getString("0017E", new Object[]{methodName, "HWSJ001", String.valueOf(retcode), rescode});
                    IMSTOCResourceException e = new IMSTOCResourceException(errMsg, "HWSJ001", retcode, rescode);
                    if (rasService.getTraceLevel() >= 2) {
                        PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                        rasService.logTraceInfo(((Throwable)((Object)e)).toString());
                        ((Throwable)((Object)e)).printStackTrace(printTraceWriter);
                    }
                    PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                    rasService.logError(((Throwable)((Object)e)).toString());
                    ((Throwable)((Object)e)).printStackTrace(printErrorWriter);
                    throw e;
                }
                if (responseIndicator == 64) {
                    String errMsg = this._res.getString("0018E", new Object[]{methodName, "HWSJ002", String.valueOf(sensecode)});
                    IMSTOCResourceException e = new IMSTOCResourceException(errMsg, "HWSJ002", sensecode, "");
                    if (rasService.getTraceLevel() >= 2) {
                        PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                        rasService.logTraceInfo(((Throwable)((Object)e)).toString());
                        ((Throwable)((Object)e)).printStackTrace(printTraceWriter);
                    }
                    PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                    rasService.logError(((Throwable)((Object)e)).toString());
                    ((Throwable)((Object)e)).printStackTrace(printErrorWriter);
                    throw e;
                }
                this.clearInputSegments();
                this._IMSAPIState.setIsInResponse(responseIndicator == 32);
                this._IMSAPIState.setIsInConversation(state == -128);
            }
            catch (UnsupportedEncodingException e1) {
                String errMsg = this._res.getString("0001E", new Object[]{methodName, e1});
                ResourceException e = new ResourceException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e1.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e1.printStackTrace(printErrorWriter);
                throw e;
            }
            catch (IOException e2) {
                commError = true;
                String errMsg = this._res.getString("0001E", new Object[]{methodName, e2});
                CommunicationException e = new CommunicationException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e2.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e2.printStackTrace(printErrorWriter);
                throw e;
            }
            catch (IMSException e3) {
                String errMsg = this._res.getString("0001E", new Object[]{methodName, e3});
                ResourceException e = new ResourceException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e3.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e3.printStackTrace(printErrorWriter);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var29_51 = null;
            if (!commError) {
                this._IMSAPIState.setVerifyState(2);
            }
            throw throwable;
        }
        Object var29_52 = null;
        if (!commError) {
            this._IMSAPIState.setVerifyState(2);
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
        return this._aIMSOutList;
    }

    public synchronized void resumeTpipe() throws ResourceException {
        IMSOTMAMsg aOTMAMsg = null;
        int buffLen = 0;
        int buffIndx = 0;
        ByteArrayOutputStream bos = null;
        DataOutputStream dos = null;
        bos = new ByteArrayOutputStream();
        dos = new DataOutputStream(bos);
        byte[] newByteArray = null;
        byte[] prodName = null;
        byte[] buffer = null;
        byte[] aOTMABuff = null;
        byte[] destBytes = null;
        byte[] userNameBytes = null;
        String methodName = String.valueOf(super.toString()) + ".resumeTpipe()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        try {
            this.generateUserName();
            aOTMAMsg = new IMSOTMAMsg(1, null, false, true);
            userNameBytes = this._aConvObj.getBytes(this._userName, false);
            aOTMAMsg.setOriginalID(userNameBytes);
            aOTMAMsg.setFirst();
            destBytes = this._aConvObj.getBytes(this._dataStoreName, false);
            aOTMAMsg.setDestID(destBytes);
            aOTMAMsg.setBitONMsgType((byte)16);
            aOTMAMsg.setBitONResumeTpipe((byte)36);
            if (this._commitMode == 0) {
                aOTMAMsg.setBitONCommitMode((byte)64);
            } else {
                aOTMAMsg.setBitONCommitMode((byte)32);
            }
            aOTMAMsg.setLast();
            buffLen = 498;
            buffer = new byte[buffLen];
            dos.writeInt(buffLen);
            dos.writeShort(28);
            dos.writeShort(0);
            newByteArray = bos.toByteArray();
            prodName = this._aConvObj.getBytes("*HWSJAV*", false);
            int i = 0;
            while (i < newByteArray.length) {
                buffer[buffIndx] = newByteArray[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < prodName.length) {
                buffer[buffIndx] = prodName[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            buffer[buffIndx] = 64;
            buffer[++buffIndx] = -64;
            ++buffIndx;
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < userNameBytes.length) {
                buffer[buffIndx] = userNameBytes[i];
                ++buffIndx;
                ++i;
            }
            buffIndx = 32;
            aOTMABuff = aOTMAMsg.export();
            i = 0;
            while (i < aOTMABuff.length) {
                buffer[buffIndx] = aOTMABuff[i];
                ++buffIndx;
                ++i;
            }
        }
        catch (UnsupportedEncodingException e1) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e1});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e1.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e1.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IOException e2) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e2});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e2.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e2.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IMSException e3) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e3});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e3.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e3.printStackTrace(printErrorWriter);
            throw e;
        }
        try {
            if (rasService.getTraceLevel() >= 3) {
                rasService.logTraceInfo("  Buffer to send:");
                rasService.logTraceInfo(this.dumpBytesInHex(buffer));
            }
            DataOutputStream out1 = new DataOutputStream(this._Socket.getOutputStream());
            int i = 0;
            while (i < buffer.length) {
                out1.writeByte(buffer[i]);
                ++i;
            }
            this._IMSAPIState.setVerifyState(7);
        }
        catch (IOException e4) {
            String errMsg = this._res.getString("0016E", new Object[]{methodName, e4});
            CommunicationException e = new CommunicationException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e4.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e4.printStackTrace(printErrorWriter);
            throw e;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public synchronized void send() throws ResourceException, CommunicationException {
        IMSOTMAMsg aOTMAMsg = null;
        byte[] aOTMABuff = null;
        byte[] buffer = null;
        int buffLen = 0;
        int buffPos = 0;
        int buffIndx = 0;
        int j = 0;
        Enumeration en = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] newByteArray = null;
        byte[] prodName = null;
        byte[] userNameBytes = null;
        String methodName = String.valueOf(super.toString()) + ".send()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        if (this._aIMSInList != null) {
            try {
                int i;
                aOTMAMsg = (IMSOTMAMsg)this._aIMSInList.lastElement();
                aOTMAMsg.setLast();
                buffLen = 32;
                en = this._aIMSInList.elements();
                while (en.hasMoreElements()) {
                    aOTMAMsg = (IMSOTMAMsg)en.nextElement();
                    buffLen += aOTMAMsg.sizeOfOTMAMsg();
                }
                buffer = new byte[buffLen];
                en = null;
                buffPos = 32;
                en = this._aIMSInList.elements();
                while (en.hasMoreElements()) {
                    aOTMABuff = null;
                    j = 0;
                    aOTMABuff = ((IMSOTMAMsg)en.nextElement()).export();
                    i = buffPos;
                    while (i < buffPos + aOTMABuff.length) {
                        buffer[i] = aOTMABuff[j];
                        ++j;
                        ++i;
                    }
                    buffPos += aOTMABuff.length;
                }
                dos.writeInt(buffLen);
                dos.writeShort(28);
                dos.writeShort(0);
                newByteArray = bos.toByteArray();
                i = 0;
                while (i < newByteArray.length) {
                    buffer[buffIndx] = newByteArray[i];
                    ++buffIndx;
                    ++i;
                }
                prodName = this._aConvObj.getBytes("*HWSJAV*", false);
                i = 0;
                while (i < prodName.length) {
                    buffer[buffIndx] = prodName[i];
                    ++buffIndx;
                    ++i;
                }
                i = 0;
                while (i < 3) {
                    buffer[buffIndx] = 0;
                    ++buffIndx;
                    ++i;
                }
                buffer[buffIndx] = 64;
                buffer[++buffIndx] = -64;
                ++buffIndx;
                i = 0;
                while (i < 3) {
                    buffer[buffIndx] = 0;
                    ++buffIndx;
                    ++i;
                }
                userNameBytes = this._aConvObj.getBytes(this._userName, false);
                i = 0;
                while (i < userNameBytes.length) {
                    buffer[buffIndx] = userNameBytes[i];
                    ++buffIndx;
                    ++i;
                }
            }
            catch (UnsupportedEncodingException e1) {
                String errMsg = this._res.getString("0001E", new Object[]{methodName, e1});
                ResourceException e = new ResourceException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e1.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e1.printStackTrace(printErrorWriter);
                throw e;
            }
            catch (IOException e2) {
                String errMsg = this._res.getString("0001E", new Object[]{methodName, e2});
                ResourceException e = new ResourceException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e2.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e2.printStackTrace(printErrorWriter);
                throw e;
            }
            catch (IMSException e3) {
                String errMsg = this._res.getString("0001E", new Object[]{methodName, e3});
                ResourceException e = new ResourceException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e3.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e3.printStackTrace(printErrorWriter);
                throw e;
            }
            try {
                DataOutputStream out1 = new DataOutputStream(this._Socket.getOutputStream());
                if (rasService.getTraceLevel() >= 3) {
                    rasService.logTraceInfo("  [" + super.toString() + ".send()]");
                    rasService.logTraceInfo("  Buffer to send:");
                    rasService.logTraceInfo(this.dumpBytesInHex(buffer));
                }
                out1.write(buffer, 0, buffer.length);
            }
            catch (IOException e4) {
                String errMsg = this._res.getString("0016E", new Object[]{methodName, e4});
                CommunicationException e = new CommunicationException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e4.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e4.printStackTrace(printErrorWriter);
                throw e;
            }
        }
        this.clearOutputSegments();
        if (this._commitMode == 0) {
            this._IMSAPIState.setVerifyState(3);
        } else {
            this._IMSAPIState.setVerifyState(1);
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public synchronized void sendAck() throws ResourceException, CommunicationException {
        IMSOTMAMsg aOTMAMsg = null;
        int buffLen = 0;
        int buffIndx = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] newByteArray = null;
        byte[] prodName = null;
        byte[] buffer = null;
        byte[] aOTMABuff = null;
        byte[] destBytes = null;
        byte[] userNameBytes = null;
        String methodName = String.valueOf(super.toString()) + ".sendAck()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        try {
            aOTMAMsg = new IMSOTMAMsg(1, null, false, true);
            aOTMAMsg.setFirst();
            destBytes = this._aConvObj.getBytes(this._dataStoreName, false);
            aOTMAMsg.setDestID(destBytes);
            userNameBytes = this._aConvObj.getBytes(this._userName, false);
            aOTMAMsg.setOriginalID(userNameBytes);
            aOTMAMsg.setBitONMsgType((byte)32);
            aOTMAMsg.setBitONResponseIndicator((byte)-128);
            if (this._commitMode == 0) {
                aOTMAMsg.setBitONCommitMode((byte)64);
            } else {
                aOTMAMsg.setBitONCommitMode((byte)32);
            }
            aOTMAMsg.setLast();
            buffLen = 498;
            buffer = new byte[buffLen];
            dos.writeInt(buffLen);
            dos.writeShort(28);
            dos.writeShort(0);
            newByteArray = bos.toByteArray();
            prodName = this._aConvObj.getBytes("*HWSJAV*", false);
            int i = 0;
            while (i < newByteArray.length) {
                buffer[buffIndx] = newByteArray[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < prodName.length) {
                buffer[buffIndx] = prodName[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            buffer[buffIndx] = 64;
            buffer[++buffIndx] = -64;
            ++buffIndx;
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < userNameBytes.length) {
                buffer[buffIndx] = userNameBytes[i];
                ++buffIndx;
                ++i;
            }
            buffIndx = 32;
            aOTMABuff = aOTMAMsg.export();
            i = 0;
            while (i < aOTMABuff.length) {
                buffer[buffIndx] = aOTMABuff[i];
                ++buffIndx;
                ++i;
            }
        }
        catch (UnsupportedEncodingException e1) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e1});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e1.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e1.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IOException e2) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e2});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e2.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e2.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IMSException e3) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e3});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e3.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e3.printStackTrace(printErrorWriter);
            throw e;
        }
        try {
            if (rasService.getTraceLevel() >= 3) {
                rasService.logTraceInfo("  Buffer to send:");
                rasService.logTraceInfo(this.dumpBytesInHex(buffer));
            }
            DataOutputStream out1 = new DataOutputStream(this._Socket.getOutputStream());
            int i = 0;
            while (i < buffer.length) {
                out1.writeByte(buffer[i]);
                ++i;
            }
            this._IMSAPIState.setVerifyState(4);
        }
        catch (IOException e4) {
            String errMsg = this._res.getString("0016E", new Object[]{methodName, e4});
            CommunicationException e = new CommunicationException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e4.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e4.printStackTrace(printErrorWriter);
            throw e;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public synchronized void sendCommit(IMSInteractionSpec interactionSpec) throws ResourceException {
        IMSOTMAMsg aOTMAMsg = null;
        int buffLen = 0;
        int buffIndx = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] newByteArray = null;
        byte[] prodName = null;
        byte[] buffer = null;
        byte[] aOTMABuff = null;
        byte[] destBytes = null;
        byte[] userNameBytes = null;
        String methodName = String.valueOf(super.toString()) + ".sendCommit(InteractionSpec)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        try {
            aOTMAMsg = new IMSOTMAMsg(1, null, false, true);
            aOTMAMsg.setFirst();
            destBytes = this._aConvObj.getBytes(this._dataStoreName, false);
            aOTMAMsg.setDestID(destBytes);
            userNameBytes = this._aConvObj.getBytes(this._userName, false);
            aOTMAMsg.setOriginalID(userNameBytes);
            aOTMAMsg.setBitONMsgType((byte)1);
            aOTMAMsg.setBitONResponseIndicator((byte)-128);
            if (this._commitMode == 0) {
                aOTMAMsg.setBitONCommitMode((byte)64);
            } else {
                aOTMAMsg.setBitONCommitMode((byte)32);
            }
            aOTMAMsg.setLast();
            buffLen = 498;
            buffer = new byte[buffLen];
            dos.writeInt(buffLen);
            dos.writeShort(28);
            dos.writeShort(0);
            newByteArray = bos.toByteArray();
            prodName = this._aConvObj.getBytes("*HWSJAV*", false);
            int i = 0;
            while (i < newByteArray.length) {
                buffer[buffIndx] = newByteArray[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < prodName.length) {
                buffer[buffIndx] = prodName[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            buffer[buffIndx] = 64;
            buffer[++buffIndx] = -64;
            ++buffIndx;
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < userNameBytes.length) {
                buffer[buffIndx] = userNameBytes[i];
                ++buffIndx;
                ++i;
            }
            buffIndx = 32;
            aOTMABuff = aOTMAMsg.export();
            i = 0;
            while (i < aOTMABuff.length) {
                buffer[buffIndx] = aOTMABuff[i];
                ++buffIndx;
                ++i;
            }
        }
        catch (UnsupportedEncodingException e1) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e1});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e1.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e1.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IOException e2) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e2});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e2.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e2.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IMSException e3) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e3});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e3.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e3.printStackTrace(printErrorWriter);
            throw e;
        }
        try {
            if (rasService.getTraceLevel() >= 3) {
                rasService.logTraceInfo("  Buffer to send:");
                rasService.logTraceInfo(this.dumpBytesInHex(buffer));
            }
            DataOutputStream out1 = new DataOutputStream(this._Socket.getOutputStream());
            int i = 0;
            while (i < buffer.length) {
                out1.writeByte(buffer[i]);
                ++i;
            }
        }
        catch (IOException e4) {
            String errMsg = this._res.getString("0016E", new Object[]{methodName, e4});
            CommunicationException e = new CommunicationException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e4.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e4.printStackTrace(printErrorWriter);
            throw e;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public synchronized void sendNack() throws ResourceException, CommunicationException {
        IMSOTMAMsg aOTMAMsg = null;
        int buffLen = 0;
        int buffIndx = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] newByteArray = null;
        byte[] prodName = null;
        byte[] buffer = null;
        byte[] aOTMABuff = null;
        byte[] destBytes = null;
        byte[] userNameBytes = null;
        String methodName = String.valueOf(super.toString()) + ".sendNack()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        try {
            aOTMAMsg = new IMSOTMAMsg(1, null, false, true);
            aOTMAMsg.setFirst();
            destBytes = this._aConvObj.getBytes(this._dataStoreName, false);
            aOTMAMsg.setDestID(destBytes);
            userNameBytes = this._aConvObj.getBytes(this._userName, false);
            aOTMAMsg.setOriginalID(userNameBytes);
            aOTMAMsg.setBitONMsgType((byte)32);
            aOTMAMsg.setBitONResponseIndicator((byte)64);
            if (this._commitMode == 0) {
                aOTMAMsg.setBitONCommitMode((byte)64);
            } else {
                aOTMAMsg.setBitONCommitMode((byte)32);
            }
            aOTMAMsg.setLast();
            buffLen = 498;
            buffer = new byte[buffLen];
            dos.writeInt(buffLen);
            dos.writeShort(28);
            dos.writeShort(0);
            newByteArray = bos.toByteArray();
            prodName = this._aConvObj.getBytes("*HWSJAV*", false);
            int i = 0;
            while (i < newByteArray.length) {
                buffer[buffIndx] = newByteArray[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < prodName.length) {
                buffer[buffIndx] = prodName[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            buffer[buffIndx] = 64;
            buffer[++buffIndx] = -64;
            ++buffIndx;
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < userNameBytes.length) {
                buffer[buffIndx] = userNameBytes[i];
                ++buffIndx;
                ++i;
            }
            buffIndx = 32;
            aOTMABuff = aOTMAMsg.export();
            i = 0;
            while (i < aOTMABuff.length) {
                buffer[buffIndx] = aOTMABuff[i];
                ++buffIndx;
                ++i;
            }
        }
        catch (UnsupportedEncodingException e1) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e1});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e1.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e1.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IOException e2) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e2});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e2.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e2.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IMSException e3) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e3});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e3.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e3.printStackTrace(printErrorWriter);
            throw e;
        }
        try {
            if (rasService.getTraceLevel() >= 3) {
                rasService.logTraceInfo("  Buffer to send:");
                rasService.logTraceInfo(this.dumpBytesInHex(buffer));
            }
            DataOutputStream out1 = new DataOutputStream(this._Socket.getOutputStream());
            int i = 0;
            while (i < buffer.length) {
                out1.writeByte(buffer[i]);
                ++i;
            }
            this._IMSAPIState.setVerifyState(5);
        }
        catch (IOException e4) {
            String errMsg = this._res.getString("0016E", new Object[]{methodName, e4});
            CommunicationException e = new CommunicationException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e4.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e4.printStackTrace(printErrorWriter);
            throw e;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public synchronized void sendRollBack(IMSInteractionSpec interactionSpec) throws ResourceException, CommunicationException {
        IMSOTMAMsg aOTMAMsg = null;
        int buffLen = 0;
        int buffIndx = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] newByteArray = null;
        byte[] prodName = null;
        byte[] buffer = null;
        byte[] aOTMABuff = null;
        byte[] destBytes = null;
        byte[] userNameBytes = null;
        String methodName = String.valueOf(super.toString()) + ".sendRollBack(InteractionSpec)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        try {
            aOTMAMsg = new IMSOTMAMsg(1, null, false, true);
            aOTMAMsg.setFirst();
            destBytes = this._aConvObj.getBytes(this._dataStoreName, false);
            aOTMAMsg.setDestID(destBytes);
            userNameBytes = this._aConvObj.getBytes(this._userName, false);
            aOTMAMsg.setOriginalID(userNameBytes);
            aOTMAMsg.setBitONMsgType((byte)1);
            aOTMAMsg.setBitONResponseIndicator((byte)64);
            if (this._commitMode == 0) {
                aOTMAMsg.setBitONCommitMode((byte)64);
            } else {
                aOTMAMsg.setBitONCommitMode((byte)32);
            }
            aOTMAMsg.setLast();
            buffLen = 498;
            buffer = new byte[buffLen];
            dos.writeInt(buffLen);
            dos.writeShort(28);
            dos.writeShort(0);
            newByteArray = bos.toByteArray();
            prodName = this._aConvObj.getBytes("*HWSJAV*", false);
            int i = 0;
            while (i < newByteArray.length) {
                buffer[buffIndx] = newByteArray[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < prodName.length) {
                buffer[buffIndx] = prodName[i];
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            buffer[buffIndx] = 64;
            buffer[++buffIndx] = -64;
            ++buffIndx;
            i = 0;
            while (i < 3) {
                buffer[buffIndx] = 0;
                ++buffIndx;
                ++i;
            }
            i = 0;
            while (i < userNameBytes.length) {
                buffer[buffIndx] = userNameBytes[i];
                ++buffIndx;
                ++i;
            }
            buffIndx = 32;
            aOTMABuff = aOTMAMsg.export();
            i = 0;
            while (i < aOTMABuff.length) {
                buffer[buffIndx] = aOTMABuff[i];
                ++buffIndx;
                ++i;
            }
        }
        catch (UnsupportedEncodingException e1) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e1});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e1.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e1.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IOException e2) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e2});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e2.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e2.printStackTrace(printErrorWriter);
            throw e;
        }
        catch (IMSException e3) {
            String errMsg = this._res.getString("0001E", new Object[]{methodName, e3});
            ResourceException e = new ResourceException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e3.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e3.printStackTrace(printErrorWriter);
            throw e;
        }
        try {
            if (rasService.getTraceLevel() >= 3) {
                rasService.logTraceInfo("  Buffer to send:");
                rasService.logTraceInfo(this.dumpBytesInHex(buffer));
            }
            DataOutputStream out1 = new DataOutputStream(this._Socket.getOutputStream());
            int i = 0;
            while (i < buffer.length) {
                out1.writeByte(buffer[i]);
                ++i;
            }
        }
        catch (IOException e4) {
            String errMsg = this._res.getString("0016E", new Object[]{methodName, e4});
            CommunicationException e = new CommunicationException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                rasService.logTraceInfo(e.toString());
                e4.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e4.printStackTrace(printErrorWriter);
            throw e;
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setCommitMode(int commitmode) {
        String methodName = String.valueOf(super.toString()) + ".setCommitMode(int)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        if (commitmode < 0 || commitmode >= 2) {
            String errMsg = this._res.getString("0019E", new Object[]{methodName, String.valueOf(commitmode)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._commitMode = commitmode;
        this._IMSAPIState.setInCommitMode(commitmode);
    }

    public void setConnectionSpec(IMSConnectionSpec connectionSpec) {
        String methodName = String.valueOf(super.toString()) + ".setConnectionSpec(ConnectionSpec)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<->  [" + methodName + "]");
        }
        this._connectionSpec = connectionSpec;
    }

    public void setDataStoreName(String dName) {
        String methodName = String.valueOf(super.toString()) + ".setDataStoreName(String)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        if (dName.length() > 8) {
            String errMsg = this._res.getString("0007E", new Object[]{methodName, dName, new Integer(dName.length()), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._dataStoreName = this.stringPad(dName, ' ', 8);
    }

    public void setGroupName(String gNM) {
        String methodName = String.valueOf(super.toString()) + ".setGroupName(String)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        if (gNM.length() > 8) {
            String errMsg = this._res.getString("0008E", new Object[]{methodName, gNM, new Integer(gNM.length()), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._groupName = this.stringPad(gNM, ' ', 8);
    }

    public void setLtermName(String lterm) {
        String methodName = String.valueOf(super.toString()) + ".setLtermName(String)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        if (lterm.length() > 8) {
            String errMsg = this._res.getString("0009E", new Object[]{methodName, lterm, new Integer(lterm.length()), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._ltermName = this.stringPad(lterm, ' ', 8);
    }

    public void setMapName(String mapname) {
        String methodName = String.valueOf(super.toString()) + ".setMapName(String)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        if (mapname.length() > 8) {
            String errMsg = this._res.getString("0010E", new Object[]{methodName, mapname, new Integer(mapname.length()), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._mapName = this.stringPad(mapname, ' ', 8);
    }

    public void setMode(int aMode) {
        String methodName = String.valueOf(super.toString()) + ".setMode(int)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        if (aMode < 0 || aMode >= 8) {
            String errMsg = this._res.getString("0011E", new Object[]{methodName, new Integer(aMode)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._mode = aMode;
    }

    public void setPassword(String pWd) {
        String methodName = String.valueOf(super.toString()) + ".setPassword(String)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        if (pWd.length() > 8) {
            String errMsg = this._res.getString("0012E", new Object[]{methodName, pWd, new Integer(pWd.length()), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._passWord = this.stringPad(pWd, ' ', 8);
    }

    public void setSyncLevel(int synclevel) {
        String methodName = String.valueOf(super.toString()) + ".setSyncLevel(int)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        if (synclevel < 0 || synclevel >= 2) {
            String errMsg = this._res.getString("0013E", new Object[]{methodName, new Integer(synclevel)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._syncLevel = synclevel;
    }

    public void setUserID(String uID) {
        String methodName = String.valueOf(super.toString()) + ".setUserID(String)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        if (uID.length() > 8) {
            String errMsg = this._res.getString("0014E", new Object[]{methodName, uID, new Integer(uID.length()), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._userID = this.stringPad(uID, ' ', 8);
    }

    public void setUserName(String userName) {
        String methodName = String.valueOf(super.toString()) + ".setUserName(String)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        if (userName.length() > 8) {
            String errMsg = this._res.getString("0015E", new Object[]{methodName, userName, new Integer(userName.length()), new Byte(8)});
            IllegalArgumentException e = new IllegalArgumentException(errMsg);
            if (rasService.getTraceLevel() >= 2) {
                PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                rasService.logTraceInfo(e.toString());
                e.printStackTrace(printTraceWriter);
            }
            PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
            rasService.logError(e.toString());
            e.printStackTrace(printErrorWriter);
            throw e;
        }
        this._userName = this.stringPad(userName, ' ', 8);
    }

    private String stringPad(String str, char ch, int l) {
        StringBuffer sb = new StringBuffer(str);
        int i = 1;
        while (i <= l - str.length()) {
            sb.append(ch);
            ++i;
        }
        return new String(sb);
    }

    public String toString() {
        return "\t[" + super.toString() + "]" + "\n\t\t\t\tdataStoreName: [" + this._dataStoreName + "]" + "\n\t\t\t\tuserID: [" + this._userID + "]" + "\n\t\t\t\tpassword: [" + this._passWord + "]" + "\n\t\t\t\tgroupName: [" + this._groupName + "]" + "\n\t\t\t\tinteractionMode: [" + this._mode + "]" + "\n\t\t\t\tsyncLevel: [" + this._syncLevel + "]" + "\n\t\t\t\tcommitMode: [" + this._commitMode + "]" + "\n\t\t\t\tltermName: [" + this._ltermName + "]" + "\n\t\t\t\tuserName(ClientID): [" + this._userName + "]" + "\n\t\t\t\tIMSAPIState: [" + this._IMSAPIState + "\n\t\t\t\t]" + "\n\t\t\t\tsocket: [" + this._Socket + "]";
    }
}

