// StatisticsDialog.cpp : implementation file
//

#include "stdafx.h"
#include "vcplayer.h"
#include "StatisticsDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// StatisticsDialog dialog


StatisticsDialog::StatisticsDialog(CWnd* pParent /*=NULL*/)
	: CDialog(StatisticsDialog::IDD, pParent)
{
		//{{AFX_DATA_INIT(StatisticsDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void StatisticsDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(StatisticsDialog)
	DDX_Control(pDX, IDC_Clipinfo, m_ClipInfo);
	DDX_Control(pDX, IDC_Duration, m_Duration);
	DDX_Control(pDX, IDC_Current, m_Current);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(StatisticsDialog, CDialog)
	//{{AFX_MSG_MAP(StatisticsDialog)
	ON_WM_TIMER()	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// StatisticsDialog message handlers

BOOL StatisticsDialog::OnInitDialog() 
{
	short w;
	short h;
	IISCMPlayerPtr pISCMPlayer;

	CDialog::OnInitDialog();
    pISCMPlayer = IISCMPlayerPtr(CLSID_ISCMPlayer);
    pISCMPlayer->GetVideoSize(&w, &h); 
        

	//This is an audio file if video width is 0

    if ( w == 0 )
	{
		m_ClipInfo.SetWindowText("Audio Clip");
		SetWindowPos(NULL, w+250, 30, 50,50, SWP_NOSIZE|SWP_NOZORDER );
	}

	else
	{	
		m_ClipInfo.SetWindowText("Video Clip");
		SetWindowPos(NULL, w+100, 50, 50,50, SWP_NOSIZE|SWP_NOZORDER );
    }


    SetTimer(1,200,NULL);


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void StatisticsDialog::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	double pos;
	char a_pos[10];
	double duration;
	char a_duration[10];

	IISCMPlayerPtr pISCMPlayer;

	pISCMPlayer = IISCMPlayerPtr(CLSID_ISCMPlayer);
	pISCMPlayer->UpdatePlayEvent(); 
    pISCMPlayer->GetCurrentPlayPosition(&pos);
	sprintf(a_pos, "%g", pos);
	m_Current.SetWindowText(a_pos);

	pISCMPlayer->GetPlayDuration(&duration);
	sprintf(a_duration, "%g", duration);
	m_Duration.SetWindowText(a_duration);

	CDialog::OnTimer(nIDEvent);
	//update current time: define controls, define variable that
	//corresponds to static text
}
