import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
//import com.ms.wfc.core.Event.*;
//import java.awt.*;
import mplayer.*;

/**
 * This class can take a variable number of parameters on the command
 * line. Program execution begins with the main() method. The class
 * constructor is not invoked unless an object of type 'StatisticsDialog'
 * created in the main() method.
 */
public class StatisticsDialog extends Form
{
	IISCMPlayer mplayer;
	/**
	 * TODO: make sure all your constructors/initialization code
	 * paths have the following line:
	 * 		initForm();
	 */
	public StatisticsDialog()
	{
		super();

		// Required for Visual J++ Form Designer support
		initForm();		

		// TODO: Add any constructor code after initForm call
	}

	/**
	 * StatisticsDialog overrides dispose so it can clean up the
	 * component list.
	 * 
	 * TODO: have dispose call
	 * 		components.dispose();
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}



	private void OKButton_click(Object source, Event e)
	{
		//Set the dialog result appropriately
		this.setDialogResult(DialogResult.OK);
		
		//Remove the dialog window
		this.dispose();
	}

	private void CancelButton_click(Object source, Event e)
	{
		//Set the dialog result appropriately
		this.setDialogResult(DialogResult.CANCEL);
		
		//Remove the dialog window
		this.dispose();
	}

	

	private void StatisticsDialog_activate(Object source, Event e)
	{
	  short [] v_height = new short[3];
	  short [] v_width = new short[3];
	  short short_zero = (short)0;
	  
	  mplayer = new ISCMPlayer(); 
	  mplayer.GetVideoSize(v_width, v_height);
      if (v_width[0] == short_zero )  // Audio Clip
	  {
		  edit3.setText("Audio Clip");
		  this.setNewControls(new Control[] {
							edit3, 
							edit2, 
							edit1, 
							CancelButton, 
							OKButton, 
							label3, 
							label2, 
							label1});
	  }
	  else                           // Video Clip
	  {
		  edit3.setText("Video Clip");
		  this.setNewControls(new Control[] {
							edit3, 
							edit2, 
							edit1, 
							CancelButton, 
							OKButton, 
							label3, 
							label2, 
							label1});
	  }
	}

	

	

	private void timer1_timer(Object source, Event e)
	{
		//This might need to be a Capital Double[] because the toString
		//function won't work on a lowercase double[0] item, but
		// toString recognizes Double[0] ok,
		//and
		//so the methods: GetCurrentPlayPosition & GetPlayDuration
		// needs to change to require Capital Double[] instead
		// of lowercase.
		double [] pos = new double[10];
	   double [] duration = new double[10];
	   
	    mplayer = new ISCMPlayer(); 
	

	 mplayer.UpdatePlayEvent(); 
    mplayer.GetCurrentPlayPosition(pos);

     edit1.setText(new Double(pos[0]).toString());


	mplayer.GetPlayDuration(duration);
	
	edit2.setText(new Double(duration[0]).toString()); 

	this.setNewControls(new Control[] {
							edit3, 
							edit2, 
							edit1, 
							CancelButton, 
							OKButton, 
							label3, 
							label2, 
							label1});
	

	
   // java.awt.Component.dispatchEvent(timer);
	//update current time: define controls, define variable that
	//corresponds to static text
}
	/**
	 * NOTE: The following code is required by the Visual J++ form
	 * designer.  It can be modified using the form editor.  Do not
	 * modify it using the code editor.
	 */
	Container components = new Container();
	Label label1 = new Label();
	Label label2 = new Label();
	Label label3 = new Label();
	Button OKButton = new Button();
	Button CancelButton = new Button();
	Edit edit1 = new Edit();
	Edit edit2 = new Edit();
	Edit edit3 = new Edit();
	Timer timer1 = new Timer(components);

	private void initForm()
	{
		label1.setLocation(new Point(16, 32));
		label1.setSize(new Point(100, 23));
		label1.setTabIndex(0);
		label1.setTabStop(false);
		label1.setText("Current:");

		label2.setLocation(new Point(16, 88));
		label2.setSize(new Point(100, 23));
		label2.setTabIndex(1);
		label2.setTabStop(false);
		label2.setText("Duration:");

		label3.setLocation(new Point(16, 152));
		label3.setSize(new Point(100, 23));
		label3.setTabIndex(2);
		label3.setTabStop(false);
		label3.setText("ClipInfo:");

		OKButton.setLocation(new Point(200, 56));
		OKButton.setSize(new Point(75, 23));
		OKButton.setTabIndex(3);
		OKButton.setText("OK");
		OKButton.addOnClick(new EventHandler(this.OKButton_click));

		CancelButton.setLocation(new Point(200, 104));
		CancelButton.setSize(new Point(75, 23));
		CancelButton.setTabIndex(4);
		CancelButton.setText("Cancel");
		CancelButton.addOnClick(new EventHandler(this.CancelButton_click));

		this.setLocation(new Point(400, 100));
		this.setText("VideoCharger Statistics");
		this.setAcceptButton(OKButton);
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setCancelButton(CancelButton);
		this.setClientSize(new Point(300, 300));
		this.setStartPosition(FormStartPosition.MANUAL);
		this.addOnClick(new EventHandler(this.StatisticsDialog_activate));
		this.addOnActivate(new EventHandler(this.StatisticsDialog_activate));

		edit1.setLocation(new Point(72, 32));
		edit1.setSize(new Point(100, 20));
		edit1.setTabIndex(5);
		edit1.setText("0.0");

		edit2.setLocation(new Point(72, 88));
		edit2.setSize(new Point(100, 20));
		edit2.setTabIndex(6);
		edit2.setText("0.0");

		edit3.setLocation(new Point(72, 152));
		edit3.setSize(new Point(100, 20));
		edit3.setTabIndex(7);
		edit3.setText("NoClip");

		timer1.setInterval(200);
		timer1.setEnabled(true);
		timer1.addOnTimer(new EventHandler(this.timer1_timer));
		/* @designTimeOnly timer1.setLocation(new Point(72, 208)); */

		this.setNewControls(new Control[] {
							edit3, 
							edit2, 
							edit1, 
							CancelButton, 
							OKButton, 
							label3, 
							label2, 
							label1});
	}



	/**
	 * The main entry point for the application. 
	 *
	 * @param args Array of parameters passed to the application
	 * via the command line.
	 */
	public static void main(String args[])
	{
		Application.run(new StatisticsDialog());
	}
}
