package com.ibm.vap.Isolation;

/**
 * TransactionPassiveLockingPolicy
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */

import javax.ejb.EJBObject;
import java.rmi.RemoteException;
import java.util.Vector; 
import com.ibm.vap.Transactions.Version;
import com.ibm.vap.Transactions.Key;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapEJBHome;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.common.VapObjectLockedException;

public class TransactionPassiveLockingPolicy extends Object implements TransactionLockingPolicy
{
	protected static TransactionPassiveLockingPolicy singleton;
	private static final java.lang.String copyright  = "(c) Copyright International Business Machines Corporation, 1998";
/**
 * Read all instances from a home
 */
public Vector allInstancesFrom(VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	return aHome.primAllInstances();
}
/**
 * Execute aQueryName from a home
 */
public Vector customQueryFrom(VapEJBHome aHome, String aQueryName, Object[] args) throws RemoteException, VapReadFailureException
{
	return aHome.primCustomQuery(aQueryName, args);
}
/**
 * Read an instance from a home
 */
public VapEJBObject findByPrimaryKey(Key aKey, VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	return aHome.primFindByPrimaryKey(aKey);
}
/**
 * Aswer the singleton instance of the receiver
 */
public static TransactionLockingPolicy getSingleton()
{
	if (singleton == null)
		singleton = new TransactionPassiveLockingPolicy();

	return (TransactionLockingPolicy)singleton;
}
/**
 * If the transaction supports read stability, initialize the child version with a copy
 * of parent's data. Otherwise share the parent's data.
 */
public void initializeVersion(Version aChildVersion, Version aParentVersion) throws RemoteException
{
	aChildVersion.initializeForUnrepeatableReadFrom(aParentVersion);
}
/**
 * The version is accessed first time
 */
public void notifyFirstAccessFor(Version aVersion) throws RemoteException, VapObjectLockedException
{
}
/**
 * The version is registered into a view
 */
public void notifyRegistrationFor(Version aVersion) throws RemoteException, VapObjectLockedException
{
}
/**
 * Answer true if the policy supports repeatable reads
 */
public boolean supportsRepeatableReads()
{
	return false;
}
}