/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import java.util.Locale;

public class LocaleUtility {
    public static Locale getLocaleFromName(String name2) {
        String language = "";
        String country = "";
        String variant = "";
        int i1 = name2.indexOf(95);
        if (i1 < 0) {
            language = name2;
        } else {
            int i2;
            language = name2.substring(0, i1);
            if ((i2 = name2.indexOf(95, ++i1)) < 0) {
                country = name2.substring(i1);
            } else {
                country = name2.substring(i1, i2);
                variant = name2.substring(i2 + 1);
            }
        }
        return new Locale(language, country, variant);
    }

    public static boolean isFallbackOf(String parent, String child) {
        if (!child.startsWith(parent)) {
            return false;
        }
        int i = parent.length();
        return i == child.length() || child.charAt(i) == '_';
    }

    public static boolean isFallbackOf(Locale parent, Locale child) {
        return LocaleUtility.isFallbackOf(parent.toString(), child.toString());
    }

    public static String canonicalLocaleString(Locale locale) {
        return LocaleUtility.canonicalLocaleString(locale.toString());
    }

    public static String canonicalLocaleString(String id) {
        if (id != null) {
            int x = id.indexOf("_");
            if (x == -1) {
                id = id.toLowerCase(Locale.ENGLISH);
            } else {
                int len;
                StringBuffer buf = new StringBuffer();
                buf.append(id.substring(0, x).toLowerCase(Locale.ENGLISH));
                buf.append(id.substring(x).toUpperCase(Locale.ENGLISH));
                int n = len = buf.length();
                while (--n >= 0 && buf.charAt(n) == '_') {
                }
                if (++n != len) {
                    buf.delete(n, len);
                }
                id = buf.toString();
            }
        }
        return id;
    }

    public static Locale fallback(Locale loc) {
        int i;
        String[] parts = new String[]{loc.getLanguage(), loc.getCountry(), loc.getVariant()};
        for (i = 2; i >= 0; --i) {
            if (parts[i].length() == 0) continue;
            parts[i] = "";
            break;
        }
        if (i < 0) {
            return null;
        }
        return new Locale(parts[0], parts[1], parts[2]);
    }
}

