/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIFormatter;
import com.ibm.ras.RASObject;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;

public abstract class RASFormatter
extends RASObject
implements RASIFormatter,
RASConstants {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    public static final String DEFAULT_DATE_FORMAT = "yyyy.MM.dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss.SSS";
    public static final String DEFAULT_SEPARATOR = " ";
    protected static final String INDENT = "  ";
    private static final Object dateLock = new Object();
    private static final Object timeLock = new Object();
    private boolean defaultFormatter = false;
    private transient Date date;
    private transient Date time;
    private transient FieldPosition dateField;
    private transient FieldPosition timeField;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat timeFormat;
    private String separator;
    protected transient String lineSep;
    private transient StringBuffer dateBuffer;
    private transient StringBuffer timeBuffer;
    private Vector eventClasses = new Vector();

    public RASFormatter() {
        this.lineSep = System.getProperty("line.separator");
        TimeZone timeZone = TimeZone.getDefault();
        this.dateFormat.setTimeZone(timeZone);
        this.timeFormat.setTimeZone(timeZone);
    }

    protected void init() {
        super.init();
        this.setSeparator(DEFAULT_SEPARATOR);
        this.dateFormat = new SimpleDateFormat();
        this.timeFormat = new SimpleDateFormat();
        this.setDateFormat(DEFAULT_DATE_FORMAT);
        this.setTimeFormat(DEFAULT_TIME_FORMAT);
        this.date = new Date();
        this.time = new Date();
        this.dateBuffer = new StringBuffer();
        this.timeBuffer = new StringBuffer();
        this.dateField = new FieldPosition(0);
        this.timeField = new FieldPosition(0);
    }

    public Hashtable getConfig() {
        Hashtable hashtable = super.getConfig();
        hashtable.put("dateFormat", this.getDateFormat().toPattern());
        hashtable.put("timeFormat", this.getTimeFormat().toPattern());
        hashtable.put("separator", this.getSeparator());
        return hashtable;
    }

    public void setConfig(Hashtable hashtable) {
        super.setConfig(hashtable);
        if (hashtable.containsKey("dateFormat")) {
            this.setDateFormat((String)hashtable.get("dateFormat"));
        }
        if (hashtable.containsKey("timeFormat")) {
            this.setTimeFormat((String)hashtable.get("timeFormat"));
        }
        if (hashtable.containsKey("separator")) {
            this.setSeparator((String)hashtable.get("separator"));
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        if (string != null) {
            this.separator = string;
        }
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat != null) {
            this.dateFormat = simpleDateFormat;
        }
    }

    public void setDateFormat(String string) {
        if (string != null) {
            this.dateFormat.applyPattern(string);
        }
    }

    public SimpleDateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat != null) {
            this.timeFormat = simpleDateFormat;
        }
    }

    public void setTimeFormat(String string) {
        if (string != null) {
            this.timeFormat.applyPattern(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDate(long l) {
        Object object = dateLock;
        synchronized (object) {
            this.date.setTime(l);
            this.dateBuffer.setLength(0);
            StringBuffer stringBuffer = this.dateFormat.format(this.date, this.dateBuffer, this.dateField);
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTime(long l) {
        Object object = timeLock;
        synchronized (object) {
            this.time.setTime(l);
            this.timeBuffer.setLength(0);
            StringBuffer stringBuffer = this.timeFormat.format(this.time, this.timeBuffer, this.timeField);
            return stringBuffer.toString();
        }
    }

    public void setDefault(boolean bl) {
        this.defaultFormatter = bl;
    }

    public boolean isDefault() {
        return this.defaultFormatter;
    }

    public void addEventClass(String string) {
        if (string != null && !this.eventClasses.contains(string)) {
            this.eventClasses.addElement(string);
        }
    }

    public void removeEventClass(String string) {
        if (string != null && this.eventClasses.contains(string)) {
            this.eventClasses.removeElement(string);
        }
    }

    public Enumeration getEventClasses() {
        return this.eventClasses.elements();
    }

    public abstract String format(RASIEvent var1);
}

