/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIMaskChangeGenerator;
import com.ibm.ras.RASIMaskChangeListener;
import com.ibm.ras.RASMaskChangeEvent;
import com.ibm.ras.RASObject;
import com.ibm.ras.RASUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RASMaskChangeGenerator
extends RASObject
implements RASIMaskChangeGenerator {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = 338264656140674871L;
    private long messageMask;
    private long traceMask;
    private Vector messageEventClasses;
    private Vector traceEventClasses;
    private Vector maskChangeListeners;

    public RASMaskChangeGenerator() {
    }

    public RASMaskChangeGenerator(String string) {
        super(string);
    }

    public RASMaskChangeGenerator(String string, String string2) {
        super(string, string2);
    }

    protected void init() {
        super.init();
        if (this.maskChangeListeners == null) {
            this.maskChangeListeners = new Vector();
        }
        this.messageEventClasses = new Vector();
        this.traceEventClasses = new Vector();
        this.setMessageMask(7L);
        this.setTraceMask(2047L);
    }

    public Hashtable getConfig() {
        Hashtable hashtable = super.getConfig();
        hashtable.put("messageEventClasses", RASUtil.vectorToString(this.messageEventClasses));
        hashtable.put("traceEventClasses", RASUtil.vectorToString(this.traceEventClasses));
        hashtable.put("messageMask", this.messageMaskToString(this.getMessageMask()));
        hashtable.put("traceMask", this.traceMaskToString(this.getTraceMask()));
        return hashtable;
    }

    public void setConfig(Hashtable hashtable) {
        super.setConfig(hashtable);
        if (hashtable.containsKey("messageEventClasses")) {
            this.messageEventClasses = RASUtil.stringToVector((String)hashtable.get("messageEventClasses"));
        }
        if (hashtable.containsKey("traceEventClasses")) {
            this.traceEventClasses = RASUtil.stringToVector((String)hashtable.get("traceEventClasses"));
        }
        if (hashtable.containsKey("messageMask")) {
            this.setMessageMask(this.messageMaskLongValue((String)hashtable.get("messageMask")));
        }
        if (hashtable.containsKey("traceMask")) {
            this.setTraceMask(this.traceMaskLongValue((String)hashtable.get("traceMask")));
        }
    }

    public long getMessageMask() {
        return this.messageMask;
    }

    public void setMessageMask(long l) {
        RASMaskChangeEvent rASMaskChangeEvent = new RASMaskChangeEvent(this, this.messageMask, l, true);
        this.messageMask = l;
        this.fireMaskChangedEvent(rASMaskChangeEvent);
    }

    public long getTraceMask() {
        return this.traceMask;
    }

    public void setTraceMask(long l) {
        RASMaskChangeEvent rASMaskChangeEvent = new RASMaskChangeEvent(this, this.traceMask, l, false);
        this.traceMask = l;
        this.fireMaskChangedEvent(rASMaskChangeEvent);
    }

    public void addMaskChangeListener(RASIMaskChangeListener rASIMaskChangeListener) {
        if (rASIMaskChangeListener != null && !this.maskChangeListeners.contains(rASIMaskChangeListener)) {
            this.maskChangeListeners.addElement(rASIMaskChangeListener);
        }
    }

    public void removeMaskChangeListener(RASIMaskChangeListener rASIMaskChangeListener) {
        if (rASIMaskChangeListener != null && this.maskChangeListeners.contains(rASIMaskChangeListener)) {
            this.maskChangeListeners.removeElement(rASIMaskChangeListener);
        }
    }

    public Enumeration getMaskChangeListeners() {
        return this.maskChangeListeners.elements();
    }

    public void fireMaskChangedEvent(RASMaskChangeEvent rASMaskChangeEvent) {
        Enumeration enumeration = this.getMaskChangeListeners();
        while (enumeration.hasMoreElements()) {
            RASIMaskChangeListener rASIMaskChangeListener = (RASIMaskChangeListener)enumeration.nextElement();
            rASIMaskChangeListener.maskValueChanged(rASMaskChangeEvent);
        }
    }

    public void addMessageEventClass(String string) {
        if (string != null && !this.messageEventClasses.contains(string)) {
            this.messageEventClasses.addElement(string);
        }
    }

    public void removeMessageEventClass(String string) {
        if (string != null && this.messageEventClasses.contains(string)) {
            this.messageEventClasses.removeElement(string);
        }
    }

    public Enumeration getMessageEventClasses() {
        return this.messageEventClasses.elements();
    }

    public void addTraceEventClass(String string) {
        if (string != null && !this.traceEventClasses.contains(string)) {
            this.traceEventClasses.addElement(string);
        }
    }

    public void removeTraceEventClass(String string) {
        if (string != null && this.traceEventClasses.contains(string)) {
            this.traceEventClasses.removeElement(string);
        }
    }

    public Enumeration getTraceEventClasses() {
        return this.traceEventClasses.elements();
    }

    public long messageMaskLongValue(String string) {
        return this.maskLongValue(this.getMessageEventClasses(), string);
    }

    public String messageMaskToString(long l) {
        return this.maskToString(this.getMessageEventClasses(), l);
    }

    public long traceMaskLongValue(String string) {
        return this.maskLongValue(this.getTraceEventClasses(), string);
    }

    public String traceMaskToString(long l) {
        return this.maskToString(this.getTraceEventClasses(), l);
    }

    private long maskLongValue(Enumeration enumeration, String string) {
        long l = 0L;
        if (enumeration != null && string != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                RASIEvent rASIEvent = (RASIEvent)RASUtil.createObject(string2);
                if (rASIEvent == null) continue;
                l |= rASIEvent.maskLongValue(string);
            }
        }
        return l;
    }

    private String maskToString(Enumeration enumeration, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                RASIEvent rASIEvent = (RASIEvent)RASUtil.createObject(string);
                if (rASIEvent == null) continue;
                stringBuffer.append(rASIEvent.maskToString(l));
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }
}

