/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionA;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.Factory;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPool;
import com.ibm.ws.wlm.threadmanager.SleeperThreadPoolFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class DescriptionFactory {
    private static final TraceComponent tc = Tr.register(DescriptionFactory.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final String TYPE_MEMBER_ADDED = "member.added";
    public static final String TYPE_MEMBER_REMOVED = "member.removed";
    public static final String TYPE_ADD_EXTRINSIC = "type.add.extrinsic";
    public static final String TYPE_REMOVE_EXTRINSIC = "type.remove.extrinsic";
    public static final String TYPE_CLUSTER_WEIGHT = "type.cluster.weight.update";
    public static final String TYPE_CLUSTER_UPDATED = "type.cluster.updated";
    public static final String TYPE_MEMENTO_UPDATED = "type.memento.updated";
    public static final String CLUSTER_ACTIVE = "cluster.active";
    public static final String CLUSTER_DEACTIVE = "cluster.deactive";
    public static final String TYPE_CLUSTER_SCOPED_DATA_ADDED = "type.cluster.scoped.data.added";
    public static final String TYPE_CLUSTER_SCOPED_DATA_REMOVED = "type.cluster.scoped.data.removed";
    private static final DescriptionFactory instance;
    private static final SleeperThreadPool pool;
    private Map listeners = new HashMap();
    private ThreadLocal recursion = new ThreadLocal();
    private Map defKeyToRefQHolder = new HashMap();

    private DescriptionFactory() {
    }

    public static DescriptionFactory getInstance() {
        return instance;
    }

    public Description createDescription(DescriptionKey descriptionKey, String string) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDescription", new Object[]{descriptionKey, string});
        }
        Class clazz = Factory.loadClass((String)string);
        Constructor constructor = clazz.getConstructor(DescriptionKey.class);
        Description description = (Description)constructor.newInstance(descriptionKey);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDescription");
        }
        return description;
    }

    public Description createLocalDescription(DescriptionKey descriptionKey, String string) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLocalDescription", new Object[]{descriptionKey, string});
        }
        DescriptionA descriptionA = (DescriptionA)this.createDescription(descriptionKey, string);
        descriptionA.setLocal();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createLocalDescription");
        }
        return descriptionA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerNotificationListener(DescriptionModificationListener descriptionModificationListener, String string, String string2) {
        ReferenceQueue referenceQueue;
        HashSet<WeakReference<DescriptionModificationListener>> hashSet;
        HashMap hashMap;
        HashMap hashMap2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerNotificationListener", new Object[]{descriptionModificationListener, string, string2});
        }
        if ((hashMap2 = (HashMap)this.listeners.get(string)) == null) {
            hashMap2 = new HashMap();
            this.listeners.put(string, hashMap2);
        }
        if ((hashMap = (HashMap)this.defKeyToRefQHolder.get(string)) == null) {
            hashMap = new HashMap();
            this.defKeyToRefQHolder.put(string, hashMap);
        }
        if ((hashSet = (HashSet<WeakReference<DescriptionModificationListener>>)hashMap2.get(string2)) == null) {
            hashSet = new HashSet<WeakReference<DescriptionModificationListener>>();
            hashMap2.put(string2, hashSet);
        }
        if ((referenceQueue = (ReferenceQueue)hashMap.get(string2)) == null) {
            referenceQueue = new ReferenceQueue();
            hashMap.put(string2, referenceQueue);
        }
        HashSet<WeakReference<DescriptionModificationListener>> hashSet2 = hashSet;
        synchronized (hashSet2) {
            hashSet.add(new WeakReference<DescriptionModificationListener>(descriptionModificationListener, referenceQueue));
            this.purge(hashSet, referenceQueue);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerNotificationListener", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(DescriptionKey descriptionKey, String string, Object object) {
        Description description = DescriptionManagerFactory.getDescriptionManager().getDescription(descriptionKey);
        if (description == null) {
            Tr.event(tc, "unexpected description was null", descriptionKey);
            return;
        }
        String string2 = description.getDefinitionKey();
        if (this.listeners.containsKey(string2)) {
            HashSet<DescriptionKey> hashSet;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "notifyListeners", new Object[]{descriptionKey, string, object});
            }
            if ((hashSet = (HashSet<DescriptionKey>)this.recursion.get()) == null) {
                hashSet = new HashSet<DescriptionKey>();
                this.recursion.set(hashSet);
            }
            if (!hashSet.contains(descriptionKey)) {
                try {
                    hashSet.add(descriptionKey);
                    Notifier notifier = new Notifier(descriptionKey, string2, string, object);
                    if (string.equals(TYPE_MEMBER_ADDED)) {
                        pool.RunInTimeOrder((Runnable)notifier, 1500);
                    } else {
                        pool.Run((Runnable)notifier);
                    }
                }
                finally {
                    hashSet.remove(descriptionKey);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "notifyListeners", this.recursion.get());
            }
        }
    }

    private void purge(Set set, ReferenceQueue referenceQueue) {
        WeakReference weakReference = null;
        while ((weakReference = (WeakReference)referenceQueue.poll()) != null) {
            set.remove(weakReference);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "purge", weakReference);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.listeners.size() + "]";
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.27 ");
        }
        instance = new DescriptionFactory();
        pool = SleeperThreadPoolFactory.getInstance();
    }

    private final class Notifier
    implements Runnable {
        private final DescriptionKey key;
        private final String definitionKey;
        private final String type;
        private final Object data;

        private Notifier(DescriptionKey descriptionKey, String string, String string2, Object object) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>", new Object[]{string, string2, object});
            }
            this.key = descriptionKey;
            this.definitionKey = string;
            this.type = string2;
            this.data = object;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashSet hashSet;
            Map map;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run notifier", this);
            }
            HashMap hashMap = new HashMap();
            Map map2 = (Map)DescriptionFactory.this.listeners.get(this.definitionKey);
            if (map2 != null) {
                hashMap.putAll(map2);
            }
            if ((map = (Map)DescriptionFactory.this.listeners.get(null)) != null) {
                hashMap.putAll(map);
            }
            if ((hashSet = (HashSet)hashMap.get(this.type)) != null) {
                HashSet hashSet2;
                Object object = hashSet;
                synchronized (object) {
                    hashSet2 = (HashSet)hashSet.clone();
                }
                object = hashSet2.iterator();
                while (object.hasNext()) {
                    DescriptionModificationListener descriptionModificationListener;
                    WeakReference weakReference = (WeakReference)object.next();
                    DescriptionModificationListener descriptionModificationListener2 = descriptionModificationListener = weakReference == null ? null : (DescriptionModificationListener)weakReference.get();
                    if (descriptionModificationListener != null) {
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "calling observer", descriptionModificationListener);
                            }
                            descriptionModificationListener.handleNotification(this.key, this.type, this.data, null);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException(exception, (class$com$ibm$websphere$cluster$topography$DescriptionFactory == null ? DescriptionFactory.class$("com.ibm.websphere.cluster.topography.DescriptionFactory") : class$com$ibm$websphere$cluster$topography$DescriptionFactory).getName() + ".notifyListeners", "173", this, new Object[]{descriptionModificationListener});
                            if (!tc.isEventEnabled()) continue;
                            Tr.event(tc, "unexpected exception processing notification.", new Object[]{descriptionModificationListener, exception});
                        }
                        continue;
                    }
                    if (map2 == null || (hashSet = (HashSet)map2.get(this.type)) == null) continue;
                    hashSet.remove(weakReference);
                    if (!hashSet.isEmpty() || map2 == null) continue;
                    map2.remove(this.type);
                    if (!map2.isEmpty() || DescriptionFactory.this.listeners == null) continue;
                    DescriptionFactory.this.listeners.remove(this.definitionKey);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run notifier");
            }
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Notifier) {
                Notifier notifier = (Notifier)object;
                return notifier.key.equals(this.key) && notifier.definitionKey.equals(this.definitionKey) && notifier.type.equals(this.type) && notifier.data.equals(this.data);
            }
            return bl;
        }

        public int hashCode() {
            return this.key.hashCode() & this.definitionKey.hashCode() & this.type.hashCode() & this.data.hashCode();
        }

        public String toString() {
            return super.toString() + "[" + this.key + " " + this.type + " " + this.definitionKey + " " + this.data + "]";
        }
    }
}

