/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgrInitException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.ClientCommandMgr;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import java.io.InputStream;
import java.util.Collection;

public abstract class CommandMgr {
    private static TraceComponent tc = Tr.register(CommandMgr.class, "CommandMgr", "com.ibm.websphere.management.resources.cmdframework");
    protected static CommandMgr cmdMgr;
    protected static boolean initialized;

    public static CommandMgr getCommandMgr() {
        if (cmdMgr == null && !initialized) {
            if (AdminServiceFactory.getAdminService() != null) {
                CommandMgr.initializeServerMode();
            } else {
                CommandMgr.initializeLocalMode();
            }
            initialized = true;
        }
        return cmdMgr;
    }

    public static CommandMgr getClientCommandMgr(AdminClient adminClient) throws CommandMgrInitException {
        return CommandMgr.initializeClientMode(adminClient);
    }

    private static synchronized CommandMgr initializeClientMode(AdminClient adminClient) throws CommandMgrInitException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeClientMode");
        }
        try {
            CommandUtility.getRemoteCmdMgrMbean(adminClient);
            Class<?> clazz = Class.forName("com.ibm.ws.management.cmdframework.impl.ClientCommandMgr");
            ClientCommandMgr clientCommandMgr = null;
            clientCommandMgr = (ClientCommandMgr)clazz.newInstance();
            clientCommandMgr.setAdminClient(adminClient);
            initialized = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeClientMode", clientCommandMgr);
            }
            return clientCommandMgr;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.cmdframework.CommandMgr", "104");
            Tr.error(tc, "commandframework failed to initialize in client mode", throwable);
            throw new CommandMgrInitException(throwable, "ClientMode");
        }
    }

    private static synchronized CommandMgr initializeServerMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeServerMode");
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.management.cmdframework.impl.ServerCommandMgr");
            CommandMgr commandMgr = null;
            if (cmdMgr == null || !clazz.isInstance(cmdMgr)) {
                commandMgr = (CommandMgr)clazz.newInstance();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeServerMode");
            }
            return cmdMgr;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.cmdframework.CommandMgr", "126");
            Tr.error(tc, "commandframework failed to initialize in server mode", throwable);
            return null;
        }
    }

    private static CommandMgr initializeLocalMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeLocalMode");
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.management.cmdframework.impl.LocalCommandMgr");
            CommandMgr commandMgr = null;
            if (cmdMgr == null || !clazz.isInstance(cmdMgr)) {
                commandMgr = (CommandMgr)clazz.newInstance();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeLocalMode");
            }
            return cmdMgr;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.cmdframework.CommandMgr", "148");
            Tr.error(tc, "commandframework failed to initialize in local mode", throwable);
            return null;
        }
    }

    public abstract Collection listCommandGroups() throws ConnectorException, CommandException;

    public abstract Collection listCommands(String var1) throws ConnectorException, CommandException;

    public abstract Collection listCommands() throws ConnectorException, CommandException;

    public abstract Collection listAllCommands() throws ConnectorException, CommandException;

    public abstract CommandMetadata getCommandMetadata(String var1) throws ConnectorException, CommandNotFoundException, CommandException;

    public abstract Collection getAllCommandMetadata() throws ConnectorException, CommandException;

    public abstract CommandGroupMetadata getCommandGroupMetadata(String var1) throws ConnectorException, CommandNotFoundException, CommandException;

    public abstract Collection getAllCommandGroupMetadata() throws ConnectorException, CommandNotFoundException, CommandException;

    public abstract AdminCommand createCommand(String var1) throws CommandNotFoundException, CommandException, ConnectorException;

    public abstract AdminCommand loadCommand(InputStream var1) throws CommandLoadException, ConnectorException, CommandException;

    public abstract CommandProviderHelper getCommandProviderHelper();

    static {
        initialized = false;
    }
}

